/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceName", type="String", defaultValue=""), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT"), @NiagaraProperty(name="maxApduLengthAccepted", type="int", defaultValue="50"), @NiagaraProperty(name="segmentationSupported", type="BBacnetSegmentation", defaultValue="BBacnetSegmentation.noSegmentation"), @NiagaraProperty(name="vendorId", type="int", defaultValue="-1"), @NiagaraProperty(name="address", type="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT"), @NiagaraProperty(name="listSize", type="int", defaultValue="-1"), @NiagaraProperty(name="encoding", type="BCharacterSetEncoding", defaultValue="BCharacterSetEncoding.unknown"), @NiagaraProperty(name="servicesSupported", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetServicesSupported\"))"), @NiagaraProperty(name="vendorName", type="String", defaultValue=""), @NiagaraProperty(name="modelName", type="String", defaultValue=""), @NiagaraProperty(name="protocolRevision", type="int", defaultValue="0"), @NiagaraProperty(name="firmwareRevision", type="String", defaultValue=""), @NiagaraProperty(name="applicationSoftwareVersion", type="String", defaultValue=""), @NiagaraProperty(name="duplicate", type="boolean", defaultValue="false")})
public class BDiscoveryDevice
extends BStruct {
    @Generated
    public static final Property deviceName = BDiscoveryDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property objectId = BDiscoveryDevice.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Property maxApduLengthAccepted = BDiscoveryDevice.newProperty((int)0, (int)50, null);
    @Generated
    public static final Property segmentationSupported = BDiscoveryDevice.newProperty((int)0, (BValue)BBacnetSegmentation.noSegmentation, null);
    @Generated
    public static final Property vendorId = BDiscoveryDevice.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property address = BDiscoveryDevice.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Property listSize = BDiscoveryDevice.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property encoding = BDiscoveryDevice.newProperty((int)0, (BValue)BCharacterSetEncoding.unknown, null);
    @Generated
    public static final Property servicesSupported = BDiscoveryDevice.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), null);
    @Generated
    public static final Property vendorName = BDiscoveryDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property modelName = BDiscoveryDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property protocolRevision = BDiscoveryDevice.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property firmwareRevision = BDiscoveryDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property applicationSoftwareVersion = BDiscoveryDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property duplicate = BDiscoveryDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDiscoveryDevice.class);

    @Generated
    public String getDeviceName() {
        return this.getString(deviceName);
    }

    @Generated
    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public int getMaxApduLengthAccepted() {
        return this.getInt(maxApduLengthAccepted);
    }

    @Generated
    public void setMaxApduLengthAccepted(int v) {
        this.setInt(maxApduLengthAccepted, v, null);
    }

    @Generated
    public BBacnetSegmentation getSegmentationSupported() {
        return (BBacnetSegmentation)this.get(segmentationSupported);
    }

    @Generated
    public void setSegmentationSupported(BBacnetSegmentation v) {
        this.set(segmentationSupported, (BValue)v, null);
    }

    @Generated
    public int getVendorId() {
        return this.getInt(vendorId);
    }

    @Generated
    public void setVendorId(int v) {
        this.setInt(vendorId, v, null);
    }

    @Generated
    public BBacnetAddress getAddress() {
        return (BBacnetAddress)this.get(address);
    }

    @Generated
    public void setAddress(BBacnetAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public int getListSize() {
        return this.getInt(listSize);
    }

    @Generated
    public void setListSize(int v) {
        this.setInt(listSize, v, null);
    }

    @Generated
    public BCharacterSetEncoding getEncoding() {
        return (BCharacterSetEncoding)this.get(encoding);
    }

    @Generated
    public void setEncoding(BCharacterSetEncoding v) {
        this.set(encoding, (BValue)v, null);
    }

    @Generated
    public BBacnetBitString getServicesSupported() {
        return (BBacnetBitString)this.get(servicesSupported);
    }

    @Generated
    public void setServicesSupported(BBacnetBitString v) {
        this.set(servicesSupported, (BValue)v, null);
    }

    @Generated
    public String getVendorName() {
        return this.getString(vendorName);
    }

    @Generated
    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    @Generated
    public String getModelName() {
        return this.getString(modelName);
    }

    @Generated
    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    @Generated
    public int getProtocolRevision() {
        return this.getInt(protocolRevision);
    }

    @Generated
    public void setProtocolRevision(int v) {
        this.setInt(protocolRevision, v, null);
    }

    @Generated
    public String getFirmwareRevision() {
        return this.getString(firmwareRevision);
    }

    @Generated
    public void setFirmwareRevision(String v) {
        this.setString(firmwareRevision, v, null);
    }

    @Generated
    public String getApplicationSoftwareVersion() {
        return this.getString(applicationSoftwareVersion);
    }

    @Generated
    public void setApplicationSoftwareVersion(String v) {
        this.setString(applicationSoftwareVersion, v, null);
    }

    @Generated
    public boolean getDuplicate() {
        return this.getBoolean(duplicate);
    }

    @Generated
    public void setDuplicate(boolean v) {
        this.setBoolean(duplicate, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDiscoveryDevice() {
    }

    public BDiscoveryDevice(String name, IAmRequest req, BBacnetAddress addr, int listSize, BCharacterSetEncoding encoding, BBacnetBitString servicesSupported, String vendorName, String modelName, int protocolRevision, String firmwareRevision, String applicationSoftwareVersion) {
        this.setDeviceName(name);
        this.setObjectId(req.getObjectId());
        this.setMaxApduLengthAccepted(req.getMaxAPDULengthAccepted());
        this.setSegmentationSupported(req.getSegmentationSupported());
        this.setVendorId(req.getVendorId());
        this.getAddress().copyFrom((BComplex)addr);
        this.setListSize(listSize);
        this.setEncoding(encoding);
        this.setServicesSupported(servicesSupported);
        this.setVendorName(vendorName);
        this.setModelName(modelName);
        this.setFirmwareRevision(firmwareRevision);
        this.setProtocolRevision(protocolRevision);
        this.setApplicationSoftwareVersion(applicationSoftwareVersion);
    }

    public Object makeKey() {
        return vendorName + ":" + modelName;
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.getDeviceName()).append(" id=" + (Object)((Object)this.getObjectId())).append(" apdu=").append(this.getMaxApduLengthAccepted()).append(" seg=" + (Object)((Object)this.getSegmentationSupported())).append(" vid=").append(this.getVendorId()).append(" addr=" + this.getAddress()).append(" siz=").append(this.getListSize()).append(" enc=" + (Object)((Object)this.getEncoding())).append(" svc=" + (Object)((Object)this.getServicesSupported())).append(" vNm=").append(this.getVendorName()).append(" mNm=").append(this.getModelName()).append(" fwR=").append(this.getFirmwareRevision()).append(" asR=").append(this.getApplicationSoftwareVersion());
        return sb.toString();
    }
}

