/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.units.BUnit;

public class BacnetDiscoveryUtil
implements AsnConst {
    private static final double LN_10 = Math.log(10.0);
    private static Logger logger = Logger.getLogger("bacnet.client");
    private static IntHashMap facetPropsByType = new IntHashMap();

    public static void addFacet(int facetProp, byte[] propertyValue, HashMap<String, BIDataValue> fmap, BBacnetDevice device) {
        block21: {
            try {
                switch (facetProp) {
                    case 69: {
                        fmap.put("min", (BIDataValue)BacnetDiscoveryUtil.makeNumericFacetKey(AsnUtil.fromAsnReal(propertyValue)));
                        break;
                    }
                    case 65: {
                        fmap.put("max", (BIDataValue)BacnetDiscoveryUtil.makeNumericFacetKey(AsnUtil.fromAsnReal(propertyValue)));
                        break;
                    }
                    case 106: {
                        float f = AsnUtil.fromAsnReal(propertyValue);
                        fmap.put("resolution", (BIDataValue)BFloat.make((float)f));
                        if (!(f > 0.0f)) break;
                        double fPrec = -(Math.log(f) / LN_10);
                        BInteger precision = BInteger.make((int)((int)Math.ceil(fPrec -= 1.0E-6)));
                        if (precision.getInt() > 7) {
                            precision = BInteger.make((int)7);
                        }
                        fmap.put("precision", (BIDataValue)precision);
                        break;
                    }
                    case 117: {
                        int unitEnum = AsnUtil.fromAsnEnumerated(propertyValue);
                        try {
                            if (BBacnetEngineeringUnits.isFixed(unitEnum)) {
                                BUnit u = BBacnetEngineeringUnits.make(unitEnum).getNiagaraUnits();
                                fmap.put("units", (BIDataValue)u);
                                break;
                            }
                            if (logger.isLoggable(Level.INFO)) {
                                logger.info("Unit enumeration " + BBacnetEngineeringUnits.tag(unitEnum) + " is unknown!");
                            }
                        }
                        catch (InvalidEnumException e) {
                            logger.warning("Can't make BUnits from BacnetEngineeringUnits:" + BBacnetEngineeringUnits.tag(unitEnum));
                        }
                        break;
                    }
                    case 4: {
                        fmap.put("trueText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(propertyValue)));
                        break;
                    }
                    case 46: {
                        fmap.put("falseText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(propertyValue)));
                        break;
                    }
                    case 110: {
                        AsnInputStream in = new AsnInputStream(propertyValue);
                        ArrayList<String> v = new ArrayList<String>();
                        int tag = in.peekTag();
                        while (tag != -1) {
                            StringBuilder s = new StringBuilder(SlotPath.escape((String)in.readCharacterString()));
                            while (v.contains(s.toString())) {
                                s.append("$2E");
                            }
                            v.add(s.toString());
                            tag = in.peekTag();
                        }
                        int[] ords = new int[v.size()];
                        for (int j = 0; j < ords.length; ++j) {
                            ords[j] = j + 1;
                        }
                        String[] tags = v.toArray(new String[0]);
                        fmap.put("range", (BIDataValue)BEnumRange.make((int[])ords, (String[])tags));
                    }
                }
            }
            catch (AsnException e) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("AsnException parsing data for facet property " + BBacnetPropertyIdentifier.tag(facetProp));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.INFO)) break block21;
                logger.info("Exception adding facet for property " + BBacnetPropertyIdentifier.tag(facetProp) + ":" + e);
            }
        }
    }

    public static BBoolean checkForPriorityArray(BBacnetObjectIdentifier objectId, BBacnetDevice device) {
        if (!objectId.isValid()) {
            return BBoolean.FALSE;
        }
        try {
            BacnetDiscoveryUtil.client().readProperty(device.getAddress(), objectId, 87, 0);
            return BBoolean.TRUE;
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }

    public static HashMap<String, BIDataValue> discoverFacets(BBacnetObjectIdentifier objectId, BBacnetDevice device) {
        return BacnetDiscoveryUtil.discoverFacets(objectId, device != null ? device.getAddress() : null);
    }

    public static HashMap<String, BIDataValue> discoverFacets(BBacnetObjectIdentifier objectId, BBacnetAddress address) {
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>();
        if (!objectId.isValid()) {
            return map;
        }
        int[] facetProps = BacnetDiscoveryUtil.getFacetProps(objectId.getObjectType());
        if (facetProps == null) {
            return map;
        }
        BBacnetClientLayer client = BacnetDiscoveryUtil.client();
        if (client != null && address != null) {
            for (int i = 0; i < facetProps.length; ++i) {
                try {
                    byte[] propertyValue = client.readProperty(address, objectId, facetProps[i]);
                    BacnetDiscoveryUtil.addFacet(facetProps[i], propertyValue, map, null);
                    continue;
                }
                catch (TransactionException e) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("TransactionException reading property " + BBacnetPropertyIdentifier.tag(facetProps[i]) + " in " + (Object)((Object)objectId) + ": " + e);
                    }
                    return map;
                }
                catch (ErrorException e) {
                    continue;
                }
                catch (BacnetException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("BacnetException reading property " + BBacnetPropertyIdentifier.tag(facetProps[i]) + " in " + (Object)((Object)objectId) + ": " + (Object)((Object)e));
                }
            }
        }
        return map;
    }

    public static int[] getFacetProps(int objectType) {
        return (int[])facetPropsByType.get(objectType);
    }

    public static final BNumber makeNumericFacetKey(float f) {
        if (f <= -3.4028235E38f) {
            return BDouble.NEGATIVE_INFINITY;
        }
        if (f >= Float.MAX_VALUE) {
            return BDouble.POSITIVE_INFINITY;
        }
        return BDouble.make((double)f);
    }

    private static BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    static {
        facetPropsByType.put(0, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(1, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(2, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(46, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(45, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(48, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(3, (Object)new int[]{4, 46});
        facetPropsByType.put(4, (Object)new int[]{4, 46});
        facetPropsByType.put(5, (Object)new int[]{4, 46});
        facetPropsByType.put(13, (Object)new int[]{110});
        facetPropsByType.put(14, (Object)new int[]{110});
        facetPropsByType.put(19, (Object)new int[]{110});
    }
}

