/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetScheduleTypeChangeJob;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="supervisorId", type="String", defaultValue="", flags=5, override=true), @NiagaraProperty(name="subordinateVersion", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=5, override=true), @NiagaraProperty(name="supervisorOrd", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"schedule:AbstractSchedule\"")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.SCHEDULE)", facets={@Facet(value="ScheduleSupport0.SCHEDULE_CALENDAR_OBJECT_ID_FACETS")}), @NiagaraProperty(name="dataType", type="String", defaultValue="", flags=1), @NiagaraProperty(name="priorityForWriting", type="int", defaultValue="16", facets={@Facet(value="BFacets.makeInt(1,16)")}), @NiagaraProperty(name="skipWrites", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="writeEnumAs", type="BEnum", defaultValue="BDynamicEnum.make(0, ENUM_DATA_TYPE_RANGE)"), @NiagaraProperty(name="outOfService", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="readFromDevice", flags=16), @NiagaraAction(name="readChangeTypeParams", returnType="BBacnetChangeTypeParm", flags=4), @NiagaraAction(name="changeType", parameterType="BBacnetChangeTypeParm", defaultValue="new BBacnetChangeTypeParm()", returnType="BOrd", flags=4)})
public class BBacnetScheduleExport
extends BScheduleExport {
    private static final BEnumRange ENUM_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(9), AsnUtil.getAsnTypeName(3)});
    @Generated
    public static final Property supervisorId = BBacnetScheduleExport.newProperty((int)5, (String)"", null);
    @Generated
    public static final Property subordinateVersion = BBacnetScheduleExport.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property supervisorOrd = BBacnetScheduleExport.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"schedule:AbstractSchedule"));
    @Generated
    public static final Property objectId = BBacnetScheduleExport.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(17), (BFacets)ScheduleSupport0.SCHEDULE_CALENDAR_OBJECT_ID_FACETS);
    @Generated
    public static final Property dataType = BBacnetScheduleExport.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property priorityForWriting = BBacnetScheduleExport.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    @Generated
    public static final Property skipWrites = BBacnetScheduleExport.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property writeEnumAs = BBacnetScheduleExport.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)ENUM_DATA_TYPE_RANGE), null);
    @Generated
    public static final Property outOfService = BBacnetScheduleExport.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action readFromDevice = BBacnetScheduleExport.newAction((int)16, null);
    @Generated
    public static final Action readChangeTypeParams = BBacnetScheduleExport.newAction((int)4, null);
    @Generated
    public static final Action changeType = BBacnetScheduleExport.newAction((int)4, (BValue)new BBacnetChangeTypeParm(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScheduleExport.class);
    private int asnType = -1;
    BEnum writeProperty = null;
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Logger logger = Logger.getLogger("bacnet.schedule");

    @Generated
    public BOrd getSupervisorOrd() {
        return (BOrd)this.get(supervisorOrd);
    }

    @Generated
    public void setSupervisorOrd(BOrd v) {
        this.set(supervisorOrd, (BValue)v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public String getDataType() {
        return this.getString(dataType);
    }

    @Generated
    public void setDataType(String v) {
        this.setString(dataType, v, null);
    }

    @Generated
    public int getPriorityForWriting() {
        return this.getInt(priorityForWriting);
    }

    @Generated
    public void setPriorityForWriting(int v) {
        this.setInt(priorityForWriting, v, null);
    }

    @Generated
    public BFacets getSkipWrites() {
        return (BFacets)this.get(skipWrites);
    }

    @Generated
    public void setSkipWrites(BFacets v) {
        this.set(skipWrites, (BValue)v, null);
    }

    @Generated
    public BEnum getWriteEnumAs() {
        return (BEnum)this.get(writeEnumAs);
    }

    @Generated
    public void setWriteEnumAs(BEnum v) {
        this.set(writeEnumAs, (BValue)v, null);
    }

    @Generated
    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    @Generated
    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    @Generated
    public void readFromDevice() {
        this.invoke(readFromDevice, null, null);
    }

    @Generated
    public BBacnetChangeTypeParm readChangeTypeParams() {
        return (BBacnetChangeTypeParm)this.invoke(readChangeTypeParams, null, null);
    }

    @Generated
    public BOrd changeType(BBacnetChangeTypeParm parameter) {
        return (BOrd)this.invoke(changeType, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetScheduleExport() {
    }

    public BBacnetScheduleExport(String sid) {
        this.setSupervisorId(sid);
    }

    public void started() throws Exception {
        super.started();
        this.setAsnType();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(supervisorOrd)) {
            this.setSupervisorId(this.getSupervisorOrd().toString());
            this.setDataType("");
        }
        if (p.equals(dataType)) {
            this.setAsnType();
        }
    }

    public String toString(Context cx) {
        return "BacnetScheduleExport_" + this.getObjectId().toString(cx);
    }

    public BAbstractSchedule getSupervisor() {
        BAbstractSchedule sch = null;
        try {
            sch = (BAbstractSchedule)this.getSupervisorOrd().resolve((BObject)this).get();
        }
        catch (Exception x) {
            throw new BajaRuntimeException(this.getSupervisorId(), (Throwable)x);
        }
        if (sch == null) {
            throw new IllegalArgumentException("Cannot resolve: " + this.getSupervisorId());
        }
        return sch;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == BDescriptor.execute) {
            if (this.isDisabled()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            if (this.getSupervisorOrd().equals((Object)BOrd.DEFAULT)) {
                return null;
            }
            if (objectId.isEquivalentToDefaultValue((BValue)this.getObjectId())) {
                return null;
            }
            if (BScheduleDeviceExt.getVersionOf((BAbstractSchedule)this.getSupervisor()).equals((Object)this.getSubordinateVersion())) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            try {
                return this.postExecute(action, arg, cx);
            }
            catch (Exception e) {
                this.executeFail(e);
                return null;
            }
        }
        if (action == readFromDevice) {
            return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public void doExecute() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BBacnetScheduleExport.doExecute on " + (Object)((Object)this));
        }
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        this.executeInProgress();
        try {
            this.validateSchedule();
            deviceExt.writeRemote(this);
            this.setSubordinateVersion(BAbsTime.now());
            this.executeOk();
            this.getDevice().pingOk();
        }
        catch (BacnetException e1) {
            logger.log(Level.WARNING, "BacnetException writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + (Object)((Object)e1), (Throwable)((Object)e1));
            this.executeFail((this.writeProperty != null ? this.writeProperty.getTag() : "null") + "::" + e1.toString());
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Exception writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + e2, e2);
            this.executeFail(e2);
        }
        finally {
            this.setState(BDescriptorState.idle);
        }
    }

    public void doReadFromDevice() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BBacnetScheduleExport.doReadFromDevice on " + (Object)((Object)this));
        }
        try {
            this.getSupervisor();
        }
        catch (Exception e) {
            this.executeFail(e);
        }
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        try {
            BAbstractSchedule ret = deviceExt.readRemote(this);
            if (ret != null) {
                this.importRemoteSubordinate((BControlSchedule)ret);
            }
            this.getDevice().pingOk();
        }
        catch (BacnetException e1) {
            logger.log(Level.SEVERE, "BacnetException reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e1), (Throwable)((Object)e1));
            this.executeFail((Throwable)((Object)e1));
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Exception reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + e2, e2);
            this.executeFail(e2);
        }
    }

    public BOrd doChangeType(BBacnetChangeTypeParm param) {
        return new BBacnetScheduleTypeChangeJob(BBacnetNetwork.bacnet(), this, param).submit(null);
    }

    private void setAsnType() {
        if (this.getDataType() == "" || this.getDataType().equals(lex.getText("asn.unknown"))) {
            this.setDataTypeFromSupervisor();
        }
        this.asnType = AsnUtil.getAsnType(this.getDataType());
    }

    private void setDataTypeFromSupervisor() {
        try {
            Type t = this.getSupervisor().getType();
            if (t.is(BBooleanSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(1));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (t.is(BNumericSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(4));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (t.is(BEnumSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(2));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) & 0xFFFFFFFB);
            } else {
                this.setDataType(AsnUtil.getAsnTypeName(7));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            }
        }
        catch (Exception e) {
            logger.info("Cannot determine ASN type for schedule export " + (Object)((Object)this) + ":invalid supervisor ord [" + this.getSupervisorOrd() + "]");
        }
    }

    public int getAsnType() {
        Type t = this.getSupervisor().getType();
        if (t.is(BEnumSchedule.TYPE)) {
            switch (this.getWriteEnumAs().getOrdinal()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 9;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return this.asnType;
    }

    public void importRemoteSubordinate(BControlSchedule remoteSubordinate) {
        BControlSchedule localSupervisor = (BControlSchedule)this.getSupervisor();
        if (!localSupervisor.getClass().equals(remoteSubordinate.getClass())) {
            throw new IllegalStateException("Incompatible Schedules: Import [" + remoteSubordinate.getClass().getName() + "] != " + localSupervisor.toPathString() + " [" + localSupervisor.getClass().getName() + "]");
        }
        boolean cleanup = localSupervisor.getCleanupExpiredEvents();
        remoteSubordinate.setCleanupExpiredEvents(cleanup);
        BFacets existingFacets = localSupervisor.getFacets();
        BBacnetScheduleExport.copyOver((BAbstractSchedule)remoteSubordinate, (BAbstractSchedule)localSupervisor);
        localSupervisor.setFacets(existingFacets);
    }

    protected static void copyOver(BAbstractSchedule source, BAbstractSchedule target) {
        target.copyFrom(source, null);
        target.set("lastModified", (BValue)BScheduleDeviceExt.getVersionOf((BAbstractSchedule)source));
    }

    protected void validateSchedule() {
        BAbstractSchedule as = this.getSupervisor();
        if (as instanceof BWeeklySchedule) {
            BWeeklySchedule ws = (BWeeklySchedule)as;
            BDailySchedule[] kids = ws.getSpecialEventsChildren();
            for (int i = 0; i < kids.length; ++i) {
                BDailySchedule daily = kids[i];
                if (daily.getDays() instanceof BCustomSchedule) {
                    throw new IllegalStateException("Cannot send CustomSchedule Special Events to BACnet");
                }
                BDaySchedule day = daily.getDay();
                SlotCursor sc = day.getProperties();
                while (sc.next(BTimeSchedule.class)) {
                    BTimeSchedule ts = (BTimeSchedule)sc.get();
                    if (!ts.getEffectiveValue().getStatus().isNull()) continue;
                    throw new IllegalStateException("Cannot write NULL-valued TimeSchedules to BACnet");
                }
            }
        }
    }

    public BBacnetChangeTypeParm doReadChangeTypeParams() {
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        BBacnetDevice dev = deviceExt.device();
        BBacnetChangeTypeParm ctp = new BBacnetChangeTypeParm();
        ctp.setDataType(this.getDataType());
        ctp.setSupervisorOrd(this.getSupervisorOrd());
        try {
            BBacnetAddress adr = dev.getAddress();
            BBacnetObjectIdentifier oid = this.getObjectId();
            BBacnetClientLayer cl = deviceExt.client();
            AsnInputStream asnIn = new AsnInputStream();
            byte[] encodedValue = cl.readProperty(adr, oid, 174);
            asnIn.setBuffer(encodedValue);
            ctp.getScheduleDefault().readAsn(asnIn);
            encodedValue = cl.readProperty(adr, oid, 54);
            asnIn.setBuffer(encodedValue);
            ctp.getListOfObjectPropertyRefs().readAsn(asnIn);
            try {
                encodedValue = cl.readProperty(adr, oid, 123);
                asnIn.setBuffer(encodedValue);
                ctp.getWeeklySchedule().readAsn(asnIn);
                ctp.setHasWeeklySchedule(true);
            }
            catch (ErrorException e) {
                ctp.setHasWeeklySchedule(false);
            }
            try {
                encodedValue = cl.readProperty(adr, oid, 38);
                asnIn.setBuffer(encodedValue);
                ctp.getExceptionSchedule().readAsn(asnIn);
                ctp.setHasExceptionSchedule(true);
            }
            catch (ErrorException e) {
                ctp.setHasExceptionSchedule(false);
            }
            return ctp;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "doReadChangeTypeParams failed with exception", e);
            return null;
        }
    }
}

