/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.client;

import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedCovNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.confirmed.ListElementRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedCovNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.stack.AppDebugListener;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="deviceNameEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="deviceName", type="String", defaultValue=""), @NiagaraProperty(name="addressEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="deviceAddress", type="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT"), @NiagaraProperty(name="serviceChoiceEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="serviceChoices", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetServicesSupported\"))", facets={@Facet(value="BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS")}), @NiagaraProperty(name="objectIdEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT")})
public class BClientDebugListener
extends BComponent
implements AppDebugListener {
    @Generated
    public static final Property enabled = BClientDebugListener.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property deviceNameEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property deviceName = BClientDebugListener.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property addressEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property deviceAddress = BClientDebugListener.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Property serviceChoiceEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property serviceChoices = BClientDebugListener.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), (BFacets)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS);
    @Generated
    public static final Property objectIdEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property objectId = BClientDebugListener.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BClientDebugListener.class);
    private static final int[] confirmedServiceChoiceMap = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 35, 37, 38, 39};
    private static final int[] unconfirmedServiceChoiceMap = new int[]{26, 27, 28, 29, 30, 31, 32, 33, 34, 36};
    private static final Logger logger = Logger.getLogger("bacnet.client");

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getDeviceNameEnabled() {
        return this.getBoolean(deviceNameEnabled);
    }

    @Generated
    public void setDeviceNameEnabled(boolean v) {
        this.setBoolean(deviceNameEnabled, v, null);
    }

    @Generated
    public String getDeviceName() {
        return this.getString(deviceName);
    }

    @Generated
    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    @Generated
    public boolean getAddressEnabled() {
        return this.getBoolean(addressEnabled);
    }

    @Generated
    public void setAddressEnabled(boolean v) {
        this.setBoolean(addressEnabled, v, null);
    }

    @Generated
    public BBacnetAddress getDeviceAddress() {
        return (BBacnetAddress)this.get(deviceAddress);
    }

    @Generated
    public void setDeviceAddress(BBacnetAddress v) {
        this.set(deviceAddress, (BValue)v, null);
    }

    @Generated
    public boolean getServiceChoiceEnabled() {
        return this.getBoolean(serviceChoiceEnabled);
    }

    @Generated
    public void setServiceChoiceEnabled(boolean v) {
        this.setBoolean(serviceChoiceEnabled, v, null);
    }

    @Generated
    public BBacnetBitString getServiceChoices() {
        return (BBacnetBitString)this.get(serviceChoices);
    }

    @Generated
    public void setServiceChoices(BBacnetBitString v) {
        this.set(serviceChoices, (BValue)v, null);
    }

    @Generated
    public boolean getObjectIdEnabled() {
        return this.getBoolean(objectIdEnabled);
    }

    @Generated
    public void setObjectIdEnabled(boolean v) {
        this.setBoolean(objectIdEnabled, v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BBacnetClientLayer clientLayer = this.getClient();
        if (clientLayer != null) {
            clientLayer.addDebugListener(this);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        BBacnetClientLayer clientLayer = this.getClient();
        if (clientLayer != null) {
            clientLayer.removeDebugListener(this);
        }
    }

    @Override
    public void receive(BBacnetAddress address, BacnetServicePrimitive message) {
        if (this.passFilter(address, message, true)) {
            this.display(address, message, true);
        }
    }

    @Override
    public void send(BBacnetAddress address, BacnetServicePrimitive message) {
        if (this.passFilter(address, message, false)) {
            this.display(address, message, false);
        }
    }

    protected boolean passFilter(BBacnetAddress address, BacnetServicePrimitive message, boolean rcv) {
        if (message == null) {
            return false;
        }
        try {
            if (!this.getEnabled()) {
                return false;
            }
            boolean pass = true;
            if (this.getAddressEnabled()) {
                pass = this.checkAddress(address);
            }
            if (!pass) {
                return false;
            }
            if (this.getDeviceNameEnabled()) {
                pass = this.checkDeviceName(address);
            }
            if (!pass) {
                return false;
            }
            if (this.getServiceChoiceEnabled()) {
                pass = this.checkServiceChoice(message);
            }
            if (!pass) {
                return false;
            }
            if (this.getObjectIdEnabled()) {
                pass = this.checkObjectId(message);
            }
            if (!pass) {
                return false;
            }
            return pass;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "passFilter exception occurred: ", e);
            return false;
        }
    }

    private boolean checkAddress(BBacnetAddress address) {
        return BClientDebugListener.equals(address, this.getDeviceAddress());
    }

    private boolean checkDeviceName(BBacnetAddress address) {
        BBacnetNetwork net = BBacnetNetwork.bacnet();
        BBacnetDevice dev = net.lookupDeviceByAddress(address);
        if (dev == null) {
            return false;
        }
        return dev.getName().equals(this.getDeviceName());
    }

    private boolean checkServiceChoice(BacnetServicePrimitive message) {
        int serviceType = message.getServiceType();
        int serviceChoice = message.getServiceChoice();
        switch (serviceType) {
            case 1: {
                return this.getServiceChoices().getBit(unconfirmedServiceChoiceMap[serviceChoice]);
            }
            case 0: 
            case 2: 
            case 3: {
                return this.getServiceChoices().getBit(confirmedServiceChoiceMap[serviceChoice]);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return false;
    }

    private boolean checkObjectId(BacnetServicePrimitive message) {
        int serviceType = message.getServiceType();
        int serviceChoice = message.getServiceChoice();
        switch (serviceType) {
            case 0: {
                return this.checkConfirmed(serviceChoice, (BacnetConfirmedRequest)message);
            }
            case 1: {
                return this.checkUnconfirmed(serviceChoice, (BacnetUnconfirmedRequest)message);
            }
            case 3: {
                return this.checkComplexAck(serviceChoice, (BacnetComplexAck)message);
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return false;
    }

    private boolean checkConfirmed(int serviceChoice, BacnetConfirmedRequest message) {
        BBacnetObjectIdentifier myId = this.getObjectId();
        switch (serviceChoice) {
            case 0: {
                return myId.equals((Object)((AcknowledgeAlarmRequest)message).getEventObjectId());
            }
            case 1: {
                return myId.equals((Object)((ConfirmedCovNotificationRequest)message).getCovNotificationParameters().getMonitoredObjectId());
            }
            case 2: {
                return myId.equals((Object)((ConfirmedEventNotificationRequest)message).getEventNotificationParameters().getEventObjectId());
            }
            case 29: {
                return myId.equals((Object)((GetEventInformationRequest)message).getLastReceivedObjectId());
            }
            case 5: {
                return myId.equals((Object)((SubscribeCovRequest)message).getMonitoredObjectId());
            }
            case 6: {
                return myId.equals((Object)((AtomicReadFileRequest)message).getFileId());
            }
            case 7: {
                return myId.equals((Object)((AtomicWriteFileRequest)message).getFileId());
            }
            case 8: {
                return myId.equals((Object)((ListElementRequest)message).getObjectId());
            }
            case 9: {
                return myId.equals((Object)((ListElementRequest)message).getObjectId());
            }
            case 12: {
                return myId.equals((Object)((ReadPropertyRequest)message).getObjectId());
            }
            case 14: {
                ListIterator<NReadAccessSpec> rit = ((ReadPropertyMultipleRequest)message).getReadAccessSpecs();
                while (rit.hasNext()) {
                    if (!myId.equals((Object)rit.next().getObjectId())) continue;
                    return true;
                }
                return false;
            }
            case 26: {
                return myId.equals((Object)((ReadRangeRequest)message).getObjectId());
            }
            case 15: {
                return myId.equals((Object)((WritePropertyRequest)message).getObjectId());
            }
            case 16: {
                ListIterator<NWriteAccessSpec> wit = ((WritePropertyMultipleRequest)message).getWriteAccessSpecs();
                while (wit.hasNext()) {
                    if (!myId.equals((Object)wit.next().getObjectId())) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean checkUnconfirmed(int serviceChoice, BacnetUnconfirmedRequest message) {
        BBacnetObjectIdentifier myId = this.getObjectId();
        switch (serviceChoice) {
            case 0: {
                return myId.equals((Object)((IAmRequest)message).getObjectId());
            }
            case 1: {
                return myId.equals((Object)((IHaveRequest)message).getObjectId());
            }
            case 2: {
                return myId.equals((Object)((UnconfirmedCovNotificationRequest)message).getCovNotificationParameters().getMonitoredObjectId());
            }
            case 3: {
                return myId.equals((Object)((UnconfirmedEventNotificationRequest)message).getEventNotificationParameters().getEventObjectId());
            }
            case 7: {
                return myId.equals((Object)((WhoHasRequest)message).getObjectId());
            }
        }
        return false;
    }

    private boolean checkComplexAck(int serviceChoice, BacnetComplexAck message) {
        BBacnetObjectIdentifier myId = this.getObjectId();
        switch (serviceChoice) {
            case 12: {
                return this.getObjectId().equals((Object)((ReadPropertyAck)message).getObjectId());
            }
            case 14: {
                ListIterator it = ((ReadPropertyMultipleAck)message).getReadAccessResults();
                while (it.hasNext()) {
                    if (!myId.equals((Object)((NReadAccessResult)it.next()).getObjectId())) continue;
                    return true;
                }
                return false;
            }
            case 26: {
                return myId.equals((Object)((ReadRangeAck)message).getObjectId());
            }
        }
        return false;
    }

    private BBacnetClientLayer getClient() {
        BClientDebugListener parent = this;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof BBacnetClientLayer)) continue;
            return (BBacnetClientLayer)((Object)parent);
        }
        return null;
    }

    private static boolean equals(BBacnetAddress a1, BBacnetAddress a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        return a1.equals(a2.getNetworkNumber(), a2.getMacAddress().getBytes());
    }

    private void display(BBacnetAddress address, BacnetServicePrimitive message, boolean recv) {
        if (recv) {
            System.out.println("BACnet Recv [" + address + "]:" + message);
        } else {
            System.out.println("BACnet Send [" + address + "]:" + message);
        }
    }
}

