/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ethernet;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.util.LinkLayerUtil;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.EthernetConst;
import com.tridium.platBacnet.EthernetListener;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="adapterTitle", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noTitleArray))", flags=64), @NiagaraProperty(name="adapterDescription", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noDescriptionArray))", flags=65), @NiagaraProperty(name="adapterName", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noNameArray))", flags=65)})
public class BBacnetEthernetLinkLayer
extends BBacnetLinkLayer
implements EthernetConst,
EthernetListener {
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final String NONE = SlotPath.escape((String)lex.getText("ethernet.adapter.none"));
    private static String[] noTitleArray = new String[]{NONE};
    private static String[] noNameArray = new String[]{NONE};
    private static String[] noDescriptionArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    @Generated
    public static final Property adapterTitle = BBacnetEthernetLinkLayer.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noTitleArray)), null);
    @Generated
    public static final Property adapterDescription = BBacnetEthernetLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noDescriptionArray)), null);
    @Generated
    public static final Property adapterName = BBacnetEthernetLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noNameArray)), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEthernetLinkLayer.class);
    private static final Logger logger = Logger.getLogger("bacnet.link.ethernet");
    private static int MAC_ADDRESS_SIZE = 6;
    private boolean commStarted = false;
    private byte[] myMacAddress;
    private String oldDeviceName = null;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private BacnetEthernetAdapter adapter;

    @Generated
    public BEnum getAdapterTitle() {
        return (BEnum)this.get(adapterTitle);
    }

    @Generated
    public void setAdapterTitle(BEnum v) {
        this.set(adapterTitle, (BValue)v, null);
    }

    @Generated
    public BEnum getAdapterDescription() {
        return (BEnum)this.get(adapterDescription);
    }

    @Generated
    public void setAdapterDescription(BEnum v) {
        this.set(adapterDescription, (BValue)v, null);
    }

    @Generated
    public BEnum getAdapterName() {
        return (BEnum)this.get(adapterName);
    }

    @Generated
    public void setAdapterName(BEnum v) {
        this.set(adapterName, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetEthernetPlatformService getPlatformService() {
        try {
            return (BBacnetEthernetPlatformService)Sys.getService((Type)BBacnetEthernetPlatformService.TYPE);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to resolve BacnetEthernetPlatformService", e);
            return null;
        }
    }

    @Override
    public final void linkCommInit() {
        BBacnetEthernetPlatformService platformService = this.getPlatformService();
        if (platformService != null) {
            platformService.init();
        }
    }

    @Override
    public final void linkCommStart() throws Exception {
        this.myMacAddress = new byte[MAC_ADDRESS_SIZE];
        BBacnetEthernetPlatformService platSvc = this.getPlatformService();
        if (platSvc == null) {
            logger.severe("BBacnetEthernetPlatformService unavailable, can not start link layer");
            return;
        }
        this.adapter = platSvc.openAdapter(SlotPath.unescape((String)this.getAdapterName().getTag()));
        this.adapter.addListener((EthernetListener)this);
        this.adapter.commStart();
        this.adapter.getAddress(this.myMacAddress);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("My MAC address:" + ByteArrayUtil.toHexString((byte[])this.myMacAddress));
        }
        this.commStarted = true;
    }

    @Override
    public final void linkCommStop() {
        this.adapter.removeListener((EthernetListener)this);
        this.adapter.commStop();
        this.commStarted = false;
    }

    @Override
    public final void linkCommCleanup() {
        this.adapter.commCleanup();
        this.adapter.removeListener((EthernetListener)this);
    }

    private void setAdapter() {
        int ordinal;
        String currentAdapterName;
        String previousAdapterName = this.getAdapterName().getTag();
        boolean traceOn = logger.isLoggable(Level.FINE);
        if (traceOn) {
            logger.fine("Ethernet adapter original adapter name '" + previousAdapterName + "'");
        }
        Vector<String> allTitles = new Vector<String>();
        Vector<String> allDescriptions = new Vector<String>();
        Vector<String> allNames = new Vector<String>();
        BBacnetEthernetPlatformService platformService = this.getPlatformService();
        if (platformService == null) {
            logger.warning("BBacnetEthernetPlatformService unavailable, can not set adapter");
            return;
        }
        try {
            platformService.getAdapterChoices(allTitles, allDescriptions, allNames);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception querying ethernet platform service for adapter choices", e);
        }
        BBacnetEthernetLinkLayer.handleMissingAdapter(previousAdapterName, allTitles, allDescriptions, allNames);
        if (traceOn) {
            logger.fine("Ethernet Adapter Title list size:" + allTitles.size());
        }
        BEnumRange titles = LinkLayerUtil.makeEnumRange(allTitles, true, NONE);
        BEnumRange descriptions = LinkLayerUtil.makeEnumRange(allDescriptions, true, NONE);
        BEnumRange names = LinkLayerUtil.makeEnumRange(allNames, false, NONE);
        if (traceOn) {
            logger.fine("Current ethernet adapter lists:");
            for (int i = 0; i < titles.getOrdinals().length; ++i) {
                logger.fine(i + ": title=" + titles + " desc=" + descriptions + " name=" + names);
            }
        }
        if (!(currentAdapterName = LinkLayerUtil.select(ordinal = LinkLayerUtil.ordinal(previousAdapterName, names, NONE), names).getTag()).equals(previousAdapterName)) {
            logger.warning("Previous ethernet adapter '" + previousAdapterName + "' unavailable, configuration reverted to '" + currentAdapterName + "'");
        }
        this.setAdapterTitle((BEnum)LinkLayerUtil.select(ordinal, titles));
        this.setAdapterDescription((BEnum)LinkLayerUtil.select(ordinal, descriptions));
        this.setAdapterName((BEnum)LinkLayerUtil.select(ordinal, names));
    }

    private static void handleMissingAdapter(String previousAdapterName, Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) {
        if (!(previousAdapterName = SlotPath.unescape((String)previousAdapterName)).equals(NONE) && !BBacnetEthernetLinkLayer.containsCurrentAdapter(previousAdapterName, adapterNames) && LinkLayerUtil.isAutoAdapterChangeDisabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding a placeholder for the previously selected adapter \"" + previousAdapterName + '\"' + " when system property niagara.bacnet.link.autoAdapterChange.disabled is true.");
            }
            adapterTitles.add(previousAdapterName);
            adapterDescriptions.add(previousAdapterName);
            adapterNames.add(previousAdapterName);
        }
    }

    private static boolean containsCurrentAdapter(String previousAdapterName, Vector<String> adapterNames) {
        for (String adapterName : adapterNames) {
            if (!previousAdapterName.equals(adapterName)) continue;
            return true;
        }
        return false;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == adapterTitle) {
            this.setAdapterDescription(this.getAdapterDescription().getRange().get(this.getAdapterTitle().getOrdinal()));
            this.setAdapterName(this.getAdapterName().getRange().get(this.getAdapterTitle().getOrdinal()));
        } else if (p == adapterName) {
            String newDeviceName = this.getAdapterName().getTag();
            if (!newDeviceName.equals(this.oldDeviceName) && this.commStarted && !this.getAdapterTitle().getTag().equals(this.getLexicon().getText("ethernet.adapterTitle.none"))) {
                this.getNetworkPort().disable();
                this.getNetworkPort().enable();
            }
            this.oldDeviceName = newDeviceName;
        }
    }

    public void started() {
        this.oldDeviceName = this.getAdapterName().getTag();
        BBacnetNetwork.bacnet().postAsync(new Runnable(){

            @Override
            public void run() {
                BBacnetEthernetLinkLayer.this.setAdapter();
            }
        });
    }

    public void receivePacket(byte[] packet, int bytesRcvd) {
        BacnetInputStream is;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\nPacket Received (" + bytesRcvd + " bytes):");
            ByteArrayUtil.hexDump((byte[])packet, (int)0, (int)bytesRcvd);
        }
        if ((is = BacnetInputStream.make(packet, 0, bytesRcvd)).skip(MAC_ADDRESS_SIZE) != (long)MAC_ADDRESS_SIZE) {
            logger.log(Level.SEVERE, "Failed to skip destination address in read!");
            return;
        }
        byte[] sourceAddress = new byte[MAC_ADDRESS_SIZE];
        if (is.read(sourceAddress, 0, MAC_ADDRESS_SIZE) != MAC_ADDRESS_SIZE) {
            logger.log(Level.SEVERE, "Failed to read source address in read!");
            return;
        }
        int llcLength = is.read();
        llcLength <<= 8;
        if (is.available() < (llcLength |= is.read())) {
            logger.log(Level.SEVERE, "LLC Length does not match!" + is.available() + " != " + llcLength + " packetLength: " + bytesRcvd);
            return;
        }
        int dsap = is.read();
        int ssap = is.read();
        int llcControl = is.read();
        if (dsap != 130 || ssap != 130 || llcControl != 3) {
            logger.log(Level.INFO, "Invalid packet received!  DSAP=" + dsap + ", SSAP=" + ssap + ", llcCtl=" + llcControl);
            ByteArrayUtil.hexDump((byte[])packet);
            return;
        }
        this.rcvIndication(sourceAddress, this.myMacAddress, is);
    }

    @Override
    public byte[] getMacAddress() {
        return this.myMacAddress;
    }

    @Override
    public int getMaxAPDULengthAccepted() {
        return 1476;
    }

    @Override
    public synchronized void sendRequest(byte[] destAddress, NetworkPdu npdu) {
        this.os.reset();
        if (destAddress == null || destAddress.length == 0) {
            this.os.write(BCAST_MAC_ADDRESS, 0, BCAST_MAC_ADDRESS.length);
        } else {
            this.os.write(destAddress, 0, destAddress.length);
        }
        this.os.write(this.myMacAddress, 0, this.myMacAddress.length);
        this.os.write(0);
        this.os.write(0);
        this.os.write(130);
        this.os.write(130);
        this.os.write(3);
        npdu.writeNetworkBytes(this.os);
        byte[] outBuffer = this.os.toByteArray();
        int llcLength = outBuffer.length - 14;
        outBuffer[12] = (byte)((llcLength & 0xFF00) >> 8);
        outBuffer[13] = (byte)(llcLength & 0xFF);
        try {
            this.adapter.sendPacket(outBuffer);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("\nPacket Sent:");
                ByteArrayUtil.hexDump((byte[])outBuffer);
            }
        }
        catch (Exception e) {
            this.getNetworkPort().fault("Cannot send Bacnet/Ethernet packet! Is the adapter enabled in the TCP/IP Platform Service?");
            logger.log(Level.SEVERE, "Cannot send Bacnet/Ethernet packet!", e);
        }
    }
}

