/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.enums.BIpDeviceType;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.BFdtEntry;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceTable;
import com.tridium.bacnet.stack.link.ip.BacnetNetworkAdapter;
import com.tridium.bacnet.stack.link.ip.BacnetNetworkInterface;
import com.tridium.bacnet.stack.link.ip.BvlcResult;
import com.tridium.bacnet.stack.link.ip.BvllConst;
import com.tridium.bacnet.stack.link.ip.BvllMessage;
import com.tridium.bacnet.stack.link.ip.DistributeBroadcastToNetwork;
import com.tridium.bacnet.stack.link.ip.ForwardedNpdu;
import com.tridium.bacnet.stack.link.ip.OriginalBroadcastNpdu;
import com.tridium.bacnet.stack.link.ip.OriginalUnicastNpdu;
import com.tridium.bacnet.stack.link.ip.ReadBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.ReadBroadcastDistributionTableAck;
import com.tridium.bacnet.stack.link.ip.ReadForeignDeviceTableAck;
import com.tridium.bacnet.stack.link.ip.WriteBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.util.BacnetIpAdapter;
import com.tridium.bacnet.stack.link.ip.util.BacnetIpInterface;
import com.tridium.bacnet.stack.link.ip.util.BacnetIpLinkUtil;
import com.tridium.bacnet.stack.link.ip.util.NetworkInterfaceProvider;
import com.tridium.bacnet.stack.link.util.LinkLayerUtil;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.nre.platform.PlatformUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="adapter", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noAdapterArray))", flags=64, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:FrozenEnumFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:FrozenEnumEditor\"")}), @NiagaraProperty(name="adapterId", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noAdapterIdArray))", flags=69), @NiagaraProperty(name="ipAddress", type="BEnum", defaultValue="BDynamicEnum.make(-1, BEnumRange.make(noneOrdinals, noAdapterIpArray))", flags=65), @NiagaraProperty(name="udpPort", type="String", defaultValue="BBacnetIpLinkLayer.UDP_PORT_DEFAULT"), @NiagaraProperty(name="ipDeviceType", type="BIpDeviceType", defaultValue="BIpDeviceType.standard"), @NiagaraProperty(name="bbmdAddress", type="String", defaultValue="BBacnetIpLinkLayer.BBMD_ADDRESS_DEFAULT"), @NiagaraProperty(name="registrationLifetime", type="BRelTime", defaultValue="BRelTime.make(15 * BRelTime.MILLIS_IN_MINUTE)"), @NiagaraProperty(name="broadcastDistributionTable", type="BBroadcastDistributionTable", defaultValue="new BBroadcastDistributionTable()"), @NiagaraProperty(name="foreignDeviceTable", type="BForeignDeviceTable", defaultValue="new BForeignDeviceTable()"), @NiagaraProperty(name="adapterDebug", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="bbmdDebug", type="boolean", defaultValue="false"), @NiagaraProperty(name="autoPollEnabled", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="adapterPollInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", flags=4, facets={@Facet(name="BFacets.MIN", value="BRelTime.make(10)")})})
@NiagaraActions(value={@NiagaraAction(name="dump"), @NiagaraAction(name="readBroadcastDistributionTable", parameterType="BString", defaultValue="BString.make(\"Enter BBMD B/IP Address\")"), @NiagaraAction(name="writeBroadcastDistributionTable", parameterType="BString", defaultValue="BString.make(\"Enter BBMD B/IP Address\")"), @NiagaraAction(name="updateAllBDTs", flags=20), @NiagaraAction(name="queryForAdapters", flags=128)})
public class BBacnetIpLinkLayer
extends BBacnetLinkLayer
implements Runnable,
BvllConst {
    private static String NONE = lex.getText("ip.adapter.none");
    private static String[] noAdapterArray = new String[]{NONE};
    private static String[] noAdapterIdArray = new String[]{NONE};
    private static String[] noAdapterIpArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    private static String DISABLED = lex.getText("ip.adapter.disabled");
    private static String NO_ADDRESS = lex.getText("ip.adapter.noAddress");
    @Generated
    public static final Property adapter = BBacnetIpLinkLayer.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterArray)), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:FrozenEnumFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"webEditors:FrozenEnumEditor")));
    @Generated
    public static final Property adapterId = BBacnetIpLinkLayer.newProperty((int)69, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIdArray)), null);
    @Generated
    public static final Property ipAddress = BBacnetIpLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIpArray)), null);
    @Generated
    public static final Property udpPort = BBacnetIpLinkLayer.newProperty((int)0, (String)"0xBAC0", null);
    @Generated
    public static final Property ipDeviceType = BBacnetIpLinkLayer.newProperty((int)0, (BValue)BIpDeviceType.standard, null);
    @Generated
    public static final Property bbmdAddress = BBacnetIpLinkLayer.newProperty((int)0, (String)"null", null);
    @Generated
    public static final Property registrationLifetime = BBacnetIpLinkLayer.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    @Generated
    public static final Property broadcastDistributionTable = BBacnetIpLinkLayer.newProperty((int)0, (BValue)new BBroadcastDistributionTable(), null);
    @Generated
    public static final Property foreignDeviceTable = BBacnetIpLinkLayer.newProperty((int)0, (BValue)new BForeignDeviceTable(), null);
    @Generated
    public static final Property adapterDebug = BBacnetIpLinkLayer.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property bbmdDebug = BBacnetIpLinkLayer.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property autoPollEnabled = BBacnetIpLinkLayer.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property adapterPollInterval = BBacnetIpLinkLayer.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)10L)));
    @Generated
    public static final Action dump = BBacnetIpLinkLayer.newAction((int)0, null);
    @Generated
    public static final Action readBroadcastDistributionTable = BBacnetIpLinkLayer.newAction((int)0, (BValue)BString.make((String)"Enter BBMD B/IP Address"), null);
    @Generated
    public static final Action writeBroadcastDistributionTable = BBacnetIpLinkLayer.newAction((int)0, (BValue)BString.make((String)"Enter BBMD B/IP Address"), null);
    @Generated
    public static final Action updateAllBDTs = BBacnetIpLinkLayer.newAction((int)20, null);
    @Generated
    public static final Action queryForAdapters = BBacnetIpLinkLayer.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetIpLinkLayer.class);
    public static final int PACKET_LENGTH = 1500;
    public static final int MAX_APDU_LENGTH = 1476;
    public static final byte[] DEFAULT_SUBNET_MASK = new byte[]{-1, -1, -1, 0};
    public static final byte[] TWO_HOP_DIST_MASK = new byte[]{-1, -1, -1, -1};
    private static final boolean LOCALHOST_ADAPTER_ALLOWED = Boolean.getBoolean("niagara.bacnet.link.ip.localhost.allow");
    private static final Logger logger = Logger.getLogger("bacnet.link.ip");
    private static int IPV4_HOST_OCTETS = 4;
    private static final String UDP_PORT_DEFAULT = "0xBAC0";
    private static final String BBMD_ADDRESS_DEFAULT = "null";
    private static final int NOT_FOUND = -1;
    private Object PORT_LOCK = new Object();
    private DatagramSocket server;
    private DatagramSocket broadcastServer = null;
    private BroadcastWorker broadcastWorker = null;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private DatagramPacket datagramOut = new DatagramPacket(new byte[0], 0);
    private String bindType = "none";
    private volatile boolean alive = false;
    private Thread myThread;
    private String oldIpAddr;
    private int myUdpPort;
    private byte[] localBroadcastAddr;
    private IntHashMap inetAddressTable = new IntHashMap();
    private Hashtable<String, byte[]> macTable = new Hashtable();
    private InetAddress bbmdInet = null;
    private int bbmdPort = -1;
    private byte[] bbmdMac;
    private int oldIpDeviceType = 0;
    protected byte[] myIp;
    protected byte[] myMac;
    protected volatile short netmask;
    private String[] bbmdMsgs;
    private int ndx = 0;
    private NetworkInterfaceProvider interfaceProvider = new JvmNetworkInterfaceProvider();
    private Clock.Ticket ticketAdapterPolling;

    @Generated
    public BEnum getAdapter() {
        return (BEnum)this.get(adapter);
    }

    @Generated
    public void setAdapter(BEnum v) {
        this.set(adapter, (BValue)v, null);
    }

    @Generated
    public BEnum getAdapterId() {
        return (BEnum)this.get(adapterId);
    }

    @Generated
    public void setAdapterId(BEnum v) {
        this.set(adapterId, (BValue)v, null);
    }

    @Generated
    public BEnum getIpAddress() {
        return (BEnum)this.get(ipAddress);
    }

    @Generated
    public void setIpAddress(BEnum v) {
        this.set(ipAddress, (BValue)v, null);
    }

    @Generated
    public String getUdpPort() {
        return this.getString(udpPort);
    }

    @Generated
    public void setUdpPort(String v) {
        this.setString(udpPort, v, null);
    }

    @Generated
    public BIpDeviceType getIpDeviceType() {
        return (BIpDeviceType)this.get(ipDeviceType);
    }

    @Generated
    public void setIpDeviceType(BIpDeviceType v) {
        this.set(ipDeviceType, (BValue)v, null);
    }

    @Generated
    public String getBbmdAddress() {
        return this.getString(bbmdAddress);
    }

    @Generated
    public void setBbmdAddress(String v) {
        this.setString(bbmdAddress, v, null);
    }

    @Generated
    public BRelTime getRegistrationLifetime() {
        return (BRelTime)this.get(registrationLifetime);
    }

    @Generated
    public void setRegistrationLifetime(BRelTime v) {
        this.set(registrationLifetime, (BValue)v, null);
    }

    @Generated
    public BBroadcastDistributionTable getBroadcastDistributionTable() {
        return (BBroadcastDistributionTable)this.get(broadcastDistributionTable);
    }

    @Generated
    public void setBroadcastDistributionTable(BBroadcastDistributionTable v) {
        this.set(broadcastDistributionTable, (BValue)v, null);
    }

    @Generated
    public BForeignDeviceTable getForeignDeviceTable() {
        return (BForeignDeviceTable)this.get(foreignDeviceTable);
    }

    @Generated
    public void setForeignDeviceTable(BForeignDeviceTable v) {
        this.set(foreignDeviceTable, (BValue)v, null);
    }

    @Generated
    public boolean getAdapterDebug() {
        return this.getBoolean(adapterDebug);
    }

    @Generated
    public void setAdapterDebug(boolean v) {
        this.setBoolean(adapterDebug, v, null);
    }

    @Generated
    public boolean getBbmdDebug() {
        return this.getBoolean(bbmdDebug);
    }

    @Generated
    public void setBbmdDebug(boolean v) {
        this.setBoolean(bbmdDebug, v, null);
    }

    @Generated
    public boolean getAutoPollEnabled() {
        return this.getBoolean(autoPollEnabled);
    }

    @Generated
    public void setAutoPollEnabled(boolean v) {
        this.setBoolean(autoPollEnabled, v, null);
    }

    @Generated
    public BRelTime getAdapterPollInterval() {
        return (BRelTime)this.get(adapterPollInterval);
    }

    @Generated
    public void setAdapterPollInterval(BRelTime v) {
        this.set(adapterPollInterval, (BValue)v, null);
    }

    @Generated
    public void dump() {
        this.invoke(dump, null, null);
    }

    @Generated
    public void readBroadcastDistributionTable(BString parameter) {
        this.invoke(readBroadcastDistributionTable, (BValue)parameter, null);
    }

    @Generated
    public void writeBroadcastDistributionTable(BString parameter) {
        this.invoke(writeBroadcastDistributionTable, (BValue)parameter, null);
    }

    @Generated
    public void updateAllBDTs() {
        this.invoke(updateAllBDTs, null, null);
    }

    @Generated
    public void queryForAdapters() {
        this.invoke(queryForAdapters, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void linkCommInit() {
        this.updateLocalAddress();
    }

    @Override
    public void linkCommStart() throws Exception {
        this.startReception();
        if (this.isBBMDActive()) {
            this.initializeBDT();
        }
    }

    @Override
    public void linkCommStop() {
        this.stopReception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkCommCleanup() {
        Object object = this.PORT_LOCK;
        synchronized (object) {
            this.myIp = null;
            this.myMac = null;
            if (this.server != null) {
                this.server.close();
            }
            this.server = null;
            if (this.broadcastServer != null) {
                this.broadcastServer.close();
            }
            this.broadcastServer = null;
            this.oldIpAddr = null;
            this.localBroadcastAddr = null;
        }
    }

    public void started() {
        this.oldIpDeviceType = this.getIpDeviceType().getOrdinal();
        this.oldIpAddr = this.getIpAddress().getTag();
        if (this.getBbmdDebug()) {
            this.bbmdMsgs = new String[this.getBbmdMsgsSize()];
        }
        BBacnetNetwork.bacnet().postAsync(new Runnable(){

            @Override
            public void run() {
                BBacnetIpLinkLayer.this.setTcpIpAdapter();
            }
        });
        if (this.getAutoPollEnabled()) {
            this.startAdapterPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() {
        Object object = this.PORT_LOCK;
        synchronized (object) {
            this.inetAddressTable = null;
            this.macTable = null;
            this.os = null;
            this.datagramOut = null;
            this.bbmdInet = null;
            this.bbmdMac = null;
        }
        this.stopAdapterPolling();
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder("B/IP (");
        sb.append(this.getIpAddress()).append(':').append(this.getUdpPort()).append(") ").append((Object)this.getIpDeviceType());
        return sb.toString();
    }

    protected boolean processCustomBvllMessage(InetAddress srcInet, byte[] srcIp, int srcPort, int srcLength, byte[] data) {
        return false;
    }

    private void debug(String s) {
        if (this.getAdapterDebug()) {
            System.out.println("BACnet TcpIpAdapterDebug:" + s);
        }
    }

    private void debugFilteredAdapters(Collection<BacnetNetworkAdapter> filtered) {
        if (this.getAdapterDebug()) {
            this.debug("Included adapters filter: " + AccessController.doPrivileged(() -> System.getProperty("niagara.bacnet.included.ip.adapters", "")));
            this.debug("Excluded adapters filter: " + AccessController.doPrivileged(() -> System.getProperty("niagara.bacnet.excluded.ip.adapters", "")));
            this.debug("Remaining adapters after applying filters:");
            for (BacnetNetworkAdapter adapter : filtered) {
                this.debug("  ID: " + adapter.getIdentifier() + ", description: " + adapter.getDescription() + ", address: " + adapter.getAddress() + ", isLoopback? " + adapter.isLoopback());
            }
        }
    }

    protected void setTcpIpAdapter() {
        AccessController.doPrivileged(new SetTcpIpPrivilegedAction(this.interfaceProvider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        this.debug("IpLL.changed: p=" + p);
        if (p.equals(ipDeviceType)) {
            if (this.alive) {
                switch (this.oldIpDeviceType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.stopForeignDeviceRegistration();
                        break;
                    }
                }
                int bdtFlags = this.getFlags((Slot)broadcastDistributionTable);
                int fdtFlags = this.getFlags((Slot)foreignDeviceTable);
                boolean foreignDevice = false;
                switch (this.getIpDeviceType().getOrdinal()) {
                    case 0: {
                        this.setFlags((Slot)broadcastDistributionTable, bdtFlags | 4);
                        this.setFlags((Slot)foreignDeviceTable, fdtFlags | 4);
                        break;
                    }
                    case 1: {
                        this.setFlags((Slot)broadcastDistributionTable, bdtFlags | 4);
                        this.setFlags((Slot)foreignDeviceTable, fdtFlags | 4);
                        this.startForeignDeviceRegistration();
                        foreignDevice = true;
                        break;
                    }
                    case 2: {
                        this.setFlags((Slot)broadcastDistributionTable, bdtFlags & 0xFFFFFFFB);
                        this.setFlags((Slot)foreignDeviceTable, fdtFlags & 0xFFFFFFFB);
                        this.initializeBDT();
                    }
                }
                if (!foreignDevice) {
                    this.removeForeignDeviceRegistrations();
                }
            }
            this.oldIpDeviceType = this.getIpDeviceType().getOrdinal();
        } else if (p.equals(bbmdAddress)) {
            if (this.alive && this.getIpDeviceType() != BIpDeviceType.standard && !this.updateBBMDAddress(BBacnetIpLinkLayer.getMacBytes(this.getBbmdAddress()))) {
                logger.info("Invalid BBMD address configuration!");
            }
        } else {
            if (p.equals(udpPort)) {
                BBacnetIpLinkLayer bdtFlags = this;
                synchronized (bdtFlags) {
                    if (this.alive) {
                        this.getNetworkPort().disable();
                        this.updateLocalAddress();
                        this.getNetworkPort().enable();
                        if (this.isBBMDActive()) {
                            this.checkBDT();
                        }
                    } else {
                        this.updateLocalAddress();
                    }
                }
            }
            if (p.equals(adapter)) {
                this.setAdapterId(this.getAdapterId().getRange().get(this.getAdapter().getOrdinal()));
                this.setIpAddress(this.getIpAddress().getRange().get(this.getAdapter().getOrdinal()));
            } else if (p.equals(ipAddress)) {
                String newIpAddr = this.getIpAddress().getTag();
                if (!newIpAddr.equals(this.oldIpAddr)) {
                    BBacnetIpLinkLayer bBacnetIpLinkLayer = this;
                    synchronized (bBacnetIpLinkLayer) {
                        if (this.getNetworkPort().getEnabled()) {
                            this.getNetworkPort().disable();
                            this.updateLocalAddress();
                            this.getNetworkPort().enable();
                            if (this.isBBMDActive()) {
                                this.checkBDT();
                            }
                        } else {
                            this.updateLocalAddress();
                        }
                    }
                }
                this.oldIpAddr = newIpAddr;
            } else if (p.equals(bbmdDebug) || p.getName().equals("bbmdMsgsSize")) {
                this.ndx = 0;
                if (this.getBbmdDebug()) {
                    this.bbmdMsgs = new String[this.getBbmdMsgsSize()];
                }
            } else if (p.equals(autoPollEnabled)) {
                if (this.getAutoPollEnabled()) {
                    this.startAdapterPolling();
                } else {
                    this.stopAdapterPolling();
                }
            }
        }
    }

    @Override
    public void doDump() {
        System.out.println("MAC Address Table (Inet->MAC):");
        Enumeration<String> k = this.macTable.keys();
        while (k.hasMoreElements()) {
            String inet = k.nextElement();
            byte[] mac = this.macTable.get(inet);
            System.out.println("  inet:" + inet + "\tmac:" + ByteArrayUtil.toHexString((byte[])mac));
        }
        System.out.println("Inet Address Table (MAC->Inet):");
        IntHashMap.Iterator i = this.inetAddressTable.iterator();
        while (i.hasNext()) {
            InetAddress inet = (InetAddress)i.next();
            System.out.println("  mac:" + Integer.toHexString(i.key()) + "\tinet:" + inet);
        }
        System.out.println("local broadcast addr:" + ByteArrayUtil.toHexString((byte[])this.localBroadcastAddr));
        System.out.println("myIp:" + ByteArrayUtil.toHexString((byte[])this.myIp));
        System.out.println("oldIpAddr:" + this.oldIpAddr);
        System.out.println("myMac:" + ByteArrayUtil.toHexString((byte[])this.myMac));
        System.out.println("myUdpPort:" + this.myUdpPort);
        System.out.println("bbmdInet:" + this.bbmdInet);
        System.out.println("bbmdPort:" + this.bbmdPort);
        System.out.println("bbmdMac:" + ByteArrayUtil.toHexString((byte[])this.bbmdMac));
        System.out.println("oldIpDeviceType:" + this.oldIpDeviceType);
    }

    public void doReadBroadcastDistributionTable(BString bbmdAddress) {
        if (this.getBbmdDebug()) {
            this.trace("doReadBDT:" + bbmdAddress.getString());
        }
        try {
            StringTokenizer st = new StringTokenizer(bbmdAddress.getString(), ":");
            InetAddress inet = InetAddress.getByName(st.nextToken());
            this.sendBvllMessage(inet, Integer.decode(st.nextToken()), new ReadBroadcastDistributionTable());
            this.checkBDT();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "UnknownHostException in doReadBroadcastDistributionTable", e);
            throw new IllegalArgumentException(bbmdAddress.getString());
        }
    }

    public void doWriteBroadcastDistributionTable(BString bbmdAddress) {
        if (this.getBbmdDebug()) {
            this.trace("doWriteBDT:" + bbmdAddress.getString());
        }
        try {
            StringTokenizer st = new StringTokenizer(bbmdAddress.getString(), ":");
            InetAddress inet = InetAddress.getByName(st.nextToken());
            this.sendBvllMessage(inet, Integer.decode(st.nextToken()), new WriteBroadcastDistributionTable(this.readBDT()));
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "UnknownHostException in doWriteBroadcastDistributionTable", e);
            throw new IllegalArgumentException(bbmdAddress.getString());
        }
    }

    public void doUpdateAllBDTs() {
    }

    public void doQueryForAdapters() {
        this.debug("Querying IP Adapter choices...");
        this.setTcpIpAdapter();
        this.debug("Finished querying IP Adapter choices!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.alive = true;
        Object object = this.PORT_LOCK;
        synchronized (object) {
            if (this.startBroadcastWorker()) {
                if (this.broadcastWorker != null) {
                    this.broadcastWorker.interrupt();
                    this.broadcastWorker = null;
                }
                this.broadcastWorker = new BroadcastWorker(Thread.currentThread().getName());
                this.broadcastWorker.start();
            }
        }
        this.listenForPackets(this.server);
    }

    protected boolean startBroadcastWorker() {
        if (AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().usesPosixSockets()).booleanValue()) {
            return !this.isLocalhost();
        }
        return false;
    }

    protected boolean isLocalhost() {
        boolean local = false;
        if (this.myIp != null && this.myIp.length >= IPV4_HOST_OCTETS) {
            local = this.myIp[0] == 127 && this.myIp[1] == 0 && this.myIp[2] == 0 && this.myIp[3] == 1;
        }
        return local;
    }

    private void listenForPackets(DatagramSocket server) {
        while (this.alive) {
            try {
                byte[] packBuf = new byte[1500];
                DatagramPacket packIn = new DatagramPacket(packBuf, 1500);
                server.receive(packIn);
                this.processPacket(packIn, server == this.broadcastServer);
            }
            catch (NullPointerException e) {
                if (server != null) break;
                logger.severe("DatagramSocket is null!  Socket " + this.getPort() + " may be in use by another process...");
                break;
            }
            catch (SocketException e) {
                if (!this.alive) continue;
                logger.log(Level.SEVERE, "SocketException in BBacnetIpLinkLayer!", e);
                if (this.recoverSocket()) continue;
                logger.severe("Unable to recover socket! Exiting...");
                break;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error receiving Bacnet/IP packet!", e);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Unknown exception in IP Link Layer:", t);
            }
        }
    }

    @Override
    public byte[] getMacAddress() {
        return this.myMac;
    }

    @Override
    public int getMaxAPDULengthAccepted() {
        return 1476;
    }

    @Override
    public void sendRequest(byte[] destAddress, NetworkPdu npdu) {
        if (destAddress == null || destAddress.length == 0) {
            this.sendBvllMessage(this.localBroadcastAddr, new OriginalBroadcastNpdu(npdu));
            if (this.isBBMDActive()) {
                this.distributeBroadcastToNetwork(npdu);
            } else if (this.isForeignDevice()) {
                this.sendBroadcastToBBMD(npdu);
            }
        } else {
            this.sendBvllMessage(destAddress, new OriginalUnicastNpdu(npdu));
        }
    }

    private int getPort() {
        return this.myUdpPort;
    }

    protected boolean isForeignDevice() {
        return this.getIpDeviceType() == BIpDeviceType.foreignDevice;
    }

    protected boolean isBBMDActive() {
        return this.getIpDeviceType() == BIpDeviceType.bbmd;
    }

    private void updateLocalAddress() {
        AccessController.doPrivileged(new UpdateLocalAddressesPrivilegedAction());
    }

    private void startReception() throws Exception {
        try {
            InetAddress myInet = this.lookupInetAddr(this.myIp);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start BACnet/IP reception on port " + this.getPort() + ", bound to " + myInet);
            }
            if (myInet == null && (this.getNetworkPort().getEnabled() || this.getAutoPollEnabled())) {
                this.setAutoPollEnabled(true);
                this.getNetworkPort().doDisable();
                throw new IllegalStateException("BACnet/IP adapter not ready! Check cable connections.");
            }
            if (this.startBroadcastWorker()) {
                this.server = new DatagramSocket(this.getPort(), myInet);
                this.broadcastServer = new DatagramSocket(this.getPort(), this.convertMacToAddress(this.localBroadcastAddr));
            } else {
                this.server = new DatagramSocket(this.getPort(), myInet);
            }
            this.bindType = "specific adapter";
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Unknown host:" + ByteArrayUtil.toHexString((byte[])this.myIp), e);
            this.getNetworkPort().fault(lex.getText("ip.unknownHost") + ByteArrayUtil.toHexString((byte[])this.myIp));
            throw e;
        }
        catch (BindException e) {
            logger.log(Level.SEVERE, "Cannot bind datagram socket on port " + this.getPort(), e);
            String msg = MessageFormat.format(lex.getText("ip.cannotBind"), this.myUdpPort);
            this.getNetworkPort().fault(msg);
            throw e;
        }
        catch (SocketException e) {
            logger.log(Level.SEVERE, "Cannot open datagram socket!", e);
            this.getNetworkPort().fault(lex.getText("ip.cannotOpen"));
            throw e;
        }
        this.myThread = new Thread((Runnable)this, "BnIpLRcv");
        this.myThread.start();
        if (this.isForeignDevice()) {
            this.startForeignDeviceRegistration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReception() {
        if (!this.alive) {
            return;
        }
        logger.fine("Stop Reception");
        if (this.isForeignDevice()) {
            this.stopForeignDeviceRegistration();
        }
        Object object = this.PORT_LOCK;
        synchronized (object) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            if (this.myThread != null) {
                this.myThread.interrupt();
            }
            this.myThread = null;
            if (this.broadcastWorker != null) {
                this.broadcastWorker.interrupt();
            }
            this.bindType = "none";
            if (this.server != null) {
                this.server.close();
            }
            if (this.broadcastServer != null) {
                this.broadcastServer.close();
            }
        }
    }

    private void startAdapterPolling() {
        this.stopAdapterPolling();
        logger.fine("Polling for availability of the selected adapter begins.");
        this.ticketAdapterPolling = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now(), (BRelTime)this.getAdapterPollInterval(), (Action)queryForAdapters, null);
    }

    private void stopAdapterPolling() {
        logger.fine("Polling for availability of the selected adapter stops.");
        if (this.ticketAdapterPolling != null) {
            this.ticketAdapterPolling.cancel();
            this.ticketAdapterPolling = null;
        }
    }

    private synchronized boolean recoverSocket() {
        try {
            this.stopReception();
            logger.fine("Re-starting socket reception.");
            this.startReception();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void processPacket(DatagramPacket packet, boolean isBroadcast) {
        InetAddress srcInet = packet.getAddress();
        byte[] srcIp = srcInet.getAddress();
        int srcPort = packet.getPort();
        int srcLength = packet.getLength();
        if (ByteArrayUtil.equals((byte[])srcIp, (byte[])this.myIp) && srcPort == this.myUdpPort) {
            return;
        }
        byte[] data = new byte[srcLength];
        byte[] pktData = packet.getData();
        System.arraycopy(pktData, 0, data, 0, srcLength);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\nPacket Received(" + srcLength + "): addr=" + srcInet.getHostAddress() + ", port=" + srcPort);
            ByteArrayUtil.hexDump((byte[])data);
        }
        byte[] srcAddress = this.lookupMacAddress(srcInet, srcPort);
        BacnetInputStream in = BacnetInputStream.make(data, 0, data.length);
        int type = in.read();
        if (type != 129) {
            return;
        }
        int function = in.read();
        in.read();
        in.read();
        if (this.getBbmdDebug()) {
            switch (function) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.trace("\nBBMD Message Received(" + srcLength + "): addr=" + srcInet.getHostAddress() + ", port=" + srcPort + ": " + ByteArrayUtil.toHexString((byte[])data));
                }
            }
        }
        switch (function) {
            case 10: {
                this.rcvIndication(srcAddress, this.myMac, in, isBroadcast);
                break;
            }
            case 11: {
                if (this.isBBMDActive()) {
                    in.mark(in.getPos());
                    this.distributeBroadcastToNetwork(in, srcAddress, false);
                    in.reset();
                }
                this.rcvIndication(srcAddress, this.myMac, in, true);
                break;
            }
            case 4: {
                byte[] fwdAddress = new byte[6];
                for (int i = 0; i < 6; ++i) {
                    fwdAddress[i] = (byte)in.read();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Forwarded NPDU received from original device:" + ByteArrayUtil.toHexString((byte[])fwdAddress));
                }
                if (this.isBBMDActive()) {
                    in.mark(in.getPos());
                    this.distributeBroadcastFromNetwork(in, fwdAddress, srcAddress);
                    in.reset();
                }
                this.rcvIndication(fwdAddress, this.myMac, in);
                break;
            }
            case 0: {
                int ms = in.read();
                int ls = in.read();
                int resultCode = ms << 8 | ls;
                if (this.getBbmdDebug()) {
                    this.trace("BVLC-Result received: resultCode=" + resultCode);
                }
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("BVLC Result " + resultCode + " received from " + srcInet);
                break;
            }
            case 1: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Write-BDT received");
                    }
                    if (this.writeBDT(in)) {
                        this.sendBvllMessage(srcInet, srcPort, BvlcResult.OK);
                    } else {
                        this.sendBvllMessage(srcInet, srcPort, BvlcResult.WRITE_BDT_NAK);
                    }
                    if (this.getBbmdDebug()) {
                        this.trace("checkBDT() on WriteBDT rec");
                    }
                    this.checkBDT();
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.WRITE_BDT_NAK);
                break;
            }
            case 2: {
                if (this.isBBMDActive()) {
                    byte[] bdt;
                    if (this.getBbmdDebug()) {
                        this.trace("Read-BDT received");
                    }
                    if ((bdt = this.readBDT()) == null) {
                        this.sendBvllMessage(srcInet, srcPort, BvlcResult.READ_BDT_NAK);
                        break;
                    }
                    this.sendBvllMessage(srcInet, srcPort, new ReadBroadcastDistributionTableAck(bdt));
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.READ_BDT_NAK);
                break;
            }
            case 3: {
                if (!this.isBBMDActive()) break;
                if (this.getBbmdDebug()) {
                    this.trace("Read-BDT-Ack received");
                }
                this.writeBDT(in);
                if (this.getBbmdDebug()) {
                    this.trace("checkBDT() on ReadBDTAck rec");
                }
                this.checkBDT();
                break;
            }
            case 5: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Register-FD received");
                    }
                    this.sendBvllMessage(srcInet, srcPort, this.registerForeignDevice(in, srcAddress));
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.REGISTER_FD_NAK);
                break;
            }
            case 6: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Read-FDT received");
                    }
                    this.sendBvllMessage(srcInet, srcPort, this.readFDT());
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.READ_FDT_NAK);
                break;
            }
            case 7: {
                if (!this.isBBMDActive()) break;
                if (this.getBbmdDebug()) {
                    this.trace("Read-FDT-Ack received");
                }
                this.writeFDT(in);
                break;
            }
            case 8: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Delete-FDTE received");
                    }
                    this.sendBvllMessage(srcInet, srcPort, this.unregisterForeignDevice(in));
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.DELETE_FDT_ENTRY_NAK);
                break;
            }
            case 9: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Distribute-Broadcast received");
                    }
                    in.mark(in.getPos());
                    if (!this.distributeBroadcastToNetwork(in, srcAddress, true)) {
                        this.sendBvllMessage(srcInet, srcPort, BvlcResult.DIST_BCAST_NAK);
                    }
                    in.reset();
                    this.rcvIndication(srcAddress, this.myMac, in);
                    break;
                }
                this.sendBvllMessage(srcInet, srcPort, BvlcResult.DIST_BCAST_NAK);
                break;
            }
            default: {
                if (this.processCustomBvllMessage(srcInet, srcIp, srcPort, srcLength, data)) break;
                logger.info("Invalid BVLL function: " + function);
            }
        }
    }

    private boolean writeBDT(BacnetInputStream in) {
        int avail;
        boolean dbg = this.getBbmdDebug();
        if (dbg) {
            this.trace("writeBDT");
        }
        if ((avail = in.available()) % 10 != 0) {
            logger.log(Level.SEVERE, "Invalid BVLL BDT size!");
            return false;
        }
        try {
            BBroadcastDistributionTable table = this.getBroadcastDistributionTable();
            Array newTable = new Array(BBdtEntry.class);
            int len = avail / 10;
            for (int i = 0; i < len; ++i) {
                byte[] bbmdAddr = new byte[6];
                in.read(bbmdAddr);
                byte[] bbmdBDMask = new byte[IPV4_HOST_OCTETS];
                in.read(bbmdBDMask);
                BBdtEntry e = new BBdtEntry(bbmdAddr, bbmdBDMask);
                if (dbg) {
                    this.trace("Adding BDT Entry: " + (Object)((Object)e));
                }
                newTable.add((Object)e);
            }
            boolean forceBDTWrite = table.updateBDT((BBdtEntry[])newTable.trim());
            if (forceBDTWrite) {
                this.checkBDT(true);
            }
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to write BDT data!", e);
            return false;
        }
    }

    private byte[] readBDT() {
        boolean dbg = this.getBbmdDebug();
        if (dbg) {
            this.trace("readBDT");
        }
        try {
            BBroadcastDistributionTable table = this.getBroadcastDistributionTable();
            SlotCursor c = table.getProperties();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (c.next(BBdtEntry.class)) {
                BBdtEntry e = (BBdtEntry)c.get();
                if (dbg) {
                    this.trace("Encoding BDTEntry:" + (Object)((Object)e));
                }
                out.write(e.getBIpAddr());
                out.write(e.getBdMask());
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException reading BDT!", e);
            return null;
        }
    }

    private BvllMessage registerForeignDevice(BacnetInputStream in, byte[] srcAddress) {
        int msb = in.read();
        int lsb = in.read();
        int timeToLive = msb << 8 | lsb;
        if (this.getBbmdDebug()) {
            this.trace("registerFD: Addr=" + ByteArrayUtil.toHexString((byte[])srcAddress) + "; TTL=" + timeToLive);
        }
        this.getForeignDeviceTable().addEntry(srcAddress, timeToLive);
        return BvlcResult.OK;
    }

    private BvllMessage readFDT() {
        boolean dbg = this.getBbmdDebug();
        if (dbg) {
            this.trace("readFDT");
        }
        try {
            BForeignDeviceTable table = this.getForeignDeviceTable();
            SlotCursor c = table.getProperties();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            long curTime = BAbsTime.make().getMillis();
            while (c.next(BFdtEntry.class)) {
                BFdtEntry e = (BFdtEntry)c.get();
                if (dbg) {
                    this.trace("Encoding FDTEntry:" + (Object)((Object)e));
                }
                out.write(e.getBIpAddr());
                int timeToLive = e.getTimeToLive();
                out.write(timeToLive >> 8 & 0xFF);
                out.write(timeToLive & 0xFF);
                int timeRemaining = (int)((e.getPurgeTime().getMillis() - curTime) / 1000L);
                out.write(timeRemaining >> 8 & 0xFF);
                out.write(timeRemaining & 0xFF);
            }
            return new ReadForeignDeviceTableAck(out.toByteArray());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error reading FDT!", e);
            return BvlcResult.READ_FDT_NAK;
        }
    }

    private void writeFDT(BacnetInputStream in) {
        if (this.getBbmdDebug()) {
            this.trace("writeFDT");
        }
    }

    private BvllMessage unregisterForeignDevice(BacnetInputStream in) {
        boolean ok;
        byte[] fdAddr = new byte[6];
        in.read(fdAddr);
        if (this.getBbmdDebug()) {
            this.trace("unregisterFD: fdAddr=" + ByteArrayUtil.toHexString((byte[])fdAddr));
        }
        if (ok = this.getForeignDeviceTable().deleteEntry(fdAddr)) {
            return BvlcResult.OK;
        }
        return BvlcResult.DELETE_FDT_ENTRY_NAK;
    }

    private void distributeBroadcastToNetwork(NetworkPdu npdu) {
        BStruct e;
        ForwardedNpdu msg = new ForwardedNpdu(npdu, this.myMac);
        SlotCursor c = this.getBroadcastDistributionTable().getProperties();
        while (c.next(BBdtEntry.class)) {
            if (c.property().getName().equals("localDevice")) continue;
            e = (BBdtEntry)c.get();
            byte[] bdtAddr = new byte[6];
            byte[] bIPAddr = e.getBIpAddr();
            System.arraycopy(bIPAddr, 0, bdtAddr, 0, 6);
            byte[] bdtMask = e.getBdMask();
            for (int i = 0; i < 4; ++i) {
                int n = i;
                bdtAddr[n] = (byte)(bdtAddr[n] | ~bdtMask[i]);
            }
            this.sendBvllMessage(bdtAddr, msg);
        }
        c = this.getForeignDeviceTable().getProperties();
        while (c.next(BFdtEntry.class)) {
            e = (BFdtEntry)c.get();
            byte[] entryAddr = e.getBIpAddr();
            this.sendBvllMessage(entryAddr, msg);
        }
    }

    private boolean distributeBroadcastToNetwork(BacnetInputStream in, byte[] srcAddr, boolean foreignDevice) {
        BStruct e;
        ForwardedNpdu msg = new ForwardedNpdu(in, srcAddr);
        if (foreignDevice) {
            if (this.isForeignDevice(srcAddr)) {
                this.sendBvllMessage(this.localBroadcastAddr, msg);
            } else {
                return false;
            }
        }
        SlotCursor c = this.getBroadcastDistributionTable().getProperties();
        while (c.next(BBdtEntry.class)) {
            e = (BBdtEntry)c.get();
            byte[] bdtAddr = new byte[6];
            byte[] bIPAddr = e.getBIpAddr();
            System.arraycopy(bIPAddr, 0, bdtAddr, 0, 6);
            byte[] bdtMask = e.getBdMask();
            for (int i = 0; i < 4; ++i) {
                int n = i;
                bdtAddr[n] = (byte)(bdtAddr[n] | ~bdtMask[i]);
            }
            this.sendBvllMessage(bdtAddr, msg);
        }
        c = this.getForeignDeviceTable().getProperties();
        block2: while (c.next(BFdtEntry.class)) {
            e = (BFdtEntry)c.get();
            byte[] entryAddr = e.getBIpAddr();
            if (foreignDevice) {
                for (int i = 0; i < 4; ++i) {
                    if (srcAddr[i] == entryAddr[i]) continue;
                    this.sendBvllMessage(entryAddr, msg);
                    continue block2;
                }
                continue;
            }
            this.sendBvllMessage(entryAddr, msg);
        }
        return true;
    }

    public boolean isForeignDevice(byte[] srcAddr) {
        SlotCursor c = this.getForeignDeviceTable().getProperties();
        while (c.next(BFdtEntry.class)) {
            BFdtEntry e = (BFdtEntry)c.get();
            byte[] entryAddr = e.getBIpAddr();
            if (!Arrays.equals(srcAddr, entryAddr)) continue;
            return true;
        }
        return false;
    }

    private void distributeBroadcastFromNetwork(BacnetInputStream in, byte[] origSrcAddress, byte[] srcAddress) {
        ForwardedNpdu msg = new ForwardedNpdu(in, origSrcAddress);
        BBdtEntry me = (BBdtEntry)this.getBroadcastDistributionTable().get("localDevice");
        if (me != null && !me.isDirectedBroadcast() && !BacnetIpLinkUtil.isSourceLocal(srcAddress, this.myMac, this.netmask)) {
            this.sendBvllMessage(this.localBroadcastAddr, msg);
        }
        SlotCursor c = this.getForeignDeviceTable().getProperties();
        while (c.next(BFdtEntry.class)) {
            BFdtEntry e = (BFdtEntry)c.get();
            byte[] entryAddr = e.getBIpAddr();
            this.sendBvllMessage(entryAddr, msg);
        }
    }

    protected void sendBroadcastToBBMD(NetworkPdu npdu) {
        SlotCursor sc = this.getSlots();
        while (sc.next(BForeignDeviceRegistration.class)) {
            try {
                BForeignDeviceRegistration fdreg = (BForeignDeviceRegistration)sc.get();
                fdreg.sendBvll(new DistributeBroadcastToNetwork(npdu));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to send broadcast to BBMD!", e);
            }
        }
    }

    protected void sendBvllMessage(byte[] destAddress, BvllMessage msg) {
        if (destAddress == null) {
            destAddress = this.localBroadcastAddr;
        }
        try {
            if (destAddress.length < 6) {
                throw new UnknownHostException("Invalid Bacnet/IP MAC address! " + ByteArrayUtil.toHexString((byte[])destAddress));
            }
            InetAddress ip = this.lookupInetAddr(destAddress);
            int port = BBacnetIpLinkLayer.getPort(destAddress);
            this.sendBvllMessage(ip, port, msg);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Cannot find host for destAddress: " + ByteArrayUtil.toHexString((byte[])destAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBvllMessage(InetAddress inet, int port, BvllMessage msg) {
        if (this.myIp == null || ByteArrayUtil.equals((byte[])this.myIp, (byte[])inet.getAddress()) && port == this.myUdpPort) {
            return;
        }
        byte[] outBuffer = null;
        Object object = this.PORT_LOCK;
        synchronized (object) {
            try {
                this.os.reset();
                outBuffer = msg.encode(this.os);
                this.datagramOut.setAddress(inet);
                this.datagramOut.setPort(port);
                this.datagramOut.setData(outBuffer);
                this.datagramOut.setLength(outBuffer.length);
                if (this.server != null) {
                    this.server.send(this.datagramOut);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("\nPacket Sent on port " + this.server.getLocalPort() + ": ip=" + inet + " port=" + port + " length=" + (outBuffer != null ? outBuffer.length : 0));
                        ByteArrayUtil.hexDump((byte[])outBuffer);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot send Bacnet/IP packet!", e);
            }
        }
        if (this.getBbmdDebug()) {
            switch (msg.function) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.trace("Sending BBMD Message (" + (outBuffer != null ? outBuffer.length : 0) + "): addr=" + inet.getHostAddress() + ", port=" + port + ": " + ByteArrayUtil.toHexString((byte[])outBuffer));
                }
            }
        }
    }

    public static byte[] parseIp(String ipStr) {
        if (ipStr == null) {
            return DEFAULT_SUBNET_MASK;
        }
        try {
            return InetAddress.getByName(ipStr).getAddress();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "UnknownHostException in parseIp", e);
            throw new IllegalArgumentException();
        }
    }

    protected static int getPort(byte[] destAddress) {
        int port = (destAddress[4] & 0xFF) << 8;
        return port |= destAddress[5] & 0xFF;
    }

    protected InetAddress lookupInetAddr(byte[] destAddress) throws UnknownHostException {
        this.debug("lookupInetAddr:" + ByteArrayUtil.toHexString((byte[])destAddress));
        if (destAddress == null) {
            return null;
        }
        int ipHash = BBacnetIpLinkLayer.ipHash(destAddress);
        if (this.inetAddressTable == null) {
            return null;
        }
        InetAddress inetAddr = (InetAddress)this.inetAddressTable.get(ipHash);
        if (inetAddr == null) {
            StringBuilder sb = new StringBuilder(15);
            sb.append(destAddress[0] & 0xFF);
            sb.append(".");
            sb.append(destAddress[1] & 0xFF);
            sb.append(".");
            sb.append(destAddress[2] & 0xFF);
            sb.append(".");
            sb.append(destAddress[3] & 0xFF);
            inetAddr = InetAddress.getByName(sb.toString());
            this.inetAddressTable.put(ipHash, (Object)inetAddr);
        }
        return inetAddr;
    }

    private byte[] lookupMacAddress(InetAddress inet, int port) {
        String key = inet.getHostAddress() + port;
        byte[] macAddress = this.macTable.get(key);
        if (macAddress == null) {
            macAddress = new byte[6];
            byte[] ip = inet.getAddress();
            System.arraycopy(ip, 0, macAddress, 0, IPV4_HOST_OCTETS);
            macAddress[4] = (byte)((port & 0xFF00) >> 8);
            macAddress[5] = (byte)(port & 0xFF);
            this.macTable.put(key, macAddress);
        }
        return macAddress;
    }

    private static int ipHash(byte[] ip) {
        int ipHash = ip[3] & 0xFF;
        ipHash |= ip[2] << 8 & 0xFF00;
        ipHash |= ip[1] << 16 & 0xFF0000;
        return ipHash |= ip[0] << 24 & 0xFF000000;
    }

    protected static byte[] getMacBytes(String addr) {
        if (addr == null || addr.length() == 0 || addr.equalsIgnoreCase(BBMD_ADDRESS_DEFAULT)) {
            return null;
        }
        try {
            byte[] b = new byte[6];
            int ndx = addr.indexOf(".");
            if (ndx > 0) {
                StringTokenizer st = new StringTokenizer(addr, ".:");
                if (st.countTokens() < 5) {
                    return null;
                }
                for (int i = 0; i < IPV4_HOST_OCTETS; ++i) {
                    b[i] = (byte)Integer.decode(st.nextToken()).intValue();
                }
                int port = Integer.decode(st.nextToken());
                b[4] = (byte)(port >> 8 & 0xFF);
                b[5] = (byte)(port & 0xFF);
            } else {
                StringTokenizer st = new StringTokenizer(addr, " :");
                if (st.countTokens() < 6) {
                    return null;
                }
                for (int i = 0; i < 6; ++i) {
                    b[i] = (byte)Integer.parseInt(st.nextToken(), 16);
                }
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private InetAddress convertMacToAddress(byte[] mac) throws UnknownHostException {
        byte[] macAddress;
        if (mac.length == IPV4_HOST_OCTETS) {
            macAddress = mac;
        } else {
            macAddress = new byte[IPV4_HOST_OCTETS];
            System.arraycopy(mac, 0, macAddress, 0, IPV4_HOST_OCTETS);
        }
        return InetAddress.getByAddress(macAddress);
    }

    protected void startForeignDeviceRegistration() {
        logger.fine("Starting foreign device registration...");
        SlotCursor sc = this.getSlots();
        BForeignDeviceRegistration fdReg = null;
        while (sc.next(BForeignDeviceRegistration.class)) {
            fdReg = (BForeignDeviceRegistration)sc.get();
            fdReg.registerWithBBMD();
        }
        if (fdReg == null) {
            fdReg = new BForeignDeviceRegistration(this.getBbmdAddress(), this.getRegistrationLifetime());
            fdReg.set(BForeignDeviceRegistration.enabled, (BValue)BBoolean.TRUE, BacnetConst.noWrite);
            this.add("ForeignDeviceReg?", (BValue)fdReg);
            if (!Sys.atSteadyState()) {
                fdReg.registerWithBBMD();
            }
        }
    }

    protected void stopForeignDeviceRegistration() {
        SlotCursor sc = this.getSlots();
        BForeignDeviceRegistration fdReg = null;
        while (sc.next(BForeignDeviceRegistration.class)) {
            fdReg = (BForeignDeviceRegistration)sc.get();
            if (!fdReg.getEnabled()) continue;
            fdReg.unregisterWithBBMD();
        }
    }

    protected void removeForeignDeviceRegistrations() {
        BForeignDeviceRegistration[] fdregs = (BForeignDeviceRegistration[])this.getChildren(BForeignDeviceRegistration.class);
        for (int i = 0; i < fdregs.length; ++i) {
            this.remove((BComplex)fdregs[i]);
        }
    }

    protected boolean updateBBMDAddress(byte[] newMacAddress) {
        if (this.isBBMDActive()) {
            this.initializeBDT();
        }
        return true;
    }

    private void initializeBDT() {
        block3: {
            logger.fine("Initializing the Broadcast Distribution Table");
            byte[] bbmdMacAddr = BBacnetIpLinkLayer.getMacBytes(this.getBbmdAddress());
            try {
                if (bbmdMacAddr != null && bbmdMacAddr.length == 6) {
                    this.sendBvllMessage(bbmdMacAddr, new ReadBroadcastDistributionTable());
                }
                this.checkBDT();
            }
            catch (Exception e) {
                logger.log(Level.INFO, " - Unable to read BroadcastDistributionTable from BBMD", e);
                if (bbmdMacAddr == null) break block3;
                ByteArrayUtil.hexDump((byte[])bbmdMacAddr);
            }
        }
    }

    boolean checkBDT() {
        return this.checkBDT(false);
    }

    private boolean checkBDT(boolean forceWrite) {
        boolean dbg = this.getBbmdDebug();
        if (dbg) {
            this.trace("checkBDT(" + (forceWrite ? "T)" : "F)"));
        }
        boolean bdtChanged = false;
        if (this.getBroadcastDistributionTable().get("localDevice") == null) {
            logger.fine("Adding ourself to the BDT...");
            if (dbg) {
                this.trace("adding local to BDT");
            }
            this.getBroadcastDistributionTable().add("localDevice", (BValue)new BBdtEntry(this.myMac, TWO_HOP_DIST_MASK), BBroadcastDistributionTable.noValidation);
            bdtChanged = true;
        } else if (!((BBdtEntry)this.getBroadcastDistributionTable().get("localDevice")).ipEquals(this.myMac)) {
            if (dbg) {
                this.trace("updating local in BDT");
            }
            this.getBroadcastDistributionTable().remove("localDevice");
            this.getBroadcastDistributionTable().add("localDevice", (BValue)new BBdtEntry(this.myMac, TWO_HOP_DIST_MASK), BBroadcastDistributionTable.noValidation);
            bdtChanged = true;
        }
        if (bdtChanged || forceWrite) {
            this.updateAllBDTs();
        }
        return bdtChanged;
    }

    private int getBbmdMsgsSize() {
        int sz = 500;
        try {
            Property p = this.getProperty("bbmdMsgsSize");
            if (p != null && p.getType().is(BInteger.TYPE)) {
                sz = this.getInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sz;
    }

    private void trace(String s) {
        System.out.println(">>>BBMD<<< " + s);
        this.bbmdMsgs[this.ndx] = Clock.time() + ":" + s;
        if (++this.ndx >= this.bbmdMsgs.length) {
            this.ndx = 0;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetIpLinkLayer", 2);
        out.prop((Object)"MAC Address Table", (Object)"Inet -> MAC");
        Enumeration<String> k = this.macTable.keys();
        while (k.hasMoreElements()) {
            String adr = k.nextElement();
            byte[] m = this.macTable.get(adr);
            out.prop((Object)("  " + adr), (Object)m);
        }
        out.prop((Object)"Inet Address Table", (Object)"MAC -> Inet");
        IntHashMap.Iterator it = this.inetAddressTable.iterator();
        while (it.hasNext()) {
            InetAddress i = (InetAddress)it.next();
            out.prop((Object)("  " + it.key()), (Object)i);
        }
        out.prop((Object)"localAddress", (Object)this.server.getLocalAddress());
        out.prop((Object)"localPort", this.server.getLocalPort());
        out.prop((Object)"bindType", (Object)this.bindType);
        out.prop((Object)"localBroadcastAddr", (Object)ByteArrayUtil.toHexString((byte[])this.localBroadcastAddr));
        out.prop((Object)"myIp", (Object)ByteArrayUtil.toHexString((byte[])this.myIp));
        out.prop((Object)"oldIpAddr", (Object)this.oldIpAddr);
        out.prop((Object)"myMac", (Object)ByteArrayUtil.toHexString((byte[])this.myMac));
        out.prop((Object)"myUdpPort", this.myUdpPort);
        out.prop((Object)"bbmdInet", (Object)this.bbmdInet);
        out.prop((Object)"bbmdPort", this.bbmdPort);
        out.prop((Object)"bbmdMac", (Object)ByteArrayUtil.toHexString((byte[])this.bbmdMac));
        out.prop((Object)"oldIpDeviceType", this.oldIpDeviceType);
        if (this.getBbmdDebug()) {
            int j;
            out.prop((Object)("BBMD Messages (last " + this.bbmdMsgs.length + "): now="), (Object)Clock.time());
            for (j = this.ndx; j < this.bbmdMsgs.length; ++j) {
                if (this.bbmdMsgs[j] == null) continue;
                out.prop((Object)(j + ":"), (Object)this.bbmdMsgs[j]);
            }
            if (this.ndx != 0) {
                for (j = 0; j < this.ndx; ++j) {
                    if (this.bbmdMsgs[j] == null) continue;
                    out.prop((Object)(j + ":"), (Object)this.bbmdMsgs[j]);
                }
            }
        }
        out.endProps();
    }

    protected byte[] getMac() {
        return this.myMac;
    }

    static /* synthetic */ byte[] access$1302(BBacnetIpLinkLayer x0, byte[] x1) {
        x0.localBroadcastAddr = x1;
        return x1;
    }

    private static class MissingBacnetAdapter
    implements BacnetNetworkAdapter {
        private final String id;

        public MissingBacnetAdapter(String id) {
            this.id = id;
        }

        @Override
        public String getIdentifier() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.id;
        }

        @Override
        public String getAddress() {
            return "0.0.0.0";
        }

        @Override
        public boolean isLoopback() {
            return false;
        }
    }

    private class UpdateLocalAddressesPrivilegedAction
    implements PrivilegedAction<Void> {
        private UpdateLocalAddressesPrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                Collection<BacnetNetworkInterface> interfaces = BBacnetIpLinkLayer.this.interfaceProvider.getNetworkInterfaces();
                if (interfaces.isEmpty()) {
                    return null;
                }
                BacnetNetworkInterface adapter = null;
                for (BacnetNetworkInterface bacnetInterface : interfaces) {
                    if (!bacnetInterface.getName().equalsIgnoreCase(SlotPath.unescape((String)BBacnetIpLinkLayer.this.getAdapterId().getTag()))) continue;
                    adapter = bacnetInterface;
                    break;
                }
                if (adapter == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(BBacnetIpLinkLayer.this.getNetworkPort().getName() + ": Could not find network interface that matches adapter ID " + BBacnetIpLinkLayer.this.getAdapterId().getTag());
                        logger.fine("Network interfaces: ");
                        for (BacnetNetworkInterface bacnetInterface : interfaces) {
                            logger.fine("  name: " + bacnetInterface.getName());
                        }
                    }
                    return null;
                }
                if (adapter.getInetAddresses().isEmpty()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(BBacnetIpLinkLayer.this.getNetworkPort().getName() + ": Network interface for adapter ID " + BBacnetIpLinkLayer.this.getAdapterId().getTag() + " has no InetAddresses");
                    }
                    return null;
                }
                try {
                    int myPort = Integer.decode(BBacnetIpLinkLayer.this.getUdpPort());
                    BBacnetIpLinkLayer.this.myUdpPort = myPort;
                }
                catch (NumberFormatException e) {
                    logger.log(Level.SEVERE, "Invalid BACnet/IP UDP Port:" + BBacnetIpLinkLayer.this.getUdpPort());
                }
                BBacnetIpLinkLayer.access$1302(BBacnetIpLinkLayer.this, new byte[6]);
                for (InterfaceAddress iAddr : adapter.getInterfaceAddresses()) {
                    if (!iAddr.getAddress().getHostAddress().equalsIgnoreCase(SlotPath.unescape((String)BBacnetIpLinkLayer.this.getIpAddress().getTag()))) continue;
                    BBacnetIpLinkLayer.this.netmask = iAddr.getNetworkPrefixLength();
                    byte[] bcast = BacnetIpLinkUtil.getBroadcastAddress(iAddr.getAddress().getAddress(), BBacnetIpLinkLayer.this.netmask);
                    System.arraycopy(bcast, 0, BBacnetIpLinkLayer.this.localBroadcastAddr, 0, 4);
                }
                BBacnetIpLinkLayer.this.myMac = new byte[6];
                BBacnetIpLinkLayer.this.myIp = BBacnetIpLinkLayer.parseIp(SlotPath.unescape((String)BBacnetIpLinkLayer.this.getIpAddress().getTag()));
                System.arraycopy(BBacnetIpLinkLayer.this.myIp, 0, BBacnetIpLinkLayer.this.myMac, 0, IPV4_HOST_OCTETS);
                BBacnetIpLinkLayer.this.myMac[4] = (byte)((BBacnetIpLinkLayer.this.getPort() & 0xFF00) >> 8);
                BBacnetIpLinkLayer.this.myMac[5] = (byte)(BBacnetIpLinkLayer.this.getPort() & 0xFF);
                System.arraycopy(BBacnetIpLinkLayer.this.myMac, 4, BBacnetIpLinkLayer.this.localBroadcastAddr, 4, 2);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(BBacnetIpLinkLayer.this.getNetworkPort().getName() + ": BACnet/IP Address: " + ByteArrayUtil.toHexString((byte[])BBacnetIpLinkLayer.this.myMac));
                    logger.fine(BBacnetIpLinkLayer.this.getNetworkPort().getName() + ": Local Broadcast Address: " + ByteArrayUtil.toHexString((byte[])BBacnetIpLinkLayer.this.localBroadcastAddr));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Invalid Bacnet/IP Link layer configuration!", e);
            }
            return null;
        }
    }

    private class BroadcastWorker
    extends Thread {
        public BroadcastWorker(String id) {
            super(id + "_broadcast");
        }

        @Override
        public void run() {
            BBacnetIpLinkLayer.this.listenForPackets(BBacnetIpLinkLayer.this.broadcastServer);
        }
    }

    protected class SetTcpIpPrivilegedAction
    implements PrivilegedAction<Void> {
        private NetworkInterfaceProvider provider;

        public SetTcpIpPrivilegedAction(NetworkInterfaceProvider provider) {
            this.provider = provider;
        }

        @Override
        public Void run() {
            try {
                BBacnetIpLinkLayer.this.debug("setTcpIpAdapter()");
                if (BBacnetIpLinkLayer.this.getAdapterDebug()) {
                    new Throwable().printStackTrace();
                }
                String currentTag = BBacnetIpLinkLayer.this.getAdapterId().getTag();
                int currentOrdinal = BBacnetIpLinkLayer.this.getAdapterId().getOrdinal();
                BBacnetIpLinkLayer.this.debug("currentTag=" + currentTag + ", currentOrdinal=" + currentOrdinal);
                Collection<BacnetNetworkAdapter> allAdapters = this.provider.getInterfaces();
                Collection<BacnetNetworkAdapter> filtered = LinkLayerUtil.filterAdapters(allAdapters);
                BBacnetIpLinkLayer.this.debugFilteredAdapters(filtered);
                this.handleMissingAdapter(currentTag, filtered);
                BEnumRange idRange = LinkLayerUtil.makeIdRange(filtered, NONE);
                int ordinal = LinkLayerUtil.ordinal(currentTag, idRange, NONE);
                BBacnetIpLinkLayer.this.debug("newOrdinal=" + ordinal);
                BBacnetIpLinkLayer.this.setAdapterId((BEnum)LinkLayerUtil.select(ordinal, idRange));
                BBacnetIpLinkLayer.this.setIpAddress((BEnum)LinkLayerUtil.select(ordinal, LinkLayerUtil.makeIpRange(filtered, NONE)));
                BBacnetIpLinkLayer.this.setAdapter((BEnum)LinkLayerUtil.select(ordinal, LinkLayerUtil.makeDescRange(filtered, NONE)));
            }
            catch (ActionInvokeException e) {
                logger.log(Level.SEVERE, "ActionInvokeException in setTcpIpAdapter", e);
                throw e;
            }
            catch (SocketException e) {
                logger.log(Level.SEVERE, "SocketException in setTcpIpAdapter", e);
            }
            return null;
        }

        private void handleMissingAdapter(String currentTag, Collection<BacnetNetworkAdapter> filtered) {
            if (!(currentTag = SlotPath.unescape((String)currentTag)).equals(NONE) && !this.containsCurrentAdapter(currentTag, filtered) && LinkLayerUtil.isAutoAdapterChangeDisabled()) {
                if (BBacnetIpLinkLayer.this.getAdapterDebug()) {
                    BBacnetIpLinkLayer.this.debug("Adding a placeholder for the previously selected adapter \"" + currentTag + '\"' + " when system property niagara.bacnet.link.autoAdapterChange.disabled is true.");
                }
                filtered.add(new MissingBacnetAdapter(currentTag));
            }
        }

        private boolean containsCurrentAdapter(String currentTag, Collection<BacnetNetworkAdapter> adapters) {
            for (BacnetNetworkAdapter adapter : adapters) {
                if (!currentTag.equals(adapter.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }

    private class JvmNetworkInterfaceProvider
    implements NetworkInterfaceProvider {
        private JvmNetworkInterfaceProvider() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Collection<BacnetNetworkAdapter> getInterfaces() throws SocketException {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<BacnetNetworkAdapter> adapters = new ArrayList<BacnetNetworkAdapter>();
            if (interfaces == null) {
                BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: NetworkInterface.getNetworkInterfaces() == null");
                return adapters;
            }
            while (true) {
                String ip;
                NetworkInterface netIf;
                block12: {
                    if (!interfaces.hasMoreElements()) {
                        return adapters;
                    }
                    netIf = interfaces.nextElement();
                    if (netIf.isLoopback() && !LOCALHOST_ADAPTER_ALLOWED) {
                        if (!BBacnetIpLinkLayer.this.getAdapterDebug()) continue;
                        BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: networkInterface " + netIf.getName() + " was skipped because it is a loopback adapter and those are disabled by system property niagara.bacnet.link.ip.localhost.allow");
                        continue;
                    }
                    ip = "";
                    for (InetAddress address : Collections.list(netIf.getInetAddresses())) {
                        if (!(address instanceof Inet4Address)) continue;
                        ip = LinkLayerUtil.addressToString(address.getAddress());
                        break;
                    }
                    if (ip.isEmpty()) {
                        if (BBacnetIpLinkLayer.this.getAdapterId().getTag().equals(netIf.getName())) {
                            if (BBacnetIpLinkLayer.this.getAdapterDebug()) {
                                BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: networkInterface " + netIf.getName() + " was the previously selected adapter but now has no associated IPv4 address: including but with address 0.0.0.0");
                            }
                            ip = "0.0.0.0";
                            break block12;
                        } else {
                            if (!BBacnetIpLinkLayer.this.getAdapterDebug()) continue;
                            BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: networkInterface " + netIf.getName() + " has no associated IPv4 address and was not the previously selected adapter: it will not be included");
                            continue;
                        }
                    }
                    if (BBacnetIpLinkLayer.this.getAdapterId().getTag().equals(netIf.getName()) && BBacnetIpLinkLayer.this.getAutoPollEnabled()) {
                        if (BBacnetIpLinkLayer.this.getAdapterDebug()) {
                            BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: networkInterface " + netIf.getName() + " was the previously selected adapter and now has an associated IPv4 address; cancelling auto poll and enabling the port");
                        }
                        BBacnetIpLinkLayer.this.setAutoPollEnabled(false);
                        BBacnetIpLinkLayer.this.getNetworkPort().doEnable();
                    }
                }
                if (BBacnetIpLinkLayer.this.getAdapterDebug()) {
                    BBacnetIpLinkLayer.this.debug("JvmNetworkInterfaceProvider.getInterfaces: returning networkInterface " + netIf.getName() + " at IPv4 address " + ip);
                }
                adapters.add(new BacnetIpAdapter(netIf, ip));
            }
        }

        @Override
        public Collection<BacnetNetworkInterface> getNetworkInterfaces() throws SocketException {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return Collections.emptyList();
            }
            ArrayList<BacnetNetworkInterface> bacnetInterfaces = new ArrayList<BacnetNetworkInterface>();
            while (interfaces.hasMoreElements()) {
                bacnetInterfaces.add(new BacnetIpInterface(interfaces.nextElement()));
            }
            return bacnetInterfaces;
        }
    }
}

