/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip.util;

public class BacnetIpLinkUtil {
    public static final String NON_ROUTABLE_ADDRESS = "0.0.0.0";
    public static final int IP_MAC_LEN = 6;

    public static boolean isSourceLocal(byte[] source, byte[] local, short mask) {
        if (source != null && local != null && source.length == 6 && local.length == 6) {
            int sourceAddress = BacnetIpLinkUtil.convertMacToInt(source);
            int localAddress = BacnetIpLinkUtil.convertMacToInt(local);
            int netmask = BacnetIpLinkUtil.convertNetmask(mask);
            if ((sourceAddress & netmask) == (localAddress & netmask)) {
                return BacnetIpLinkUtil.sameUdpPort(source, local);
            }
        }
        return false;
    }

    public static int convertNetmask(short networkPrefix) {
        if (networkPrefix <= 0) {
            return 0;
        }
        int offset = 32 - networkPrefix;
        int mask = -1 >> offset << offset;
        return mask;
    }

    public static boolean sameUdpPort(byte[] macAddress, byte[] otherMacAddress) {
        return macAddress[4] == otherMacAddress[4] && macAddress[5] == otherMacAddress[5];
    }

    public static int convertMacToInt(byte[] mac) {
        int intMac = 0;
        if (mac.length > 3) {
            intMac = mac[0] << 24 & 0xFF000000 | mac[1] << 16 & 0xFF0000 | mac[2] << 8 & 0xFF00 | mac[3] & 0xFF;
        }
        return intMac;
    }

    public static byte[] convertIntToAddress(int address) {
        byte[] b = new byte[]{(byte)(0xFF & address >> 24), (byte)(0xFF & address >> 16), (byte)(0xFF & address >> 8), (byte)(0xFF & address)};
        return b;
    }

    public static byte[] getBroadcastAddress(byte[] address, short networkPrefix) {
        return BacnetIpLinkUtil.convertIntToAddress(BacnetIpLinkUtil.convertMacToInt(address) | ~BacnetIpLinkUtil.convertNetmask(networkPrefix));
    }
}

