/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc;

import com.tridium.bacnet.stack.link.sc.BHubConnector;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.connection.BAcceptingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BDirectAcceptingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BDirectInitiatingConnection;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="nodeMaxBvlcLength", type="int", defaultValue="MAX_SC_BVLC_LENGTH", facets={@Facet(name="BFacets.MAX", value="MAX_SC_BVLC_LENGTH"), @Facet(name="BFacets.MIN", value="NODE_MIN_BVLC_LENGTH")}), @NiagaraProperty(name="nodeMaxNpduLength", type="int", defaultValue="MAX_NPDU_LENGTH", facets={@Facet(name="BFacets.MAX", value="MAX_NPDU_LENGTH"), @Facet(name="BFacets.MIN", value="NODE_MIN_NPDU_LENGTH")}), @NiagaraProperty(name="minimumReconnectTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(2)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="maximumReconnectTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(600)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(600)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="connectWaitTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="disconnectWaitTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="webSocketWaitTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="initiatingHeartbeatTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(300)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}), @NiagaraProperty(name="acceptingHeartbeatTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(500)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")})})
public final class BScConfiguration
extends BComponent {
    @Generated
    public static final Property nodeMaxBvlcLength = BScConfiguration.newProperty((int)0, (int)65535, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)65535), (BFacets)BFacets.make((String)"min", (int)91)));
    @Generated
    public static final Property nodeMaxNpduLength = BScConfiguration.newProperty((int)0, (int)61327, (BFacets)BFacets.make((BFacets)BFacets.make((String)"max", (int)61327), (BFacets)BFacets.make((String)"min", (int)74)));
    @Generated
    public static final Property minimumReconnectTime = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property maximumReconnectTime = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)600), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)600))), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property connectWaitTimeout = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property disconnectWaitTimeout = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property webSocketWaitTimeout = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property initiatingHeartbeatTimeout = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)300), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Property acceptingHeartbeatTimeout = BScConfiguration.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)500), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    @Generated
    public static final Type TYPE = Sys.loadType(BScConfiguration.class);
    private static final double IDLE_TIMEOUT_MULTIPLIER = 4.0;
    private BScLinkLayer scLinkLayer;

    @Generated
    public int getNodeMaxBvlcLength() {
        return this.getInt(nodeMaxBvlcLength);
    }

    @Generated
    public void setNodeMaxBvlcLength(int v) {
        this.setInt(nodeMaxBvlcLength, v, null);
    }

    @Generated
    public int getNodeMaxNpduLength() {
        return this.getInt(nodeMaxNpduLength);
    }

    @Generated
    public void setNodeMaxNpduLength(int v) {
        this.setInt(nodeMaxNpduLength, v, null);
    }

    @Generated
    public BRelTime getMinimumReconnectTime() {
        return (BRelTime)this.get(minimumReconnectTime);
    }

    @Generated
    public void setMinimumReconnectTime(BRelTime v) {
        this.set(minimumReconnectTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getMaximumReconnectTime() {
        return (BRelTime)this.get(maximumReconnectTime);
    }

    @Generated
    public void setMaximumReconnectTime(BRelTime v) {
        this.set(maximumReconnectTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getConnectWaitTimeout() {
        return (BRelTime)this.get(connectWaitTimeout);
    }

    @Generated
    public void setConnectWaitTimeout(BRelTime v) {
        this.set(connectWaitTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getDisconnectWaitTimeout() {
        return (BRelTime)this.get(disconnectWaitTimeout);
    }

    @Generated
    public void setDisconnectWaitTimeout(BRelTime v) {
        this.set(disconnectWaitTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getWebSocketWaitTimeout() {
        return (BRelTime)this.get(webSocketWaitTimeout);
    }

    @Generated
    public void setWebSocketWaitTimeout(BRelTime v) {
        this.set(webSocketWaitTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getInitiatingHeartbeatTimeout() {
        return (BRelTime)this.get(initiatingHeartbeatTimeout);
    }

    @Generated
    public void setInitiatingHeartbeatTimeout(BRelTime v) {
        this.set(initiatingHeartbeatTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getAcceptingHeartbeatTimeout() {
        return (BRelTime)this.get(acceptingHeartbeatTimeout);
    }

    @Generated
    public void setAcceptingHeartbeatTimeout(BRelTime v) {
        this.set(acceptingHeartbeatTimeout, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.scLinkLayer = (BScLinkLayer)this.getParent();
        this.updateWebSocketWaitTimeoutDefault();
    }

    private void updateWebSocketWaitTimeoutDefault() {
        if (!Flags.isUserDefined1((BComplex)this, (Slot)webSocketWaitTimeout)) {
            if (this.getWebSocketWaitTimeout().equals((Object)webSocketWaitTimeout.getDefaultValue())) {
                this.setWebSocketWaitTimeout(BRelTime.makeSeconds((int)30));
            }
            Flags.add((BComponent)this, (Slot)webSocketWaitTimeout, null, (int[])new int[]{0x10000000});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (acceptingHeartbeatTimeout.equals(property)) {
            long timeout = this.getAcceptingSocketIdleTimeout();
            for (BDirectAcceptingConnection bDirectAcceptingConnection : this.scLinkLayer.getDirectAcceptingConnections()) {
                bDirectAcceptingConnection.setSocketIdleTimeout(timeout);
                bDirectAcceptingConnection.resetPeriodicWaitTicket();
            }
            for (BAcceptingConnection bAcceptingConnection : this.scLinkLayer.getHubFunctionConnections()) {
                bAcceptingConnection.setSocketIdleTimeout(timeout);
                bAcceptingConnection.resetPeriodicWaitTicket();
            }
        } else if (initiatingHeartbeatTimeout.equals(property)) {
            void var8_15;
            long timeout = this.getInitiatingSocketIdleTimeout();
            BHubConnector hubConnector = this.scLinkLayer.getHubConnector();
            hubConnector.getPrimaryConnection().setSocketIdleTimeout(timeout);
            hubConnector.getFailoverConnection().setSocketIdleTimeout(timeout);
            hubConnector.getPrimaryConnection().resetPeriodicWaitTicket();
            hubConnector.getFailoverConnection().resetPeriodicWaitTicket();
            BDirectInitiatingConnection[] bDirectInitiatingConnectionArray = this.scLinkLayer.getDirectInitiatingConnections();
            int n = bDirectInitiatingConnectionArray.length;
            boolean bl = false;
            while (var8_15 < n) {
                BDirectInitiatingConnection connection = bDirectInitiatingConnectionArray[var8_15];
                connection.setSocketIdleTimeout(timeout);
                connection.resetPeriodicWaitTicket();
                ++var8_15;
            }
        } else if (nodeMaxBvlcLength.equals(property)) {
            this.scLinkLayer.getNodeSwitch().getWebSocketAcceptor().updateWebSocketSettings();
            this.scLinkLayer.getWebSocketInitiator().updateWebSocketSettings();
        }
    }

    public long getInitiatingSocketIdleTimeout() {
        return (long)((double)this.getInitiatingHeartbeatTimeout().getMillis() * 4.0);
    }

    public long getAcceptingSocketIdleTimeout() {
        return (long)((double)this.getAcceptingHeartbeatTimeout().getMillis() * 4.0);
    }
}

