/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.authn.LoginFailureCause;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticationScheme;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticator;
import com.tridium.bacnet.stack.link.sc.authentication.BacnetScCallback;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetScAuthenticationScheme"})})
public final class BBacnetScWebCallbackHandler
extends BWebCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScWebCallbackHandler.class);
    private String username;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public int handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        NiagaraWebSession session = null;
        try {
            session = WebSessionUtil.getSession((HttpSession)request.getSession());
            Locale locale = request.getLocale();
            BasicContext context = new BasicContext(null, locale != null ? locale.toLanguageTag() : Sys.getLanguage());
            if (!request.isSecure()) {
                BBacnetScAuthenticator.logger.warning(ScLinkLayerUtil.LEXICON.getText("authFailure.noTls", (Context)context));
                return BBacnetScWebCallbackHandler.handleError(session);
            }
            SSLSession sslSession = (SSLSession)request.getAttribute("org.eclipse.jetty.servlet.request.ssl_session");
            if (sslSession == null || !sslSession.getProtocol().equalsIgnoreCase("tlsv1.3")) {
                BBacnetScAuthenticator.logger.warning(ScLinkLayerUtil.LEXICON.getText("authFailure.tlsVersion", (Context)context));
                return BBacnetScWebCallbackHandler.handleError(session);
            }
            X509Certificate[] clientCertChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (clientCertChain == null) {
                BBacnetScAuthenticator.logger.warning(ScLinkLayerUtil.LEXICON.getText("authFailure.noClientCert", (Context)context));
                return BBacnetScWebCallbackHandler.handleError(session);
            }
            this.username = BBacnetScWebCallbackHandler.findUserFromCertificateChain(clientCertChain);
            if (this.username == null) {
                BBacnetScAuthenticator.logger.warning(ScLinkLayerUtil.LEXICON.getText("authFailure.noUser", (Context)context));
                return BBacnetScWebCallbackHandler.handleError(session);
            }
            return 0;
        }
        catch (Exception e) {
            if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
                BBacnetScAuthenticator.logger.log(Level.WARNING, e.getMessage(), e);
            } else {
                BBacnetScAuthenticator.logger.log(Level.WARNING, e.getMessage());
            }
            return BBacnetScWebCallbackHandler.handleError(session);
        }
    }

    private static int handleError(NiagaraWebSession session) {
        if (session != null) {
            session.setAttribute("loginFailureCause", (Object)LoginFailureCause.CLIENT_CERT_FAILURE);
        }
        return 3;
    }

    public String getUsername() {
        return this.username;
    }

    private static String findUserFromCertificateChain(X509Certificate[] clientCertChain) {
        List sortedClientCertChain = null;
        int bestMatchingIndex = Integer.MAX_VALUE;
        String bestMatchingUser = null;
        for (BUser user : BUserService.getService().getUsers()) {
            int currentIndex;
            BBacnetScAuthenticator authenticator;
            PKIXCertPathBuilderResult result;
            if (!(user.getAuthenticationScheme() instanceof BBacnetScAuthenticationScheme)) continue;
            if (sortedClientCertChain == null) {
                sortedClientCertChain = CertUtils.sortCertChain(Arrays.asList(clientCertChain));
            }
            if ((result = (authenticator = (BBacnetScAuthenticator)user.getAuthenticator()).verify(sortedClientCertChain)) == null || (currentIndex = BBacnetScWebCallbackHandler.getTrustedCertIndex(result)) >= bestMatchingIndex) continue;
            bestMatchingUser = user.getName();
            bestMatchingIndex = currentIndex;
        }
        return bestMatchingUser;
    }

    private static int getTrustedCertIndex(PKIXCertPathBuilderResult result) {
        X509Certificate matchingCert;
        List<? extends Certificate> certPath = result.getCertPath().getCertificates();
        int currentIndex = certPath.indexOf(matchingCert = result.getTrustAnchor().getTrustedCert());
        if (currentIndex == -1) {
            return certPath.size();
        }
        return currentIndex;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new IOException("invalid callback array provided");
        }
        for (Callback callback : callbacks) {
            if (!(callback instanceof BacnetScCallback)) {
                throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
            }
            ((BacnetScCallback)callback).setUsername(this.username);
        }
    }
}

