/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BIRoleService;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationServiceSecurityDashboardProviderAgent"})})
public class BScSchemeSecurityDashboardItemProvider
extends BObject
implements BISecurityDashboardItemProvider,
BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BScSchemeSecurityDashboardItemProvider.class);
    private static final int VERSION = 1;
    private static final String SC_USERS_DESCRIPTION = "securityDashboard.scAuthScheme.users.description";
    private static final SecurityDashboardItemBuilder builder = new SecurityDashboardItemBuilder(TYPE);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List<BUser> scUsers = BScSchemeSecurityDashboardItemProvider.getScUsers();
        if (scUsers.isEmpty()) {
            return Collections.singletonList(builder.makeInfo("securityDashboard.scAuthScheme.noUsers.summary", "securityDashboard.scAuthScheme.noUsers.description"));
        }
        BScSchemeSecurityDashboardItemProvider.addPermissionItems(items, scUsers);
        return items;
    }

    private static void addPermissionItems(List<SecurityDashboardItem> items, List<BUser> scUsers) {
        BRoleService roleService = BRoleService.getService();
        ArrayList<String> scUsersWithPermissions = new ArrayList<String>(scUsers.size());
        ArrayList<String> scUsersWithNoPermissions = new ArrayList<String>(scUsers.size());
        for (BUser user : scUsers) {
            if (BPermissionsMap.DEFAULT.equals((Object)user.getPermissions((BIRoleService)roleService))) {
                scUsersWithNoPermissions.add(user.getName());
                continue;
            }
            scUsersWithPermissions.add(user.getName());
        }
        if (!scUsersWithNoPermissions.isEmpty()) {
            items.add(builder.makeOk().withSummary("securityDashboard.scAuthScheme.users.noPermissions.summary", new Object[]{String.join((CharSequence)", ", scUsersWithNoPermissions)}).withDescription(SC_USERS_DESCRIPTION, new Object[0]));
        }
        if (!scUsersWithPermissions.isEmpty()) {
            items.add(builder.makeAlert().withSummary("securityDashboard.scAuthScheme.users.withPermissions.summary", new Object[]{String.join((CharSequence)", ", scUsersWithPermissions)}).withDescription(SC_USERS_DESCRIPTION, new Object[0]));
        }
    }

    private static List<BUser> getScUsers() {
        BUserService userService = BUserService.getService();
        if (userService == null) {
            return Collections.emptyList();
        }
        ArrayList<BUser> scUsers = new ArrayList<BUser>();
        for (BUser user : userService.getUsers()) {
            if (!(user.getAuthenticator() instanceof BBacnetScAuthenticator)) continue;
            scUsers.add(user);
        }
        return scUsers;
    }
}

