/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import com.tridium.bacnet.stack.link.sc.authentication.BacnetScCallback;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public final class BacnetScLoginModule
extends NiagaraLoginModule {
    public boolean login() throws LoginException {
        FailedLoginException e;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for BACnet/SC login");
        }
        Callback[] callbacks = new Callback[]{new BacnetScCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((BacnetScCallback)callbacks[0]).getUsername();
        }
        catch (UnsupportedCallbackException e2) {
            String msg = "Provided callback handler could not handle: " + e2.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e2);
            throw new LoginException(msg);
        }
        catch (Exception e3) {
            String msg = "Error handling callbacks:" + e3;
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e3);
            throw new LoginException(msg);
        }
        if (username != null) {
            try {
                this.user = this.getUserService().getUser(username);
                if (this.user != null && this.getUserService().canLogin(this.user)) {
                    this.succeeded = true;
                    return true;
                }
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw e;
    }
}

