/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.connection;

import com.tridium.bacnet.stack.link.sc.BHubFunction;
import com.tridium.bacnet.stack.link.sc.BHubFunctionConnections;
import com.tridium.bacnet.stack.link.sc.VmacUtil;
import com.tridium.bacnet.stack.link.sc.connection.BAcceptingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BAcceptingConnectionState;
import com.tridium.bacnet.stack.link.sc.connection.BBacnetScConnectionState;
import com.tridium.bacnet.stack.link.sc.connection.IScConnectionManager;
import com.tridium.bacnet.stack.link.sc.message.ScBvlcMessage;
import com.tridium.bacnet.stack.link.sc.message.ScReadMessageException;
import com.tridium.bacnet.stack.link.sc.message.ScSendMessageException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BBacnetScConnectionState", defaultValue="BBacnetScConnectionState.notConnected", flags=257), @NiagaraProperty(name="subState", type="BAcceptingConnectionState", defaultValue="BAcceptingConnectionState.DEFAULT", flags=257), @NiagaraProperty(name="nodeAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"null\")", flags=1), @NiagaraProperty(name="nodeVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT", flags=1), @NiagaraProperty(name="nodeUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=1), @NiagaraProperty(name="nodeMaxBvlcLength", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="nodeMaxNpduLength", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="lastConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastDisconnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastFailureToConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)", flags=1), @NiagaraProperty(name="errorDetails", type="String", defaultValue="", flags=1)})
@NiagaraAction(name="forceDisconnect")
public final class BHubAcceptingConnection
extends BAcceptingConnection {
    @Generated
    public static final Property state = BHubAcceptingConnection.newProperty((int)257, (BValue)BBacnetScConnectionState.notConnected, null);
    @Generated
    public static final Property subState = BHubAcceptingConnection.newProperty((int)257, (BValue)BAcceptingConnectionState.DEFAULT, null);
    @Generated
    public static final Property nodeAddress = BHubAcceptingConnection.newProperty((int)1, (BValue)new BInternetAddress("null"), null);
    @Generated
    public static final Property nodeVmac = BHubAcceptingConnection.newProperty((int)1, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property nodeUuid = BHubAcceptingConnection.newProperty((int)1, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property nodeMaxBvlcLength = BHubAcceptingConnection.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property nodeMaxNpduLength = BHubAcceptingConnection.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property lastConnect = BHubAcceptingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastDisconnect = BHubAcceptingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailureToConnect = BHubAcceptingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property error = BHubAcceptingConnection.newProperty((int)1, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BHubAcceptingConnection.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action forceDisconnect = BHubAcceptingConnection.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHubAcceptingConnection.class);
    private static final Logger logger = Logger.getLogger("bacnet.sc.hubFunction");
    private BHubFunction hubFunction;
    private boolean isLocal;

    @Override
    @Generated
    public BBacnetScConnectionState getState() {
        return (BBacnetScConnectionState)this.get(state);
    }

    @Override
    @Generated
    public void setState(BBacnetScConnectionState v) {
        this.set(state, (BValue)v, null);
    }

    @Override
    @Generated
    public BAcceptingConnectionState getSubState() {
        return (BAcceptingConnectionState)this.get(subState);
    }

    @Override
    @Generated
    public void setSubState(BAcceptingConnectionState v) {
        this.set(subState, (BValue)v, null);
    }

    @Generated
    public BInternetAddress getNodeAddress() {
        return (BInternetAddress)this.get(nodeAddress);
    }

    @Generated
    public void setNodeAddress(BInternetAddress v) {
        this.set(nodeAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getNodeVmac() {
        return (BBacnetOctetString)this.get(nodeVmac);
    }

    @Generated
    public void setNodeVmac(BBacnetOctetString v) {
        this.set(nodeVmac, (BValue)v, null);
    }

    @Generated
    public BUuid getNodeUuid() {
        return (BUuid)this.get(nodeUuid);
    }

    @Generated
    public void setNodeUuid(BUuid v) {
        this.set(nodeUuid, (BValue)v, null);
    }

    @Generated
    public int getNodeMaxBvlcLength() {
        return this.getInt(nodeMaxBvlcLength);
    }

    @Generated
    public void setNodeMaxBvlcLength(int v) {
        this.setInt(nodeMaxBvlcLength, v, null);
    }

    @Generated
    public int getNodeMaxNpduLength() {
        return this.getInt(nodeMaxNpduLength);
    }

    @Generated
    public void setNodeMaxNpduLength(int v) {
        this.setInt(nodeMaxNpduLength, v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastConnect() {
        return (BAbsTime)this.get(lastConnect);
    }

    @Override
    @Generated
    public void setLastConnect(BAbsTime v) {
        this.set(lastConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastDisconnect() {
        return (BAbsTime)this.get(lastDisconnect);
    }

    @Override
    @Generated
    public void setLastDisconnect(BAbsTime v) {
        this.set(lastDisconnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastFailureToConnect() {
        return (BAbsTime)this.get(lastFailureToConnect);
    }

    @Override
    @Generated
    public void setLastFailureToConnect(BAbsTime v) {
        this.set(lastFailureToConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Override
    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Override
    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Override
    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public void forceDisconnect() {
        this.invoke(forceDisconnect, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.hubFunction = (BHubFunction)this.getParent().getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BHubFunctionConnections;
    }

    @Override
    protected void setRemoteAddress(BInternetAddress address) {
        this.setNodeAddress(address);
    }

    @Override
    protected void setRemoteVmac(long vmac) {
        this.setNodeVmac(VmacUtil.vmacToOctetString(vmac));
    }

    @Override
    protected void setRemoteUuid(UUID uuid) {
        this.setNodeUuid(BUuid.make((UUID)uuid));
    }

    @Override
    protected void setRemoteMaxBvlcLength(int maxBvlcLength) {
        this.setNodeMaxBvlcLength(maxBvlcLength);
    }

    @Override
    protected void setRemoteMaxNpduLength(int maxNpduLength) {
        this.setNodeMaxNpduLength(maxNpduLength);
    }

    @Override
    protected int getLocalMaxBvlcLength() {
        return this.hubFunction.getMaxBvlcLength();
    }

    @Override
    protected int getNextMessageId() {
        return this.hubFunction.getNextMessageId();
    }

    @Override
    protected IScConnectionManager getConnectionManager() {
        return this.hubFunction;
    }

    @Override
    protected void checkMessageReceivedSize(byte[] payload, int offset, int len) throws ScReadMessageException {
        if (len > 65535) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Received message length ").append(len).append(" exceeds the maximum BVLC message length of ").append(65535).append("; message: ").append(this.messageToString(payload, offset, len)).toString());
            }
            throw new ScReadMessageException("Received message length " + len + " exceeds the maximum BVLC message length of " + 65535, BBacnetErrorCode.messageTooLong);
        }
    }

    @Override
    protected void handleUnicastAddressedMessage(int function, byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        long destinationVmac = ScBvlcMessage.readDestinationVmac(payload, offset, len);
        BHubAcceptingConnection.checkIsUnicast(destinationVmac);
        this.hubFunction.forwardMessage(this.getRemoteVmac(), destinationVmac, payload, offset, len);
    }

    @Override
    protected void handleEncapsulatedNpdu(byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        long destinationVmac = ScBvlcMessage.readDestinationVmac(payload, offset, len);
        this.hubFunction.forwardMessage(this.getRemoteVmac(), destinationVmac, payload, offset, len);
    }

    @Override
    protected void handleBvlcResult(byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        int resultFunction = ScBvlcMessage.readResultFunction(payload, offset, len);
        if (ScBvlcMessage.isAddressedMessage(resultFunction)) {
            long destinationVmac = ScBvlcMessage.readDestinationVmac(payload, offset, len);
            BHubAcceptingConnection.checkIsUnicast(destinationVmac);
            this.hubFunction.forwardMessage(this.getRemoteVmac(), destinationVmac, payload, offset, len);
        } else {
            this.logIgnoredBvlcResult(payload, offset, len);
        }
    }

    @Override
    public void validateLocalConnectionToken(String connectionToken) {
        this.isLocal = this.hubFunction.isValidLocalConnectionToken(connectionToken);
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public StringBuilder getLogInfo() {
        long remoteVmac = this.getRemoteVmac();
        UUID remoteUuid = this.getRemoteUuid();
        if (remoteVmac != -1L && remoteUuid != null) {
            return new StringBuilder("Hub accepting connection, VMAC ").append(VmacUtil.vmacToString(remoteVmac)).append(", UUID ").append(remoteUuid);
        }
        return new StringBuilder("Hub accepting connection");
    }

    public String toString(Context cx) {
        return this.getState().getDisplayTag(cx) + " [" + this.getNodeVmac().toString(cx) + ']';
    }
}

