/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.connection.jetty;

import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.connection.BAbstractScWebSocketInitiator;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.IScWebSocket;
import com.tridium.bacnet.stack.link.sc.connection.jetty.JettyScUtil;
import com.tridium.bacnet.stack.link.sc.connection.jetty.JettyScWebSocket;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustManagerBuilder;
import com.tridium.nre.security.SecretChars;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BacnetException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.TrustManager;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@NiagaraType
@NiagaraProperty(name="performHostnameValidation", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.SECURITY", value="true")})
public final class BJettyScWebSocketInitiator
extends BAbstractScWebSocketInitiator {
    @Generated
    public static final Property performHostnameValidation = BJettyScWebSocketInitiator.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Type TYPE = Sys.loadType(BJettyScWebSocketInitiator.class);
    private final AtomicReference<WebSocketClient> clientRef = new AtomicReference();
    private static final Logger logger = Logger.getLogger("bacnet.sc.linkLayer");

    @Generated
    public boolean getPerformHostnameValidation() {
        return this.getBoolean(performHostnameValidation);
    }

    @Generated
    public void setPerformHostnameValidation(boolean v) {
        this.setBoolean(performHostnameValidation, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopClient();
    }

    @Override
    public IScWebSocket initiateWebSocket(BInitiatingConnection connection) throws Exception {
        JettyScWebSocket webSocket = new JettyScWebSocket(connection);
        URI uri = connection.getURI();
        ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
        clientUpgradeRequest.setSubProtocols(new String[]{connection.getSubProtocol()});
        String localConnectionToken = connection.getLocalConnectionToken();
        if (localConnectionToken != null) {
            clientUpgradeRequest.setHeader("Niagara-Local-Connection-Token", localConnectionToken);
        }
        this.clientRef.get().connect((Object)webSocket, uri, clientUpgradeRequest);
        return webSocket;
    }

    @Override
    public void linkCommStart() throws Exception {
        this.stopClient();
        if (!this.isRunning()) {
            throw new BacnetException("linkCommStart called on JettyScWebSocketInitiator that is not running");
        }
        WebSocketClient client = null;
        try {
            client = AccessController.doPrivileged(() -> {
                HttpClient httpClient = new HttpClient(this.makeSslContextFactory());
                return new WebSocketClient(httpClient);
            });
        }
        catch (PrivilegedActionException e) {
            throw new BacnetException("Failed to create WebSocketClient", e.getException());
        }
        JettyScUtil.configurePolicy(client.getPolicy(), ((BScLinkLayer)this.getParent()).getMaxBvlcLength());
        if (this.clientRef.compareAndSet(null, client)) {
            client.start();
        }
    }

    @Override
    public void linkCommStop() {
        this.stopClient();
    }

    @Override
    public void updateWebSocketSettings() {
        try {
            this.clientRef.get().getPolicy().setMaxBinaryMessageSize(((BScLinkLayer)this.getParent()).getMaxBvlcLength());
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(logger, new StringBuilder("Failed to set the web socket initiator's policy max binary message size"), e);
        }
    }

    private void stopClient() {
        try {
            WebSocketClient client = this.clientRef.getAndSet(null);
            if (client != null) {
                client.stop();
            }
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(logger, new StringBuilder("Failed to stop the BACnet SC link layer's JettyScWebSocketInitiator WebSocketClient"), e);
        }
    }

    private SslContextFactory makeSslContextFactory() throws BacnetException {
        try {
            return AccessController.doPrivileged(() -> {
                BScLinkLayer scLinkLayer = ScLinkLayerUtil.getScLinkLayer((BComplex)this);
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                scLinkLayer.addTrustAnchors(trustAnchors);
                if (trustAnchors.isEmpty()) {
                    throw new AuthenticationException("No trust anchors specified for bacnet sc");
                }
                HashSet<X509CRL> crls = new HashSet<X509CRL>();
                scLinkLayer.addCRLs(crls);
                String protocol = BSslTlsEnum.tlsv1_3.getTag();
                BCertificateAliasAndPassword operationalCert = scLinkLayer.getCredentials().getOperationalCertificateAliasAndPassword();
                String certAlias = operationalCert.getAlias();
                TrustManager[] trustManagers = TrustManagerBuilder.getTrustManagers(trustAnchors, crls);
                ClientTlsParameters tlsParams = new ClientTlsParameters(protocol, certAlias);
                BPassword certPassword = operationalCert.getPassword();
                if (!certPassword.isDefault()) {
                    try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)certPassword).getSecretChars());){
                        tlsParams.setKeyPassphrase(passwordChars.get());
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The WebSocket client for SC port " + scLinkLayer.getParent().getName() + " is using these TLS params: " + tlsParams);
                }
                SslContextFactory.Client factory = CoreCryptoManager.get().getSslContextFactory(tlsParams, trustManagers, !crls.isEmpty());
                if (!this.getPerformHostnameValidation()) {
                    factory.setEndpointIdentificationAlgorithm(null);
                }
                factory.setValidateCerts(false);
                return factory;
            });
        }
        catch (PrivilegedActionException pae) {
            ScLinkLayerUtil.logException(logger, new StringBuilder("Error creating SSL context factory for the JettyScWebSocketInitiator WebSocketClient"), pae.getException());
            throw new BacnetException(pae.getException());
        }
    }
}

