/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.message;

import com.tridium.bacnet.stack.link.sc.message.ProprietaryHeaderOption;
import com.tridium.bacnet.stack.link.sc.message.ScReadMessageException;
import com.tridium.bacnet.stack.link.sc.message.SecurePathHeaderOption;
import com.tridium.bacnet.stack.link.sc.message.UnsupportedHeaderOption;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.nre.util.ByteBuffer;

public abstract class HeaderOption {
    private final int headerMarker;

    protected HeaderOption(int headerMarker) {
        this.headerMarker = headerMarker;
    }

    protected HeaderOption(int optionType, boolean mustUnderstand, boolean hasData) {
        int headerMarker = optionType;
        if (hasData) {
            headerMarker |= 0x20;
        }
        if (mustUnderstand) {
            headerMarker |= 0x40;
        }
        this.headerMarker = headerMarker;
    }

    public static HeaderOption make(ByteBuffer in, boolean isDestinationOption) throws ScReadMessageException {
        HeaderOption headerOption;
        int headerMarker;
        try {
            headerMarker = in.readUnsignedByte();
        }
        catch (Exception e) {
            throw new ScReadMessageException("Message header is incomplete: failed to read header marker", e, BBacnetErrorCode.messageIncomplete);
        }
        switch (HeaderOption.readOptionType(headerMarker)) {
            case 1: {
                if (isDestinationOption) {
                    throw new ScReadMessageException("Secure path destination header option not supported", BBacnetErrorCode.inconsistentParameters, headerMarker);
                }
                headerOption = new SecurePathHeaderOption(headerMarker);
                break;
            }
            case 31: {
                if (isDestinationOption && HeaderOption.mustUnderstand(headerMarker)) {
                    throw new ScReadMessageException("Proprietary destination header option not understood", BBacnetErrorCode.headerNotUnderstood, headerMarker);
                }
                headerOption = new ProprietaryHeaderOption(headerMarker);
                break;
            }
            default: {
                if (isDestinationOption && HeaderOption.mustUnderstand(headerMarker)) {
                    throw new ScReadMessageException("Unknown destination header option not understood", BBacnetErrorCode.headerNotUnderstood, headerMarker);
                }
                headerOption = new UnsupportedHeaderOption(headerMarker);
            }
        }
        headerOption.checkMustUnderstandFlag(HeaderOption.mustUnderstand(headerMarker), isDestinationOption);
        headerOption.checkDataFlag(HeaderOption.hasData(headerMarker), isDestinationOption);
        try {
            headerOption.decodeHeaderData(in);
        }
        catch (Exception e) {
            throw new ScReadMessageException("Message header is incomplete", e, BBacnetErrorCode.messageIncomplete, isDestinationOption ? headerMarker : 0);
        }
        return headerOption;
    }

    protected void checkMustUnderstandFlag(boolean mustUnderstand, boolean isDestinationOption) throws ScReadMessageException {
    }

    protected void checkDataFlag(boolean hasData, boolean isDestinationOption) throws ScReadMessageException {
        if (hasData) {
            throw new ScReadMessageException("Header Data flag should not be set", BBacnetErrorCode.inconsistentParameters);
        }
    }

    protected void decodeHeaderData(ByteBuffer in) throws IOException {
    }

    public final void encode(DataOutput out, boolean hasMore) throws IOException {
        int encodedHeaderMarker = this.headerMarker;
        if (hasMore) {
            encodedHeaderMarker |= 0x80;
        }
        out.writeByte(encodedHeaderMarker);
        this.encodeHeaderData(out);
    }

    protected void encodeHeaderData(DataOutput out) throws IOException {
    }

    private static int readOptionType(int headerMarker) {
        return headerMarker & 0x1F;
    }

    private static boolean hasData(int headerMarker) {
        return (headerMarker & 0x20) > 0;
    }

    private static boolean mustUnderstand(int headerMarker) {
        return (headerMarker & 0x40) > 0;
    }

    public final int getHeaderMarker() {
        return this.headerMarker;
    }

    public final int getOptionType() {
        return HeaderOption.readOptionType(this.headerMarker);
    }

    public final boolean hasData() {
        return HeaderOption.hasData(this.headerMarker);
    }

    public final boolean mustUnderstand() {
        return HeaderOption.mustUnderstand(this.headerMarker);
    }

    public final boolean hasMore() {
        return (this.headerMarker & 0x80) > 0;
    }

    public String toString() {
        return HeaderOption.optionToString(this.getOptionType()) + "; hasData? " + this.hasData() + "; mustUnderstand? " + this.mustUnderstand() + "; hasMore? " + this.hasMore();
    }

    private static String optionToString(int optionType) {
        switch (optionType) {
            case 1: {
                return "Secure Path (0x01)";
            }
            case 31: {
                return "Proprietary (0x31)";
            }
        }
        return String.format("Unknown - 0x%02X", optionType);
    }
}

