/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BRouterStatus;
import com.tridium.bacnet.timers.Timers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dnet", type="int", defaultValue="-1"), @NiagaraProperty(name="routerAddress", type="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT"), @NiagaraProperty(name="portId", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="portInfo", type="String", defaultValue="", flags=1), @NiagaraProperty(name="routerStatus", type="BRouterStatus", defaultValue="BRouterStatus.unknown", flags=1)})
public class BBacnetRouterEntry
extends BStruct {
    @Generated
    public static final Property dnet = BBacnetRouterEntry.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property routerAddress = BBacnetRouterEntry.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Property portId = BBacnetRouterEntry.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property portInfo = BBacnetRouterEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property routerStatus = BBacnetRouterEntry.newProperty((int)1, (BValue)BRouterStatus.unknown, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetRouterEntry.class);
    public static final int BUSY_TIMEOUT = 30000;
    private int busyTimerId;
    long lastUpdateTicks = Clock.ticks();

    @Generated
    public int getDnet() {
        return this.getInt(dnet);
    }

    @Generated
    public void setDnet(int v) {
        this.setInt(dnet, v, null);
    }

    @Generated
    public BBacnetAddress getRouterAddress() {
        return (BBacnetAddress)this.get(routerAddress);
    }

    @Generated
    public void setRouterAddress(BBacnetAddress v) {
        this.set(routerAddress, (BValue)v, null);
    }

    @Generated
    public int getPortId() {
        return this.getInt(portId);
    }

    @Generated
    public void setPortId(int v) {
        this.setInt(portId, v, null);
    }

    @Generated
    public String getPortInfo() {
        return this.getString(portInfo);
    }

    @Generated
    public void setPortInfo(String v) {
        this.setString(portInfo, v, null);
    }

    @Generated
    public BRouterStatus getRouterStatus() {
        return (BRouterStatus)this.get(routerStatus);
    }

    @Generated
    public void setRouterStatus(BRouterStatus v) {
        this.set(routerStatus, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetRouterEntry() {
    }

    public BBacnetRouterEntry(int dnet, BBacnetAddress routerAddress, int portId, String portInfo, BRouterStatus routerStatus) {
        this.setDnet(dnet);
        this.setRouterAddress(routerAddress);
        this.setPortId(portId);
        this.setPortInfo(portInfo == null ? "" : portInfo);
        this.setRouterStatus(routerStatus);
    }

    public String toString(Context cx) {
        return "" + this.getPortId() + ":" + this.getRouterAddress() + "->" + this.getDnet() + "-" + (Object)((Object)this.getRouterStatus());
    }

    public boolean isDisconnected() {
        return this.getRouterStatus() == BRouterStatus.routerNotConnected;
    }

    public boolean isUnavailable() {
        return this.getRouterStatus() == BRouterStatus.routerUnavailable;
    }

    public boolean isBusy() {
        return this.getRouterStatus() == BRouterStatus.routerBusy;
    }

    public void readNetworkBytes(ByteArrayInputStream is) throws IOException {
        int dnet = is.read() << 8;
        this.setDnet(dnet |= is.read());
        this.setPortId(is.read());
        int portInfoLength = is.read();
        byte[] portInfo = new byte[portInfoLength];
        is.read(portInfo);
        this.setPortInfo(new String(portInfo));
    }

    public void writeNetworkBytes(ByteArrayOutputStream os) {
        int dnet = this.getDnet();
        os.write(dnet >> 8);
        os.write(dnet & 0xFF);
        os.write(this.getPortId());
        byte[] portInfo = this.getPortInfo().getBytes();
        if (portInfo == null) {
            os.write(0);
        } else {
            os.write(portInfo.length);
            os.write(portInfo, 0, portInfo.length);
        }
    }

    public void startBusyTimer() {
        Timers.cancel(this.busyTimerId);
        this.busyTimerId = Timers.add(((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork(), 30000L, (Object)this);
    }

    public void stopBusyTimer() {
        Timers.cancel(this.busyTimerId);
    }
}

