/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.datatypes.BChangeDeviceIdConfig;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BTimeSynchConfig;
import com.tridium.bacnet.datatypes.BWhoHasConfig;
import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.job.BChangeDeviceIdJob;
import com.tridium.bacnet.job.BTimeSynchJob;
import com.tridium.bacnet.job.BWhoHasJob;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.cov.BBacnetCovWorker;
import com.tridium.util.ComponentTreeCursor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetDeviceFolder;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyPolicies", type="BHistoryNetworkExt", defaultValue="new BHistoryNetworkExt()"), @NiagaraProperty(name="worker", type="BBacnetWorker", defaultValue="new BBacnetWorker()", flags=4), @NiagaraProperty(name="writeWorker", type="BBacnetWorker", defaultValue="new BBacnetWorker()", flags=4), @NiagaraProperty(name="bacnetComm", type="BBacnetComm", defaultValue="new BBacnetStack()"), @NiagaraProperty(name="localDevice", type="BLocalBacnetDevice", defaultValue="new BLocalBacnetDevice()"), @NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BBacnetTuningPolicyMap()"), @NiagaraProperty(name="covWorker", type="BBacnetCovWorker", defaultValue="new BBacnetCovWorker()", flags=4), @NiagaraProperty(name="asyncPing", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="submitDeviceManagerJob", parameterType="BValue", defaultValue="new BDeviceDiscoveryConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="lookupDeviceById", parameterType="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT", returnType="BBacnetDevice", flags=4), @NiagaraAction(name="lookupDeviceByAddress", parameterType="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT", returnType="BBacnetDevice", flags=4), @NiagaraAction(name="lookupDeviceOrdById", parameterType="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT", returnType="BOrd", flags=4), @NiagaraAction(name="lookupDeviceOrdByAddress", parameterType="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT", returnType="BOrd", flags=4)})
public class BBacnetNetwork
extends BLoadableNetwork
implements BacnetConst,
BIService {
    @Generated
    public static final Property historyPolicies = BBacnetNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    @Generated
    public static final Property worker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetWorker(), null);
    @Generated
    public static final Property writeWorker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetWorker(), null);
    @Generated
    public static final Property bacnetComm = BBacnetNetwork.newProperty((int)0, (BValue)new BBacnetStack(), null);
    @Generated
    public static final Property localDevice = BBacnetNetwork.newProperty((int)0, (BValue)new BLocalBacnetDevice(), null);
    @Generated
    public static final Property tuningPolicies = BBacnetNetwork.newProperty((int)0, (BValue)new BBacnetTuningPolicyMap(), null);
    @Generated
    public static final Property covWorker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetCovWorker(), null);
    @Generated
    public static final Property asyncPing = BBacnetNetwork.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action submitDeviceManagerJob = BBacnetNetwork.newAction((int)4, (BValue)new BDeviceDiscoveryConfig(), null);
    @Generated
    public static final Action lookupDeviceById = BBacnetNetwork.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Action lookupDeviceByAddress = BBacnetNetwork.newAction((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Action lookupDeviceOrdById = BBacnetNetwork.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Action lookupDeviceOrdByAddress = BBacnetNetwork.newAction((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static final String UPLOAD_ON_START = "uploadOnStart";
    public static final String WRITE_ON_FACET_CHANGE = "writeOnFacetChange";
    public static final String SHOULD_SUPPORT_FAULTS_MULTI_STATE = "shouldSupportFaultForMultiState";
    public static final String PRIVATE_TRANSFER_RESULT_BLOCK = "privateTransferResultBlockFlag";
    private boolean networkReady = false;
    private BBoolean uploadOnStart = null;
    private static BBacnetNetwork bacnetService = null;
    private static BBacnetNetwork BACNET_NETWORK = null;
    private static BLocalBacnetDevice BACNET_LOCAL_DEVICE = null;
    protected static final Logger log = Logger.getLogger("bacnet");
    private Hashtable<BBacnetObjectIdentifier, BOrd> ordByObjectId = new Hashtable();
    private Map<Integer, Map<BBacnetOctetString, BOrd>> ordByAddress = new HashMap<Integer, Map<BBacnetOctetString, BOrd>>();

    @Generated
    public BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    @Generated
    public void setHistoryPolicies(BHistoryNetworkExt v) {
        this.set(historyPolicies, (BValue)v, null);
    }

    @Generated
    public BBacnetWorker getWorker() {
        return (BBacnetWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BBacnetWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public BBacnetWorker getWriteWorker() {
        return (BBacnetWorker)this.get(writeWorker);
    }

    @Generated
    public void setWriteWorker(BBacnetWorker v) {
        this.set(writeWorker, (BValue)v, null);
    }

    @Generated
    public BBacnetComm getBacnetComm() {
        return (BBacnetComm)this.get(bacnetComm);
    }

    @Generated
    public void setBacnetComm(BBacnetComm v) {
        this.set(bacnetComm, (BValue)v, null);
    }

    @Generated
    public BLocalBacnetDevice getLocalDevice() {
        return (BLocalBacnetDevice)this.get(localDevice);
    }

    @Generated
    public void setLocalDevice(BLocalBacnetDevice v) {
        this.set(localDevice, (BValue)v, null);
    }

    @Generated
    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    @Generated
    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    @Generated
    public BBacnetCovWorker getCovWorker() {
        return (BBacnetCovWorker)this.get(covWorker);
    }

    @Generated
    public void setCovWorker(BBacnetCovWorker v) {
        this.set(covWorker, (BValue)v, null);
    }

    @Generated
    public boolean getAsyncPing() {
        return this.getBoolean(asyncPing);
    }

    @Generated
    public void setAsyncPing(boolean v) {
        this.setBoolean(asyncPing, v, null);
    }

    @Generated
    public BOrd submitDeviceManagerJob(BValue parameter) {
        return (BOrd)this.invoke(submitDeviceManagerJob, parameter, null);
    }

    @Generated
    public BBacnetDevice lookupDeviceById(BBacnetObjectIdentifier parameter) {
        return (BBacnetDevice)this.invoke(lookupDeviceById, (BValue)parameter, null);
    }

    @Generated
    public BBacnetDevice lookupDeviceByAddress(BBacnetAddress parameter) {
        return (BBacnetDevice)this.invoke(lookupDeviceByAddress, (BValue)parameter, null);
    }

    @Generated
    public BOrd lookupDeviceOrdById(BBacnetObjectIdentifier parameter) {
        return (BOrd)this.invoke(lookupDeviceOrdById, (BValue)parameter, null);
    }

    @Generated
    public BOrd lookupDeviceOrdByAddress(BBacnetAddress parameter) {
        return (BOrd)this.invoke(lookupDeviceOrdByAddress, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
        bacnetService = this;
        BACNET_NETWORK = null;
        BACNET_LOCAL_DEVICE = null;
        BBacnetNetwork.bacnet();
        BBacnetNetwork.localDevice();
    }

    public final void serviceStopped() {
        bacnetService = null;
        BACNET_NETWORK = null;
        BACNET_LOCAL_DEVICE = null;
    }

    public boolean isChildLegal(BComponent child) {
        return !(child instanceof BLocalBacnetDevice);
    }

    public void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail("Duplicate BacnetNetwork");
                throw new IllegalStateException("Only one BacnetNetwork allowed per station!");
            }
            this.setUploadOnStart();
            this.setAndGetShouldSupportFaults();
            this.setAndGetPrivateTransferResultBlockFlag();
        }
        catch (ServiceNotFoundException e) {
            log.severe("BACnet Network not registered as a service!");
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.isDynamic() && property.getName().equalsIgnoreCase(UPLOAD_ON_START)) {
            this.uploadOnStart = this.setUploadOnStart();
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        ((BBacnetStack)this.getBacnetComm()).getNetwork().networkReady();
        ((BBacnetStack)this.getBacnetComm()).getServer().iAm();
        this.networkReady = true;
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetDevice.class)) {
            ((BBacnetDevice)c.get()).networkReady();
        }
    }

    public void descendantsStopped() throws Exception {
        super.descendantsStopped();
        ((BBacnetStack)this.getBacnetComm()).stopStack();
    }

    public Type getDeviceType() {
        return BBacnetDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BBacnetDeviceFolder.TYPE;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        acc.add((Object)this.getLocalDevice());
        acc.add((Object)this.getBacnetComm());
        acc.add((Object)this.getMonitor());
        acc.add((Object)this.getTuningPolicies());
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "bacnet");
    }

    public final boolean hasServerLicense() {
        return this.getLicenseFeature().getb("export", false);
    }

    public boolean isAws() {
        return false;
    }

    public IFuture postAsync(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public IFuture postWrite(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public BOrd doSubmitDeviceManagerJob(BValue arg, Context cx) {
        if (this.isFatalFault()) {
            return null;
        }
        Type t = arg.getType();
        if (t.is(BWhoHasConfig.TYPE)) {
            return new BWhoHasJob(this, (BWhoHasConfig)arg).submit(cx);
        }
        if (t.is(BDeviceDiscoveryConfig.TYPE)) {
            return new BBacnetDiscoverDevicesJob(this, (BDeviceDiscoveryConfig)arg).submit(cx);
        }
        if (t.is(BTimeSynchConfig.TYPE)) {
            return new BTimeSynchJob(this, (BTimeSynchConfig)arg).submit(cx);
        }
        if (t.is(BChangeDeviceIdConfig.TYPE)) {
            return new BChangeDeviceIdJob(this, (BChangeDeviceIdConfig)arg).submit(cx);
        }
        return BOrd.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBacnetDevice doLookupDeviceById(BBacnetObjectIdentifier objectId) {
        if (objectId == null) {
            return null;
        }
        if (objectId.getInstanceNumber() < 0) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            BOrd ord = this.ordByObjectId.get((Object)objectId);
            if (ord == null) {
                return null;
            }
            try {
                BBacnetDevice dev = (BBacnetDevice)ord.get((BObject)this);
                return dev;
            }
            catch (UnresolvedException e) {
                this.ordByObjectId.remove((Object)objectId);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBacnetDevice doLookupDeviceByAddress(BBacnetAddress address) {
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            BOrd ord = this.doLookupDeviceOrdByAddress(address);
            if (ord != null) {
                try {
                    BBacnetDevice dev = (BBacnetDevice)ord.get((BObject)this);
                    return dev;
                }
                catch (UnresolvedException e) {
                    this.removeAddress(address);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrd doLookupDeviceOrdById(BBacnetObjectIdentifier objectId) {
        if (objectId == null) {
            return null;
        }
        if (objectId.getInstanceNumber() < 0) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            BOrd ord = this.ordByObjectId.get((Object)objectId);
            return ord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrd doLookupDeviceOrdByAddress(BBacnetAddress address) {
        if (address == null) {
            return null;
        }
        if (address.equals(BBacnetAddress.DEFAULT)) {
            return null;
        }
        BOrd ord = null;
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            int networkNumber = address.getNetworkNumber();
            Map<BBacnetOctetString, BOrd> network = this.ordByAddress.get(networkNumber);
            if (network != null) {
                ord = network.get((Object)address.getMacAddress());
            }
        }
        return ord;
    }

    public synchronized void registerDevice(BBacnetDevice device) {
        BOrd ordInSession = device.getOrdInSession();
        this.ordByObjectId.put(device.getObjectId(), ordInSession);
        BBacnetAddress address = device.getAddress();
        int networkNumber = address.getNetworkNumber();
        Map<BBacnetOctetString, BOrd> network = this.ordByAddress.get(networkNumber);
        if (network == null) {
            network = new HashMap<BBacnetOctetString, BOrd>();
            this.ordByAddress.put(networkNumber, network);
        }
        network.put(address.getMacAddress(), ordInSession);
    }

    public synchronized void unregisterDevice(BBacnetDevice device) {
        this.removeFromMaps(device.getOrdInSession());
    }

    public synchronized void updateDevice(BBacnetDevice device) {
        this.unregisterDevice(device);
        this.registerDevice(device);
    }

    @Deprecated
    public BBacnetDevice lookupDevice(BBacnetObjectIdentifier objectId) {
        return this.doLookupDeviceById(objectId);
    }

    @Deprecated
    public BBacnetDevice lookupDevice(BBacnetAddress address) {
        return this.doLookupDeviceByAddress(address);
    }

    public void updateDeviceInfo(BBacnetObjectIdentifier objectId, BBacnetAddress address, int maxAPDULengthAccepted, BBacnetSegmentation segmentationSupported, int vendorId) {
        BBacnetDevice device;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updating device data for {" + (Object)((Object)objectId) + "}");
        }
        if ((device = this.doLookupDeviceById(objectId)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Updating device data for " + device.getName() + " {" + (Object)((Object)objectId) + "}");
            }
            device.updateDeviceInfo(objectId, address, maxAPDULengthAccepted, segmentationSupported, vendorId, this.network().getPortByNetwork(address.getNetworkNumber()));
        }
    }

    public BBacnetDevice[] getDeviceList() {
        Array ret = new Array(BBacnetDevice.class);
        ComponentTreeCursor c = new ComponentTreeCursor((BComponent)this, null);
        while (c.next(BBacnetDevice.class)) {
            ret.add((Object)((BBacnetDevice)c.get()));
        }
        return (BBacnetDevice[])ret.trim();
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.getLocalDevice().getObjectId();
    }

    public static BBacnetNetwork bacnet() {
        if (BACNET_NETWORK == null) {
            BBacnetNetwork tempBacnetNetwork = null;
            try {
                tempBacnetNetwork = Sys.getStation() == null ? bacnetService : (BBacnetNetwork)Sys.getService((Type)TYPE);
            }
            catch (ServiceNotFoundException e) {
                log.log(Level.SEVERE, "Unable to locate Bacnet Service!", e);
            }
            BACNET_NETWORK = tempBacnetNetwork;
        }
        return BACNET_NETWORK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BLocalBacnetDevice localDevice() {
        if (BACNET_LOCAL_DEVICE != null) return BACNET_LOCAL_DEVICE;
        BLocalBacnetDevice tempLocalDevice = null;
        try {
            if (Sys.getStation() == null) {
                if (bacnetService == null) throw new ServiceNotFoundException("BacnetNetwork service not initialized!");
                tempLocalDevice = bacnetService.getLocalDevice();
            } else {
                tempLocalDevice = ((BBacnetNetwork)Sys.getService((Type)TYPE)).getLocalDevice();
            }
        }
        catch (ServiceNotFoundException e) {
            log.log(Level.SEVERE, "Unable to locate Bacnet Service!", e);
        }
        BACNET_LOCAL_DEVICE = tempLocalDevice;
        return BACNET_LOCAL_DEVICE;
    }

    public boolean isNetworkReady() {
        return this.networkReady;
    }

    public BAbstractPollService getPollService(BIBacnetPollable pollable) {
        return this.poll(pollable.device().getAddress().getNetworkNumber());
    }

    public void tuningChanged(BBacnetTuningPolicy policy, Context cx) {
        BBacnetDevice[] devices = this.getDeviceList();
        for (int i = 0; i < devices.length; ++i) {
            devices[i].tuningChanged(policy, cx);
        }
    }

    public BBoolean uploadOnStart() {
        if (this.uploadOnStart == null) {
            this.uploadOnStart = this.setUploadOnStart();
        }
        return this.uploadOnStart;
    }

    private BBoolean setUploadOnStart() {
        BValue value = this.get(UPLOAD_ON_START);
        BBoolean uploadOnStart = BBoolean.TRUE;
        if (value == null) {
            this.add(UPLOAD_ON_START, (BValue)uploadOnStart);
        } else if (value instanceof BBoolean) {
            uploadOnStart = (BBoolean)value;
        }
        return uploadOnStart;
    }

    public BBoolean setAndGetWriteOnFacetChange() {
        BValue value = this.get(WRITE_ON_FACET_CHANGE);
        BBoolean writeOnFacetChange = BBoolean.TRUE;
        if (value == null) {
            this.add(WRITE_ON_FACET_CHANGE, (BValue)writeOnFacetChange, 4);
        } else if (value instanceof BBoolean) {
            writeOnFacetChange = (BBoolean)value;
        }
        return writeOnFacetChange;
    }

    public boolean setAndGetShouldSupportFaults() {
        BValue value = this.get(SHOULD_SUPPORT_FAULTS_MULTI_STATE);
        BBoolean toSupportFaults = BBoolean.TRUE;
        if (value == null) {
            this.add(SHOULD_SUPPORT_FAULTS_MULTI_STATE, (BValue)toSupportFaults, 4);
        } else if (value instanceof BBoolean) {
            toSupportFaults = (BBoolean)value;
        }
        return toSupportFaults.getBoolean();
    }

    public boolean setAndGetPrivateTransferResultBlockFlag() {
        BValue value = this.get(PRIVATE_TRANSFER_RESULT_BLOCK);
        BBoolean privateTransferResultBlockFlag = BBoolean.TRUE;
        if (value == null) {
            this.add(PRIVATE_TRANSFER_RESULT_BLOCK, (BValue)privateTransferResultBlockFlag, 4);
        } else if (value instanceof BBoolean) {
            privateTransferResultBlockFlag = (BBoolean)value;
        }
        return privateTransferResultBlockFlag.getBoolean();
    }

    BBacnetClientLayer client() {
        return ((BBacnetStack)this.getBacnetComm()).getClient();
    }

    BBacnetServerLayer server() {
        return ((BBacnetStack)this.getBacnetComm()).getServer();
    }

    BBacnetNetworkLayer network() {
        return ((BBacnetStack)this.getBacnetComm()).getNetwork();
    }

    final BBacnetPoll poll(int networkNumber) {
        BNetworkPort port = this.network().getPortByDNET(networkNumber);
        if (port == null) {
            port = this.network().getIpPort();
        }
        return port.getPollService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAddress(BBacnetAddress address) {
        if (address == null) {
            return;
        }
        if (address.equals(BBacnetAddress.DEFAULT)) {
            return;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            int networkNumber = address.getNetworkNumber();
            Map<BBacnetOctetString, BOrd> network = this.ordByAddress.get(networkNumber);
            if (network != null) {
                network.remove((Object)address.getMacAddress());
                if (network.isEmpty()) {
                    this.ordByAddress.remove(networkNumber);
                }
            }
        }
    }

    private synchronized void removeFromMaps(BOrd ord) {
        this.ordByObjectId.values().remove(ord);
        Iterator<Map.Entry<Integer, Map<BBacnetOctetString, BOrd>>> entries = this.ordByAddress.entrySet().iterator();
        while (entries.hasNext()) {
            Map<BBacnetOctetString, BOrd> network = entries.next().getValue();
            network.values().remove(ord);
            if (!network.isEmpty()) continue;
            entries.remove();
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("driver:DeviceManager");
        agents.toBottom("bacnetEDE:EdeBacnetDeviceManager");
        return agents;
    }

    private int hashtableSize(Hashtable<BBacnetObjectIdentifier, BOrd> t) {
        int vsize = 0;
        int ksize = 0;
        Enumeration<BOrd> ee = t.elements();
        while (ee.hasMoreElements()) {
            ++vsize;
            ee.nextElement();
        }
        Enumeration<BBacnetObjectIdentifier> ek = t.keys();
        while (ek.hasMoreElements()) {
            ++ksize;
            ek.nextElement();
        }
        if (ksize != vsize) {
            log.warning("HASHTABLE SIZE MISMATCH: ksize=" + ksize + "; vsize=" + vsize);
        }
        return vsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetNetwork", 2);
        out.prop((Object)"networkReady", this.networkReady);
        out.prop((Object)"bacnetService", (Object)bacnetService);
        out.prop((Object)"bacnet()", (Object)BBacnetNetwork.bacnet());
        if (this.isRunning()) {
            BComponent c = Sys.getService((Type)TYPE);
            out.prop((Object)"service", (Object)c);
        }
        out.prop((Object)"this", (Object)this);
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            out.trTitle((Object)("ordByObjectId reported size:" + this.ordByObjectId.size() + "; actual size:" + this.hashtableSize(this.ordByObjectId)), 2);
            Enumeration<BBacnetObjectIdentifier> e = this.ordByObjectId.keys();
            if (this.ordByObjectId.size() < 1000) {
                while (e.hasMoreElements()) {
                    BBacnetObjectIdentifier k = e.nextElement();
                    out.prop((Object)("  " + (Object)((Object)k)), (Object)this.ordByObjectId.get((Object)k));
                }
            }
            out.trTitle((Object)("ordByAddress network size:" + this.ordByAddress.size()), 2);
        }
        out.endProps();
    }

    public String toString(Context cx) {
        return super.toString(cx) + this.getHandleOrd();
    }

    static {
        UnitDatabase.getDefault();
    }
}

