/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.datatypes.BNcRecipientList;
import javax.baja.bacnet.config.BBacnetCreatableObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.NOTIFICATION_CLASS)", flags=8, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)")}, override=true), @NiagaraProperty(name="objectType", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetObjectType.NOTIFICATION_CLASS, BEnumRange.make(BBacnetObjectType.TYPE))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)")}, override=true), @NiagaraProperty(name="notificationClass", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS, ASN_UNSIGNED)")}), @NiagaraProperty(name="priority", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetUnsigned.TYPE, 3)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.PRIORITY, ASN_BACNET_ARRAY)")}), @NiagaraProperty(name="ackRequired", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetEventTransitionBits\"))", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.ACK_REQUIRED, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP)")}), @NiagaraProperty(name="recipientList", type="BBacnetListOf", defaultValue="new BNcRecipientList(BBacnetDestination.TYPE)", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.RECIPIENT_LIST, ASN_BACNET_LIST)")})})
@NiagaraActions(value={@NiagaraAction(name="addDestination", parameterType="BBacnetDestination", defaultValue="new BBacnetDestination()"), @NiagaraAction(name="removeDestination", parameterType="BBacnetDestination", defaultValue="new BBacnetDestination()"), @NiagaraAction(name="removeRecipient", parameterType="BBacnetRecipient", defaultValue="new BBacnetRecipient()")})
public class BBacnetNotificationClass
extends BBacnetCreatableObject {
    @Generated
    public static final Property objectId = BBacnetNotificationClass.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(15), (BFacets)BBacnetNotificationClass.makeFacets(75, 12));
    @Generated
    public static final Property objectType = BBacnetNotificationClass.newProperty((int)1, (BValue)BDynamicEnum.make((int)15, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetNotificationClass.makeFacets(79, 9));
    @Generated
    public static final Property notificationClass = BBacnetNotificationClass.newProperty((int)1, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BBacnetNotificationClass.makeFacets(17, 2));
    @Generated
    public static final Property priority = BBacnetNotificationClass.newProperty((int)1, (BValue)new BBacnetArray(BBacnetUnsigned.TYPE, 3), (BFacets)BBacnetNotificationClass.makeFacets(86, -2));
    @Generated
    public static final Property ackRequired = BBacnetNotificationClass.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")), (BFacets)BBacnetNotificationClass.makeFacets(1, 8, BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP));
    @Generated
    public static final Property recipientList = BBacnetNotificationClass.newProperty((int)0, (BValue)new BNcRecipientList(BBacnetDestination.TYPE), (BFacets)BBacnetNotificationClass.makeFacets(102, -3));
    @Generated
    public static final Action addDestination = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetDestination(), null);
    @Generated
    public static final Action removeDestination = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetDestination(), null);
    @Generated
    public static final Action removeRecipient = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetRecipient(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNotificationClass.class);

    @Generated
    public BBacnetUnsigned getNotificationClass() {
        return (BBacnetUnsigned)this.get(notificationClass);
    }

    @Generated
    public void setNotificationClass(BBacnetUnsigned v) {
        this.set(notificationClass, (BValue)v, null);
    }

    @Generated
    public BBacnetArray getPriority() {
        return (BBacnetArray)this.get(priority);
    }

    @Generated
    public void setPriority(BBacnetArray v) {
        this.set(priority, (BValue)v, null);
    }

    @Generated
    public BBacnetBitString getAckRequired() {
        return (BBacnetBitString)this.get(ackRequired);
    }

    @Generated
    public void setAckRequired(BBacnetBitString v) {
        this.set(ackRequired, (BValue)v, null);
    }

    @Generated
    public BBacnetListOf getRecipientList() {
        return (BBacnetListOf)this.get(recipientList);
    }

    @Generated
    public void setRecipientList(BBacnetListOf v) {
        this.set(recipientList, (BValue)v, null);
    }

    @Generated
    public void addDestination(BBacnetDestination parameter) {
        this.invoke(addDestination, (BValue)parameter, null);
    }

    @Generated
    public void removeDestination(BBacnetDestination parameter) {
        this.invoke(removeDestination, (BValue)parameter, null);
    }

    @Generated
    public void removeRecipient(BBacnetRecipient parameter) {
        this.invoke(removeRecipient, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doAddDestination(BBacnetDestination dest) {
        this.getRecipientList().addListElement((BValue)dest, null);
    }

    public void doRemoveDestination(BBacnetDestination dest) {
        this.getRecipientList().removeListElement((BValue)dest, null);
    }

    public void doRemoveRecipient(BBacnetRecipient recip) {
        this.network().postAsync(new NCRemoveRecipientRequest(recip));
        this.upload(new BUploadParameters());
    }

    @Override
    protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues) {
        this.addPriority(priority, listOfInitialValues);
        this.addAckRequired(ackRequired, listOfInitialValues);
        this.addRecipientist(recipientList, listOfInitialValues);
    }

    class NCRemoveRecipientRequest
    implements Runnable {
        public BBacnetRecipient recip;

        NCRemoveRecipientRequest(BBacnetRecipient recip) {
            this.recip = recip;
        }

        @Override
        public void run() {
            SlotCursor sc = BBacnetNotificationClass.this.getRecipientList().getProperties();
            while (sc.next(BBacnetDestination.class)) {
                BBacnetDestination d = (BBacnetDestination)sc.get();
                if (!d.getRecipient().equivalent(this.recip)) continue;
                BBacnetNotificationClass.this.getRecipientList().removeListElement((BValue)d, null);
            }
        }
    }
}

