/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.GregorianCalendar;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateRange;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="choice", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0,2)")}), @NiagaraProperty(name="date", type="BBacnetDate", defaultValue="BBacnetDate.DEFAULT"), @NiagaraProperty(name="dateRange", type="BBacnetDateRange", defaultValue="new BBacnetDateRange()"), @NiagaraProperty(name="weekNDay", type="BBacnetOctetString", defaultValue="BBacnetOctetString.BACNET_WEEK_N_DAY", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"bacnet:BacnetWeekNDayFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"bacnet:BacnetWeekNDayEditor\"")})})
public final class BBacnetCalendarEntry
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetCalendarEntry.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)2));
    @Generated
    public static final Property date = BBacnetCalendarEntry.newProperty((int)0, (BValue)BBacnetDate.DEFAULT, null);
    @Generated
    public static final Property dateRange = BBacnetCalendarEntry.newProperty((int)0, (BValue)new BBacnetDateRange(), null);
    @Generated
    public static final Property weekNDay = BBacnetCalendarEntry.newProperty((int)0, (BValue)BBacnetOctetString.BACNET_WEEK_N_DAY, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"bacnet:BacnetWeekNDayFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"bacnet:BacnetWeekNDayEditor")));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCalendarEntry.class);
    public static final int DATE_TAG = 0;
    public static final int DATE_RANGE_TAG = 1;
    public static final int WEEK_N_DAY_TAG = 2;
    private static GregorianCalendar GREG = new GregorianCalendar();
    private static final Logger logger = Logger.getLogger("bacnet.debug");
    private static int MAX_ITERATIONS = 366;
    public static final int MAX_ENCODED_SIZE = 12;

    @Generated
    public int getChoice() {
        return this.getInt(choice);
    }

    @Generated
    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    @Generated
    public BBacnetDate getDate() {
        return (BBacnetDate)this.get(date);
    }

    @Generated
    public void setDate(BBacnetDate v) {
        this.set(date, (BValue)v, null);
    }

    @Generated
    public BBacnetDateRange getDateRange() {
        return (BBacnetDateRange)this.get(dateRange);
    }

    @Generated
    public void setDateRange(BBacnetDateRange v) {
        this.set(dateRange, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getWeekNDay() {
        return (BBacnetOctetString)this.get(weekNDay);
    }

    @Generated
    public void setWeekNDay(BBacnetOctetString v) {
        this.set(weekNDay, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetCalendarEntry() {
    }

    public BBacnetCalendarEntry(BBacnetDate date) {
        this.setChoice(0);
        this.setDate(date);
    }

    public BBacnetCalendarEntry(BBacnetDateRange dateRange) {
        this.setChoice(1);
        this.setDateRange(dateRange);
    }

    public BBacnetCalendarEntry(BBacnetOctetString weekNDay) {
        this.setChoice(2);
        this.setWeekNDay(weekNDay);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append("BBacnetCalendarEntry:").append(this.getChoice()).append(" ");
        switch (this.getChoice()) {
            case 0: {
                sb.append(this.getDate().toString((Context)cx));
                break;
            }
            case 1: {
                sb.append(this.getDateRange().toString((Context)cx));
                break;
            }
            case 2: {
                cx = cx != null ? new BasicContext(cx, BFacets.make((String)"bacOctetStr", (BIDataValue)BString.make((String)"weekNDay"))) : BFacets.make((String)"bacOctetStr", (BIDataValue)BString.make((String)"weekNDay"));
                sb.append(this.getWeekNDay().toString((Context)cx));
            }
        }
        return sb.toString();
    }

    public BValue getCalendarEntry() {
        switch (this.getChoice()) {
            case 0: {
                return this.getDate();
            }
            case 1: {
                return this.getDateRange();
            }
            case 2: {
                return this.getWeekNDay();
            }
        }
        throw new IllegalStateException();
    }

    public void setCalendarEntry(BValue e) {
        this.setCalendarEntry(e, null);
    }

    public void setCalendarEntry(BValue e, Context cx) {
        Type t = e.getType();
        if (t == BBacnetDate.TYPE) {
            this.setInt(choice, 0, cx);
            this.set(date, e, cx);
        } else if (t == BBacnetDateRange.TYPE) {
            this.setInt(choice, 1, cx);
            this.set(dateRange, e.newCopy(), cx);
        } else if (t == BBacnetOctetString.TYPE) {
            this.setInt(choice, 2, cx);
            this.set(weekNDay, e, cx);
        }
    }

    public boolean isActive(BAbsTime at) {
        BBacnetDate d = BBacnetDate.make(at);
        switch (this.getChoice()) {
            case 0: {
                return this.getDate().dateEquals((Object)d);
            }
            case 1: {
                return this.getDateRange().getStartDate().isNotAfter((Object)d) && this.getDateRange().getEndDate().isNotBefore((Object)d);
            }
            case 2: {
                int month = at.getMonth().getOrdinal() + 1;
                int dayOfMonth = at.getDay();
                int dayOfWeek = at.getWeekday().getOrdinal();
                if (dayOfWeek == 0) {
                    dayOfWeek = 7;
                }
                byte[] weekNDay = this.getWeekNDay().getBytes();
                boolean result = true;
                if (weekNDay.length < 3) {
                    throw new IllegalStateException();
                }
                if (weekNDay[0] != -1 && weekNDay[0] != month) {
                    result = false;
                }
                if (weekNDay[1] != -1) {
                    switch (weekNDay[1]) {
                        case 1: {
                            return dayOfMonth >= 1 && dayOfMonth <= 7;
                        }
                        case 2: {
                            return dayOfMonth >= 8 && dayOfMonth <= 14;
                        }
                        case 3: {
                            return dayOfMonth >= 15 && dayOfMonth <= 21;
                        }
                        case 4: {
                            return dayOfMonth >= 22 && dayOfMonth <= 28;
                        }
                        case 5: {
                            return dayOfMonth >= 29 && dayOfMonth <= 31;
                        }
                        case 6: {
                            int maxDOM = GREG.getActualMaximum(5);
                            return dayOfMonth > maxDOM - 7 && dayOfMonth <= maxDOM;
                        }
                    }
                    logger.severe("Incorrect weekOfMonth configuration for BBacnetWeekNDay in BBacnetCalendarEntry!");
                    throw new IllegalStateException();
                }
                if (weekNDay[2] != -1 && weekNDay[2] != dayOfWeek) {
                    result = false;
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Invalid calendar entry type:" + this.getChoice());
    }

    public BAbsTime nextDate(BAbsTime time) {
        BBacnetDate d = BBacnetDate.make(time);
        switch (this.getChoice()) {
            case 0: {
                if (!d.isNotAfter((Object)this.getDate())) break;
                return this.getDate().makeBAbsTime(time);
            }
            case 1: {
                if (!d.isNotAfter((Object)this.getDateRange().getEndDate())) break;
                if (d.isNotBefore((Object)this.getDateRange().getStartDate())) {
                    return time;
                }
                return this.getDateRange().getStartDate().makeBAbsTime(time);
            }
            case 2: {
                for (int i = 0; i < MAX_ITERATIONS; ++i) {
                    if (this.isActive(time)) {
                        return time;
                    }
                    time = time.nextDay();
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        switch (this.getChoice()) {
            case 0: {
                out.writeDate(0, this.getDate());
                break;
            }
            case 1: {
                out.writeOpeningTag(1);
                this.getDateRange().writeAsn(out);
                out.writeClosingTag(1);
                break;
            }
            case 2: {
                out.writeOctetString(2, this.getWeekNDay());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid calendar entry type:" + this.getChoice());
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int choice = in.peekTag();
        switch (choice) {
            case 0: {
                this.set(date, (BValue)in.readDate(0), noWrite);
                break;
            }
            case 1: {
                in.skipOpeningTag(1);
                BBacnetDateRange dateRange = new BBacnetDateRange();
                dateRange.readAsn(in);
                in.skipClosingTag(1);
                this.set(BBacnetCalendarEntry.dateRange, (BValue)dateRange, noWrite);
                break;
            }
            case 2: {
                this.set(weekNDay, (BValue)in.readBacnetOctetString(2), noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + choice);
            }
        }
        this.setInt(BBacnetCalendarEntry.choice, choice, noWrite);
    }
}

