/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="recipient", type="BBacnetRecipientProcess", defaultValue="new BBacnetRecipientProcess()"), @NiagaraProperty(name="monitoredPropertyReference", type="BBacnetObjectPropertyReference", defaultValue="new BBacnetObjectPropertyReference()"), @NiagaraProperty(name="issueConfirmedNotifications", type="boolean", defaultValue="false"), @NiagaraProperty(name="subscriptionEndTime", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="covIncrement", type="float", defaultValue="BFloat.NaN")})
public final class BBacnetCovSubscription
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property recipient = BBacnetCovSubscription.newProperty((int)0, (BValue)new BBacnetRecipientProcess(), null);
    @Generated
    public static final Property monitoredPropertyReference = BBacnetCovSubscription.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), null);
    @Generated
    public static final Property issueConfirmedNotifications = BBacnetCovSubscription.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property subscriptionEndTime = BBacnetCovSubscription.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    @Generated
    public static final Property covIncrement = BBacnetCovSubscription.newProperty((int)0, (BValue)BFloat.NaN, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCovSubscription.class);
    public static final int RECIPIENT_TAG = 0;
    public static final int MONITORED_PROPERTY_REFERENCE_TAG = 1;
    public static final int ISSUE_CONFIRMED_NOTIFICATIONS_TAG = 2;
    public static final int TIME_REMAINING_TAG = 3;
    public static final int COV_INCREMENT_TAG = 4;
    public static final int MAX_ENCODED_SIZE = 44;
    private Clock.Ticket ticket;
    private boolean covProperty = false;
    private BValue lastPropValue = null;
    private PropertyValue lastPropertyValue = null;
    private BStatus lastStatusFlags = null;

    @Generated
    public BBacnetRecipientProcess getRecipient() {
        return (BBacnetRecipientProcess)this.get(recipient);
    }

    @Generated
    public void setRecipient(BBacnetRecipientProcess v) {
        this.set(recipient, (BValue)v, null);
    }

    @Generated
    public BBacnetObjectPropertyReference getMonitoredPropertyReference() {
        return (BBacnetObjectPropertyReference)this.get(monitoredPropertyReference);
    }

    @Generated
    public void setMonitoredPropertyReference(BBacnetObjectPropertyReference v) {
        this.set(monitoredPropertyReference, (BValue)v, null);
    }

    @Generated
    public boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    @Generated
    public void setIssueConfirmedNotifications(boolean v) {
        this.setBoolean(issueConfirmedNotifications, v, null);
    }

    @Generated
    public BAbsTime getSubscriptionEndTime() {
        return (BAbsTime)this.get(subscriptionEndTime);
    }

    @Generated
    public void setSubscriptionEndTime(BAbsTime v) {
        this.set(subscriptionEndTime, (BValue)v, null);
    }

    @Generated
    public float getCovIncrement() {
        return this.getFloat(covIncrement);
    }

    @Generated
    public void setCovIncrement(float v) {
        this.setFloat(covIncrement, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetCovSubscription() {
    }

    public BBacnetCovSubscription(BBacnetAddress subscriberAddress, long subscriberProcessId, BBacnetObjectIdentifier monitoredObjectId, boolean issueConfirmedNotifications) {
        this.getRecipient().getRecipient().setRecipient((BValue)subscriberAddress);
        this.getRecipient().setProcessIdentifier(BBacnetUnsigned.make(subscriberProcessId));
        this.getMonitoredPropertyReference().setObjectId(monitoredObjectId);
        this.setIssueConfirmedNotifications(issueConfirmedNotifications);
    }

    public BBacnetCovSubscription(BBacnetAddress subscriberAddress, long subscriberProcessId, BBacnetObjectIdentifier monitoredObjectId, PropertyReference monitoredPropertyId, boolean issueConfirmedNotifications, BNumber covIncr) {
        this.getRecipient().getRecipient().setRecipient((BValue)subscriberAddress);
        this.getRecipient().setProcessIdentifier(BBacnetUnsigned.make(subscriberProcessId));
        this.getMonitoredPropertyReference().setObjectId(monitoredObjectId);
        this.getMonitoredPropertyReference().setPropertyId(monitoredPropertyId.getPropertyId());
        this.getMonitoredPropertyReference().setPropertyArrayIndex(monitoredPropertyId.getPropertyArrayIndex());
        this.setIssueConfirmedNotifications(issueConfirmedNotifications);
        this.setCovIncrement(covIncr != null ? covIncr.getFloat() : Float.NaN);
    }

    public BStatusValue getLastValue() {
        return this.covProperty ? null : (BStatusValue)this.lastPropValue;
    }

    public void setLastValue(BStatusValue newValue) {
        this.lastPropValue = newValue.newCopy();
    }

    public BValue getLastPropValue() {
        return this.lastPropValue;
    }

    public void setLastPropValue(BValue newValue) {
        this.lastPropValue = newValue.newCopy();
    }

    public PropertyValue getLastPropertyValue() {
        return this.lastPropertyValue;
    }

    public void setLastPropertyValue(PropertyValue lastPropertyValue) {
        this.lastPropertyValue = lastPropertyValue;
    }

    public Clock.Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Clock.Ticket ticket) {
        this.ticket = ticket;
    }

    public int getTimeRemaining() {
        if (this.getSubscriptionEndTime().equals((Object)BAbsTime.NULL)) {
            return 0;
        }
        long curTime = BAbsTime.make().getMillis();
        int timeRemaining = (int)((this.getSubscriptionEndTime().getMillis() - curTime) / 1000L);
        return timeRemaining > 0 ? timeRemaining : -1;
    }

    public String toString(Context cx) {
        if (cx != null && cx.equals(nameContext)) {
            return this.getNameString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.covProperty ? "CovPSub " : "CovSub ").append(this.getRecipient().toString(cx)).append('{').append(this.getMonitoredPropertyReference().toString(cx));
        if (this.covProperty) {
            sb.append(':').append(this.getCovIncrement());
        }
        sb.append(this.getIssueConfirmedNotifications() ? "} C until " : "} U until ").append(this.getSubscriptionEndTime());
        return sb.toString();
    }

    public boolean isCovIncrementUsed() {
        return !Float.isNaN(this.getCovIncrement());
    }

    public boolean isCovProperty() {
        return this.covProperty;
    }

    public void setCovProperty(boolean v) {
        this.covProperty = v;
    }

    public int getLastStatusBits() {
        BStatus status = this.getLastStatusFlags();
        if (status != null) {
            return status.getBits();
        }
        return 0;
    }

    public void setLastStatusBits(int lastStatusBits) {
        this.lastStatusFlags = BStatus.make((int)(lastStatusBits & 0x2B));
    }

    public void setLastStatusFlags(BStatus lastStatusFlags) {
        this.lastStatusFlags = BStatus.make((int)(lastStatusFlags.getBits() & 0x2B));
    }

    public BStatus getLastStatusFlags() {
        return this.lastStatusFlags;
    }

    private void setTimeRemaining(long timeRemaining) {
        this.set(subscriptionEndTime, (BValue)BAbsTime.make().add(BRelTime.make((long)(timeRemaining * 1000L))), noWrite);
    }

    private String getNameString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.covProperty ? "covP_" : "cov_").append(SlotPath.unescape((String)this.getRecipient().toString(nameContext))).append("_").append(this.getMonitoredPropertyReference().toString(nameContext));
        if (this.covProperty) {
            sb.append('_').append(this.getCovIncrement());
        }
        return SlotPath.escape((String)sb.toString());
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getRecipient().writeAsn(out);
        out.writeClosingTag(0);
        out.writeOpeningTag(1);
        this.getMonitoredPropertyReference().writeAsn(out);
        out.writeClosingTag(1);
        out.writeBoolean(2, this.getIssueConfirmedNotifications());
        out.writeUnsignedInteger(3, this.getTimeRemaining());
        if (this.isCovIncrementUsed()) {
            out.writeReal(4, this.getCovIncrement());
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetRecipientProcess recipient = new BBacnetRecipientProcess();
        recipient.readAsn(in);
        in.skipClosingTag(0);
        in.skipOpeningTag(1);
        BBacnetObjectPropertyReference monitoredPropertyReference = new BBacnetObjectPropertyReference();
        monitoredPropertyReference.readAsn(in);
        in.skipClosingTag(1);
        boolean issueConfirmedNotifications = in.readBoolean(2);
        long timeRemaining = in.readUnsignedInteger(3);
        in.peekTag();
        float covIncrement = in.isValueTag(4) ? in.readReal(4) : Float.NaN;
        this.set(BBacnetCovSubscription.recipient, (BValue)recipient, noWrite);
        this.set(BBacnetCovSubscription.monitoredPropertyReference, (BValue)monitoredPropertyReference, noWrite);
        this.setBoolean(BBacnetCovSubscription.issueConfirmedNotifications, issueConfirmedNotifications, noWrite);
        this.setTimeRemaining(timeRemaining);
        this.setFloat(BBacnetCovSubscription.covIncrement, covIncrement, noWrite);
    }
}

