/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="date", type="BBacnetDate", defaultValue="BBacnetDate.DEFAULT"), @NiagaraProperty(name="time", type="BBacnetTime", defaultValue="BBacnetTime.DEFAULT")})
public class BBacnetDateTime
extends BStruct
implements BIBacnetDataType,
Comparable<Object> {
    @Generated
    public static final Property date = BBacnetDateTime.newProperty((int)0, (BValue)BBacnetDate.DEFAULT, null);
    @Generated
    public static final Property time = BBacnetDateTime.newProperty((int)0, (BValue)BBacnetTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDateTime.class);

    @Generated
    public BBacnetDate getDate() {
        return (BBacnetDate)this.get(date);
    }

    @Generated
    public void setDate(BBacnetDate v) {
        this.set(date, (BValue)v, null);
    }

    @Generated
    public BBacnetTime getTime() {
        return (BBacnetTime)this.get(time);
    }

    @Generated
    public void setTime(BBacnetTime v) {
        this.set(time, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetDateTime() {
    }

    public BBacnetDateTime(BBacnetDate date, BBacnetTime time) {
        this.setDate(date);
        this.setTime(time);
    }

    public BBacnetDateTime(BAbsTime bt) {
        this.setDate(BBacnetDate.make(bt));
        this.setTime(BBacnetTime.make(bt));
    }

    @Override
    public final void writeAsn(AsnOutput out) {
        out.writeDate(this.getDate());
        out.writeTime(this.getTime());
    }

    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        BBacnetDate date = in.readDate();
        BBacnetTime time = in.readTime();
        this.set(BBacnetDateTime.date, (BValue)date, noWrite);
        this.set(BBacnetDateTime.time, (BValue)time, noWrite);
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getDate().toString(context, false) + ' ' + this.getTime().toString(context);
        }
        return this.getDate().toString(context) + '_' + this.getTime().toString(context);
    }

    public final boolean isAnyUnspecified() {
        return this.getDate().isAnyUnspecified() || this.getTime().isAnyUnspecified();
    }

    public final BAbsTime toBAbsTime() {
        return BBacnetDateTime.makeBAbsTime(this.getDate(), this.getTime());
    }

    public final void fromBAbsTime(BAbsTime t) {
        this.setDate(BBacnetDate.make(t));
        this.setTime(BBacnetTime.make(t));
    }

    public final boolean dateTimeEquals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    @Override
    public final int compareTo(Object obj) {
        if (obj == null) {
            throw new ClassCastException();
        }
        BBacnetDateTime other = (BBacnetDateTime)obj;
        int ret = this.getDate().compareTo((Object)other.getDate());
        if (ret != 0) {
            return ret;
        }
        return this.getTime().compareTo((Object)other.getTime());
    }

    public final boolean isBefore(Object x) {
        return this.compareTo(x) < 0;
    }

    public final boolean isAfter(Object x) {
        return this.compareTo(x) > 0;
    }

    public final boolean isNotBefore(Object x) {
        return this.compareTo(x) >= 0;
    }

    public final boolean isNotAfter(Object x) {
        return this.compareTo(x) <= 0;
    }

    public static final BBacnetDateTime fromString(String s) {
        BBacnetDate d = BBacnetDate.fromString(s.substring(0, 14));
        BBacnetTime t = BBacnetTime.fromString(s.substring(15, 26));
        return new BBacnetDateTime(d, t);
    }

    public static final BAbsTime makeBAbsTime(BBacnetDate d, BBacnetTime t) {
        int n;
        int y = d.isYearUnspecified() ? 1900 : d.getYear();
        BMonth m = d.isMonthUnspecified() ? BMonth.january : d.getBMonth();
        int a = d.isDayOfMonthUnspecified() ? 1 : d.getDayOfMonth();
        int h = t.isHourUnspecified() ? 0 : t.getHour();
        int n2 = n = t.isMinuteUnspecified() ? 0 : t.getMinute();
        if (t.isSecondUnspecified() || t.isHundredthUnspecified()) {
            return BAbsTime.make((int)y, (BMonth)m, (int)a, (int)h, (int)n);
        }
        return BAbsTime.make((int)y, (BMonth)m, (int)a, (int)h, (int)n, (int)t.getSecond(), (int)(t.getHundredth() * 10));
    }

    public static final BAbsTime makeBAbsTime(BAbsTime d, BBacnetTime t) {
        int n;
        int h = t.isHourUnspecified() ? 0 : t.getHour();
        int n2 = n = t.isMinuteUnspecified() ? 0 : t.getMinute();
        if (t.isSecondUnspecified() || t.isHundredthUnspecified()) {
            return BAbsTime.make((int)d.getYear(), (BMonth)d.getMonth(), (int)d.getDay(), (int)h, (int)n);
        }
        return BAbsTime.make((int)d.getYear(), (BMonth)d.getMonth(), (int)d.getDay(), (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond(), (int)(t.getHundredth() * 10));
    }
}

