/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteria;
import javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteriaChoice;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetExtendedParameter;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetPropertyStates;
import javax.baja.bacnet.datatypes.BBacnetSequenceOf;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperty(name="choice", type="int", defaultValue="BBacnetEventType.NONE", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"bacnet:BacnetEventTypeFE\"")})
public final class BBacnetEventParameter
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetEventParameter.newProperty((int)0, (int)20, (BFacets)BFacets.make((String)"fieldEditor", (String)"bacnet:BacnetEventTypeFE"));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEventParameter.class);
    private static final Logger logger = Logger.getLogger("bacnet.datatypes");
    private static final int MAX_TAG = 21;
    private static final BFacets SECONDS_FACETS = BFacets.makeInt((BUnit)BUnit.getUnit((String)"second"));
    public static final String TIME_DELAY_SLOT_NAME = "timeDelay";
    public static final String LIST_OF_VALUES_SLOT_NAME = "listOfValues";
    public static final String LIST_OF_BIT_STRING_VALUES_SLOT_NAME = "listOfBitstringValues";
    public static final String BITMASK_SLOT_NAME = "bitmask";
    public static final String REFERENCED_PROPERTY_INCREMENT_SLOT_NAME = "referencedPropertyIncrement";
    public static final String LIST_OF_ALARM_VALUES_SLOT_NAME = "listOfAlarmValues";
    public static final String FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME = "feedbackPropertyReference";
    public static final String SETPOINT_REFERENCE_SLOT_NAME = "setpointReference";
    public static final String LOW_DIFF_LIMIT_SLOT_NAME = "lowDiffLimit";
    public static final String HIGH_DIFF_LIMIT_SLOT_NAME = "highDiffLimit";
    public static final String LOW_LIMIT_SLOT_NAME = "lowLimit";
    public static final String HIGH_LIMIT_SLOT_NAME = "highLimit";
    public static final String DEADBAND_SLOT_NAME = "deadband";
    public static final String NOTIFICATION_THRESHOLD_SLOT_NAME = "notificationThreshold";
    public static final String PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME = "previousNotificationCount";
    public static final String STATUS_FLAGS_SLOT_NAME = "statusFlags";
    public static final String ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME = "accessEventTimeReference";
    public static final int CHANGE_OF_BITSTRING_TAG = 0;
    public static final int CHANGE_OF_BITSTRING_TIME_DELAY_TAG = 0;
    public static final int CHANGE_OF_BITSTRING_BITMASK_TAG = 1;
    public static final int CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG = 2;
    public static final int CHANGE_OF_STATE_TAG = 1;
    public static final int CHANGE_OF_STATE_TIME_DELAY_TAG = 0;
    public static final int CHANGE_OF_STATE_LIST_OF_VALUES_TAG = 1;
    public static final int CHANGE_OF_VALUE_TAG = 2;
    public static final int CHANGE_OF_VALUE_TIME_DELAY_TAG = 0;
    public static final int CHANGE_OF_VALUE_COV_CRITERIA_TAG = 1;
    public static final int CHANGE_OF_VALUE_BITMASK_TAG = 0;
    public static final int CHANGE_OF_VALUE_REFERENCED_PROPERTY_INCREMENT_TAG = 1;
    public static final int COMMAND_FAILURE_TAG = 3;
    public static final int COMMAND_FAILURE_TIME_DELAY_TAG = 0;
    public static final int COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG = 1;
    public static final int FLOATING_LIMIT_TAG = 4;
    public static final int FLOATING_LIMIT_TIME_DELAY_TAG = 0;
    public static final int FLOATING_LIMIT_SETPOINT_REFERENCE_TAG = 1;
    public static final int FLOATING_LIMIT_LOW_DIFF_LIMIT_TAG = 2;
    public static final int FLOATING_LIMIT_HIGH_DIFF_LIMIT_TAG = 3;
    public static final int FLOATING_LIMIT_DEADBAND_TAG = 4;
    public static final int OUT_OF_RANGE_TAG = 5;
    public static final int OUT_OF_RANGE_TIME_DELAY_TAG = 0;
    public static final int OUT_OF_RANGE_LOW_LIMIT_TAG = 1;
    public static final int OUT_OF_RANGE_HIGH_LIMIT_TAG = 2;
    public static final int OUT_OF_RANGE_DEADBAND_TAG = 3;
    public static final int COMPLEX_EVENT_TYPE_TAG = 6;
    public static final int BUFFER_READY_DEPRECATED_TAG = 7;
    public static final int BUFFER_READY_DEPRECATED_NOTIFICATION_THRESHOLD_TAG = 0;
    public static final int BUFFER_READY_DEPRECATED_PREVIOUS_NOTIFICATION_COUNT_TAG = 1;
    public static final int CHANGE_OF_LIFE_SAFETY_TAG = 8;
    public static final int CHANGE_OF_LIFE_SAFETY_TIME_DELAY_TAG = 0;
    public static final int CHANGE_OF_LIFE_SAFETY_LIST_OF_LIFE_SAFETY_ALARM_VALUES_TAG = 1;
    public static final int CHANGE_OF_LIFE_SAFETY_LIST_ALARM_VALUES_TAG = 2;
    public static final int CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG = 3;
    public static final int EXTENDED_TAG = 9;
    public static final int EXTENDED_VENDOR_ID_TAG = 0;
    public static final int EXTENDED_EXTENDED_EVENT_TYPE_TAG = 1;
    public static final int EXTENDED_PARAMETERS_TAG = 2;
    public static final int EXTENDED_REFERENCE_TAG = 0;
    public static final int BUFFER_READY_TAG = 10;
    public static final int BUFFER_READY_NOTIFICATION_THRESHOLD_TAG = 0;
    public static final int BUFFER_READY_PREVIOUS_NOTIFICATION_COUNT_TAG = 1;
    public static final int UNSIGNED_RANGE_TAG = 11;
    public static final int UNSIGNED_RANGE_TIME_DELAY_TAG = 0;
    public static final int UNSIGNED_RANGE_LOW_LIMIT_TAG = 1;
    public static final int UNSIGNED_RANGE_HIGH_LIMIT_TAG = 2;
    public static final String ACCESS_EVENT_PREFIX = "accessEvent";
    public static final int ACCESS_EVENT_TAG = 13;
    public static final int LIST_OF_ACCESS_EVENTS_TAG = 0;
    public static final int ACCESS_EVENT_TIME_REFERENCE_TAG = 1;
    public static final int DOUBLE_OOR_TAG = 14;
    public static final int SIGNED_OOR_TAG = 15;
    public static final int UNSIGNED_OOR_TAG = 16;
    public static final String CHANGE_OF_CHAR_STR_PREFIX = "chrstr";
    public static final int CHANGE_OF_CHAR_STR_TAG = 17;
    public static final int CHANGE_OF_CHAR_STR_TIME_DELAY_TAG = 0;
    public static final int CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG = 1;
    public static final int MAX_ALARM_VALUES = 50;
    public static final int CHANGE_OF_STATUS_FLAGS_TAG = 18;
    public static final int CHANGE_OF_RELIABILITY_FLAGS_TAG = 19;
    public static final int COSF_TIME_DELAY_TAG = 0;
    public static final int COSF_SELECTED_FLAGS_TAG = 1;
    public static final int EP_EVENT_TYPE_NONE = 20;
    public static final int CHANGE_OF_DISCRETE_VALUE_TAG = 21;
    public static final int CHANGE_OF_DISCRETE_VALUE_TIME_DELAY_TAG = 0;

    @Generated
    public int getChoice() {
        return this.getInt(choice);
    }

    @Generated
    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetEventParameter makeChangeOfState(BRelTime timeDelay, BBacnetListOf listOfValues) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(1);
        eventParams.addTimeDelay(timeDelay);
        BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetPropertyStates.TYPE);
        for (BBacnetPropertyStates value : (BBacnetPropertyStates[])listOfValues.getChildren(BBacnetPropertyStates.class)) {
            sequenceOf.add(value.newCopy());
        }
        eventParams.add(LIST_OF_VALUES_SLOT_NAME, (BValue)sequenceOf);
        return eventParams;
    }

    public static BBacnetEventParameter makeChangeOfState(BRelTime timeDelay, BBacnetSequenceOf listOfValues) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(1);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(LIST_OF_VALUES_SLOT_NAME, (BValue)listOfValues);
        return eventParams;
    }

    public static BBacnetEventParameter makeCommandFailure(BRelTime timeDelay, BBacnetDeviceObjectPropertyReference feedbackRef) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(3);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME, (BValue)feedbackRef);
        return eventParams;
    }

    public static BBacnetEventParameter makeFloatingLimit(BRelTime timeDelay, BBacnetDeviceObjectPropertyReference setpointRef, float lowDiffLimit, float highDiffLimit, float deadband) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(4);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(SETPOINT_REFERENCE_SLOT_NAME, (BValue)setpointRef);
        eventParams.add(LOW_DIFF_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)lowDiffLimit));
        eventParams.add(HIGH_DIFF_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)highDiffLimit));
        eventParams.add(DEADBAND_SLOT_NAME, (BValue)BFloat.make((float)deadband));
        return eventParams;
    }

    public static BBacnetEventParameter makeOutOfRange(BRelTime timeDelay, float lowLimit, float highLimit, float deadband) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(5);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(LOW_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)lowLimit));
        eventParams.add(HIGH_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)highLimit));
        eventParams.add(DEADBAND_SLOT_NAME, (BValue)BFloat.make((float)deadband));
        return eventParams;
    }

    public static BBacnetEventParameter makeOutOfRange(BBacnetEventType eventType, BRelTime timeDelay, double lowLimit, double highLimit, double deadband) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(eventType.getOrdinal());
        eventParams.addTimeDelay(timeDelay);
        if (eventType.equals(BBacnetEventType.outOfRange)) {
            eventParams.add(LOW_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)((float)lowLimit)));
            eventParams.add(HIGH_LIMIT_SLOT_NAME, (BValue)BFloat.make((float)((float)highLimit)));
            eventParams.add(DEADBAND_SLOT_NAME, (BValue)BFloat.make((float)((float)deadband)));
        } else {
            eventParams.add(LOW_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)lowLimit));
            eventParams.add(HIGH_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)highLimit));
            eventParams.add(DEADBAND_SLOT_NAME, (BValue)BDouble.make((double)deadband));
        }
        return eventParams;
    }

    public static BBacnetEventParameter makeBufferReady(long notificationThreshold, long previousNotificationCount) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(10);
        eventParams.add(NOTIFICATION_THRESHOLD_SLOT_NAME, (BValue)BBacnetUnsigned.make(notificationThreshold));
        eventParams.add(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, (BValue)BBacnetUnsigned.make(previousNotificationCount));
        return eventParams;
    }

    public static BBacnetEventParameter makeSignedOutOfRange(BRelTime timeDelay, double lowLimit, double highLimit, double deadband) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(15);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(LOW_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)lowLimit));
        eventParams.add(HIGH_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)highLimit));
        eventParams.add(DEADBAND_SLOT_NAME, (BValue)BDouble.make((double)deadband));
        return eventParams;
    }

    public static BBacnetEventParameter makeChangeOfCharacterString(BRelTime timeDelay, BBacnetListOf listOfValues) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(17);
        eventParams.addTimeDelay(timeDelay);
        BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BString.TYPE);
        for (BString value : (BString[])listOfValues.getChildren(BString.class)) {
            sequenceOf.add(value.newCopy());
        }
        eventParams.add(LIST_OF_ALARM_VALUES_SLOT_NAME, (BValue)sequenceOf);
        return eventParams;
    }

    public static BBacnetEventParameter makeChangeOfCharacterString(BRelTime timeDelay, BBacnetSequenceOf listOfValues) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(17);
        eventParams.addTimeDelay(timeDelay);
        eventParams.add(LIST_OF_ALARM_VALUES_SLOT_NAME, (BValue)listOfValues);
        return eventParams;
    }

    public static BBacnetEventParameter makeChangeOfDiscreteValue(BRelTime timeDelay) {
        BBacnetEventParameter eventParams = new BBacnetEventParameter();
        eventParams.setChoice(21);
        eventParams.addTimeDelay(timeDelay);
        return eventParams;
    }

    private void addTimeDelay(BRelTime timeDelay) {
        this.add(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelay.getSeconds()), 0, BFacets.makeInt((BUnit)BUnit.getUnit((String)"second")), null);
    }

    public void started() throws Exception {
        BValue listOfValues;
        super.started();
        int choice = this.getChoice();
        if (choice == 0) {
            BValue listOfValues2 = this.get(LIST_OF_BIT_STRING_VALUES_SLOT_NAME);
            if (listOfValues2 instanceof BBacnetListOf) {
                BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetBitString.TYPE);
                for (BBacnetBitString element : (BBacnetBitString[])((BBacnetListOf)listOfValues2).getChildren(BBacnetBitString.class)) {
                    sequenceOf.add("element?", (BValue)element, noWrite);
                }
                this.remove(LIST_OF_BIT_STRING_VALUES_SLOT_NAME);
                this.add(LIST_OF_BIT_STRING_VALUES_SLOT_NAME, (BValue)sequenceOf);
            }
        } else if (choice == 1) {
            BValue listOfValues3 = this.get(LIST_OF_VALUES_SLOT_NAME);
            if (listOfValues3 instanceof BBacnetListOf) {
                BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetPropertyStates.TYPE);
                for (BBacnetPropertyStates element : (BBacnetPropertyStates[])((BBacnetListOf)listOfValues3).getChildren(BBacnetPropertyStates.class)) {
                    sequenceOf.add("element?", element.newCopy(), noWrite);
                }
                this.remove(LIST_OF_VALUES_SLOT_NAME);
                this.add(LIST_OF_VALUES_SLOT_NAME, (BValue)sequenceOf);
            }
        } else if (choice == 9) {
            BValue parameters = this.get("parameters");
            if (parameters instanceof BBlob) {
                BBacnetSequenceOf newParameters = new BBacnetSequenceOf(BBacnetExtendedParameter.TYPE);
                AsnUtil.fromAsn(-4, ((BBlob)parameters).copyBytes(), (BValue)newParameters);
                this.remove("parameters");
                this.add("parameters", (BValue)newParameters);
            }
        } else if (choice == 2) {
            BValue oldCovCriteria = this.get("covCriteria");
            if (oldCovCriteria instanceof BInteger) {
                BBacnetChangeOfValueCriteria newCovCriteria = new BBacnetChangeOfValueCriteria();
                int oldChoice = ((BInteger)oldCovCriteria).getInt();
                if (oldChoice == 0) {
                    newCovCriteria.setChoice(BBacnetChangeOfValueCriteriaChoice.bitmask);
                    BValue bitmask = this.get(BITMASK_SLOT_NAME);
                    newCovCriteria.setValue(bitmask instanceof BBacnetBitString ? (BBacnetBitString)bitmask : BBacnetBitString.DEFAULT);
                } else if (oldChoice == 1) {
                    newCovCriteria.setChoice(BBacnetChangeOfValueCriteriaChoice.referencedPropertyIncrement);
                    BValue increment = this.get(REFERENCED_PROPERTY_INCREMENT_SLOT_NAME);
                    newCovCriteria.setValue((BSimple)(increment instanceof BFloat ? (BFloat)increment : BFloat.DEFAULT));
                }
                CompUtil.removeIfPresent((BComponent)this, (String)BITMASK_SLOT_NAME);
                CompUtil.removeIfPresent((BComponent)this, (String)REFERENCED_PROPERTY_INCREMENT_SLOT_NAME);
                this.set("covCriteria", (BValue)newCovCriteria);
            }
        } else if (choice == 17 && (listOfValues = this.get(LIST_OF_ALARM_VALUES_SLOT_NAME)) instanceof BBacnetListOf) {
            BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BString.TYPE);
            for (BString element : (BString[])((BBacnetListOf)listOfValues).getChildren(BString.class)) {
                sequenceOf.add("element?", element.newCopy(), noWrite);
            }
            this.remove(LIST_OF_ALARM_VALUES_SLOT_NAME);
            this.add(LIST_OF_ALARM_VALUES_SLOT_NAME, (BValue)sequenceOf);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent != null) {
            parent.asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childSubscribed(this);
        }
    }

    public void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(this.getChoice());
        try {
            switch (this.getChoice()) {
                case 0: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeBitString(1, (BBacnetBitString)this.get(BITMASK_SLOT_NAME));
                    out.writeOpeningTag(2);
                    ((BBacnetSequenceOf)this.get(LIST_OF_BIT_STRING_VALUES_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(2);
                    break;
                }
                case 1: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetSequenceOf)this.get(LIST_OF_VALUES_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 2: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetChangeOfValueCriteria)this.get("covCriteria")).writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 3: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetDeviceObjectPropertyReference)this.get(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 4: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetDeviceObjectPropertyReference)this.get(SETPOINT_REFERENCE_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(1);
                    out.writeReal(2, (BNumber)((BFloat)this.get(LOW_DIFF_LIMIT_SLOT_NAME)));
                    out.writeReal(3, (BNumber)((BFloat)this.get(HIGH_DIFF_LIMIT_SLOT_NAME)));
                    out.writeReal(4, (BNumber)((BFloat)this.get(DEADBAND_SLOT_NAME)));
                    break;
                }
                case 5: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeReal(1, (BNumber)((BFloat)this.get(LOW_LIMIT_SLOT_NAME)));
                    out.writeReal(2, (BNumber)((BFloat)this.get(HIGH_LIMIT_SLOT_NAME)));
                    out.writeReal(3, (BNumber)((BFloat)this.get(DEADBAND_SLOT_NAME)));
                    break;
                }
                case 6: {
                    throw new IllegalStateException("Complex Event Type not supported!");
                }
                case 7: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(NOTIFICATION_THRESHOLD_SLOT_NAME));
                    out.writeUnsigned(1, (BBacnetUnsigned)this.get(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME));
                    break;
                }
                case 8: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetListOf)this.get("listOfLifeSafetyAlarmValues")).writeAsn(out);
                    out.writeClosingTag(1);
                    out.writeOpeningTag(2);
                    ((BBacnetListOf)this.get(LIST_OF_ALARM_VALUES_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(2);
                    out.writeOpeningTag(3);
                    ((BBacnetDeviceObjectPropertyReference)this.get("modePropertyReference")).writeAsn(out);
                    out.writeClosingTag(3);
                    break;
                }
                case 9: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get("vendorId"));
                    out.writeUnsigned(1, (BBacnetUnsigned)this.get("extendedEventType"));
                    out.writeOpeningTag(2);
                    ((BBacnetSequenceOf)this.get("parameters")).writeAsn(out);
                    out.writeClosingTag(2);
                    break;
                }
                case 10: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(NOTIFICATION_THRESHOLD_SLOT_NAME));
                    out.writeUnsigned(1, (BBacnetUnsigned)this.get(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME));
                    break;
                }
                case 11: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeUnsigned(1, (BBacnetUnsigned)this.get(LOW_LIMIT_SLOT_NAME));
                    out.writeUnsigned(2, (BBacnetUnsigned)this.get(HIGH_LIMIT_SLOT_NAME));
                    break;
                }
                case 13: {
                    out.writeOpeningTag(0);
                    for (BBacnetAccessEvent accessEvent : (BBacnetAccessEvent[])this.getChildren(BBacnetAccessEvent.class)) {
                        out.writeEnumerated((BEnum)accessEvent);
                    }
                    out.writeClosingTag(0);
                    BBacnetDeviceObjectPropertyReference accessEventTimeReference = (BBacnetDeviceObjectPropertyReference)this.get(ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME);
                    out.writeOpeningTag(1);
                    accessEventTimeReference.writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 14: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeDouble(1, (BNumber)((BDouble)this.get(LOW_LIMIT_SLOT_NAME)));
                    out.writeDouble(2, (BNumber)((BDouble)this.get(HIGH_LIMIT_SLOT_NAME)));
                    out.writeDouble(3, (BNumber)((BDouble)this.get(DEADBAND_SLOT_NAME)));
                    break;
                }
                case 15: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeSignedInteger(1, ((BDouble)this.get(LOW_LIMIT_SLOT_NAME)).getInt());
                    out.writeSignedInteger(2, ((BDouble)this.get(HIGH_LIMIT_SLOT_NAME)).getInt());
                    out.writeUnsignedInteger(3, ((BDouble)this.get(DEADBAND_SLOT_NAME)).getInt());
                    break;
                }
                case 16: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeUnsignedInteger(1, ((BDouble)this.get(LOW_LIMIT_SLOT_NAME)).getLong());
                    out.writeUnsignedInteger(2, ((BDouble)this.get(HIGH_LIMIT_SLOT_NAME)).getLong());
                    out.writeUnsignedInteger(3, ((BDouble)this.get(DEADBAND_SLOT_NAME)).getLong());
                    break;
                }
                case 17: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    out.writeOpeningTag(1);
                    ((BBacnetSequenceOf)this.get(LIST_OF_ALARM_VALUES_SLOT_NAME)).writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 18: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                    BBacnetBitString statusFlags = (BBacnetBitString)this.get(STATUS_FLAGS_SLOT_NAME);
                    if (statusFlags != null) {
                        out.writeBitString(1, statusFlags);
                        break;
                    }
                    out.writeBitString(1, BacnetBitStringUtil.DEFAULT_STATUS);
                    break;
                }
                case 19: {
                    throw new IllegalStateException("Change Of Reliability not supported!");
                }
                case 20: {
                    out.writeNull();
                    break;
                }
                case 21: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get(TIME_DELAY_SLOT_NAME));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in writeAsn", e);
        }
        out.writeClosingTag(this.getChoice());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (tag < 0 || tag > 21) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipOpeningTag(tag);
        switch (tag) {
            case 0: {
                long timeDelayValue = in.readUnsignedInteger(0);
                BBacnetBitString bitmask = in.readBitString(1);
                in.skipOpeningTag(2);
                List<BValue> listOfBitStringValues = BBacnetSequenceOf.readAsn(in, 2, BBacnetBitString.TYPE);
                in.skipClosingTag(2);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(BITMASK_SLOT_NAME, (BValue)bitmask);
                this.updateOrAddSequenceOf(LIST_OF_BIT_STRING_VALUES_SLOT_NAME, BBacnetBitString.TYPE, listOfBitStringValues);
                break;
            }
            case 1: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipOpeningTag(1);
                List<BValue> listOfValues = BBacnetSequenceOf.readAsn(in, 1, BBacnetPropertyStates.TYPE);
                in.skipClosingTag(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.updateOrAddSequenceOf(LIST_OF_VALUES_SLOT_NAME, BBacnetPropertyStates.TYPE, listOfValues);
                break;
            }
            case 2: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipOpeningTag(1);
                BBacnetChangeOfValueCriteria covCriteria = new BBacnetChangeOfValueCriteria();
                covCriteria.readAsn(in);
                in.skipClosingTag(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd("covCriteria", (BValue)covCriteria);
                break;
            }
            case 3: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipOpeningTag(1);
                BBacnetDeviceObjectPropertyReference feedbackPropRef = new BBacnetDeviceObjectPropertyReference();
                feedbackPropRef.readAsn(in);
                in.skipClosingTag(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME, (BValue)feedbackPropRef);
                break;
            }
            case 4: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipOpeningTag(1);
                BBacnetDeviceObjectPropertyReference setpointRef = new BBacnetDeviceObjectPropertyReference();
                setpointRef.readAsn(in);
                in.skipClosingTag(1);
                BFloat lowDiffLimit = in.readFloat(2);
                BFloat highDiffLimit = in.readFloat(3);
                BFloat deadband = in.readFloat(4);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(SETPOINT_REFERENCE_SLOT_NAME, (BValue)setpointRef);
                this.setOrAdd(LOW_DIFF_LIMIT_SLOT_NAME, (BValue)lowDiffLimit);
                this.setOrAdd(HIGH_DIFF_LIMIT_SLOT_NAME, (BValue)highDiffLimit);
                this.setOrAdd(DEADBAND_SLOT_NAME, (BValue)deadband);
                break;
            }
            case 5: {
                long timeDelayValue = in.readUnsignedInteger(0);
                BFloat lowLimit = in.readFloat(1);
                BFloat highLimit = in.readFloat(2);
                BFloat deadband = in.readFloat(3);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(LOW_LIMIT_SLOT_NAME, (BValue)lowLimit);
                this.setOrAdd(HIGH_LIMIT_SLOT_NAME, (BValue)highLimit);
                this.setOrAdd(DEADBAND_SLOT_NAME, (BValue)deadband);
                break;
            }
            case 6: {
                BValue[] alarmParameters = AsnUtil.fromAsn(in, 6);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                for (BValue alarmParameter : alarmParameters) {
                    this.setOrAdd(null, alarmParameter);
                }
                break;
            }
            case 7: {
                long notificationThreshold = in.readUnsignedInteger(0);
                long previousNotificationCount = in.readUnsignedInteger(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(NOTIFICATION_THRESHOLD_SLOT_NAME, (BValue)BBacnetUnsigned.make(notificationThreshold));
                this.setOrAdd(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, (BValue)BBacnetUnsigned.make(previousNotificationCount));
                break;
            }
            case 8: {
                long timeDelayValue = in.readUnsignedInteger(0);
                BBacnetListOf lifeSafetyAlarmValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
                lifeSafetyAlarmValues.readAsn(AsnInputStream.make(in.readEncodedValue(1)));
                BBacnetListOf alarmValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
                alarmValues.readAsn(AsnInputStream.make(in.readEncodedValue(2)));
                in.skipOpeningTag(3);
                BBacnetDeviceObjectPropertyReference modePropRef = new BBacnetDeviceObjectPropertyReference();
                modePropRef.readAsn(in);
                in.skipClosingTag(3);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd("listOfLifeSafetyAlarmValues", (BValue)lifeSafetyAlarmValues);
                this.setOrAdd(LIST_OF_ALARM_VALUES_SLOT_NAME, (BValue)alarmValues);
                this.setOrAdd("modePropertyReference", (BValue)modePropRef);
                break;
            }
            case 9: {
                long vendorId = in.readUnsignedInteger(0);
                long eventType = in.readUnsignedInteger(1);
                in.skipOpeningTag(2);
                List<BValue> parameters = BBacnetSequenceOf.readAsn(in, 2, BBacnetExtendedParameter.TYPE);
                in.skipClosingTag(2);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd("vendorId", (BValue)BBacnetUnsigned.make(vendorId));
                this.setOrAdd("extendedEventType", (BValue)BBacnetUnsigned.make(eventType));
                this.updateOrAddSequenceOf("parameters", BBacnetExtendedParameter.TYPE, parameters);
                break;
            }
            case 10: {
                long notificationThreshold = in.readUnsignedInteger(0);
                long previousNotificationCount = in.readUnsignedInteger(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(NOTIFICATION_THRESHOLD_SLOT_NAME, (BValue)BBacnetUnsigned.make(notificationThreshold));
                this.setOrAdd(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, (BValue)BBacnetUnsigned.make(previousNotificationCount));
                break;
            }
            case 11: {
                long timeDelayValue = in.readUnsignedInteger(0);
                long lowLimit = in.readUnsignedInteger(1);
                long highLimit = in.readUnsignedInteger(2);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(LOW_LIMIT_SLOT_NAME, (BValue)BBacnetUnsigned.make(lowLimit));
                this.setOrAdd(HIGH_LIMIT_SLOT_NAME, (BValue)BBacnetUnsigned.make(highLimit));
                break;
            }
            case 13: {
                ArrayList<BBacnetAccessEvent> accessEvents = new ArrayList<BBacnetAccessEvent>();
                in.skipOpeningTag(0);
                in.peekTag();
                while (!in.isClosingTag(0)) {
                    accessEvents.add(BBacnetAccessEvent.make(in.readEnumerated()));
                    in.peekTag();
                }
                in.skipClosingTag(0);
                in.skipOpeningTag(1);
                BBacnetDeviceObjectPropertyReference accessEventTimeReference = new BBacnetDeviceObjectPropertyReference();
                accessEventTimeReference.readAsn(in);
                in.skipClosingTag(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                for (int i = 0; i < accessEvents.size(); ++i) {
                    this.setOrAdd(ACCESS_EVENT_PREFIX + i, (BValue)accessEvents.get(i));
                }
                this.setOrAdd(ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME, (BValue)accessEventTimeReference);
                break;
            }
            case 14: {
                long timeDelayValue = in.readUnsignedInteger(0);
                double lowLimit = in.readDouble(1);
                double highLimit = in.readDouble(2);
                double deadband = in.readDouble(3);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(LOW_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)lowLimit));
                this.setOrAdd(HIGH_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)highLimit));
                this.setOrAdd(DEADBAND_SLOT_NAME, (BValue)BDouble.make((double)deadband));
                break;
            }
            case 15: {
                long timeDelayValue = in.readUnsignedInteger(0);
                int lowLimit = in.readSignedInteger(1);
                int highLimit = in.readSignedInteger(2);
                long deadband = in.readUnsignedInteger(3);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(LOW_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)lowLimit));
                this.setOrAdd(HIGH_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)highLimit));
                this.setOrAdd(DEADBAND_SLOT_NAME, (BValue)BDouble.make((double)deadband));
                break;
            }
            case 16: {
                long timeDelayValue = in.readUnsignedInteger(0);
                long lowLimit = in.readUnsignedInteger(1);
                long highLimit = in.readUnsignedInteger(2);
                long deadband = in.readUnsignedInteger(3);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(LOW_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)lowLimit));
                this.setOrAdd(HIGH_LIMIT_SLOT_NAME, (BValue)BDouble.make((double)highLimit));
                this.setOrAdd(DEADBAND_SLOT_NAME, (BValue)BDouble.make((double)deadband));
                break;
            }
            case 17: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipOpeningTag(1);
                List<BValue> charStrValues = BBacnetSequenceOf.readAsn(in, 1, BString.TYPE);
                in.skipClosingTag(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.updateOrAddSequenceOf(LIST_OF_ALARM_VALUES_SLOT_NAME, BString.TYPE, charStrValues);
                break;
            }
            case 18: {
                long timeDelayValue = in.readUnsignedInteger(0);
                BBacnetBitString cosfSelectedFalgs = in.readBitString(1);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                this.setOrAdd(STATUS_FLAGS_SLOT_NAME, (BValue)cosfSelectedFalgs);
                break;
            }
            case 19: {
                throw new IllegalStateException("Change Of Reliability not supported!");
            }
            case 20: {
                in.readNull();
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                break;
            }
            case 21: {
                long timeDelayValue = in.readUnsignedInteger(0);
                in.skipClosingTag(tag);
                this.updateChoice(tag);
                this.setOrAdd(TIME_DELAY_SLOT_NAME, (BValue)BBacnetUnsigned.make(timeDelayValue), (BFacets)SECONDS_FACETS.newCopy());
                break;
            }
        }
    }

    private void updateOrAddSequenceOf(String slotName, Type sequenceType, List<BValue> values) {
        BBacnetSequenceOf listOfValues = (BBacnetSequenceOf)this.get(slotName);
        if (listOfValues == null) {
            listOfValues = new BBacnetSequenceOf(sequenceType);
            listOfValues.updateElements(values, sequenceType, noWrite);
            this.add(slotName, (BValue)listOfValues);
        } else {
            listOfValues.updateElements(values, sequenceType, noWrite);
        }
    }

    private void updateChoice(int tag) {
        if (tag != this.getChoice()) {
            this.removeAll(noWrite);
        }
        this.setInt(choice, tag, noWrite);
    }

    private void setOrAdd(String name, BValue value) {
        this.setOrAdd(name, value, null);
    }

    private void setOrAdd(String name, BValue value, BFacets facets) {
        BacUtil.setOrAdd(this, name, value, 0, facets, noWrite);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetEventParameter", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

