/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="operation", type="BBacnetLightingOperation", defaultValue="BBacnetLightingOperation.DEFAULT")
public class BBacnetLightingCommand
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property operation = BBacnetLightingCommand.newProperty((int)0, (BValue)BBacnetLightingOperation.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetLightingCommand.class);
    public static final int OPERATION_TAG = 0;
    public static final int TARGET_LEVEL_TAG = 1;
    public static final int RAMP_RATE_TAG = 2;
    public static final int STEP_INCREMENT_TAG = 3;
    public static final int FADE_TIME_TAG = 4;
    public static final int PRIORITY_TAG = 5;

    @Generated
    public BBacnetLightingOperation getOperation() {
        return (BBacnetLightingOperation)this.get(operation);
    }

    @Generated
    public void setOperation(BBacnetLightingOperation v) {
        this.set(operation, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetLightingCommand() {
    }

    public BBacnetLightingCommand(BBacnetLightingOperation operation) {
        this.setOperation(operation);
    }

    public BBacnetLightingCommand(BBacnetLightingOperation operation, Float targetLevel, Float rampRate, Float stepIncrement, Long fadeTime, Integer priority) {
        this.setOperation(operation);
        if (targetLevel != null) {
            this.setTargetLevel(targetLevel);
        }
        if (rampRate != null) {
            this.setRampRate(rampRate);
        }
        if (stepIncrement != null) {
            this.setStepIncrement(stepIncrement);
        }
        if (fadeTime != null) {
            this.setFadeTime(fadeTime);
        }
        if (priority != null) {
            this.setPriority(priority);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        BComplex parent = this.getParent();
        Property propertyInParent = this.getPropertyInParent();
        if (parent instanceof BComponent && propertyInParent != null) {
            ((BComponent)parent).changed(propertyInParent, context);
        }
    }

    @Override
    public void writeAsn(AsnOutput out) {
        Integer priority;
        Long fadeTime;
        Float stepIncrement;
        Float rampRate;
        out.writeEnumerated(0, (BEnum)this.getOperation());
        Float targetLevel = this.getTargetLevel();
        if (targetLevel != null) {
            out.writeReal(1, targetLevel.floatValue());
        }
        if ((rampRate = this.getRampRate()) != null) {
            out.writeReal(2, rampRate.floatValue());
        }
        if ((stepIncrement = this.getStepIncrement()) != null) {
            out.writeReal(3, stepIncrement.floatValue());
        }
        if ((fadeTime = this.getFadeTime()) != null) {
            out.writeUnsignedInteger(4, fadeTime);
        }
        if ((priority = this.getPriority()) != null) {
            out.writeUnsignedInteger(5, priority.intValue());
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int operation = in.readEnumerated(0);
        float targetLevel = -1.0f;
        if (in.peekTag() == 1) {
            targetLevel = in.readReal(1);
        }
        float rampRate = -1.0f;
        if (in.peekTag() == 2) {
            rampRate = in.readReal(2);
        }
        float stepIncrement = -1.0f;
        if (in.peekTag() == 3) {
            stepIncrement = in.readReal(3);
        }
        long fadeTime = -1L;
        if (in.peekTag() == 4) {
            fadeTime = in.readUnsignedInteger(4);
        }
        int priority = -1;
        if (in.peekTag() == 5) {
            priority = in.readUnsignedInt(5);
        }
        this.set(BBacnetLightingCommand.operation, (BValue)BBacnetLightingOperation.make(operation), noWrite);
        if (targetLevel >= 0.0f) {
            this.setTargetLevel(Float.valueOf(targetLevel));
        }
        if (rampRate >= 0.0f) {
            this.setRampRate(Float.valueOf(rampRate));
        }
        if (stepIncrement >= 0.0f) {
            this.setStepIncrement(Float.valueOf(stepIncrement));
        }
        if (fadeTime >= 0L) {
            this.setFadeTime(fadeTime);
        }
        if (priority >= 0) {
            this.setPriority(priority);
        }
    }

    public Float getTargetLevel() {
        return this.getFloat("targetLevel");
    }

    public void setTargetLevel(Float targetLevel) {
        this.add("targetLevel", (BValue)BFloat.make((float)targetLevel.floatValue()));
    }

    public Float getRampRate() {
        return this.getFloat("rampRate");
    }

    public void setRampRate(Float rampRate) {
        this.add("rampRate", (BValue)BFloat.make((float)rampRate.floatValue()));
    }

    public Float getStepIncrement() {
        return this.getFloat("stepIncrement");
    }

    public void setStepIncrement(Float stepIncrement) {
        this.add("stepIncrement", (BValue)BFloat.make((float)stepIncrement.floatValue()));
    }

    public Long getFadeTime() {
        BLong fadeTime = (BLong)this.get("fadeTime");
        if (fadeTime != null) {
            return fadeTime.getLong();
        }
        return null;
    }

    public void setFadeTime(Long fadeTime) {
        this.add("fadeTime", (BValue)BLong.make((long)fadeTime));
    }

    public Integer getPriority() {
        BInteger priority = (BInteger)this.get("priority");
        if (priority != null) {
            return priority.getInt();
        }
        return null;
    }

    public void setPriority(Integer priority) {
        this.add("priority", (BValue)BInteger.make((int)priority));
    }

    public Float getFloat(String name) {
        BFloat bFloat = (BFloat)this.get(name);
        if (bFloat != null) {
            return Float.valueOf(bFloat.getFloat());
        }
        return null;
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder("" + this.getOperation());
        sb.append("\n\tTargetLevel: ").append(this.getTargetLevel()).append("\n\tRampRate: ").append(this.getRampRate()).append("\n\tStepIncrement: ").append(this.getStepIncrement()).append("\n\tFadeTime: ").append(this.getFadeTime()).append("\n\tPriority: ").append(this.getPriority());
        return sb.toString();
    }
}

