/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isNull", type="boolean", defaultValue="true"), @NiagaraProperty(name="value", type="double", defaultValue="0.0")})
public final class BBacnetOptionalDouble
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property isNull = BBacnetOptionalDouble.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property value = BBacnetOptionalDouble.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetOptionalDouble.class);

    @Generated
    public boolean getIsNull() {
        return this.getBoolean(isNull);
    }

    @Generated
    public void setIsNull(boolean v) {
        this.setBoolean(isNull, v, null);
    }

    @Generated
    public double getValue() {
        return this.getDouble(value);
    }

    @Generated
    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetOptionalDouble() {
    }

    public BBacnetOptionalDouble(double value) {
        this.setIsNull(false);
        this.setValue(value);
    }

    public boolean isNull() {
        return this.getIsNull();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        if (this.getIsNull()) {
            out.writeNull();
        } else {
            out.writeDouble(this.getValue());
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        switch (tag) {
            case 0: {
                in.readNull();
                this.setBoolean(isNull, true, noWrite);
                break;
            }
            case 5: {
                double doubleValue = in.readDouble();
                this.setBoolean(isNull, false, noWrite);
                this.setDouble(value, doubleValue, noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
    }

    public String toString(Context context) {
        return this.getIsNull() ? "null" : BDouble.toString((double)this.getValue(), (Context)context);
    }
}

