/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFloat;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isNull", type="boolean", defaultValue="true"), @NiagaraProperty(name="value", type="float", defaultValue="0.0f")})
public final class BBacnetOptionalReal
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property isNull = BBacnetOptionalReal.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property value = BBacnetOptionalReal.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetOptionalReal.class);

    @Generated
    public boolean getIsNull() {
        return this.getBoolean(isNull);
    }

    @Generated
    public void setIsNull(boolean v) {
        this.setBoolean(isNull, v, null);
    }

    @Generated
    public float getValue() {
        return this.getFloat(value);
    }

    @Generated
    public void setValue(float v) {
        this.setFloat(value, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetOptionalReal() {
    }

    public BBacnetOptionalReal(float value) {
        this.setIsNull(false);
        this.setValue(value);
    }

    public boolean isNull() {
        return this.getIsNull();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        if (this.getIsNull()) {
            out.writeNull();
        } else {
            out.writeReal(this.getValue());
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        switch (tag) {
            case 0: {
                in.readNull();
                this.setBoolean(isNull, true, noWrite);
                break;
            }
            case 4: {
                float real = in.readReal();
                this.setBoolean(isNull, false, noWrite);
                this.setFloat(value, real, noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
    }

    public String toString(Context context) {
        return this.getIsNull() ? "null" : BFloat.toString((float)this.getValue(), (Context)context);
    }
}

