/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="choice", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0,1)")}), @NiagaraProperty(name="device", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE)"), @NiagaraProperty(name="address", type="BBacnetAddress", defaultValue="new BBacnetAddress()")})
public final class BBacnetRecipient
extends BStruct
implements BIBacnetDataType,
IBacnetAddress {
    @Generated
    public static final Property choice = BBacnetRecipient.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)1));
    @Generated
    public static final Property device = BBacnetRecipient.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(8), null);
    @Generated
    public static final Property address = BBacnetRecipient.newProperty((int)0, (BValue)new BBacnetAddress(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetRecipient.class);
    public static final int DEVICE_TAG = 0;
    public static final int ADDRESS_TAG = 1;

    @Generated
    public int getChoice() {
        return this.getInt(choice);
    }

    @Generated
    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getDevice() {
        return (BBacnetObjectIdentifier)this.get(device);
    }

    @Generated
    public void setDevice(BBacnetObjectIdentifier v) {
        this.set(device, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetAddress getAddress() {
        return (BBacnetAddress)this.get(address);
    }

    @Generated
    public void setAddress(BBacnetAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetRecipient() {
    }

    public BBacnetRecipient(BBacnetObjectIdentifier device) {
        this.setChoice(0);
        this.setDevice(device);
    }

    public BBacnetRecipient(BBacnetAddress address) {
        this.setChoice(1);
        this.getAddress().copyFrom((BComplex)address);
    }

    public boolean isDevice() {
        return this.getChoice() == 0;
    }

    public boolean isAddress() {
        return this.getChoice() == 1;
    }

    public BValue getRecipient() {
        if (this.getChoice() == 0) {
            return this.getDevice();
        }
        return this.getAddress();
    }

    public void setRecipient(BValue v) {
        this.setRecipient(v, null);
    }

    public void setRecipient(BValue v, Context cx) {
        Type t = v.getType();
        if (t == BBacnetObjectIdentifier.TYPE) {
            this.setInt(choice, 0, cx);
            this.set(device, v, cx);
        } else if (t == BBacnetAddress.TYPE) {
            this.setInt(choice, 1, cx);
            this.getAddress().copyFrom((BComplex)((BBacnetAddress)v), cx);
        }
    }

    @Override
    public void writeAsn(AsnOutput out) {
        switch (this.getChoice()) {
            case 0: {
                out.writeObjectIdentifier(0, this.getDevice());
                break;
            }
            case 1: {
                out.writeOpeningTag(1);
                this.getAddress().writeAsn(out);
                out.writeClosingTag(1);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid recipient type:" + this.getChoice());
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int choice = in.peekTag();
        switch (choice) {
            case 0: {
                this.set(device, (BValue)in.readObjectIdentifier(0), noWrite);
                break;
            }
            case 1: {
                in.skipOpeningTag(1);
                BBacnetAddress address = new BBacnetAddress();
                address.readAsn(in);
                in.skipClosingTag(1);
                this.set(BBacnetRecipient.address, (BValue)address, noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + choice);
            }
        }
        this.setInt(BBacnetRecipient.choice, choice, noWrite);
    }

    public boolean equivalent(Object o) {
        if (o instanceof BBacnetRecipient) {
            BBacnetRecipient other = (BBacnetRecipient)o;
            int choice = this.getChoice();
            if (choice != other.getChoice()) {
                return false;
            }
            switch (choice) {
                case 0: {
                    return this.getDevice().equals((Object)other.getDevice());
                }
                case 1: {
                    int networkNumber = this.getAddress().getNetworkNumber();
                    if (networkNumber != other.getAddress().getNetworkNumber()) {
                        return false;
                    }
                    return this.getAddress().macEquals(other.getAddress().getMacAddress().getAddr());
                }
            }
        }
        return false;
    }

    public String toString(Context context) {
        return this.getRecipient().toString(context);
    }
}

