/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="shedInactive"), @Range(value="shedRequestPending"), @Range(value="shedCompliant"), @Range(value="shedNonCompliant")})
public final class BBacnetShedState
extends BFrozenEnum
implements BacnetConst {
    @Generated
    public static final int SHED_INACTIVE = 0;
    @Generated
    public static final int SHED_REQUEST_PENDING = 1;
    @Generated
    public static final int SHED_COMPLIANT = 2;
    @Generated
    public static final int SHED_NON_COMPLIANT = 3;
    @Generated
    public static final BBacnetShedState shedInactive = new BBacnetShedState(0);
    @Generated
    public static final BBacnetShedState shedRequestPending = new BBacnetShedState(1);
    @Generated
    public static final BBacnetShedState shedCompliant = new BBacnetShedState(2);
    @Generated
    public static final BBacnetShedState shedNonCompliant = new BBacnetShedState(3);
    @Generated
    public static final BBacnetShedState DEFAULT = shedInactive;
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetShedState.class);
    public static final int MAX_ASHRAE_ID = 3;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;

    @Generated
    public static BBacnetShedState make(int ordinal) {
        return (BBacnetShedState)shedInactive.getRange().get(ordinal, false);
    }

    @Generated
    public static BBacnetShedState make(String tag) {
        return (BBacnetShedState)shedInactive.getRange().get(tag);
    }

    @Generated
    private BBacnetShedState(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetShedState.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetShedState.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        throw new InvalidEnumException(id);
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 63 && id <= 65535;
    }

    public static boolean isAshrae(int id) {
        return id > 3 && id <= 63;
    }

    public static boolean isValid(int id) {
        return id <= 65535;
    }

    public static boolean isFixed(int id) {
        return id <= 3;
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }
}

