/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.export.BBacnetBinaryPointDescriptor;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="bacnetWritable", type="String", defaultValue="BBacnetPointDescriptor.lexNotWritable", flags=5)
public abstract class BBacnetBinaryWritableDescriptor
extends BBacnetBinaryPointDescriptor
implements BacnetWritableDescriptor {
    @Generated
    public static final Property bacnetWritable = BBacnetBinaryWritableDescriptor.newProperty((int)5, (String)BBacnetPointDescriptor.lexNotWritable, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBinaryWritableDescriptor.class);

    @Override
    @Generated
    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    @Generated
    public void setBacnetWritable(String v) {
        this.setString(bacnetWritable, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BBooleanWritable;
    }

    @Override
    protected boolean isCommandable() {
        return true;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        switch (pId) {
            case 87: {
                return this.readPriorityArray(ndx);
            }
            case 104: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getFallback().getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    return this.writePriorityArray(pri, val);
                }
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BStatusBoolean fb = pt.getFallback();
                    fb.setBoolean(BStatusBoolean.value, AsnUtil.fromOnlyBinaryPv(val), BLocalBacnetDevice.getBacnetContext());
                    fb.setStatusNull(false);
                    return null;
                }
            }
        }
        catch (OutOfRangeException e) {
            log.warning("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        switch (pId) {
            case 66: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getMinInactiveTime().getMillis() / 1000L));
            }
            case 67: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getMinActiveTime().getMillis() / 1000L));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        try {
            BBooleanWritable pt = (BBooleanWritable)this.getPoint();
            switch (pId) {
                case 66: {
                    pt.set(BBooleanWritable.minInactiveTime, (BValue)BRelTime.make((long)(1000L * AsnUtil.fromAsnUnsignedInteger(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 67: {
                    pt.set(BBooleanWritable.minActiveTime, (BValue)BRelTime.make((long)(1000L * AsnUtil.fromAsnUnsignedInteger(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return super.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue readPriorityArray(int ndx) {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(87, ndx, new NErrorType(1, 1000));
        }
        if (ndx == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                for (int i = 1; i <= 16; ++i) {
                    BStatusBoolean e = pt.getLevel(BPriorityLevel.make((int)i));
                    if (e.getStatus().isNull()) {
                        asnOut.writeNull();
                        continue;
                    }
                    asnOut.writeEnumerated(e.getValue() ? 1 : 0);
                }
                return new NReadPropertyResult(87, ndx, asnOut.toByteArray());
            }
        }
        if (ndx == 0) {
            return new NReadPropertyResult(87, ndx, AsnUtil.toAsnUnsigned(16L));
        }
        try {
            BStatusBoolean e = pt.getLevel(BPriorityLevel.make((int)ndx));
            if (e.getStatus().isNull()) {
                return new NReadPropertyResult(87, ndx, AsnUtil.toAsnNull());
            }
            return new NReadPropertyResult(87, ndx, AsnUtil.toAsnEnumerated(e.getValue() ? 1 : 0));
        }
        catch (Exception e) {
            return new NReadPropertyResult(87, ndx, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorType writePriorityArray(int pri, byte[] val) throws BacnetException {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        try {
            if (pri == -1) {
                pri = 16;
            }
            if (pri < 1 || pri > 16) {
                return new NErrorType(5, 80);
            }
            String inSlotName = "bacnetValueIn" + pri;
            Property inSlot = this.loadSlots().getProperty(inSlotName);
            if (inSlot == null) {
                return new NErrorType(2, 40);
            }
            BStatusBoolean bacval = (BStatusBoolean)this.get(inSlotName).newCopy();
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(val);
                int tag = asnIn.peekTag();
                if (tag == 0) {
                    bacval.setStatusNull(true);
                } else if (tag == 9) {
                    int pv = asnIn.readEnumerated();
                    if (pv != 0 && pv != 1) {
                        return new NErrorType(2, 37);
                    }
                    BOutOfServiceExt outOfServiceExt = this.getOosExt();
                    if (outOfServiceExt.getOutOfService()) {
                        outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BBoolean.make((pv == 1 ? 1 : 0) != 0), BLocalBacnetDevice.getBacnetContext());
                    }
                    bacval.setStatusNull(false);
                    bacval.setValue(pv == 1);
                } else {
                    throw new AsnException("Invalid tag: " + tag);
                }
            }
            this.set(inSlot, (BValue)bacval, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (IllegalArgumentException e) {
            log.warning("IllegalArgumentException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 37);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    private void resetBacnetWritable() {
        StringBuilder sb = new StringBuilder();
        Knob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BObject tgt = knobs[i].getTargetOrd().get((BObject)this);
            BControlPoint pt = this.getPoint();
            if (!knobs[i].getTargetSlotName().startsWith("in") || tgt != pt) continue;
            sb.append(knobs[i].getTargetSlotName()).append(',');
        }
        this.setBacnetWritable(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    @Override
    public final void doMakeWritable(BValue writable) {
        if (!this.isRunning()) {
            return;
        }
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return;
        }
        BLink[] links = pt.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (links[i].isActive()) {
                if (links[i].getSourceComponent() != this || !links[i].getTargetSlot().getName().startsWith("in")) continue;
                pt.remove((BComplex)links[i]);
                continue;
            }
            pt.remove((BComplex)links[i]);
        }
        BStatusBoolean[] bacnetValues = (BStatusBoolean[])this.getChildren(BStatusBoolean.class);
        for (int i = 0; i < bacnetValues.length; ++i) {
            if (!bacnetValues[i].getName().startsWith("bacnetValueIn")) continue;
            this.remove((BComplex)bacnetValues[i]);
        }
        String s = ((BString)writable).getString();
        if (s.equals(lexNotWritable)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String tgtSlotName = st.nextToken();
            Slot tgtSlot = pt.getSlot(tgtSlotName);
            String srcSlotName = "bacnetValue" + TextUtil.capitalize((String)tgtSlotName);
            BStatusBoolean sf = new BStatusBoolean();
            sf.setStatusNull(true);
            this.add(srcSlotName, (BValue)sf, 257);
            pt.setFlags(tgtSlot, pt.getFlags(tgtSlot) | 0x400);
            BLink link = new BLink(this.getHandleOrd(), srcSlotName, tgtSlotName, true);
            pt.add("bacnet" + tgtSlotName, (BValue)link, 1);
        }
    }
}

