/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BEnumCommandFailureAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:EnumWritable"})})
@NiagaraProperties(value={@NiagaraProperty(name="deviceType", type="String", defaultValue=""), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.MULTI_STATE_OUTPUT)", flags=64, override=true)})
public class BBacnetMultiStateOutputDescriptor
extends BBacnetMultiStateWritableDescriptor {
    @Generated
    public static final Property deviceType = BBacnetMultiStateOutputDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property objectId = BBacnetMultiStateOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(14), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMultiStateOutputDescriptor.class);

    @Generated
    public String getDeviceType() {
        return this.getString(deviceType);
    }

    @Generated
    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(14);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.commandFailure;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BEnumCommandFailureAlgorithm;
        }
        return false;
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.numberOfStates);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.deviceType);
        v.add(BBacnetPropertyIdentifier.reliability);
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (r != null) {
            v.add(BBacnetPropertyIdentifier.stateText);
        }
        v.add(BBacnetPropertyIdentifier.interfaceValue);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.feedbackValue);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    public ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    public ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BEnumCommandFailureAlgorithm alg = (BEnumCommandFailureAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 40) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(alg.getFeedbackValue().getValue().getOrdinal()));
            }
        }
        switch (pId) {
            case 31: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDeviceType()));
            }
            case 387: {
                return this.readInterfaceValue();
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 31: 
            case 387: {
                return new NErrorType(2, 40);
            }
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            if (pId == 40) {
                return new NErrorType(2, 40);
            }
            if (pId == 35) {
                almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }

    @Override
    protected void validate() {
        BStatusEnum pointOut;
        if (!this.configOk.get()) {
            return;
        }
        if (this.getOosExt().getOutOfService()) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            return;
        }
        BEnumPoint point = (BEnumPoint)this.getPoint();
        BBacnetReliability pointReliability = this.validatePoint(point, pointOut = point.getOut());
        if (!pointReliability.equals(BBacnetReliability.noFaultDetected)) {
            // empty if block
        }
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }
}

