/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacnetVendorUtil;
import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.LocalBacnetCovPropPoll;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.util.ComponentTreeCursor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetAddressBinding;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BacnetCovSubscriber;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.export.BacnetSpecialEventsSubscriber;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualGateway;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.LongHashMap;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE)", facets={@Facet(value="BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.DEVICE)")}), @NiagaraProperty(name="systemStatus", type="BBacnetDeviceStatus", defaultValue="BBacnetDeviceStatus.operational", flags=3), @NiagaraProperty(name="vendorName", type="String", defaultValue="Tridium", flags=1), @NiagaraProperty(name="vendorId", type="int", defaultValue="36", flags=1), @NiagaraProperty(name="modelName", type="String", defaultValue="Niagara4 Station", flags=1), @NiagaraProperty(name="firmwareRevision", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="applicationSoftwareVersion", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="location", type="String", defaultValue="unknown"), @NiagaraProperty(name="description", type="String", defaultValue="Local BACnet Device object"), @NiagaraProperty(name="deviceUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=65, facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="protocolVersion", type="int", defaultValue="1", flags=1), @NiagaraProperty(name="protocolRevision", type="int", defaultValue="14", flags=1), @NiagaraProperty(name="protocolConformanceClass", type="int", defaultValue="3", flags=5), @NiagaraProperty(name="protocolServicesSupported", type="BBacnetBitString", defaultValue="SERVER_SERVICES_SUPPORTED", flags=1, facets={@Facet(value="BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS")}), @NiagaraProperty(name="protocolObjectTypesSupported", type="BBacnetBitString", defaultValue="SERVER_OBJECT_TYPES_SUPPORTED", flags=1, facets={@Facet(value="BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_FACETS")}), @NiagaraProperty(name="maxAPDULengthAccepted", type="int", defaultValue="ConfirmedRequestPdu.MAX_APDU_LENGTH_UP_TO_1476_OCTETS", flags=1), @NiagaraProperty(name="segmentationSupported", type="BBacnetSegmentation", defaultValue="BBacnetSegmentation.segmentedBoth", flags=1), @NiagaraProperty(name="maxSegmentsAccepted", type="int", defaultValue="ConfirmedRequestPdu.MAX_SEGS_GREATER_THAN_64", flags=1), @NiagaraProperty(name="apduSegmentTimeout", type="int", defaultValue="2000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="apduTimeout", type="int", defaultValue="3000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="numberOfApduRetries", type="int", defaultValue="3"), @NiagaraProperty(name="deviceAddressBinding", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetAddressBinding.TYPE)", flags=7), @NiagaraProperty(name="databaseRevision", type="int", defaultValue="1", flags=1), @NiagaraProperty(name="configurationFiles", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetObjectIdentifier.TYPE)", flags=5), @NiagaraProperty(name="lastRestoreTime", type="BBacnetTimeStamp", defaultValue="new BBacnetTimeStamp(new BBacnetDateTime())", flags=1), @NiagaraProperty(name="backupFailureTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(180)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="false"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="backupPreparationTime", type="BRelTime", defaultValue="BRelTime.make(60000)", flags=1, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="restorePreparationTime", type="BRelTime", defaultValue="BRelTime.make(60000)", flags=1, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="restoreCompletionTime", type="BRelTime", defaultValue="BRelTime.make(180000)", flags=1, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="backupAndRestoreState", type="BBacnetBackupState", defaultValue="BBacnetBackupState.DEFAULT", flags=3), @NiagaraProperty(name="activeCovSubscriptions", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetCovSubscription.TYPE)", flags=7), @NiagaraProperty(name="characterSet", type="BCharacterSetEncoding", defaultValue="BCharacterSetEncoding.iso10646_UTF8"), @NiagaraProperty(name="enumerationList", type="BExtensibleEnumList", defaultValue="new BExtensibleEnumList()"), @NiagaraProperty(name="exportTable", type="BComponent", defaultValue="new BBacnetExportTable()"), @NiagaraProperty(name="virtual", type="BLocalBacnetVirtualGateway", defaultValue="new BLocalBacnetVirtualGateway()", flags=4), @NiagaraProperty(name="covPropertyPollRate", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)", flags=4), @NiagaraProperty(name="timeSynchronizationRecipients", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetRecipient.TYPE)"), @NiagaraProperty(name="timeSynchronizationInterval", type="BRelTime", defaultValue="BRelTime.make(86400000)", facets={@Facet(name="BFacets.SHOW_SECONDS", value="false"), @Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="alignIntervals", type="boolean", defaultValue="true"), @NiagaraProperty(name="intervalOffset", type="int", defaultValue="0", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"minute\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="1440")}), @NiagaraProperty(name="utcTimeSynchronizationRecipients", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetRecipient.TYPE)"), @NiagaraProperty(name="lastRestartReason", type="BBacnetRestartReason", defaultValue="BBacnetRestartReason.unknown"), @NiagaraProperty(name="nextRestartReason", type="BBacnetRestartReason", defaultValue="BBacnetRestartReason.unknown", flags=5), @NiagaraProperty(name="timeOfDeviceRestart", type="BBacnetTimeStamp", defaultValue="new BBacnetTimeStamp(BAbsTime.make())", flags=2), @NiagaraProperty(name="restartNotificationRecipients", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetRecipient.TYPE)"), @NiagaraProperty(name="saveStationOnRestartRecipientsChange", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="sendIAm"), @NiagaraAction(name="setBackupMode", parameterType="BBoolean", defaultValue="BBoolean.FALSE", flags=4), @NiagaraAction(name="setRestoreMode", parameterType="BBoolean", defaultValue="BBoolean.FALSE", flags=4), @NiagaraAction(name="println", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="sendTimeSynch", flags=4), @NiagaraAction(name="checkDuplicates", flags=4), @NiagaraAction(name="sendRestartNotifications", flags=4), @NiagaraAction(name="changeDeviceUuid", parameterType="BUuid", defaultValue="BUuid.NULL", flags=128)})
public class BLocalBacnetDevice
extends BComponent
implements BIBacnetExportObject,
BIBacnetObjectContainer,
BacnetPropertyListProvider {
    private static final BBacnetBitString SERVER_OBJECT_TYPES_SUPPORTED = BBacnetBitString.make(true, true, true, true, true, true, true, false, true, true, true, false, true, true, true, true, false, true, false, true, true, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, true, false, false, false, false, false, false);
    private static final BBacnetBitString SERVER_SERVICES_SUPPORTED = BBacnetBitString.make(true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, false, true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, true, true, false, true, true, false);
    @Generated
    public static final Property status = BLocalBacnetDevice.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BLocalBacnetDevice.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property objectId = BLocalBacnetDevice.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(8), (BFacets)BBacnetObjectType.getObjectIdFacets(8));
    @Generated
    public static final Property systemStatus = BLocalBacnetDevice.newProperty((int)3, (BValue)BBacnetDeviceStatus.operational, null);
    @Generated
    public static final Property vendorName = BLocalBacnetDevice.newProperty((int)1, (String)"Tridium", null);
    @Generated
    public static final Property vendorId = BLocalBacnetDevice.newProperty((int)1, (int)36, null);
    @Generated
    public static final Property modelName = BLocalBacnetDevice.newProperty((int)1, (String)"Niagara4 Station", null);
    @Generated
    public static final Property firmwareRevision = BLocalBacnetDevice.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property applicationSoftwareVersion = BLocalBacnetDevice.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property location = BLocalBacnetDevice.newProperty((int)0, (String)"unknown", null);
    @Generated
    public static final Property description = BLocalBacnetDevice.newProperty((int)0, (String)"Local BACnet Device object", null);
    @Generated
    public static final Property deviceUuid = BLocalBacnetDevice.newProperty((int)65, (BValue)BUuid.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property protocolVersion = BLocalBacnetDevice.newProperty((int)1, (int)1, null);
    @Generated
    public static final Property protocolRevision = BLocalBacnetDevice.newProperty((int)1, (int)14, null);
    @Generated
    public static final Property protocolConformanceClass = BLocalBacnetDevice.newProperty((int)5, (int)3, null);
    @Generated
    public static final Property protocolServicesSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)SERVER_SERVICES_SUPPORTED, (BFacets)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS);
    @Generated
    public static final Property protocolObjectTypesSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)SERVER_OBJECT_TYPES_SUPPORTED, (BFacets)BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_FACETS);
    @Generated
    public static final Property maxAPDULengthAccepted = BLocalBacnetDevice.newProperty((int)1, (int)1476, null);
    @Generated
    public static final Property segmentationSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)BBacnetSegmentation.segmentedBoth, null);
    @Generated
    public static final Property maxSegmentsAccepted = BLocalBacnetDevice.newProperty((int)1, (int)255, null);
    @Generated
    public static final Property apduSegmentTimeout = BLocalBacnetDevice.newProperty((int)0, (int)2000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)));
    @Generated
    public static final Property apduTimeout = BLocalBacnetDevice.newProperty((int)0, (int)3000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)));
    @Generated
    public static final Property numberOfApduRetries = BLocalBacnetDevice.newProperty((int)0, (int)3, null);
    @Generated
    public static final Property deviceAddressBinding = BLocalBacnetDevice.newProperty((int)7, (BValue)new BBacnetListOf(BBacnetAddressBinding.TYPE), null);
    @Generated
    public static final Property databaseRevision = BLocalBacnetDevice.newProperty((int)1, (int)1, null);
    @Generated
    public static final Property configurationFiles = BLocalBacnetDevice.newProperty((int)5, (BValue)new BBacnetArray(BBacnetObjectIdentifier.TYPE), null);
    @Generated
    public static final Property lastRestoreTime = BLocalBacnetDevice.newProperty((int)1, (BValue)new BBacnetTimeStamp(new BBacnetDateTime()), null);
    @Generated
    public static final Property backupFailureTimeout = BLocalBacnetDevice.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)180), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    @Generated
    public static final Property backupPreparationTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    @Generated
    public static final Property restorePreparationTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    @Generated
    public static final Property restoreCompletionTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)180000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    @Generated
    public static final Property backupAndRestoreState = BLocalBacnetDevice.newProperty((int)3, (BValue)BBacnetBackupState.DEFAULT, null);
    @Generated
    public static final Property activeCovSubscriptions = BLocalBacnetDevice.newProperty((int)7, (BValue)new BBacnetListOf(BBacnetCovSubscription.TYPE), null);
    @Generated
    public static final Property characterSet = BLocalBacnetDevice.newProperty((int)0, (BValue)BCharacterSetEncoding.iso10646_UTF8, null);
    @Generated
    public static final Property enumerationList = BLocalBacnetDevice.newProperty((int)0, (BValue)new BExtensibleEnumList(), null);
    @Generated
    public static final Property exportTable = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetExportTable(), null);
    @Generated
    public static final Property virtual = BLocalBacnetDevice.newProperty((int)4, (BValue)new BLocalBacnetVirtualGateway(), null);
    @Generated
    public static final Property covPropertyPollRate = BLocalBacnetDevice.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)5), null);
    @Generated
    public static final Property timeSynchronizationRecipients = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetRecipient.TYPE), null);
    @Generated
    public static final Property timeSynchronizationInterval = BLocalBacnetDevice.newProperty((int)0, (BValue)BRelTime.make((long)86400000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    @Generated
    public static final Property alignIntervals = BLocalBacnetDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property intervalOffset = BLocalBacnetDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)1440)));
    @Generated
    public static final Property utcTimeSynchronizationRecipients = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetRecipient.TYPE), null);
    @Generated
    public static final Property lastRestartReason = BLocalBacnetDevice.newProperty((int)0, (BValue)BBacnetRestartReason.unknown, null);
    @Generated
    public static final Property nextRestartReason = BLocalBacnetDevice.newProperty((int)5, (BValue)BBacnetRestartReason.unknown, null);
    @Generated
    public static final Property timeOfDeviceRestart = BLocalBacnetDevice.newProperty((int)2, (BValue)new BBacnetTimeStamp(BAbsTime.make()), null);
    @Generated
    public static final Property restartNotificationRecipients = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetRecipient.TYPE), null);
    @Generated
    public static final Property saveStationOnRestartRecipientsChange = BLocalBacnetDevice.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action sendIAm = BLocalBacnetDevice.newAction((int)0, null);
    @Generated
    public static final Action setBackupMode = BLocalBacnetDevice.newAction((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Action setRestoreMode = BLocalBacnetDevice.newAction((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Action println = BLocalBacnetDevice.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action sendTimeSynch = BLocalBacnetDevice.newAction((int)4, null);
    @Generated
    public static final Action checkDuplicates = BLocalBacnetDevice.newAction((int)4, null);
    @Generated
    public static final Action sendRestartNotifications = BLocalBacnetDevice.newAction((int)4, null);
    @Generated
    public static final Action changeDeviceUuid = BLocalBacnetDevice.newAction((int)128, (BValue)BUuid.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalBacnetDevice.class);
    private boolean fatalFault = false;
    private volatile boolean brandPropertiesRead = false;
    private static final BIcon icon = BIcon.std((String)"deviceLocal.png");
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 112, 121, 120, 70, 44, 12, 98, 139, 97, 96, 76, 62, 107, 11, 73, 30, 155};
    public static final String LAST_RESTORE_TIME_FILENAME = "~backups/lastRestoreTime";
    public static final String OBJECT_NAME_OVERRIDE_SLOTNAME = "objectName";
    private static final Logger log = Logger.getLogger("bacnet.server.localDevice");
    private static final Logger loggerBacnetTransport = Logger.getLogger("bacnet.transport");
    private static final AsnInputStream asnIn = new AsnInputStream();
    private static final AsnOutputStream asnOut = new AsnOutputStream();
    private BacnetCovSubscriber covSubscriber = new BacnetCovSubscriber();
    private final BIBacnetExportObject.ObjectSubscriber objectSubscriber = new BIBacnetExportObject.ObjectSubscriber();
    private final BacnetSpecialEventsSubscriber specialEventsSubscriber = new BacnetSpecialEventsSubscriber();
    static BasicContext bacnetContext;
    private int maxWaitTime = 0;
    private String objectName = "";
    private BBacnetDeviceStatus preBackupRestoreStatus = BBacnetDeviceStatus.operational;
    private final LocalBacnetCovPropPoll covPropPoller = new LocalBacnetCovPropPoll(this);
    private Clock.Ticket tsTicket = null;
    private final Object TIME_SYNC_LOCK = new Object();
    private BAbsTime lastTSTime = null;
    private static final boolean allowObjectIdWrite = false;
    private static final BRelTime CHECK_DUP_DELAY;
    private Clock.Ticket checkDupTicket = null;
    private final Object CHECK_DUP_LOCK = new Object();
    private static final String SERIAL_NUMBER;
    private final Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            BLocalBacnetDevice.this.setDatabaseRevision(BLocalBacnetDevice.this.getDatabaseRevision() + 1);
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "Local BACnet Device " + BLocalBacnetDevice.this.getNavOrd();
        }
    };

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public BBacnetDeviceStatus getSystemStatus() {
        return (BBacnetDeviceStatus)this.get(systemStatus);
    }

    @Generated
    public void setSystemStatus(BBacnetDeviceStatus v) {
        this.set(systemStatus, (BValue)v, null);
    }

    @Generated
    public String getVendorName() {
        return this.getString(vendorName);
    }

    @Generated
    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    @Generated
    public int getVendorId() {
        return this.getInt(vendorId);
    }

    @Generated
    public void setVendorId(int v) {
        this.setInt(vendorId, v, null);
    }

    @Generated
    public String getModelName() {
        return this.getString(modelName);
    }

    @Generated
    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    @Generated
    public String getFirmwareRevision() {
        return this.getString(firmwareRevision);
    }

    @Generated
    public void setFirmwareRevision(String v) {
        this.setString(firmwareRevision, v, null);
    }

    @Generated
    public String getApplicationSoftwareVersion() {
        return this.getString(applicationSoftwareVersion);
    }

    @Generated
    public void setApplicationSoftwareVersion(String v) {
        this.setString(applicationSoftwareVersion, v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BUuid getDeviceUuid() {
        return (BUuid)this.get(deviceUuid);
    }

    @Generated
    public void setDeviceUuid(BUuid v) {
        this.set(deviceUuid, (BValue)v, null);
    }

    @Generated
    public int getProtocolVersion() {
        return this.getInt(protocolVersion);
    }

    @Generated
    public void setProtocolVersion(int v) {
        this.setInt(protocolVersion, v, null);
    }

    @Generated
    public int getProtocolRevision() {
        return this.getInt(protocolRevision);
    }

    @Generated
    public void setProtocolRevision(int v) {
        this.setInt(protocolRevision, v, null);
    }

    @Generated
    public int getProtocolConformanceClass() {
        return this.getInt(protocolConformanceClass);
    }

    @Generated
    public void setProtocolConformanceClass(int v) {
        this.setInt(protocolConformanceClass, v, null);
    }

    @Generated
    public BBacnetBitString getProtocolServicesSupported() {
        return (BBacnetBitString)this.get(protocolServicesSupported);
    }

    @Generated
    public void setProtocolServicesSupported(BBacnetBitString v) {
        this.set(protocolServicesSupported, (BValue)v, null);
    }

    @Generated
    public BBacnetBitString getProtocolObjectTypesSupported() {
        return (BBacnetBitString)this.get(protocolObjectTypesSupported);
    }

    @Generated
    public void setProtocolObjectTypesSupported(BBacnetBitString v) {
        this.set(protocolObjectTypesSupported, (BValue)v, null);
    }

    @Generated
    public int getMaxAPDULengthAccepted() {
        return this.getInt(maxAPDULengthAccepted);
    }

    @Generated
    public void setMaxAPDULengthAccepted(int v) {
        this.setInt(maxAPDULengthAccepted, v, null);
    }

    @Generated
    public BBacnetSegmentation getSegmentationSupported() {
        return (BBacnetSegmentation)this.get(segmentationSupported);
    }

    @Generated
    public void setSegmentationSupported(BBacnetSegmentation v) {
        this.set(segmentationSupported, (BValue)v, null);
    }

    @Generated
    public int getMaxSegmentsAccepted() {
        return this.getInt(maxSegmentsAccepted);
    }

    @Generated
    public void setMaxSegmentsAccepted(int v) {
        this.setInt(maxSegmentsAccepted, v, null);
    }

    @Generated
    public int getApduSegmentTimeout() {
        return this.getInt(apduSegmentTimeout);
    }

    @Generated
    public void setApduSegmentTimeout(int v) {
        this.setInt(apduSegmentTimeout, v, null);
    }

    @Generated
    public int getApduTimeout() {
        return this.getInt(apduTimeout);
    }

    @Generated
    public void setApduTimeout(int v) {
        this.setInt(apduTimeout, v, null);
    }

    @Generated
    public int getNumberOfApduRetries() {
        return this.getInt(numberOfApduRetries);
    }

    @Generated
    public void setNumberOfApduRetries(int v) {
        this.setInt(numberOfApduRetries, v, null);
    }

    @Generated
    public BBacnetListOf getDeviceAddressBinding() {
        return (BBacnetListOf)this.get(deviceAddressBinding);
    }

    @Generated
    public void setDeviceAddressBinding(BBacnetListOf v) {
        this.set(deviceAddressBinding, (BValue)v, null);
    }

    @Generated
    public int getDatabaseRevision() {
        return this.getInt(databaseRevision);
    }

    @Generated
    public void setDatabaseRevision(int v) {
        this.setInt(databaseRevision, v, null);
    }

    @Generated
    public BBacnetArray getConfigurationFiles() {
        return (BBacnetArray)this.get(configurationFiles);
    }

    @Generated
    public void setConfigurationFiles(BBacnetArray v) {
        this.set(configurationFiles, (BValue)v, null);
    }

    @Generated
    public BBacnetTimeStamp getLastRestoreTime() {
        return (BBacnetTimeStamp)this.get(lastRestoreTime);
    }

    @Generated
    public void setLastRestoreTime(BBacnetTimeStamp v) {
        this.set(lastRestoreTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getBackupFailureTimeout() {
        return (BRelTime)this.get(backupFailureTimeout);
    }

    @Generated
    public void setBackupFailureTimeout(BRelTime v) {
        this.set(backupFailureTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getBackupPreparationTime() {
        return (BRelTime)this.get(backupPreparationTime);
    }

    @Generated
    public void setBackupPreparationTime(BRelTime v) {
        this.set(backupPreparationTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getRestorePreparationTime() {
        return (BRelTime)this.get(restorePreparationTime);
    }

    @Generated
    public void setRestorePreparationTime(BRelTime v) {
        this.set(restorePreparationTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getRestoreCompletionTime() {
        return (BRelTime)this.get(restoreCompletionTime);
    }

    @Generated
    public void setRestoreCompletionTime(BRelTime v) {
        this.set(restoreCompletionTime, (BValue)v, null);
    }

    @Generated
    public BBacnetBackupState getBackupAndRestoreState() {
        return (BBacnetBackupState)this.get(backupAndRestoreState);
    }

    @Generated
    public void setBackupAndRestoreState(BBacnetBackupState v) {
        this.set(backupAndRestoreState, (BValue)v, null);
    }

    @Generated
    public BBacnetListOf getActiveCovSubscriptions() {
        return (BBacnetListOf)this.get(activeCovSubscriptions);
    }

    @Generated
    public void setActiveCovSubscriptions(BBacnetListOf v) {
        this.set(activeCovSubscriptions, (BValue)v, null);
    }

    @Generated
    public BCharacterSetEncoding getCharacterSet() {
        return (BCharacterSetEncoding)this.get(characterSet);
    }

    @Generated
    public void setCharacterSet(BCharacterSetEncoding v) {
        this.set(characterSet, (BValue)v, null);
    }

    @Generated
    public BExtensibleEnumList getEnumerationList() {
        return (BExtensibleEnumList)this.get(enumerationList);
    }

    @Generated
    public void setEnumerationList(BExtensibleEnumList v) {
        this.set(enumerationList, (BValue)v, null);
    }

    @Generated
    public BComponent getExportTable() {
        return (BComponent)this.get(exportTable);
    }

    @Generated
    public void setExportTable(BComponent v) {
        this.set(exportTable, (BValue)v, null);
    }

    @Generated
    public BLocalBacnetVirtualGateway getVirtual() {
        return (BLocalBacnetVirtualGateway)this.get(virtual);
    }

    @Generated
    public void setVirtual(BLocalBacnetVirtualGateway v) {
        this.set(virtual, (BValue)v, null);
    }

    @Generated
    public BRelTime getCovPropertyPollRate() {
        return (BRelTime)this.get(covPropertyPollRate);
    }

    @Generated
    public void setCovPropertyPollRate(BRelTime v) {
        this.set(covPropertyPollRate, (BValue)v, null);
    }

    @Generated
    public BBacnetListOf getTimeSynchronizationRecipients() {
        return (BBacnetListOf)this.get(timeSynchronizationRecipients);
    }

    @Generated
    public void setTimeSynchronizationRecipients(BBacnetListOf v) {
        this.set(timeSynchronizationRecipients, (BValue)v, null);
    }

    @Generated
    public BRelTime getTimeSynchronizationInterval() {
        return (BRelTime)this.get(timeSynchronizationInterval);
    }

    @Generated
    public void setTimeSynchronizationInterval(BRelTime v) {
        this.set(timeSynchronizationInterval, (BValue)v, null);
    }

    @Generated
    public boolean getAlignIntervals() {
        return this.getBoolean(alignIntervals);
    }

    @Generated
    public void setAlignIntervals(boolean v) {
        this.setBoolean(alignIntervals, v, null);
    }

    @Generated
    public int getIntervalOffset() {
        return this.getInt(intervalOffset);
    }

    @Generated
    public void setIntervalOffset(int v) {
        this.setInt(intervalOffset, v, null);
    }

    @Generated
    public BBacnetListOf getUtcTimeSynchronizationRecipients() {
        return (BBacnetListOf)this.get(utcTimeSynchronizationRecipients);
    }

    @Generated
    public void setUtcTimeSynchronizationRecipients(BBacnetListOf v) {
        this.set(utcTimeSynchronizationRecipients, (BValue)v, null);
    }

    @Generated
    public BBacnetRestartReason getLastRestartReason() {
        return (BBacnetRestartReason)this.get(lastRestartReason);
    }

    @Generated
    public void setLastRestartReason(BBacnetRestartReason v) {
        this.set(lastRestartReason, (BValue)v, null);
    }

    @Generated
    public BBacnetRestartReason getNextRestartReason() {
        return (BBacnetRestartReason)this.get(nextRestartReason);
    }

    @Generated
    public void setNextRestartReason(BBacnetRestartReason v) {
        this.set(nextRestartReason, (BValue)v, null);
    }

    @Generated
    public BBacnetTimeStamp getTimeOfDeviceRestart() {
        return (BBacnetTimeStamp)this.get(timeOfDeviceRestart);
    }

    @Generated
    public void setTimeOfDeviceRestart(BBacnetTimeStamp v) {
        this.set(timeOfDeviceRestart, (BValue)v, null);
    }

    @Generated
    public BBacnetListOf getRestartNotificationRecipients() {
        return (BBacnetListOf)this.get(restartNotificationRecipients);
    }

    @Generated
    public void setRestartNotificationRecipients(BBacnetListOf v) {
        this.set(restartNotificationRecipients, (BValue)v, null);
    }

    @Generated
    public boolean getSaveStationOnRestartRecipientsChange() {
        return this.getBoolean(saveStationOnRestartRecipientsChange);
    }

    @Generated
    public void setSaveStationOnRestartRecipientsChange(boolean v) {
        this.setBoolean(saveStationOnRestartRecipientsChange, v, null);
    }

    @Generated
    public void sendIAm() {
        this.invoke(sendIAm, null, null);
    }

    @Generated
    public void setBackupMode(BBoolean parameter) {
        this.invoke(setBackupMode, (BValue)parameter, null);
    }

    @Generated
    public void setRestoreMode(BBoolean parameter) {
        this.invoke(setRestoreMode, (BValue)parameter, null);
    }

    @Generated
    public void println(BString parameter) {
        this.invoke(println, (BValue)parameter, null);
    }

    @Generated
    public void sendTimeSynch() {
        this.invoke(sendTimeSynch, null, null);
    }

    @Generated
    public void checkDuplicates() {
        this.invoke(checkDuplicates, null, null);
    }

    @Generated
    public void sendRestartNotifications() {
        this.invoke(sendRestartNotifications, null, null);
    }

    @Generated
    public void changeDeviceUuid(BUuid parameter) {
        this.invoke(changeDeviceUuid, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String toString(Context c) {
        return "Local Bacnet Device [" + (Object)((Object)this.getObjectId()) + "]";
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        Type type = BBacnetNetwork.bacnet().getType();
        this.setFirmwareRevision(type.getVendorVersion().toString());
        this.setApplicationSoftwareVersion(type.getVendor() + " " + type.getVendorVersion());
        this.objectName = Sys.getStation().getStationName();
        if (!Sys.isStationStarted()) {
            this.incrementDatabaseRevision();
        }
        if (BUuid.DEFAULT.equals((Object)this.getDeviceUuid())) {
            this.setDeviceUuid(BUuid.make());
        }
        this.setInt(protocolRevision, 16);
        this.checkConfiguration();
        this.network().postAsync(new Runnable(){

            @Override
            public void run() {
                BLocalBacnetDevice.this.readBrandProperties();
            }
        });
        this.linkTo("sendIAmLink", this, (Slot)objectId, (Slot)sendIAm);
        this.setFlags(this.getSlot("sendIAmLink"), this.getFlags(this.getSlot("sendIAmLink")) | 4);
        Flags.add((BComponent)this, (Slot)lastRestartReason, null, (int[])new int[]{2});
        this.setLastRestartReason(this.getNextRestartReason());
        this.setNextRestartReason(BBacnetRestartReason.unknown);
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        try {
            BLocalBacnetDevice.getBacnetContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.maxWaitTime = this.getApduTimeout() * (this.getNumberOfApduRetries() + 1);
        boolean[] bits = this.getProtocolObjectTypesSupported().getBits();
        if (bits.length < 56) {
            bits = Arrays.copyOf(bits, 56);
            bits[55] = false;
            this.setProtocolObjectTypesSupported(BBacnetBitString.make(bits));
        }
    }

    public void descendantsStarted() {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath path = new FilePath(LAST_RESTORE_TIME_FILENAME);
        AccessController.doPrivileged(() -> {
            BIFile lastRestoreFile = fs.findFile(path);
            if (lastRestoreFile != null) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(lastRestoreFile.getInputStream(), StandardCharsets.UTF_8));){
                    String s = br.readLine();
                    BAbsTime t = BAbsTime.make((String)s);
                    BBacnetTimeStamp ts = new BBacnetTimeStamp(t);
                    this.setLastRestoreTime(ts);
                    s = br.readLine();
                    int dbRev = Integer.parseInt(s);
                    this.setDatabaseRevision(dbRev + 1);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "IOException occurred reading last restore time file in descendantsStarted", e);
                }
                try {
                    lastRestoreFile.delete();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "IOException occurred deleting last restore time file in descendantsStarted", e);
                }
            }
            return null;
        });
    }

    public void stopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        this.covSubscriber.unsubscribeAll();
        this.covSubscriber = null;
        if (this.tsTicket != null) {
            this.tsTicket.cancel();
        }
        this.tsTicket = null;
        this.lastTSTime = null;
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (OBJECT_NAME_OVERRIDE_SLOTNAME.equals(p.getName())) {
            log.fine("LocalBacnetDevice: added new property slot \"objectName\" to override the Object_Name property");
            this.incrementDatabaseRevision();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (OBJECT_NAME_OVERRIDE_SLOTNAME.equals(p.getName())) {
            this.incrementDatabaseRevision();
        } else if (p.equals(objectId)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(apduTimeout) || p.equals(numberOfApduRetries)) {
            this.maxWaitTime = this.getApduTimeout() * (this.getNumberOfApduRetries() + 1);
            BBacnetTransportLayer transport = ((BBacnetStack)((BBacnetNetwork)this.getParent()).getBacnetComm()).getTransport();
            long lockup = transport.getLockupThreshold().getMillis();
            if ((long)this.maxWaitTime > lockup) {
                loggerBacnetTransport.info("Reconfiguring Transport layer lockup threshold...");
                transport.set(BBacnetTransportLayer.lockupThreshold, (BValue)BRelTime.make((long)this.maxWaitTime), BacnetConst.fallback);
            }
        }
        if (p.equals(timeSynchronizationInterval) || p.equals(alignIntervals) || p.equals(intervalOffset)) {
            this.scheduleTimeSynch();
        }
        if (p.equals(timeSynchronizationRecipients)) {
            this.checkRecipients(p);
        } else if (p.equals(utcTimeSynchronizationRecipients)) {
            this.checkRecipients(p);
        } else if (p.equals(restartNotificationRecipients)) {
            this.checkRecipients(p);
            if (this.getSaveStationOnRestartRecipientsChange()) {
                try {
                    Station.saveAsync(null);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Setting restart notification recipients, error while saving station: " + e, log.isLoggable(Level.FINE) ? e : null);
                }
            }
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (!this.isRunning()) {
            return;
        }
        if (OBJECT_NAME_OVERRIDE_SLOTNAME.equals(p.getName())) {
            log.fine("LocalBacnetDevice: removed the property slot \"objectName\"");
            this.incrementDatabaseRevision();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.checkRecipients(timeSynchronizationRecipients);
        this.checkRecipients(utcTimeSynchronizationRecipients);
        this.checkRecipients(restartNotificationRecipients);
        this.sendTimeSynch();
        this.scheduleTimeSynch();
        this.setTimeOfDeviceRestart(new BBacnetTimeStamp(BAbsTime.make()));
        this.sendRestartNotifications();
    }

    public void clockChanged(BRelTime shift) throws Exception {
        this.sendTimeSynch();
        this.scheduleTimeSynch();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetNetwork;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        for (int i = 0; i < kids.length; ++i) {
            BComponent kid = (BComponent)kids[i];
            if (kid.getType().is(BBacnetListOf.TYPE) || kid.getType().is(BBacnetArray.TYPE)) continue;
            acc.add((Object)kid);
        }
        return (BINavNode[])acc.trim();
    }

    public UUID getUuid() {
        BUuid bUuid = this.getDeviceUuid();
        long msb = bUuid.getMostSignificant();
        long lsb = bUuid.getLeastSignificant();
        return new UUID(msb, lsb);
    }

    @Override
    public final BObject getObject() {
        return this;
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getOrdInSession();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.localDevice.setObjectOrd"));
    }

    @Override
    public String getObjectName() {
        String name;
        BValue objName = this.get(OBJECT_NAME_OVERRIDE_SLOTNAME);
        if (objName instanceof BString && (name = ((BString)objName).getString()).length() > 0) {
            return name;
        }
        return this.objectName + "_" + this.getObjectId().getInstanceNumber();
    }

    @Override
    public void setObjectName(String objectName) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.localDevice.setObjectName"));
    }

    @Override
    public void checkConfiguration() {
        BIBacnetExportObject o;
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        boolean configOk = true;
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
        }
        if (Sys.getStation() != null && (o = BBacnetNetwork.localDevice().lookupBacnetObject(this.getObjectName())) != this) {
            this.setFaultCause("Duplicate Object_Name");
            configOk = false;
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
    }

    public String export(BIBacnetExportObject object) {
        return this.exports().export(object);
    }

    public String exportByOrd(BIBacnetExportObject object) {
        return this.exports().exportByOrd(object);
    }

    public void unexport(BBacnetObjectIdentifier objectId, String objectName, BIBacnetExportObject object) {
        this.exports().unexport(objectId, objectName, object);
        if (this.isRunning()) {
            this.checkDuplicates(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDuplicates(BIBacnetExportObject exclude) {
        Object object = this.CHECK_DUP_LOCK;
        synchronized (object) {
            if (this.checkDupTicket != null) {
                this.checkDupTicket.cancel();
            }
            this.checkDupTicket = Clock.schedule((BComponent)this, (BRelTime)CHECK_DUP_DELAY, (Action)checkDuplicates, null);
        }
    }

    public void doCheckDuplicates() {
        ComponentTreeCursor c = new ComponentTreeCursor((BComponent)this.exports(), null);
        BIBacnetExportObject e = null;
        while (c.next(BIBacnetExportObject.class)) {
            e = (BIBacnetExportObject)c.get();
            if (!e.getStatus().isFault()) continue;
            e.checkConfiguration();
        }
    }

    private BBacnetExportTable exports() {
        return (BBacnetExportTable)this.getExportTable();
    }

    public final BIBacnetExportObject lookupBacnetObject(BBacnetObjectIdentifier objectId) {
        if (this.getObjectId().equals((Object)objectId)) {
            return this;
        }
        return this.exports().byObjectId(objectId);
    }

    public final BIBacnetExportObject lookupBacnetObject(String objectName) {
        if (this.getObjectName().equals(objectName)) {
            return this;
        }
        return this.exports().byObjectName(objectName);
    }

    public final BBacnetObjectIdentifier lookupBacnetObjectId(BOrd objectOrd) {
        if (this.getObjectOrd().equals((Object)objectOrd)) {
            return this.getObjectId();
        }
        return this.exports().byObjectOrd(objectOrd);
    }

    public final int getNextInstance(int objectType) {
        return this.exports().getNextInstance(objectType);
    }

    public final void incrementDatabaseRevision() {
        this.setDatabaseRevision(this.getDatabaseRevision() + 1);
    }

    @Override
    public final BObject lookupBacnetObject(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex, String domain) {
        return (BObject)this.lookupBacnetObject(objectId);
    }

    public void doSendIAm() {
        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().iAm();
    }

    public void doSetBackupMode(BBoolean backupMode) {
        if (this.getSystemStatus().getOrdinal() == 3) {
            throw new IllegalStateException("Cannot modify backup mode while restore is in progress");
        }
        if (backupMode.getBoolean()) {
            log.info("Entering Backup Mode...");
            this.preBackupRestoreStatus = this.getSystemStatus();
            this.setBackupAndRestoreState(BBacnetBackupState.preparingForBackup);
            this.setSystemStatus(BBacnetDeviceStatus.backupInProgress);
        } else {
            log.info("Exiting Backup Mode...");
            this.setBackupAndRestoreState(BBacnetBackupState.idle);
            this.setSystemStatus(this.preBackupRestoreStatus);
            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().cleanupBackupMode();
        }
    }

    public void doSetRestoreMode(BBoolean restoreMode) {
        if (this.getSystemStatus().getOrdinal() == 5) {
            throw new IllegalStateException("Cannot modify restore mode while backup is in progress");
        }
        if (restoreMode.getBoolean()) {
            log.info("Entering Restore Mode...");
            this.preBackupRestoreStatus = this.getSystemStatus();
            this.setBackupAndRestoreState(BBacnetBackupState.preparingForRestore);
            this.setSystemStatus(BBacnetDeviceStatus.downloadInProgress);
        } else {
            log.info("Exiting Restore Mode...");
            this.setBackupAndRestoreState(BBacnetBackupState.idle);
            this.setSystemStatus(this.preBackupRestoreStatus);
            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().cleanupBackupMode();
        }
    }

    public void doPrintln(BString arg) {
        System.out.println("\n\n********\n" + arg + "\n********\n");
    }

    public final void doSendTimeSynch() {
        this.lastTSTime = BAbsTime.make();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending Automatic Time Synch...");
        }
        try {
            BBacnetClientLayer client = ((BBacnetStack)this.network().getBacnetComm()).getClient();
            SlotCursor c = this.getTimeSynchronizationRecipients().getProperties();
            BBacnetRecipient r = null;
            while (c.next(BBacnetRecipient.class)) {
                r = (BBacnetRecipient)c.get();
                if (r.isDevice() && (!r.getDevice().isValid() || DeviceRegistry.getDeviceAddress(r.getDevice()) == null)) continue;
                client.timeSynch(r);
            }
            c = this.getUtcTimeSynchronizationRecipients().getProperties();
            while (c.next(BBacnetRecipient.class)) {
                r = (BBacnetRecipient)c.get();
                if (r.isDevice() && (!r.getDevice().isValid() || DeviceRegistry.getDeviceAddress(r.getDevice()) == null)) continue;
                client.utcTimeSynch(r);
            }
        }
        catch (BacnetException e) {
            log.log(Level.WARNING, "BacnetException sending time synch {" + (Object)((Object)e) + "}", (Throwable)((Object)e));
        }
    }

    public void doSendRestartNotifications() {
        SlotCursor c = this.getRestartNotificationRecipients().getProperties();
        BBacnetClientLayer client = ((BBacnetStack)this.network().getBacnetComm()).getClient();
        while (c.next(BBacnetRecipient.class)) {
            BBacnetRecipient r = (BBacnetRecipient)c.get();
            if (r.isDevice() && (!r.getDevice().isValid() || DeviceRegistry.getDeviceAddress(r.getDevice()) == null)) continue;
            try {
                client.deviceRestartNotification(r);
            }
            catch (BacnetException e) {
                log.log(Level.WARNING, "BacnetException sending restart notification {" + (Object)((Object)e) + "}", (Throwable)((Object)e));
            }
        }
    }

    public void doChangeDeviceUuid(BUuid uuid) {
        if (BUuid.NULL.equals((Object)uuid)) {
            throw new LocalizableRuntimeException("bacnet", "localBacnetDevice.changeDeviceUuid.newValueNull");
        }
        if (BLocalBacnetDevice.hasEnabledScPort()) {
            throw new LocalizableRuntimeException("bacnet", "localBacnetDevice.changeDeviceUuid.scPortEnabled");
        }
        this.setDeviceUuid(uuid);
    }

    private static boolean hasEnabledScPort() {
        BNetworkPort[] ports;
        BBacnetStack comm = (BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm();
        for (BNetworkPort port : ports = (BNetworkPort[])comm.getNetwork().getChildren(BNetworkPort.class)) {
            if (!(port.getLink() instanceof BScLinkLayer) || !port.getEnabled()) continue;
            return true;
        }
        return false;
    }

    public final void addAddressBinding(BBacnetDevice device) {
        BBacnetAddressBinding b;
        BBacnetAddress address = (BBacnetAddress)device.getAddress().newCopy();
        BBacnetNetworkLayer net = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork();
        if (net.isDirectlyConnectedNetwork(address.getNetworkNumber())) {
            address.setNetworkNumber(0);
        }
        if ((b = this.bindingById(device.getObjectId())) == null) {
            b = new BBacnetAddressBinding(device.getObjectId(), address);
            this.getDeviceAddressBinding().addListElement((BValue)b, null);
        } else {
            b.getDeviceAddress().copyFrom((BComplex)address);
        }
        Flags.setAllReadonly((BComponent)this.getDeviceAddressBinding(), (boolean)true, null);
    }

    public final void removeAddressBinding(BBacnetDevice device) {
        BBacnetAddressBinding b = this.bindingById(device.getObjectId());
        if (b != null) {
            this.getDeviceAddressBinding().removeListElement((BValue)b, null);
        }
    }

    public final void updateAddressBinding(BBacnetObjectIdentifier oldId, BBacnetObjectIdentifier newId) {
        BBacnetAddressBinding b = this.bindingById(oldId);
        if (b != null) {
            b.setDeviceObjectId(newId);
        }
    }

    public final void updateAddressBinding(BBacnetAddress oldAddress, BBacnetAddress newAddress) {
        BBacnetAddressBinding b;
        BBacnetAddress address = (BBacnetAddress)oldAddress.newCopy();
        BBacnetNetworkLayer net = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork();
        if (net.isDirectlyConnectedNetwork(address.getNetworkNumber())) {
            address.setNetworkNumber(0);
        }
        if ((b = this.bindingByAddress(address)) != null) {
            b.getDeviceAddress().copyFrom((BComplex)newAddress);
        }
    }

    private BBacnetAddressBinding bindingById(BBacnetObjectIdentifier id) {
        SlotCursor sc = this.getDeviceAddressBinding().getProperties();
        while (sc.next(BBacnetAddressBinding.class)) {
            BBacnetAddressBinding b = (BBacnetAddressBinding)sc.get();
            if (!b.getDeviceObjectId().equals((Object)id)) continue;
            return b;
        }
        return null;
    }

    private BBacnetAddressBinding bindingByAddress(BBacnetAddress address) {
        if (address == null) {
            return null;
        }
        byte[] mac = address.getMacAddress().getBytes();
        SlotCursor sc = this.getDeviceAddressBinding().getProperties();
        while (sc.next(BBacnetAddressBinding.class)) {
            BBacnetAddressBinding b = (BBacnetAddressBinding)sc.get();
            if (!b.getDeviceAddress().macEquals(mac)) continue;
            return b;
        }
        return null;
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        if (!BLocalBacnetDevice.checkPropertyForReadMultiple(props[j])) continue;
                        results.add(this.readProperty(props[j]));
                    }
                    props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j]));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j]));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        if (!BLocalBacnetDevice.checkPropertyForReadMultiple(props[j])) continue;
                        results.add(this.readProperty(props[j]));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(new PropertyValue[0]);
    }

    private static boolean checkPropertyForReadMultiple(int property_id) {
        return property_id != 371;
    }

    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 30 && propertyId != 152 && propertyId != 202 && propertyId != 116 && propertyId != 206) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (rangeReference.getPropertyArrayIndex() != -1) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        switch (propertyId) {
            case 30: {
                Object[] addrList = (BBacnetAddressBinding[])this.getDeviceAddressBinding().getChildren(BBacnetAddressBinding.class);
                return this.readRange(rangeReference, addrList, 16);
            }
            case 152: {
                BOrd[] covOrdList = (BOrd[])this.getActiveCovSubscriptions().getChildren(BOrd.class);
                Object[] covList = new BBacnetCovSubscription[covOrdList.length];
                int j = 0;
                try {
                    for (j = 0; j < covOrdList.length; ++j) {
                        covList[j] = (BBacnetCovSubscription)covOrdList[j].get((BObject)this);
                    }
                    return this.readRange(rangeReference, covList, 44);
                }
                catch (Exception e) {
                    log.warning("Exception building Active_COV_Subscriptions[" + j + "] for ReadRange: " + e);
                    return new ReadRangeAck(0, 25);
                }
            }
            case 202: {
                SlotCursor rnC = this.getRestartNotificationRecipients().getProperties();
                ArrayList<BBacnetRecipient> rstPropsList = new ArrayList<BBacnetRecipient>();
                int m = 0;
                try {
                    while (rnC.next(BBacnetRecipient.class)) {
                        rstPropsList.add((BBacnetRecipient)rnC.get());
                    }
                    Object[] rstNotiList = new BBacnetRecipient[rstPropsList.size()];
                    for (m = 0; m < rstPropsList.size(); ++m) {
                        rstNotiList[m] = (BBacnetRecipient)rstPropsList.get(m);
                    }
                    return this.readRange(rangeReference, rstNotiList, 44);
                }
                catch (Exception e) {
                    log.warning("Exception building RESTART_NOTIFICATION_RECIPIENTS[" + m + "] for ReadRange: " + e);
                    return new ReadRangeAck(0, 25);
                }
            }
            case 116: {
                SlotCursor tsC = this.getTimeSynchronizationRecipients().getProperties();
                ArrayList<BBacnetRecipient> timeSyncOrdList = new ArrayList<BBacnetRecipient>();
                int k = 0;
                try {
                    while (tsC.next(BBacnetRecipient.class)) {
                        timeSyncOrdList.add((BBacnetRecipient)tsC.get());
                    }
                    Object[] timeSyncList = new BBacnetRecipient[timeSyncOrdList.size()];
                    for (k = 0; k < timeSyncOrdList.size(); ++k) {
                        timeSyncList[k] = (BBacnetRecipient)timeSyncOrdList.get(k);
                    }
                    return this.readRange(rangeReference, timeSyncList, 44);
                }
                catch (Exception e) {
                    log.warning("Exception building TIME_SYNCHRONIZATION_RECIPIENTS[" + k + "] for ReadRange: " + e);
                    return new ReadRangeAck(0, 25);
                }
            }
            case 206: {
                SlotCursor utsC = this.getUtcTimeSynchronizationRecipients().getProperties();
                ArrayList<BBacnetRecipient> utcTimeSyncOrdList = new ArrayList<BBacnetRecipient>();
                int l = 0;
                try {
                    while (utsC.next(BBacnetRecipient.class)) {
                        utcTimeSyncOrdList.add((BBacnetRecipient)utsC.get());
                    }
                    Object[] utcTimeSyncList = new BBacnetRecipient[utcTimeSyncOrdList.size()];
                    for (l = 0; l < utcTimeSyncOrdList.size(); ++l) {
                        utcTimeSyncList[l] = (BBacnetRecipient)utcTimeSyncOrdList.get(l);
                    }
                    return this.readRange(rangeReference, utcTimeSyncList, 44);
                }
                catch (Exception e) {
                    log.warning("Exception building UTC_TIME_SYNCHRONIZATION_RECIPIENTS[" + l + "] for ReadRange: " + e);
                    return new ReadRangeAck(0, 25);
                }
            }
        }
        return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotA_List);
    }

    private boolean hasProperty(int propertyId) {
        for (int id : REQUIRED_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : this.getOptionalProps()) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue val) throws BacnetException {
        return this.addListElements(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue());
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue val) throws BacnetException {
        return this.removeListElements(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue());
    }

    public int getDeviceTimeout() {
        return this.maxWaitTime;
    }

    boolean isArray(int propertyId) {
        if (propertyId == 76) {
            return true;
        }
        if (propertyId == 154) {
            return true;
        }
        return propertyId == 371;
    }

    private PropertyValue readProperty(int pId) {
        return this.readProperty(pId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyValue readProperty(int pId, int ndx) {
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            try {
                switch (pId) {
                    case 75: {
                        asnOut.writeObjectIdentifier(this.getObjectId());
                        break;
                    }
                    case 77: {
                        asnOut.writeCharacterString(this.getObjectName(), this.getCharacterSet());
                        break;
                    }
                    case 79: {
                        asnOut.writeEnumerated(this.getObjectId().getObjectType());
                        break;
                    }
                    case 371: {
                        return this.readPropertyList(ndx);
                    }
                    case 112: {
                        asnOut.writeEnumerated(this.getSystemStatus().getOrdinal());
                        break;
                    }
                    case 121: {
                        asnOut.writeCharacterString(this.getVendorName(), this.getCharacterSet());
                        break;
                    }
                    case 120: {
                        asnOut.writeUnsignedInteger(this.getVendorId());
                        break;
                    }
                    case 372: {
                        asnOut.writeCharacterString(SERIAL_NUMBER, this.getCharacterSet());
                        break;
                    }
                    case 70: {
                        asnOut.writeCharacterString(this.getModelName(), this.getCharacterSet());
                        break;
                    }
                    case 44: {
                        asnOut.writeCharacterString(this.getFirmwareRevision(), this.getCharacterSet());
                        break;
                    }
                    case 12: {
                        asnOut.writeCharacterString(this.getApplicationSoftwareVersion(), this.getCharacterSet());
                        break;
                    }
                    case 58: {
                        asnOut.writeCharacterString(this.getLocation(), this.getCharacterSet());
                        break;
                    }
                    case 28: {
                        asnOut.writeCharacterString(this.getDescription(), this.getCharacterSet());
                        break;
                    }
                    case 98: {
                        asnOut.writeUnsignedInteger(this.getProtocolVersion());
                        break;
                    }
                    case 139: {
                        asnOut.writeUnsignedInteger(this.getProtocolRevision());
                        break;
                    }
                    case 97: {
                        asnOut.writeBitString(this.getProtocolServicesSupported());
                        break;
                    }
                    case 96: {
                        asnOut.writeBitString(this.getProtocolObjectTypesSupported());
                        break;
                    }
                    case 76: {
                        if (ndx == 0) {
                            int size = this.exports().getSize();
                            asnOut.writeUnsignedInteger(size + 1);
                            break;
                        }
                        if (ndx == -1) {
                            asnOut.writeObjectIdentifier(this.getObjectId());
                            this.exports().writeObjectIds(asnOut);
                            break;
                        }
                        if (ndx == 1) {
                            asnOut.writeObjectIdentifier(this.getObjectId());
                            break;
                        }
                        asnOut.writeObjectIdentifier(this.exports().getEntry(ndx - 2));
                        break;
                    }
                    case 62: {
                        asnOut.writeUnsignedInteger(this.getMaxAPDULengthAccepted());
                        break;
                    }
                    case 107: {
                        asnOut.writeEnumerated(this.getSegmentationSupported().getOrdinal());
                        break;
                    }
                    case 167: {
                        int num = this.getMaxSegmentsAccepted();
                        if (num < 0) {
                            num = 100;
                        }
                        asnOut.writeUnsignedInteger(num);
                        break;
                    }
                    case 57: {
                        BAbsTime t = BAbsTime.make();
                        asnOut.writeTime(t.getHour(), t.getMinute(), t.getSecond(), t.getMillisecond() / 10);
                        break;
                    }
                    case 56: {
                        BAbsTime t0 = BAbsTime.make();
                        int wd = t0.getWeekday().getOrdinal();
                        if (wd == 0) {
                            wd = 7;
                        }
                        asnOut.writeDate(t0.getYear() - 1900, t0.getMonth().getOrdinal() + 1, t0.getDay(), wd);
                        break;
                    }
                    case 119: {
                        int niagaraMillis = BTimeZone.getLocal().getUtcOffset();
                        int off = (int)((long)(-niagaraMillis) / 60000L);
                        asnOut.writeSignedInteger(off);
                        break;
                    }
                    case 24: {
                        asnOut.writeBoolean(BAbsTime.make().inDaylightTime());
                        break;
                    }
                    case 10: {
                        asnOut.writeUnsignedInteger(this.getApduSegmentTimeout());
                        break;
                    }
                    case 11: {
                        asnOut.writeUnsignedInteger(this.getApduTimeout());
                        break;
                    }
                    case 73: {
                        asnOut.writeUnsignedInteger(this.getNumberOfApduRetries());
                        break;
                    }
                    case 116: {
                        this.getTimeSynchronizationRecipients().writeAsn(asnOut);
                        break;
                    }
                    case 64: {
                        BBacnetNetworkLayer net = ((BBacnetStack)((BBacnetNetwork)this.getParent()).getBacnetComm()).getNetwork();
                        SlotCursor sc = net.loadSlots().getProperties();
                        while (sc.next(BNetworkPort.class)) {
                            if (!(((BNetworkPort)sc.get()).getLink() instanceof BBacnetMstpLinkLayer)) continue;
                            asnOut.writeUnsignedInteger(((BBacnetMstpLinkLayer)((BNetworkPort)sc.get()).getLink()).getMaxMaster());
                            break;
                        }
                        if (asnOut.size() == 0) {
                            asnOut.writeUnsignedInteger(127L);
                        }
                        break;
                    }
                    case 63: {
                        BBacnetNetworkLayer net = ((BBacnetStack)((BBacnetNetwork)this.getParent()).getBacnetComm()).getNetwork();
                        SlotCursor sc = net.loadSlots().getProperties();
                        while (sc.next(BNetworkPort.class)) {
                            if (!(((BNetworkPort)sc.get()).getLink() instanceof BBacnetMstpLinkLayer)) continue;
                            asnOut.writeUnsignedInteger(((BBacnetMstpLinkLayer)((BNetworkPort)sc.get()).getLink()).getMaxInfoFrames());
                            break;
                        }
                        if (asnOut.size() == 0) {
                            asnOut.writeUnsignedInteger(1L);
                        }
                        break;
                    }
                    case 30: {
                        this.getDeviceAddressBinding().writeAsn(asnOut);
                        break;
                    }
                    case 155: {
                        asnOut.writeUnsignedInteger(this.getDatabaseRevision());
                        break;
                    }
                    case 154: {
                        if (ndx == 0) {
                            int size = this.getConfigurationFiles().getSize();
                            asnOut.writeUnsignedInteger(size);
                            break;
                        }
                        if (ndx == -1) {
                            this.getConfigurationFiles().writeAsn(asnOut);
                            break;
                        }
                        BBacnetObjectIdentifier id = (BBacnetObjectIdentifier)this.getConfigurationFiles().getElement(ndx);
                        if (id != null) {
                            asnOut.writeObjectIdentifier(id);
                            break;
                        }
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
                    }
                    case 157: {
                        this.getLastRestoreTime().writeAsn(asnOut);
                        break;
                    }
                    case 153: {
                        asnOut.writeUnsignedInteger(this.getBackupFailureTimeout().getMillis() / 1000L);
                        break;
                    }
                    case 152: {
                        this.getActiveCovSubscriptions().writeAsn(asnOut);
                        break;
                    }
                    case 206: {
                        this.getUtcTimeSynchronizationRecipients().writeAsn(asnOut);
                        break;
                    }
                    case 204: {
                        asnOut.writeUnsignedInteger(this.getTimeSynchronizationInterval().getMillis() / 60000L);
                        break;
                    }
                    case 193: {
                        asnOut.writeBoolean(this.getAlignIntervals());
                        break;
                    }
                    case 195: {
                        asnOut.writeUnsignedInteger(this.getIntervalOffset());
                        break;
                    }
                    case 338: {
                        asnOut.writeEnumerated(this.getBackupAndRestoreState().getOrdinal());
                        break;
                    }
                    case 339: {
                        asnOut.writeUnsignedInteger(this.getBackupPreparationTime().getSeconds());
                        break;
                    }
                    case 340: {
                        asnOut.writeUnsignedInteger(this.getRestoreCompletionTime().getSeconds());
                        break;
                    }
                    case 341: {
                        asnOut.writeUnsignedInteger(this.getRestorePreparationTime().getSeconds());
                        break;
                    }
                    case 196: {
                        asnOut.writeEnumerated(this.getLastRestartReason().getOrdinal());
                        break;
                    }
                    case 203: {
                        this.getTimeOfDeviceRestart().writeAsn(asnOut);
                        break;
                    }
                    case 202: {
                        this.getRestartNotificationRecipients().writeAsn(asnOut);
                        break;
                    }
                    default: {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
            }
            return new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RangeData readRange(RangeReference ref, Object[] list, int maxEncodedSize) {
        int rangeType = ref.getRangeType();
        int len = list.length;
        boolean[] rflags = new boolean[]{false, false, false};
        int maxDataLength = -1;
        if (ref instanceof BacnetConfirmedRequest) {
            maxDataLength = ((BacnetConfirmedRequest)((Object)ref)).getMaxDataLength() - 23 + 3 + 5;
        }
        if (rangeType == 3) {
            int i;
            int refNdx = (int)ref.getReferenceIndex();
            int count = ref.getCount();
            if (refNdx > len || refNdx < 1) {
                return new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
            }
            Array a = new Array(Object.class);
            int itemsFound = 0;
            if (count > 0) {
                for (i = refNdx - 1; i < len && itemsFound < count; ++itemsFound, ++i) {
                    a.add(list[i]);
                }
                if (refNdx == 1) {
                    rflags[0] = true;
                }
                if (refNdx + count - 1 >= len) {
                    rflags[1] = true;
                }
            } else if (count < 0) {
                count = -count;
                for (i = refNdx - 1; i >= 0 && itemsFound < count; ++itemsFound, --i) {
                    a.add(list[i]);
                }
                a = a.reverse();
                if (refNdx - count <= 0) {
                    rflags[0] = true;
                }
                if (refNdx == len) {
                    rflags[1] = true;
                }
            } else {
                return new ReadRangeAck(5, 7);
            }
            ListIterator it = a.iterator();
            int itemCount = 0;
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                if (maxDataLength > 0) {
                    while (it.hasNext()) {
                        if (maxDataLength - asnOut.size() < maxEncodedSize) {
                            rflags[1] = false;
                            break;
                        }
                        ((BIBacnetDataType)it.next()).writeAsn(asnOut);
                        ++itemCount;
                    }
                } else {
                    itemCount = itemsFound;
                    while (it.hasNext()) {
                        ((BIBacnetDataType)it.next()).writeAsn(asnOut);
                    }
                }
                if (itemCount < itemsFound) {
                    rflags[2] = true;
                }
                return new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
            }
        }
        if (rangeType == -1) {
            rflags[0] = false;
            int itemCount = 0;
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                if (maxDataLength > 0) {
                    for (int i = 0; i < len; ++i) {
                        ((BIBacnetDataType)list[i]).writeAsn(asnOut);
                        ++itemCount;
                        if (maxDataLength - asnOut.size() < maxEncodedSize) break;
                    }
                    if (itemCount > 0) {
                        rflags[0] = true;
                    }
                    if (itemCount > 0 && itemCount == len) {
                        rflags[1] = true;
                    }
                } else {
                    itemCount = len;
                    for (int i = 0; i < len; ++i) {
                        ((BIBacnetDataType)list[i]).writeAsn(asnOut);
                    }
                    if (itemCount > 0) {
                        rflags[0] = true;
                    }
                    if (itemCount > 0 && itemCount == len) {
                        rflags[1] = true;
                    }
                }
                if (itemCount < len) {
                    rflags[2] = true;
                }
                return new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
            }
        }
        if (rangeType == 6) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotNumbered);
        }
        if (rangeType == 7) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotTimestamped);
        }
        return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                long lval = 0L;
                switch (pId) {
                    case 75: {
                        return new NErrorType(2, 40);
                    }
                    case 58: {
                        this.setString(location, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 28: {
                        this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 116: {
                        asnIn.setBuffer(val);
                        BBacnetListOf tsRecips = (BBacnetListOf)this.getTimeSynchronizationRecipients().newCopy();
                        tsRecips.readAsn(asnIn);
                        this.set(timeSynchronizationRecipients, (BValue)tsRecips, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 202: {
                        asnIn.setBuffer(val);
                        BBacnetListOf rsRecips = (BBacnetListOf)this.getRestartNotificationRecipients().newCopy();
                        rsRecips.readAsn(asnIn);
                        this.set(restartNotificationRecipients, (BValue)rsRecips, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 153: {
                        lval = AsnUtil.fromAsnUnsignedInteger(val);
                        if (lval > 65535L) {
                            return new NErrorType(2, 37);
                        }
                        this.set(backupFailureTimeout, (BValue)BRelTime.make((long)(1000L * lval)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 206: {
                        asnIn.setBuffer(val);
                        BBacnetListOf utcTsRecips = (BBacnetListOf)this.getUtcTimeSynchronizationRecipients().newCopy();
                        utcTsRecips.readAsn(asnIn);
                        this.set(utcTimeSynchronizationRecipients, (BValue)utcTsRecips, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 204: {
                        BBacnetUnsigned unsigned = AsnUtil.fromAsnUnsigned(val);
                        long timeSynchIntervalMinutes = unsigned.getUnsigned();
                        this.set(timeSynchronizationInterval, (BValue)BRelTime.make((long)(timeSynchIntervalMinutes * 60000L)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 193: {
                        boolean align = AsnUtil.fromAsnBoolean(val);
                        this.setBoolean(alignIntervals, align, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 195: {
                        long offset = AsnUtil.fromAsnUnsignedInteger(val);
                        BFacets f = this.getSlotFacets((Slot)intervalOffset);
                        if (offset > (long)f.geti("max", 1440) || offset < (long)f.geti("min", 0)) {
                            return new NErrorType(2, 37);
                        }
                        this.setInt(intervalOffset, (int)offset, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 371: {
                        return new NErrorType(2, 40);
                    }
                }
                for (int i = 0; i < REQUIRED_PROPS.length; ++i) {
                    if (pId != REQUIRED_PROPS[i]) continue;
                    return new NErrorType(2, 40);
                }
                int[] props = this.getOptionalProps();
                for (int i = 0; i < props.length; ++i) {
                    if (pId != props[i]) continue;
                    return new NErrorType(2, 40);
                }
                return new NErrorType(2, 32);
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeListError addListElements(int pId, int ndx, byte[] val) throws BacnetException {
        if (!this.hasProperty(pId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (pId != 30 && pId != 152 && pId != 202 && pId != 116 && pId != 206) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (ndx != -1) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            switch (pId) {
                case 30: 
                case 152: {
                    return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
                case 116: {
                    return this.getTimeSynchronizationRecipients().addElements(val, BLocalBacnetDevice.getBacnetContext());
                }
                case 206: {
                    return this.getUtcTimeSynchronizationRecipients().addElements(val, BLocalBacnetDevice.getBacnetContext());
                }
                case 202: {
                    return this.getRestartNotificationRecipients().addElements(val, BLocalBacnetDevice.getBacnetContext());
                }
            }
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeListError removeListElements(int pId, int ndx, byte[] val) throws BacnetException {
        if (!this.hasProperty(pId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (pId != 30 && pId != 152 && pId != 202 && pId != 116 && pId != 206) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (ndx != -1) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            switch (pId) {
                case 30: 
                case 152: {
                    return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
                case 116: {
                    return this.getTimeSynchronizationRecipients().removeElements(val, BLocalBacnetDevice.getBacnetContext());
                }
                case 206: {
                    return this.getUtcTimeSynchronizationRecipients().removeElements(val, BLocalBacnetDevice.getBacnetContext());
                }
                case 202: {
                    return this.getRestartNotificationRecipients().removeElements(val, BLocalBacnetDevice.getBacnetContext());
                }
            }
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
    }

    private int[] getOptionalProps() {
        Vector<BBacnetPropertyIdentifier> v = new Vector<BBacnetPropertyIdentifier>();
        v.add(BBacnetPropertyIdentifier.location);
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.maxSegmentsAccepted);
        v.add(BBacnetPropertyIdentifier.localTime);
        v.add(BBacnetPropertyIdentifier.localDate);
        v.add(BBacnetPropertyIdentifier.utcOffset);
        v.add(BBacnetPropertyIdentifier.serialNumber);
        v.add(BBacnetPropertyIdentifier.daylightSavingsStatus);
        v.add(BBacnetPropertyIdentifier.apduSegmentTimeout);
        v.add(BBacnetPropertyIdentifier.timeSynchronizationRecipients);
        v.add(BBacnetPropertyIdentifier.maxMaster);
        v.add(BBacnetPropertyIdentifier.maxInfoFrames);
        v.add(BBacnetPropertyIdentifier.utcTimeSynchronizationRecipients);
        v.add(BBacnetPropertyIdentifier.timeSynchronizationInterval);
        v.add(BBacnetPropertyIdentifier.alignIntervals);
        v.add(BBacnetPropertyIdentifier.intervalOffset);
        v.add(BBacnetPropertyIdentifier.lastRestartReason);
        v.add(BBacnetPropertyIdentifier.timeOfDeviceRestart);
        this.addOptionalProps(v);
        int[] optionalProps = new int[v.size()];
        for (int i = 0; i < optionalProps.length; ++i) {
            optionalProps[i] = ((BEnum)v.elementAt(i)).getOrdinal();
        }
        return optionalProps;
    }

    protected void addOptionalProps(Vector<BBacnetPropertyIdentifier> v) {
        v.add(BBacnetPropertyIdentifier.activeCovSubscriptions);
        v.add(BBacnetPropertyIdentifier.restartNotificationRecipients);
        v.add(BBacnetPropertyIdentifier.configurationFiles);
        v.add(BBacnetPropertyIdentifier.lastRestoreTime);
        v.add(BBacnetPropertyIdentifier.backupFailureTimeout);
        v.add(BBacnetPropertyIdentifier.backupPreparationTime);
        v.add(BBacnetPropertyIdentifier.restorePreparationTime);
        v.add(BBacnetPropertyIdentifier.restoreCompletionTime);
        v.add(BBacnetPropertyIdentifier.backupAndRestoreState);
    }

    private BBacnetNetwork network() {
        return (BBacnetNetwork)this.getParent();
    }

    public void subscribeCov(BIBacnetCovSource export, BComponent src, Property p) {
        BBacnetCovSubscription cov = (BBacnetCovSubscription)((BComplex)export).get(p);
        if (cov.isCovProperty()) {
            this.covPropPoller.subscribe((BObject)cov);
        } else {
            this.covSubscriber.subscribe(export, src);
        }
        BOrd covOrd = BOrd.make((String)(((BComponent)export).getSlotPathOrd().toString() + "/" + p.getName()));
        Property sub = this.getActiveCovSubscriptions().addListElement((BValue)covOrd, null);
        this.getActiveCovSubscriptions().setFlags((Slot)sub, 1);
    }

    public void unsubscribeCov(BIBacnetCovSource export, BComponent src, Property p) {
        BBacnetCovSubscription cov = (BBacnetCovSubscription)((BComplex)export).get(p);
        if (cov.isCovProperty()) {
            this.covPropPoller.unsubscribe((BObject)cov);
        } else {
            Object[] children = ((BComponent)export).getChildren(BBacnetCovSubscription.class);
            if (children.length <= 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Removing cov subscription on " + export);
                }
                this.covSubscriber.unsubscribe(export, src);
            }
        }
        BOrd covOrd = BOrd.make((String)(((BComponent)export).getSlotPathOrd().toString() + "/" + p.getName()));
        this.getActiveCovSubscriptions().removeListElement((BValue)covOrd, null);
    }

    public void subscribe(BIBacnetExportObject export, Object src) {
        if (src instanceof BComponent) {
            this.objectSubscriber.subscribe(export, (BComponent)src);
        }
    }

    public void unsubscribe(BIBacnetExportObject export, Object src) {
        if (src instanceof BComponent) {
            this.objectSubscriber.unsubscribe(export, (BComponent)src);
        }
    }

    public void subscribeSpecialEvents(BBacnetScheduleDescriptor descriptor, BCompositeSchedule specialEvents) {
        this.specialEventsSubscriber.subscribe(descriptor, specialEvents);
    }

    public void unsubscribeSpecialEvents(BCompositeSchedule specialEvents) {
        this.specialEventsSubscriber.unsubscribe(specialEvents);
    }

    public static Context getBacnetContext() {
        if (bacnetContext == null) {
            try {
                BUserService us = (BUserService)Sys.getService((Type)BUserService.TYPE);
                BUser bacnetUser = us.getUser("BACnet");
                if (bacnetUser == null) {
                    bacnetUser = (BUser)us.get(us.add("BACnet", (BValue)new BUser()));
                }
                if (!bacnetUser.getEnabled()) {
                    throw new PermissionException("BACnet User not enabled");
                }
                bacnetContext = new BasicContext(bacnetUser);
            }
            catch (Exception e1) {
                log.log(Level.SEVERE, "Unable to retrieve BACnet user context", e1);
                throw new PermissionException("Error retrieving BACnet user context");
            }
        }
        return bacnetContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimeSynch() {
        Object object = this.TIME_SYNC_LOCK;
        synchronized (object) {
            BRelTime interval;
            long imillis;
            if (this.tsTicket != null) {
                this.tsTicket.cancel();
            }
            if ((imillis = (interval = this.getTimeSynchronizationInterval()).getMillis()) == 0L) {
                this.tsTicket = null;
                return;
            }
            BAbsTime now = BAbsTime.now();
            BAbsTime start = null;
            long nowMillis = now.getMillis();
            if (imillis > 0L) {
                if (this.getAlignIntervals()) {
                    if (3600000L % imillis == 0L) {
                        BAbsTime startOfHour = BAbsTime.make((int)now.getYear(), (BMonth)now.getMonth(), (int)now.getDay(), (int)now.getHour(), (int)0);
                        long startOfHourMillis = startOfHour.getMillis();
                        start = BLocalBacnetDevice.getNextInterval(startOfHourMillis, imillis, this.getIntervalOffset(), nowMillis);
                    } else if (86400000L % imillis == 0L) {
                        BAbsTime startOfDay = BAbsTime.make((int)now.getYear(), (BMonth)now.getMonth(), (int)now.getDay(), (int)0, (int)0);
                        long startOfDayMillis = startOfDay.getMillis();
                        start = BLocalBacnetDevice.getNextInterval(startOfDayMillis, imillis, this.getIntervalOffset(), nowMillis);
                    } else {
                        start = this.lastTSTime.add(interval);
                        if (start.isBefore(now)) {
                            now.add(interval);
                        }
                    }
                } else {
                    start = this.lastTSTime.add(interval);
                    if (start.isBefore(now)) {
                        now.add(interval);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder("BACnet Time Synchronization: every ");
                    sb.append(interval.toString((Context)BFacets.make((String)"showSeconds", (boolean)false))).append(", beginning at ").append(start.toString((Context)BFacets.make((String)"showSeconds", (boolean)false))).append(this.getAlignIntervals() ? ": aligned" : ": unaligned");
                    if (this.getAlignIntervals()) {
                        sb.append(", offset:").append(this.getIntervalOffset()).append(" min");
                    }
                    log.fine(sb.toString());
                }
                this.tsTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)start, (BRelTime)interval, (Action)sendTimeSynch, null);
            } else {
                log.fine("BACnet Time Synchronization disabled");
            }
        }
    }

    private static BAbsTime getNextInterval(long start, long interval, int offset, long now) {
        long offsetInterval = (long)offset * 60000L % interval;
        long next = start + offsetInterval;
        while ((next += interval) < now) {
        }
        return BAbsTime.make((long)next);
    }

    private void checkRecipients(Property p) {
        SlotCursor c = ((BComplex)this.get(p)).getProperties();
        BBacnetRecipient r = null;
        while (c.next(BBacnetRecipient.class)) {
            BBacnetObjectIdentifier deviceId;
            r = (BBacnetRecipient)c.get();
            if (!r.isDevice() || !(deviceId = r.getDevice()).isValid() || DeviceRegistry.getDeviceAddress(deviceId) != null) continue;
            try {
                ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, deviceId.getInstanceNumber(), deviceId.getInstanceNumber());
            }
            catch (BacnetException e) {
                log.log(Level.SEVERE, "Unable to determine address for Bacnet Time Synch Recipient " + (Object)((Object)deviceId), (Throwable)((Object)e));
            }
        }
    }

    public void updateSystemStatus(BBacnetDeviceStatus newStatus) {
        this.preBackupRestoreStatus = this.getSystemStatus();
        this.setSystemStatus(newStatus);
    }

    public void restoreSystemStatus() {
        this.setSystemStatus(this.preBackupRestoreStatus);
    }

    public PropertyInfo getPropertyInfo(int objectType, int propId) {
        PropertyInfo propInfo = ObjectTypeList.getInstance().getPropertyInfo(objectType, propId);
        if (propInfo == null) {
            propInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(propId), propId, -6);
        }
        return propInfo;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"LocalBacnetDevice", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)OBJECT_NAME_OVERRIDE_SLOTNAME, (Object)this.getObjectName());
        out.prop((Object)"preBackupRestoreStatus", (Object)this.preBackupRestoreStatus);
        out.prop((Object)"tsTicket", (Object)this.tsTicket);
        out.prop((Object)"lastTSTime", (Object)this.lastTSTime);
        out.trTitle((Object)"DeviceRegistry", 2);
        LongHashMap.Iterator it = DeviceRegistry.addressIterator();
        int i = 0;
        while (it.hasNext()) {
            out.prop((Object)("  " + i++), it.next());
        }
        out.prop((Object)"bacnetContext", (Object)bacnetContext);
        out.prop((Object)"COV subscription count", this.covSubscriber.getSubscriptionCount());
        this.covPropPoller.spy(out);
        out.endProps();
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        if (this.fatalFault) {
            return;
        }
        if (this.network().isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + this.network().getFaultCause());
            return;
        }
        this.setFaultCause("");
    }

    private void readBrandProperties() {
        if (this.brandPropertiesRead) {
            return;
        }
        AccessController.doPrivileged(() -> {
            InputStream is = null;
            try {
                BOrd ord = BOrd.make((String)"file:!etc/brand.properties");
                BIFile brandFile = (BIFile)ord.resolve().get();
                is = brandFile.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String line = br.readLine();
                while (line != null) {
                    block24: {
                        try {
                            line = line.trim();
                            if (line.startsWith("bacnetVendorId=")) {
                                int vid = 36;
                                try {
                                    vid = Integer.parseInt(line.substring(15));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.setVendorId(vid);
                                this.setVendorName(BacnetVendorUtil.getVendorName(vid));
                                break block24;
                            }
                            if (line.startsWith("modelName=")) {
                                String mn;
                                this.objectName = mn = line.substring(10);
                                this.setModelName(mn);
                            } else if (line.startsWith("applicationSoftwareVersion=")) {
                                String nAppSwVer = this.getType().getVendor() + " " + this.getType().getVendorVersion();
                                this.setApplicationSoftwareVersion(line.substring(27) + " - BACnet: " + nAppSwVer);
                            }
                        }
                        catch (Exception e) {
                            log.warning("Error parsing BACnet device branding information line: " + line + " (" + e + ")");
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (UnresolvedException ord) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error reading BACnet device branding information", e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                this.brandPropertiesRead = true;
            }
            return null;
        });
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, this.getOptionalProps());
    }

    static {
        CHECK_DUP_DELAY = BRelTime.makeSeconds((int)5);
        SERIAL_NUMBER = Nre.getHostId();
    }
}

