/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetLoopDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BPointExtension;
import javax.baja.control.BStringWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="outOfService", type="boolean", defaultValue="false"), @NiagaraProperty(name="presentValue", type="BValue", defaultValue="BBoolean.FALSE")})
public class BOutOfServiceExt
extends BPointExtension {
    @Generated
    public static final Property outOfService = BOutOfServiceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property presentValue = BOutOfServiceExt.newProperty((int)0, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOutOfServiceExt.class);
    private static final BPriorityLevel[] PRIORITY_LEVELS = new BPriorityLevel[]{BPriorityLevel.level_1, BPriorityLevel.level_2, BPriorityLevel.level_3, BPriorityLevel.level_4, BPriorityLevel.level_5, BPriorityLevel.level_6, BPriorityLevel.level_7, BPriorityLevel.level_8, BPriorityLevel.level_9, BPriorityLevel.level_10, BPriorityLevel.level_11, BPriorityLevel.level_12, BPriorityLevel.level_13, BPriorityLevel.level_14, BPriorityLevel.level_15, BPriorityLevel.level_16};
    private static final Context noExecuteContext = new BasicContext();
    BIBacnetExportObject export;
    boolean isCommandable;
    private boolean wasProxyExtEnabled = true;
    private final AtomicReference<Map<BLink, Boolean>> linkEnabledStates = new AtomicReference();

    @Generated
    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    @Generated
    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    @Generated
    public BValue getPresentValue() {
        return this.get(presentValue);
    }

    @Generated
    public void setPresentValue(BValue v) {
        this.set(presentValue, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.set(presentValue, this.getParentPoint().getOutStatusValue().getValueValue(), noExecuteContext);
        int presentValueFlags = this.getFlags((Slot)presentValue);
        this.setFlags((Slot)presentValue, presentValueFlags |= 1);
        this.reorderToTop();
    }

    private void reorderToTop() {
        this.getParentPoint().reorderToTop(this.getPropertyInParent());
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(outOfService)) {
            BControlPoint point = this.getParentPoint();
            this.setPresentValue(point.getOutStatusValue().getValueValue());
            if (this.getOutOfService()) {
                this.disableProxyExt(point);
            } else {
                this.restoreProxyExt(point);
            }
            if (this.export instanceof BBacnetLoopDescriptor && point.getType().toString().equals("kitControl:LoopPoint")) {
                if (this.getOutOfService()) {
                    point.set("loopEnable", (BValue)new BStatusBoolean(false));
                } else {
                    point.set("loopEnable", (BValue)new BStatusBoolean(true));
                }
            }
            if (BOutOfServiceExt.isValueDescriptor(this.export) && this.export instanceof BacnetWritableDescriptor) {
                if (this.getOutOfService()) {
                    this.disableInputLinks((BIWritablePoint)point, this.export);
                } else {
                    this.restoreInputLinks((BIWritablePoint)point, this.export);
                }
            }
            if (this.export instanceof BBacnetEventSource) {
                BBacnetEventSource eventSource = (BBacnetEventSource)this.export;
                eventSource.checkValid();
                eventSource.statusChanged();
            }
        }
        if (cx != noExecuteContext) {
            this.executePoint();
            if (this.export instanceof BIBacnetCovSource) {
                ((BIBacnetCovSource)((Object)this.export)).checkCov();
            }
        }
    }

    private void disableProxyExt(BControlPoint point) {
        BProxyExt proxyExt = this.getProxyExt(point);
        if (proxyExt != null) {
            this.wasProxyExtEnabled = proxyExt.getEnabled();
            proxyExt.setEnabled(false);
        }
    }

    private void restoreProxyExt(BControlPoint point) {
        BProxyExt proxyExt = this.getProxyExt(point);
        if (proxyExt != null && this.wasProxyExtEnabled) {
            proxyExt.setEnabled(true);
        }
    }

    private BProxyExt getProxyExt(BControlPoint point) {
        BAbstractProxyExt proxyExt = point.getProxyExt();
        if (proxyExt instanceof BProxyExt) {
            return (BProxyExt)proxyExt;
        }
        return null;
    }

    private static boolean isValueDescriptor(BIBacnetExportObject descriptor) {
        int type = descriptor.getObjectId().getObjectType();
        switch (type) {
            case 2: 
            case 5: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private void disableInputLinks(BIWritablePoint point, BIBacnetExportObject descriptor) {
        WeakHashMap<BLink, Boolean> linkEnabledStates = new WeakHashMap<BLink, Boolean>();
        for (BPriorityLevel level : PRIORITY_LEVELS) {
            BLink[] links;
            Property inProperty = point.getInProperty(level);
            for (BLink link : links = ((BControlPoint)point).getLinks((Slot)inProperty)) {
                if (link.getSourceComponent() == descriptor) continue;
                linkEnabledStates.put(link, link.getEnabled());
                link.setEnabled(false);
            }
        }
        this.linkEnabledStates.set(linkEnabledStates);
    }

    private void restoreInputLinks(BIWritablePoint point, BIBacnetExportObject descriptor) {
        Map linkEnabledStates = this.linkEnabledStates.getAndSet(null);
        for (BPriorityLevel level : PRIORITY_LEVELS) {
            BLink[] links;
            Property inProperty = point.getInProperty(level);
            for (BLink link : links = ((BControlPoint)point).getLinks((Slot)inProperty)) {
                Boolean enabledState;
                if (link.getSourceComponent() == descriptor) continue;
                boolean wasEnabled = true;
                if (linkEnabledStates != null && (enabledState = (Boolean)linkEnabledStates.get(link)) != null) {
                    wasEnabled = enabledState;
                }
                if (!wasEnabled) continue;
                link.setEnabled(true);
                if (!link.getSourceSlot().isProperty() || !link.getSourceSlot().isProperty()) continue;
                link.propagate(null);
            }
        }
    }

    public void onExecute(BStatusValue working, Context cx) {
        if (this.getOutOfService()) {
            BControlPoint point = this.getParentPoint();
            BProxyExt proxyExt = this.getProxyExt(point);
            if (this.isCommandable && proxyExt != null) {
                proxyExt.writeReset();
            }
            if (this.export instanceof BacnetWritableDescriptor) {
                if (proxyExt != null) {
                    BStatusValue inValue = this.getInValue((BIWritablePoint)this.getParentPoint());
                    working.setStatus(inValue.getStatus());
                    working.setValueValue(inValue.getValueValue());
                }
            } else {
                working.setValueValue(this.getPresentValue());
            }
            BStatus status = working.getStatus();
            status = BStatus.makeDisabled((BStatus)status, (boolean)false);
            status = BStatus.makeOverridden((BStatus)status, (boolean)true);
            working.setStatus(status);
        }
    }

    private BStatusValue getInValue(BIWritablePoint point) {
        BPriorityLevel activeLevel = this.getActiveLevel(point);
        if (activeLevel == BPriorityLevel.fallback) {
            if (point instanceof BBooleanWritable) {
                return ((BBooleanWritable)point).getFallback();
            }
            if (point instanceof BNumericWritable) {
                return ((BNumericWritable)point).getFallback();
            }
            if (point instanceof BEnumWritable) {
                return ((BEnumWritable)point).getFallback();
            }
            return ((BStringWritable)point).getFallback();
        }
        return point.getInStatusValue(activeLevel);
    }

    private BPriorityLevel getActiveLevel(BIWritablePoint point) {
        int activeLevel = 17;
        for (int level = 1; level <= 16; ++level) {
            BStatusValue in = point.getInStatusValue(BPriorityLevel.make((int)level));
            if (!in.getStatus().isValid()) continue;
            activeLevel = level;
            break;
        }
        return BPriorityLevel.make((int)activeLevel);
    }

    public BIBacnetExportObject getExport() {
        return this.export;
    }

    public void setExport(BIBacnetExportObject exp) {
        this.export = exp;
    }

    public void setCommandable(boolean commandable) {
        this.isCommandable = commandable;
    }
}

