/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.alarm.ext.BIAlarmMessages;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmInhibit", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)"), @NiagaraProperty(name="alarmState", type="BAlarmState", defaultValue="BAlarmState.normal", flags=65), @NiagaraProperty(name="timeDelay", type="BRelTime", defaultValue="BRelTime.DEFAULT", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)")}), @NiagaraProperty(name="alarmEnable", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.DEFAULT", facets={@Facet(value="BFacets.make(\"showOffNormal\", false)"), @Facet(value="BFacets.make(\"showAlert\", false)")}), @NiagaraProperty(name="ackedTransitions", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.ALL", flags=7), @NiagaraProperty(name="notifyType", type="BBacnetNotifyType", defaultValue="BBacnetNotifyType.alarm", facets={@Facet(value="BacUtil.makeBacnetNotifyTypeFacets()")}), @NiagaraProperty(name="toFaultTimes", type="BAlarmTimestamps", defaultValue="new BAlarmTimestamps()", flags=3), @NiagaraProperty(name="toFaultText", type="BFormat", defaultValue="BFormat.make(\"\")", facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="toNormalText", type="BFormat", defaultValue="BFormat.make(\"\")", facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="hyperlinkOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.ORD_RELATIVIZE", value="false"), @Facet(value="BFacets.make(\"chooseView\", true)")}), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"alarm:AlarmClassFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"alarm:AlarmClassEditor\"")}), @NiagaraProperty(name="reliability", type="BBacnetReliability", defaultValue="BBacnetReliability.noFaultDetected")})
@NiagaraActions(value={@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="timerElapsed", parameterType="BBacnetReliability", defaultValue="BBacnetReliability.noFaultDetected", flags=4)})
public class BReliabilityAlarmSourceExt
extends BPointExtension
implements BIAlarmSource,
BIAlarmMessages,
BacnetAlarmConst {
    @Generated
    public static final Property alarmInhibit = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    @Generated
    public static final Property alarmState = BReliabilityAlarmSourceExt.newProperty((int)65, (BValue)BAlarmState.normal, null);
    @Generated
    public static final Property timeDelay = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    @Generated
    public static final Property alarmEnable = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BAlarmTransitionBits.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showOffNormal", (boolean)false), (BFacets)BFacets.make((String)"showAlert", (boolean)false)));
    @Generated
    public static final Property ackedTransitions = BReliabilityAlarmSourceExt.newProperty((int)7, (BValue)BAlarmTransitionBits.ALL, null);
    @Generated
    public static final Property notifyType = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BacUtil.makeBacnetNotifyTypeFacets());
    @Generated
    public static final Property toFaultTimes = BReliabilityAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    @Generated
    public static final Property toFaultText = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property toNormalText = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property hyperlinkOrd = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"ordRelativize", (boolean)false), (BFacets)BFacets.make((String)"chooseView", (boolean)true)));
    @Generated
    public static final Property alarmClass = BReliabilityAlarmSourceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:AlarmClassFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Property reliability = BReliabilityAlarmSourceExt.newProperty((int)0, (BValue)BBacnetReliability.noFaultDetected, null);
    @Generated
    public static final Action ackAlarm = BReliabilityAlarmSourceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action timerElapsed = BReliabilityAlarmSourceExt.newAction((int)4, (BValue)BBacnetReliability.noFaultDetected, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BReliabilityAlarmSourceExt.class);
    long endTime;
    Clock.Ticket ticket;
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private BBacnetReliability reliabilityStored;
    private AlarmSupport support;

    @Generated
    public BStatusBoolean getAlarmInhibit() {
        return (BStatusBoolean)this.get(alarmInhibit);
    }

    @Generated
    public void setAlarmInhibit(BStatusBoolean v) {
        this.set(alarmInhibit, (BValue)v, null);
    }

    @Generated
    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    @Generated
    public void setAlarmState(BAlarmState v) {
        this.set(alarmState, (BValue)v, null);
    }

    @Generated
    public BRelTime getTimeDelay() {
        return (BRelTime)this.get(timeDelay);
    }

    @Generated
    public void setTimeDelay(BRelTime v) {
        this.set(timeDelay, (BValue)v, null);
    }

    @Generated
    public BAlarmTransitionBits getAlarmEnable() {
        return (BAlarmTransitionBits)this.get(alarmEnable);
    }

    @Generated
    public void setAlarmEnable(BAlarmTransitionBits v) {
        this.set(alarmEnable, (BValue)v, null);
    }

    @Generated
    public BAlarmTransitionBits getAckedTransitions() {
        return (BAlarmTransitionBits)this.get(ackedTransitions);
    }

    @Generated
    public void setAckedTransitions(BAlarmTransitionBits v) {
        this.set(ackedTransitions, (BValue)v, null);
    }

    @Generated
    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    @Generated
    public void setNotifyType(BBacnetNotifyType v) {
        this.set(notifyType, (BValue)v, null);
    }

    @Generated
    public BAlarmTimestamps getToFaultTimes() {
        return (BAlarmTimestamps)this.get(toFaultTimes);
    }

    @Generated
    public void setToFaultTimes(BAlarmTimestamps v) {
        this.set(toFaultTimes, (BValue)v, null);
    }

    @Generated
    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    @Generated
    public void setToFaultText(BFormat v) {
        this.set(toFaultText, (BValue)v, null);
    }

    @Generated
    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    @Generated
    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    @Generated
    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    @Generated
    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public BBacnetReliability getReliability() {
        return (BBacnetReliability)this.get(reliability);
    }

    @Generated
    public void setReliability(BBacnetReliability v) {
        this.set(reliability, (BValue)v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public void timerElapsed(BBacnetReliability parameter) {
        this.invoke(timerElapsed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BReliabilityAlarmSourceExt() {
        this.cancelTimer();
    }

    public final void started() throws Exception {
        super.started();
        this.cancelTimer();
        this.support = new AlarmSupport((BIAlarmSource)this, "");
        if (this.reliabilityStored != null) {
            if (!this.reliabilityStored.equals(this.getReliability())) {
                this.reliabilityChanged(this.reliabilityStored);
            }
            this.reliabilityStored = null;
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        this.cancelTimer();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        this.cancelTimer();
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Acknowledging the alarm " + ackRequest.getSourceState());
        }
        try {
            this.updateAlarmTimeProps(ackRequest, false, true);
            return BBoolean.make((boolean)this.support.ackAlarm(ackRequest));
        }
        catch (Exception e) {
            logger.severe("Unable to acknowledge the alarm: " + e);
            return BBoolean.make((boolean)false);
        }
    }

    public void doTimerElapsed(BBacnetReliability reliability) {
        if (this.isTimerExpired()) {
            this.alarmProcessing(reliability);
        }
    }

    public void alarmProcessing(BBacnetReliability reliability) {
        this.setReliability(reliability);
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Reliability has changed to " + reliability);
            }
            if (reliability == BBacnetReliability.noFaultDetected) {
                HashMap<String, BIDataValue> map = this.getAlarmFacet(reliability, true);
                this.support.toNormal(BFacets.make(map), null);
                this.setAlarmState(BAlarmState.normal);
                this.updateAlarmTimeProps(null, true);
            } else {
                HashMap<String, BIDataValue> map = this.getAlarmFacet(reliability, false);
                BAlarmRecord alarmRecord = this.support.newFaultAlarm(BFacets.make(map));
                this.setAlarmState(BAlarmState.fault);
                this.updateAlarmTimeProps(alarmRecord, false);
            }
        }
        catch (Exception e) {
            logger.severe("Unable to process tha alarm for Reliability changed: " + e);
        }
    }

    public void reliabilityChanged(BBacnetReliability reliability) {
        if (!this.isRunning()) {
            this.reliabilityStored = reliability;
            return;
        }
        if (this.getAlarmInhibit().getBoolean()) {
            logger.warning("Alarm inhibit is enabled, alarm cannot be processed.");
            return;
        }
        if (this.getTimeDelay().getMillis() > 0L) {
            this.startTimer(this.getTimeDelay().getMillis(), reliability);
        } else {
            this.alarmProcessing(reliability);
        }
    }

    private void updateAlarmTimeProps(BAlarmRecord alarm, boolean isNormal) {
        this.updateAlarmTimeProps(alarm, isNormal, false);
    }

    private void updateAlarmTimeProps(BAlarmRecord alarm, boolean isNormal, boolean isAck) {
        Property alarmTimesProp = toFaultTimes;
        BAlarmTimestamps alarmTimes = (BAlarmTimestamps)this.get(alarmTimesProp);
        if (isNormal) {
            alarmTimes.setNormalTime(BAbsTime.now());
        } else {
            alarmTimes.setAlarmTime(alarm.getTimestamp());
            alarmTimes.setCount(alarmTimes.getCount() + 1);
        }
        if (isAck) {
            alarmTimes.setAckTime(alarm.getAckTime());
        }
    }

    private HashMap<String, BIDataValue> getAlarmFacet(BBacnetReliability reliability, boolean isNormalAlarm) {
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>();
        BOrd ord = this.getHyperlinkOrd();
        map.put("alarmValue", (BIDataValue)BString.make((String)reliability.getTag()));
        map.put("fromState", (BIDataValue)BString.make((String)this.getAlarmState().getTag()));
        map.put("toState", (BIDataValue)BString.make((String)(isNormalAlarm ? BAlarmState.normal.getTag() : BAlarmState.fault.getTag())));
        map.put("msgText", (BIDataValue)BString.make((String)(isNormalAlarm ? this.getToNormalText().getFormat() : this.getToFaultText().getFormat())));
        map.put("hyperlinkOrd", (BIDataValue)BString.make((String)ord.toString()));
        map.put("notifyType", (BIDataValue)BString.make((String)this.getNotifyType().getTag()));
        return map;
    }

    public void onExecute(BStatusValue out, Context cx) {
    }

    public BFormat getToOffnormalText() {
        return null;
    }

    protected void startTimer(long timeDelay, BBacnetReliability reliability) {
        this.endTime = Clock.ticks() + timeDelay;
        if (this.isRunning()) {
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)timeDelay), (Action)timerElapsed, (BValue)reliability);
        }
    }

    protected void cancelTimer() {
        this.endTime = -1L;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    protected boolean isTimerExpired() {
        long now = Clock.ticks();
        if (this.endTime == -1L) {
            throw new IllegalStateException();
        }
        return now >= this.endTime;
    }
}

