/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.logging.Logger;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetOptionalBinaryLightingPv;
import javax.baja.bacnet.datatypes.BBacnetOptionalBinaryPv;
import javax.baja.bacnet.datatypes.BBacnetOptionalBitString;
import javax.baja.bacnet.datatypes.BBacnetOptionalCharacterString;
import javax.baja.bacnet.datatypes.BBacnetOptionalDate;
import javax.baja.bacnet.datatypes.BBacnetOptionalDatePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalDateTime;
import javax.baja.bacnet.datatypes.BBacnetOptionalDateTimePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalDoorValue;
import javax.baja.bacnet.datatypes.BBacnetOptionalDouble;
import javax.baja.bacnet.datatypes.BBacnetOptionalInteger;
import javax.baja.bacnet.datatypes.BBacnetOptionalOctetString;
import javax.baja.bacnet.datatypes.BBacnetOptionalReal;
import javax.baja.bacnet.datatypes.BBacnetOptionalTime;
import javax.baja.bacnet.datatypes.BBacnetOptionalTimePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalUnsigned;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.virtual.BBacnetVirtualObject;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BVirtualPropertyWrite
extends BAction
implements BacnetConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BVirtualPropertyWrite.class);
    private static final Logger logger = Logger.getLogger("bacnet.virtual");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BValue getParameterDefault() {
        BBacnetVirtualProperty property = (BBacnetVirtualProperty)this.getParent();
        BBacnetVirtualObject object = property.object();
        BValue value = property.getValue();
        if (object.getPrioritizedPoint() && property.getPropertyId() == 85) {
            int objectType = object.getObjectId().getObjectType();
            return BVirtualPropertyWrite.makePriorityValue(objectType, value);
        }
        return property.getValue().newCopy();
    }

    private static BValue makePriorityValue(int objectType, BValue presentValue) {
        switch (objectType) {
            case 1: 
            case 2: 
            case 54: {
                return new BBacnetOptionalReal(((BFloat)presentValue).getFloat());
            }
            case 4: 
            case 5: {
                return new BBacnetOptionalBinaryPv((BBacnetBinaryPv)presentValue);
            }
            case 14: 
            case 19: 
            case 48: {
                return new BBacnetOptionalUnsigned((BBacnetUnsigned)presentValue);
            }
            case 40: {
                return new BBacnetOptionalCharacterString(((BString)presentValue).getString());
            }
            case 39: {
                return new BBacnetOptionalBitString((BBacnetBitString)presentValue);
            }
            case 47: {
                return new BBacnetOptionalOctetString((BBacnetOctetString)presentValue);
            }
            case 46: {
                return new BBacnetOptionalDouble(((BDouble)presentValue).getDouble());
            }
            case 45: {
                return new BBacnetOptionalInteger(((BInteger)presentValue).getInt());
            }
            case 42: {
                return new BBacnetOptionalDate(((BBacnetDate)presentValue).toBDate());
            }
            case 41: {
                return new BBacnetOptionalDatePattern((BBacnetDate)presentValue);
            }
            case 50: {
                return new BBacnetOptionalTime(((BBacnetTime)presentValue).toBTime());
            }
            case 49: {
                return new BBacnetOptionalTimePattern((BBacnetTime)presentValue);
            }
            case 44: {
                return new BBacnetOptionalDateTime(((BBacnetDateTime)presentValue).toBAbsTime());
            }
            case 43: {
                return new BBacnetOptionalDateTimePattern((BBacnetDateTime)presentValue.newCopy());
            }
            case 30: {
                return new BBacnetOptionalDoorValue((BBacnetDoorValue)presentValue);
            }
            case 55: {
                return new BBacnetOptionalBinaryLightingPv((BBacnetBinaryLightingPv)presentValue);
            }
        }
        throw new IllegalArgumentException("Object type not supported when making priority value for present value property: " + BBacnetObjectType.tag(objectType));
    }

    public Type getParameterType() {
        BBacnetVirtualProperty bvp = (BBacnetVirtualProperty)this.getParent();
        return bvp.getValue().getType();
    }

    public Type getReturnType() {
        return null;
    }

    public BValue invoke(BComponent target, BValue arg) throws Exception {
        BBacnetVirtualProperty bvp = (BBacnetVirtualProperty)target;
        BValue currentValue = bvp.getValue();
        boolean audit = bvp.auditWrites();
        if (bvp.object().getPrioritizedPoint() && bvp.getPropertyId() == 85) {
            byte[] encodedValue = AsnUtil.toAsn(arg);
            bvp.write(-1, encodedValue, bvp.object().getWritePriority());
        } else if (!currentValue.equals((Object)arg)) {
            if (bvp.getValue() instanceof BBacnetArray) {
                if (arg instanceof BBacnetArray) {
                    BBacnetArray cur = (BBacnetArray)currentValue;
                    BBacnetArray nue = (BBacnetArray)arg;
                    int len = nue.getSize();
                    for (int i = 1; i <= len; ++i) {
                        if (cur.getElement(i).equivalent((Object)nue.getElement(i))) continue;
                        bvp.write(i, AsnUtil.toAsn(nue.getElement(i)), -1);
                    }
                    bvp.setValue((BValue)nue, noWrite);
                } else {
                    int index = bvp.getArrayIndex();
                    bvp.write(index, AsnUtil.toAsn(arg), -1);
                }
            } else {
                bvp.setValue(arg);
                audit = false;
            }
        } else {
            byte[] encodedValue = AsnUtil.toAsn(arg);
            bvp.write(-1, encodedValue, -1);
        }
        if (audit) {
            AuditEvent event = new AuditEvent("Changed", bvp.getAuditName(), "value", currentValue.toString(), arg.toString(), "");
            try {
                Auditor a = Sys.getAuditor();
                a.audit(event);
            }
            catch (ServiceNotFoundException e) {
                logger.info("Could not find AuditHistoryService to log audit event:" + event);
            }
        }
        return null;
    }
}

