/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.job;

import com.tridium.bacnet.asn.NEnrollmentSummary;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetOws.datatypes.BGetESummConfig;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BGetEnrollmentSummaryJob
extends BDeviceManagerJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BGetEnrollmentSummaryJob.class);
    private BGetESummConfig params;
    static Lexicon lex = Lexicon.make((String)"bacnetOws");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BGetEnrollmentSummaryJob() {
    }

    public BGetEnrollmentSummaryJob(BBacnetNetwork bacnet, BGetESummConfig params) {
        super(bacnet);
        this.params = params;
        this.add("filter", (BValue)params);
    }

    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting enrollment information from " + this.params.getDeviceAddress() + "\nCriteria:" + (Object)((Object)this.params));
        }
        try {
            Vector esum = this.client().getEnrollmentSummary(this.params.getDeviceAddress(), this.params.getAcknowledgmentFilter().getOrdinal(), this.params.getEnrollmentFilter(), this.params.getEventState().getOrdinal(), this.params.getEventTypeFilter(), new int[]{this.params.getPriority().getMinPriority(), this.params.getPriority().getMaxPriority()}, this.params.getNotificationClassFilter());
            logger.fine("Enrollment Summary response:");
            Iterator it = esum.iterator();
            int i = 0;
            while (it.hasNext()) {
                NEnrollmentSummary nesum = (NEnrollmentSummary)it.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("\nEnrollmentSummary #" + ++i + ":" + nesum);
                }
                this.add(null, (BValue)nesum.toJob());
            }
            logger.fine("\n");
            this.log().success(lex.getText("getESumm.success"));
            this.complete(BJobState.success);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception sending GetEnrollmentSummary to " + this.params.getDeviceAddress() + ": " + e, e);
            String msg = MessageFormat.format(lex.getText("getESumm.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            throw e;
        }
    }
}

