/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BINiagaraVirtualPropertySubstitute;
import com.tridium.nv.BNiagaraVirtualComponentInfo;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.BSlotType;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.NiagaraVirtualPropertyHandler;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.VirtualSlotNameParser;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.IProxyActionParent;
import com.tridium.sys.station.BStationScheme;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BHandleScheme;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BFormat;
import javax.baja.util.BIFormatPropertyHandler;
import javax.baja.util.BNameList;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualScheme;
import javax.baja.virtual.VirtualPath;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="icon", type="BIcon", defaultValue="DEFAULT_ICON", flags=261), @NiagaraProperty(name="niagaraVirtualCompInfo", type="BNiagaraVirtualComponentInfo", defaultValue="new BNiagaraVirtualComponentInfo()", flags=257)})
@NiagaraActions(value={@NiagaraAction(name="niagaraVirtualCompCheckActions", flags=260), @NiagaraAction(name="getProxyActionDefault", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BValue", flags=260), @NiagaraAction(name="niagaraVirtualCompUpdateStatus", flags=20), @NiagaraAction(name="niagaraVirtualCompDeviceStatusChanged", flags=20)})
public class BNiagaraVirtualComponent
extends BVirtualComponent
implements IProxyActionParent,
BIStatus,
BIFormatPropertyHandler,
BIAgent {
    private static final BIcon GHOST_ICON = BIcon.std((String)"badges/ghost.png");
    private static final BIcon DEFAULT_ICON = BNiagaraVirtualComponent.makeVirtualIcon(BIcon.std((String)"object.png"));
    @Generated
    public static final Property icon = BNiagaraVirtualComponent.newProperty((int)261, (BValue)DEFAULT_ICON, null);
    @Generated
    public static final Property niagaraVirtualCompInfo = BNiagaraVirtualComponent.newProperty((int)257, (BValue)new BNiagaraVirtualComponentInfo(), null);
    @Generated
    public static final Action niagaraVirtualCompCheckActions = BNiagaraVirtualComponent.newAction((int)260, null);
    @Generated
    public static final Action getProxyActionDefault = BNiagaraVirtualComponent.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action niagaraVirtualCompUpdateStatus = BNiagaraVirtualComponent.newAction((int)20, null);
    @Generated
    public static final Action niagaraVirtualCompDeviceStatusChanged = BNiagaraVirtualComponent.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualComponent.class);
    private final HandlerArray propertyHandlerArray = new HandlerArray();
    private boolean actionFetchRequired = true;
    private final Object monitor = new Object();
    private boolean mappedToNiagaraVirtual = false;
    private BStatus mappedStatus;
    private BNiagaraVirtualGateway gw;
    public static final String NIAGARA_VIRTUAL = "nVirtual";
    public static final String NIAGARA_VIRTUAL_WRITABLE = "nVirtualW";
    public static final String NIAGARA_VIRTUAL_SLOT_NAME = "nVirtualSN";
    public static final String NIAGARA_VIRTUAL_FROZEN = "nVirtualFroz";
    public static final String NIAGARA_VIRTUAL_COMP_TYPE_SPEC = "nVirtualTS";
    public static final String NIAGARA_VIRTUAL_PX_VIEW_SLOTS = "nVirtualPxViewNames";
    public static final int NIAGARA_VIRTUAL_SLOT_FLAG = 0x10000000;
    public static final char POST_ID_SEP = ';';
    public static final char PROP_FROZEN = 'f';
    public static final char PROP_DYNAMIC = 'd';
    private static final Set<String> VALID_ORD_SCHEMES = Collections.unmodifiableSet(Stream.of(BStationScheme.INSTANCE.getId(), BSlotScheme.INSTANCE.getId(), BHandleScheme.INSTANCE.getId(), BVirtualScheme.INSTANCE.getId(), "nspace").collect(Collectors.toSet()));

    @Generated
    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    @Generated
    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    @Generated
    public BNiagaraVirtualComponentInfo getNiagaraVirtualCompInfo() {
        return (BNiagaraVirtualComponentInfo)this.get(niagaraVirtualCompInfo);
    }

    @Generated
    public void setNiagaraVirtualCompInfo(BNiagaraVirtualComponentInfo v) {
        this.set(niagaraVirtualCompInfo, (BValue)v, null);
    }

    @Generated
    public void niagaraVirtualCompCheckActions() {
        this.invoke(niagaraVirtualCompCheckActions, null, null);
    }

    @Override
    @Generated
    public BValue getProxyActionDefault(BString parameter) {
        return this.invoke(getProxyActionDefault, (BValue)parameter, null);
    }

    @Generated
    public void niagaraVirtualCompUpdateStatus() {
        this.invoke(niagaraVirtualCompUpdateStatus, null, null);
    }

    @Generated
    public void niagaraVirtualCompDeviceStatusChanged() {
        this.invoke(niagaraVirtualCompDeviceStatusChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final BNiagaraVirtualComponent make(BTypeSpec typeSpec) {
        BNiagaraVirtualComponent comp = null;
        try {
            Type t = typeSpec.getResolvedType();
            AgentList list = Sys.getRegistry().getAgents(t.getTypeInfo());
            comp = (BNiagaraVirtualComponent)list.filter(AgentFilter.is((Type)TYPE)).getDefault().getInstance();
        }
        catch (NoSuchAgentException | ModuleException | TypeException throwable) {
            // empty catch block
        }
        if (comp == null) {
            comp = new BNiagaraVirtualComponent();
        }
        return comp;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 17: {
                this.fwSubscribed();
                break;
            }
            case 18: {
                this.fwUnsubscribed();
                break;
            }
            case 3: {
                this.fwAdded((Property)a, (Context)b);
                break;
            }
            case 4: {
                this.fwRemoved((Property)a, (BValue)b, (Context)c);
                break;
            }
            case 2: {
                this.fwChanged((Property)a, (Context)b);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        Property[] props = this.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            this.addToPropHandler(props[i]);
        }
    }

    private void fwStopped() {
        NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].stop();
        }
        this.propertyHandlerArray.clear();
    }

    private void fwSubscribed() {
        if (!this.isRunning()) {
            return;
        }
        if (this.actionFetchRequired) {
            NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
            if (handlers.length == 0) {
                this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().postAsync((Runnable)new Invocation((BComponent)this, niagaraVirtualCompCheckActions, null, null));
                this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)false));
            } else {
                for (int i = 0; i < handlers.length; ++i) {
                    if (i == 0) {
                        handlers[i].fetchActionsForComponent();
                    }
                    handlers[i].subscribed();
                }
            }
        }
        this.niagaraVirtualCompUpdateStatus();
    }

    private void fwUnsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
        }
        this.unsubscribeHandlers();
    }

    private void fwAdded(Property property, Context context) {
        if (this.isRunning()) {
            BVirtualAction proxyAction;
            BAction action;
            this.addToPropHandler(property);
            if (property.isAction() && (action = (BAction)this.get(property)) instanceof BVirtualAction && (proxyAction = (BVirtualAction)action).getProxyActionName().equals("set") && this.get("set") == null) {
                BTypeSpec returnTypeSpec = proxyAction.getReturnTypeSpec();
                Type returnType = returnTypeSpec.isNull() ? null : returnTypeSpec.getResolvedType();
                BTypeSpec paramTypeSpec = proxyAction.getParamTypeSpec();
                Type paramType = paramTypeSpec.isNull() ? null : paramTypeSpec.getResolvedType();
                BVirtualAction newAction = new BVirtualAction(proxyAction.getProxyActionName(), proxyAction.getProxyActionDisplayName(), returnType, paramType, proxyAction.getProxyActionFlags(), proxyAction.getFacets());
                int flags = this.getFlags((Slot)property) | 4;
                this.add("set", (BValue)newAction, flags &= 0xEFFFFFFF, this.getSlotFacets((Slot)property), context);
            }
        } else {
            if (property.isTopic()) {
                return;
            }
            if (property.isAction()) {
                return;
            }
            BValue val = this.get(property);
            if (!val.isComponent()) {
                BFacets facets = this.getSlotFacets((Slot)property);
                int flags = this.getFlags((Slot)property);
                int newFlags = NiagaraVirtualUtil.getVirtualFlags(val, flags, facets);
                if (newFlags != flags) {
                    this.setFlags((Slot)property, newFlags);
                }
            }
        }
    }

    private void fwRemoved(Property property, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        NiagaraVirtualPropertyHandler handler = this.propertyHandlerArray.findAndRemove(property);
        if (handler != null) {
            handler.stop();
        }
    }

    private void fwChanged(Property property, Context context) {
        if (this.isRunning() && context != NiagaraVirtualPropertyHandler.readUpdateContext && !property.isAction() && !property.isTopic() && Flags.isUserDefined1((BComplex)this, (Slot)property) && !Flags.isReadonly((BComplex)this, (Slot)property)) {
            NiagaraVirtualPropertyHandler handler;
            BValue val = this.get(property);
            if (val.isComponent()) {
                return;
            }
            if (property == niagaraVirtualCompInfo) {
                this.getLog().log(Level.SEVERE, "Invalid State -> Attempting to write Virtual Comp Info!");
            }
            if ((handler = this.propertyHandlerArray.find(property)) == null) {
                this.getLog().log(Level.SEVERE, "Could not perform Niagara Virtual Component write. Could not find Property Handler");
                return;
            }
            if (val instanceof BINiagaraVirtualPropertySubstitute && (val = ((BINiagaraVirtualPropertySubstitute)val).nvWrite(this)) == null) {
                if (this.getLog().isLoggable(Level.FINE)) {
                    this.getLog().fine("Could not perform Niagara Virtual Component write. Could not get valid Property to write for INiagaraVirtualPropertySubstitute");
                }
                return;
            }
            this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().postAsync(new WriteRequest(this, handler, val));
        }
    }

    public final String getDisplayName(Slot slot, Context cx) {
        if ((slot.isProperty() || slot.isAction()) && slot != niagaraVirtualCompInfo && (this.getFlags(slot) & 0x10000000) == 0x10000000) {
            BNameMap nameMap;
            BFormat format;
            Property p = this.getProperty("displayNames");
            if (p != null && p.getType().is(BNameMap.TYPE) && (format = (nameMap = (BNameMap)this.get(p)).get(slot.getName())) != null) {
                return format.format(null, cx);
            }
            try {
                BFacets facets = this.getSlotFacets(slot);
                boolean frozen = facets.getb(NIAGARA_VIRTUAL_FROZEN, false);
                String slotName = facets.gets(NIAGARA_VIRTUAL_SLOT_NAME, slot.getName());
                try {
                    slotName = VirtualSlotNameParser.make(SlotPath.unescape((String)slotName)).parsePartial().getSlotName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!frozen) {
                    BValue val = this.get((Property)slot);
                    if (val instanceof BNiagaraVirtualComponent) {
                        String orgTypeSpec = facets.gets(NIAGARA_VIRTUAL_COMP_TYPE_SPEC, "");
                        if (orgTypeSpec.length() > 0) {
                            try {
                                Type t = Sys.getType((String)orgTypeSpec);
                                BObject defaultObj = t.getInstance();
                                if (defaultObj instanceof BIMixIn) {
                                    return ((BIMixIn)defaultObj).getDisplayNameInParent(cx);
                                }
                            }
                            catch (Exception t) {}
                        }
                    } else if (val instanceof BIMixIn) {
                        return ((BIMixIn)val).getDisplayNameInParent(cx);
                    }
                }
                try {
                    Type t = Sys.getType((String)this.getNiagaraVirtualCompInfo().getTypeSpec());
                    String module = t.getModule().getModuleName();
                    String n = Lexicon.make((String)module, (Context)cx).get(slotName);
                    if (n != null) {
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (frozen) {
                    return TextUtil.toFriendly((String)slotName);
                }
                return SlotPath.unescape((String)slotName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getDisplayName(slot, cx);
    }

    public final BFacets getSlotFacets(Slot slot) {
        BFacets facets = super.getSlotFacets(slot);
        if (Flags.isUserDefined1((BComplex)this, (Slot)slot)) {
            return BFacets.make((BFacets)facets, (String)NIAGARA_VIRTUAL, (BIDataValue)BBoolean.TRUE);
        }
        return facets;
    }

    public boolean isParentLegal(BComponent parent) {
        return true;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        try {
            BNiagaraVirtualPolicies virtualPolicies = (BNiagaraVirtualPolicies)BOrd.make((String)"service:niagaraDriver:NiagaraVirtualNetworkExt").get((BObject)this.getVirtualGateway());
            if (!virtualPolicies.isRunning()) {
                virtualPolicies.lease();
            }
            list = list.filter(agent -> virtualPolicies.supportsRemoteAgentType(agent.getAgentType(), (BComponent)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    final void fwVirtualInitialized() {
        try {
            String encodedViewSlotNames = this.getSlotFacets((Slot)this.getPropertyInParent()).gets(NIAGARA_VIRTUAL_PX_VIEW_SLOTS, null);
            if (encodedViewSlotNames != null) {
                BNameList viewSlotNames = (BNameList)BNameList.DEFAULT.decodeFromString(encodedViewSlotNames);
                String[] names = viewSlotNames.getNames();
                ArrayList<BOrd> viewOrds = new ArrayList<BOrd>(names.length);
                for (String viewSlotName : names) {
                    if (this.get(viewSlotName) != null) continue;
                    viewOrds.add(NiagaraVirtualUtil.addSlotNameToOrd(this.getNavOrd(), viewSlotName));
                }
                if (!viewOrds.isEmpty()) {
                    this.getNiagaraVirtualGateway().ensureVirtualsLoaded(viewOrds.toArray(new BOrd[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.virtualInitialized();
    }

    public void virtualInitialized() {
    }

    private void addToPropHandler(Property property) {
        if (!(!this.isRunning() || property.isAction() || property.isTopic() || (this.getFlags((Slot)property) & 0x10000000) != 0x10000000 || this.get(property).isComponent() || Flags.isHidden((BComplex)this, (Slot)property))) {
            try {
                if (!this.propertyHandlerArray.hasPropertyHandlers()) {
                    this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
                }
                this.propertyHandlerArray.add(NiagaraVirtualPropertyHandler.make(this.getStationAdapter(), this, property));
            }
            catch (Exception e) {
                this.getLog().log(Level.SEVERE, "Could not parse virtual slot path information", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BNiagaraVirtualGateway getNiagaraVirtualGateway() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.gw != null) {
                return this.gw;
            }
            this.gw = (BNiagaraVirtualGateway)this.getVirtualGateway();
            if (this.gw != null) {
                if (this.isRunning()) {
                    this.getNiagaraVirtualCompInfo().setGateway(this.gw.getOrdInSession());
                }
            } else if (!this.getNiagaraVirtualCompInfo().getGateway().isNull()) {
                try {
                    this.gw = (BNiagaraVirtualGateway)this.getNiagaraVirtualCompInfo().getGateway().get((BObject)this.getHost());
                }
                catch (Exception e) {
                    System.out.println("Error attempting to resolve Niagara Virtual Gateway: " + this.getNiagaraVirtualCompInfo().getGateway() + "...");
                    e.printStackTrace();
                }
            } else if (this.isRunning()) {
                System.out.println("Could not resolve Niagara Virtual Gateway (ORD reference is NULL)");
            }
            return this.gw;
        }
    }

    public final Logger getLog() {
        return this.getStationAdapter().getLog();
    }

    final void close() {
        NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].close();
        }
    }

    @Override
    public final String getPointId() {
        return this.getNiagaraVirtualCompInfo().getSlotOrd().toString();
    }

    @Override
    public final BValue invokeAction(BVirtualAction action, BValue arg) throws Exception {
        return this.getComms().invokeAction(this, action, arg, "ProxyActionInvoke");
    }

    public final BValue doGetProxyActionDefault(BString actionName) throws Exception {
        if (this.getComms().isTraceOn()) {
            this.getComms().trace("getProxyActionDefault " + actionName);
        }
        BVirtualAction action = (BVirtualAction)this.get(actionName.toString());
        return this.getComms().getActionDefault(this, action, this.getDisplayName(null) + ": Niagara Virtual Proxy Action Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doNiagaraVirtualCompCheckActions() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.actionFetchRequired) {
                INiagaraVirtualStationAdapter adapter = this.getStationAdapter();
                if (!this.getNiagaraVirtualGateway().isLicensed() || adapter.getStationStatus().isDisabled() || adapter.getStationStatus().isDown() || !adapter.isVirtualsEnabled()) {
                    return;
                }
                try {
                    this.updateActions(this.getComms().loadActions(this, this.getDisplayName(null) + ": Niagara Virtual Get Actions"));
                }
                catch (Exception e) {
                    this.getComms().error("Could not get Actions back from component", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reloadActionsIfLoaded() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.actionFetchRequired) {
                INiagaraVirtualStationAdapter adapter = this.getStationAdapter();
                if (!this.getNiagaraVirtualGateway().isLicensed() || adapter.getStationStatus().isDisabled() || adapter.getStationStatus().isDown() || !adapter.isVirtualsEnabled()) {
                    return;
                }
                try {
                    this.updateActions(this.getComms().loadActions(this, this.getDisplayName(null) + ": Niagara Virtual Get Actions"));
                }
                catch (Exception e) {
                    this.getComms().error("Could not get Actions back from component", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateActions(BVirtualAction[] actions) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.getLog().isLoggable(Level.FINE)) {
                this.getLog().fine("updateActions - Virtuals - " + this.getSlotPathOrd());
            }
            try {
                BSlotInfo info;
                HashMap<String, BFormat> names = NiagaraVirtualUtil.getDisplayNamesHashMap((BComponent)this);
                boolean reorder = false;
                Array propArray = new Array(Property.class);
                for (int i = 0; i < actions.length; ++i) {
                    try {
                        Property p = this.getProperty(actions[i].getProxyActionName());
                        if (p == null) {
                            info = new BSlotInfo();
                            info.setSlotName(actions[i].getProxyActionName());
                            info.setSlotDisplayName(BFormat.make((String)actions[i].getProxyActionDisplayName()));
                            info.setSlotFlags(actions[i].getProxyActionFlags());
                            info.setSlotType(BSlotType.action);
                            info.setReturnTypeSpec(actions[i].getReturnTypeSpec().toString());
                            BFacets facets = actions[i].getFacets();
                            int flags = actions[i].getProxyActionFlags() | 0x10000000;
                            if (this.checkVirtualAdd(info, (BValue)actions[i], facets, flags)) {
                                p = this.add(actions[i].getProxyActionName(), (BValue)actions[i], flags, facets, null);
                            }
                        } else {
                            this.set(actions[i].getProxyActionName(), (BValue)actions[i]);
                            reorder = true;
                        }
                        if (p == null) continue;
                        propArray.add((Object)p);
                        String proxyActionDisplayName = actions[i].getProxyActionDisplayName();
                        String proxyActionName = actions[i].getProxyActionName();
                        String friendlyProxyActionName = TextUtil.toFriendly((String)proxyActionName);
                        if (proxyActionDisplayName.length() > 0 && !proxyActionDisplayName.equals(friendlyProxyActionName)) {
                            names.put(proxyActionName, BFormat.make((String)proxyActionDisplayName));
                            continue;
                        }
                        BFormat existing = names.get(proxyActionName);
                        if (existing == null || !existing.equals((Object)BFormat.make((String)proxyActionDisplayName))) continue;
                        names.remove(proxyActionName);
                        continue;
                    }
                    catch (Exception e) {
                        this.getLog().log(Level.SEVERE, "Could not add Proxy Action to Virtual", e);
                    }
                }
                NiagaraVirtualUtil.setDisplayNames((BComponent)this, names);
                if (reorder) {
                    Property[] orgProps = this.getDynamicPropertiesArray();
                    for (int i = 0; i < orgProps.length; ++i) {
                        if (orgProps[i].isAction()) continue;
                        propArray.add((Object)orgProps[i]);
                    }
                    final Property[] props = (Property[])propArray.trim();
                    Array dynProps = new Array(Property.class);
                    dynProps.addAll((Object[])this.getDynamicPropertiesArray());
                    dynProps = dynProps.sort((Comparator)new Comparator<Property>(){

                        @Override
                        public int compare(Property p1, Property p2) {
                            int index1 = -1;
                            int index2 = -1;
                            for (int i = 0; i < props.length; ++i) {
                                if (props[i] == p1) {
                                    index1 = i;
                                } else if (props[i] == p2) {
                                    index2 = i;
                                }
                                if (index1 > -1 && index2 > -1) break;
                            }
                            return index1 > index2 ? 1 : -1;
                        }
                    });
                    this.reorder((Property[])dynProps.trim());
                }
                BNiagaraVirtualCache cache = this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().getCache();
                for (int i = 0; i < actions.length; ++i) {
                    info = new BSlotInfo();
                    info.setSlotName(actions[i].getProxyActionName());
                    info.setSlotDisplayName(BFormat.make((String)actions[i].getProxyActionDisplayName()));
                    info.setSlotOrd(this.getNiagaraVirtualCompInfo().formSlotOrd(actions[i].getProxyActionName()));
                    info.setIsFrozen(actions[i].getFacets().getb(NIAGARA_VIRTUAL_FROZEN, false));
                    info.setIsComponent(false);
                    info.setSlotType(BSlotType.action);
                    info.setIsNiagaraVirtual(false);
                    Type paramType = actions[i].getParameterType();
                    if (paramType != null) {
                        info.setTypeSpec(paramType.toString());
                    }
                    info.setFacets(BFacets.makeRemove((BFacets)actions[i].getFacets(), (String)NIAGARA_VIRTUAL_FROZEN));
                    info.setSlotFlags(info.getSlotFlags() | actions[i].getProxyActionFlags());
                    Type returnType = actions[i].getReturnType();
                    if (returnType != null) {
                        info.setReturnTypeSpec(returnType.toString());
                    }
                    BOrd vOrd = this.formVirtualOrd(VirtualPath.toVirtualPathName((String)actions[i].getProxyActionName()));
                    cache.update(this.getStationAdapter().getStationName(), vOrd, info);
                }
            }
            finally {
                this.actionFetchRequired = false;
            }
        }
    }

    final void makeIcon(BIcon discoveredIcon) {
        try {
            boolean useDiscoveredIcon = false;
            if (!BIcon.DEFAULT.equals((Object)discoveredIcon)) {
                useDiscoveredIcon = true;
                BOrdList ordList = discoveredIcon.getOrdList();
                if (ordList.size() >= 1) {
                    Iterator ords = ordList.iterator();
                    while (useDiscoveredIcon && ords.hasNext()) {
                        try {
                            ((BOrd)ords.next()).get();
                        }
                        catch (Exception e) {
                            useDiscoveredIcon = false;
                        }
                    }
                } else {
                    useDiscoveredIcon = false;
                }
                if (useDiscoveredIcon) {
                    this.setIcon(BNiagaraVirtualComponent.makeVirtualIcon(discoveredIcon));
                }
            }
            if (!useDiscoveredIcon && this.getIcon().equals((Object)DEFAULT_ICON)) {
                this.setIcon(BNiagaraVirtualComponent.makeVirtualIcon(Sys.getType((String)this.getNiagaraVirtualCompInfo().getTypeSpec()).getInstance().getIcon()));
            }
        }
        catch (Exception e) {
            this.setIcon(DEFAULT_ICON);
        }
    }

    private static BIcon makeVirtualIcon(BIcon ic) {
        BOrd[] ords = ic.getOrdList().toArray();
        boolean hasGhost = false;
        for (int i = 0; i < ords.length; ++i) {
            if (!ords[i].equals((Object)GHOST_ICON)) continue;
            hasGhost = true;
            break;
        }
        if (!hasGhost) {
            return BIcon.make((BIcon)ic, (BIcon)GHOST_ICON);
        }
        return ic;
    }

    public void spy(SpyWriter out) throws Exception {
        this.spyInfo(out);
        super.spy(out);
    }

    public final void spyInfo(SpyWriter out) throws Exception {
        out.startProps("Niagara Virtual Component Information");
        BNiagaraVirtualComponentInfo info = this.getNiagaraVirtualCompInfo();
        out.prop((Object)"Virtual Status", (Object)info.getStatus());
        out.prop((Object)"Type Specification", (Object)info.getTypeSpec());
        out.prop((Object)"Slot ORD", (Object)info.getSlotOrd());
        out.prop((Object)"Last Failure Cause", (Object)info.getLastFailureCause());
        out.endProps();
        out.startTable(true);
        out.trTitle((Object)"Fox Point Channel Subscriptions", 9);
        out.w((Object)"<tr>");
        out.th((Object)"Name");
        out.th((Object)"Type");
        out.th((Object)"Message Id");
        out.th((Object)"Last Read");
        out.th((Object)"Last Write");
        out.th((Object)"Subscription State");
        out.th((Object)"Subscription Status");
        out.th((Object)"Read Status");
        out.th((Object)"Write Status");
        out.w((Object)"</tr>");
        NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
        for (int i = 0; i < handlers.length; ++i) {
            StringBuilder rowBuff = new StringBuilder();
            rowBuff.append("<tr");
            try {
                BSimple color = (BSimple)Sys.getType((String)"gx:Color").getInstance();
                BSimple defaultColor = (BSimple)color.decodeFromString("#90ee90");
                BSimple newColor = handlers[i].getOverallStatus().getBackgroundColor(defaultColor);
                Method toHtmlStringMethod = newColor.getClass().getMethod("toHtmlString", new Class[0]);
                String colorStr = toHtmlStringMethod.invoke((Object)newColor, new Object[0]).toString();
                if (colorStr != null) {
                    rowBuff.append(" bgcolor='").append(colorStr).append("'");
                }
            }
            catch (Exception color) {
                // empty catch block
            }
            rowBuff.append(">");
            out.w((Object)rowBuff.toString());
            String lastReadDur = "-";
            long lastReadTicks = handlers[i].getLastReadTicks();
            if (lastReadTicks != 0L) {
                lastReadDur = BRelTime.toString((long)(Clock.ticks() - lastReadTicks));
            }
            String lastWriteDur = "-";
            long lastWriteTicks = handlers[i].getLastWriteTicks();
            if (lastWriteTicks != 0L) {
                lastWriteDur = BRelTime.toString((long)(Clock.ticks() - lastWriteTicks));
            }
            out.td().a(handlers[i].getProperty().getName(), (Object)handlers[i].getName()).endTd();
            out.td((Object)handlers[i].getProperty().getType());
            out.td((Object)handlers[i].getMessageId());
            out.td((Object)lastReadDur);
            out.td((Object)lastWriteDur);
            out.td((Object)handlers[i].getSubscriptionState());
            out.td((Object)handlers[i].getSubscriptionStatus());
            out.td((Object)handlers[i].getReadStatus());
            out.td((Object)handlers[i].getWriteStatus());
            out.w((Object)"</tr>");
        }
        out.endTable();
    }

    public BStatus getStatus() {
        return this.getNiagaraVirtualCompInfo().getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doNiagaraVirtualCompUpdateStatus() {
        INiagaraVirtualStationAdapter adapter = this.getStationAdapter();
        BStatus status = adapter.getStationStatus();
        if (!adapter.isVirtualsEnabled()) {
            status = BStatus.makeDisabled((BStatus)status, (boolean)true);
        }
        if (status.isDown() || status.isFault()) {
            StringBuilder buff = new StringBuilder();
            buff.append("Station Err: (");
            buff.append(Sys.getStation().getStationName());
            buff.append(" -> ");
            buff.append(adapter.getStationName());
            buff.append(") ");
            buff.append(status.toString());
            this.getNiagaraVirtualCompInfo().setLastFailureCause(buff.toString());
        }
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            if (this.getNiagaraVirtualCompInfo().getStatus().isStale()) {
                status = BStatus.makeStale((BStatus)status, (boolean)true);
            }
            if (this.getNiagaraVirtualCompInfo().getStatus().isFault()) {
                status = BStatus.makeFault((BStatus)status, (boolean)true);
            }
        } else {
            NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
            int bits = 0;
            for (int i = 0; i < handlers.length; ++i) {
                bits = handlers[i].getOverallStatus().getBits() | bits;
            }
            status = BStatus.make((int)(status.getBits() | bits));
        }
        if (!(!this.mappedToNiagaraVirtual || status.isDisabled() || status.isStale() || status.isDown() || status.isFault())) {
            HandlerArray handlerArray = this.propertyHandlerArray;
            synchronized (handlerArray) {
                if (this.mappedStatus != null) {
                    status = BStatus.make((int)(status.getBits() | this.mappedStatus.getBits()));
                    status = BStatus.makeOverridden((BStatus)status, (boolean)true);
                }
            }
        }
        this.getNiagaraVirtualCompInfo().setStatus(status);
    }

    public final void doNiagaraVirtualCompDeviceStatusChanged() {
        INiagaraVirtualStationAdapter adapter = this.getStationAdapter();
        BStatus status = adapter.getStationStatus();
        if (status.isDown() || status.isFault() || status.isDisabled() || !this.getNiagaraVirtualGateway().isRunning() || !adapter.isVirtualsEnabled()) {
            this.unsubscribeHandlers();
        } else {
            this.niagaraVirtualCompUpdateStatus();
        }
    }

    final void unsubscribeHandlers() {
        NiagaraVirtualPropertyHandler[] handlers = this.propertyHandlerArray.toArray();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].unsubscribed();
        }
        this.niagaraVirtualCompUpdateStatus();
    }

    final void discoveryFail(String cause, boolean fault) {
        if (fault) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeFault((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
        }
        this.getNiagaraVirtualCompInfo().setLastFailureCause(cause);
        this.unsubscribeHandlers();
    }

    final void discoveryOk() {
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeFault((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)false));
        }
    }

    public String toString(Context context) {
        return this.getNiagaraVirtualCompInfo().toString(context);
    }

    public final BOrd getCategorizableOrd() {
        BOrd navOrd = this.getNavOrd();
        if (navOrd == null) {
            return BOrd.NULL;
        }
        OrdQuery[] queries = navOrd.parse();
        try {
            for (int i = 0; i < queries.length; ++i) {
                if (!(queries[i] instanceof VirtualPath)) continue;
                VirtualPath vPath = (VirtualPath)queries[i];
                StringBuilder buff = new StringBuilder();
                BNiagaraVirtualComponent nParent = this.getNiagaraVirtualGateway().getRootComponent();
                for (int j = 0; j < vPath.depth(); ++j) {
                    String name = vPath.nameAt(j);
                    if (name.length() <= 0) continue;
                    buff.append("/");
                    BNiagaraVirtualComponent comp = (BNiagaraVirtualComponent)nParent.get(VirtualPath.toSlotPathName((String)name));
                    BFacets facets = nParent.getSlotFacets((Slot)comp.getPropertyInParent());
                    String newName = VirtualPath.toVirtualPathName((String)facets.gets(NIAGARA_VIRTUAL_SLOT_NAME, comp.getName()));
                    buff.append(newName);
                    nParent = comp;
                }
                queries[i] = new VirtualPath(buff.toString());
            }
        }
        catch (Exception e) {
            this.getLog().log(Level.SEVERE, "Error parsing Niagara Virtual Component Categorizable ORD", e);
        }
        return BOrd.make((OrdQuery[])queries);
    }

    public final Property getFormatPropertyByName(String name) {
        Slot slot;
        BComponentSpace space;
        if (name.isEmpty()) {
            return null;
        }
        Property prop = this.findPropertyByName(name);
        if (prop == null && (space = this.getComponentSpace()) != null && space.getLoadCallbacks() != null && (slot = space.getLoadCallbacks().loadSlot((BComponent)this, name)) instanceof Property) {
            prop = (Property)slot;
        }
        if (prop == null) {
            this.loadSlots();
            prop = this.findPropertyByName(name);
        }
        return prop;
    }

    private Property findPropertyByName(String name) {
        Property prop = this.getProperty(name);
        if (prop == null) {
            Property[] props = this.getPropertiesArray();
            try {
                for (int i = 0; i < props.length; ++i) {
                    BFacets facets;
                    String slotName;
                    if (props[i].isAction() || props[i].isTopic() || (this.getFlags((Slot)props[i]) & 0x10000000) != 0x10000000 || !(slotName = (facets = this.getSlotFacets((Slot)props[i])).gets(NIAGARA_VIRTUAL_SLOT_NAME, props[i].getName())).equals(name)) continue;
                    prop = props[i];
                    break;
                }
            }
            catch (Exception e) {
                this.getLog().log(Level.SEVERE, "Could not decode format value", e);
            }
        }
        return prop;
    }

    public final BValue getFormatValue(String name) {
        Property prop = this.getFormatPropertyByName(name);
        if (prop != null) {
            return this.get(prop);
        }
        return null;
    }

    public final int getVirtualPropertySize() {
        return this.propertyHandlerArray.size();
    }

    public final BOrd getVirtualOrd() {
        return BOrd.make((OrdQuery)VirtualPath.convertFromSlotPath((SlotPath)this.getSlotPath()));
    }

    public final BOrd formVirtualOrd(String virtualPathName) {
        String ordStr = this.getVirtualOrd().toString();
        ordStr = !ordStr.endsWith("/") ? ordStr + "/" + virtualPathName : ordStr + virtualPathName;
        return BOrd.make((String)ordStr);
    }

    public final String getTypeSpec() {
        return this.getNiagaraVirtualCompInfo().getTypeSpec();
    }

    public final INiagaraVirtualStationAdapter getStationAdapter() {
        return this.getNiagaraVirtualGateway().getStationAdapter();
    }

    public final INiagaraVirtualCommsAdapter getComms() {
        return this.getNiagaraVirtualGateway().getComms();
    }

    public final boolean checkVirtualAdd(BSlotInfo info, BValue val, BFacets facets, int flags) {
        if (this.getStationAdapter() != null && this.getStationAdapter().getNiagaraVirtualPolicies() != null && !this.getStationAdapter().getNiagaraVirtualPolicies().supportsRemoteType(val.getType())) {
            return false;
        }
        return this.doCheckVirtualAdd(info, val, facets, flags);
    }

    public boolean doCheckVirtualAdd(BSlotInfo info, BValue val, BFacets facets, int flags) {
        return true;
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.web), @Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public Map<String, String> fetchRemoteTags(List<String> requestedTags, Context cx) {
        INiagaraProxyExt ext = this.getNiagaraProxyExt();
        if (ext != null) {
            return this.getNiagaraVirtualGateway().getStationAdapter().fetchRemoteTags(requestedTags, ext, cx);
        }
        return Collections.emptyMap();
    }

    public INiagaraProxyExt getNiagaraProxyExt() {
        if (this.propertyHandlerArray.hasPropertyHandlers()) {
            return this.propertyHandlerArray.toArray()[0];
        }
        return null;
    }

    final void setMappedToNiagaraVirtual(boolean mappedToNiagaraVirtual) {
        this.mappedToNiagaraVirtual = mappedToNiagaraVirtual;
        if (mappedToNiagaraVirtual) {
            this.setFlags((Slot)niagaraVirtualCompInfo, this.getFlags((Slot)niagaraVirtualCompInfo) | 0x10000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void readOkMappedVirtualInfo(BNiagaraVirtualComponentInfo info) {
        if (this.getComms().isTraceOn()) {
            this.getComms().trace("Called readOkMappedVirtualInfo: " + this.getVirtualOrd());
        }
        if (this.mappedToNiagaraVirtual) {
            if (info.getLastFailureCause().length() > 0) {
                this.getNiagaraVirtualCompInfo().setLastFailureCause(info.getLastFailureCause());
            }
            HandlerArray handlerArray = this.propertyHandlerArray;
            synchronized (handlerArray) {
                this.mappedStatus = info.getStatus();
            }
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.web), @Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static List<String> findDescendantHistories(String ordStr, double limit, Context cx) {
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BOrd ord = BOrd.make((String)ordStr).normalize().relativizeToSession();
        BNiagaraVirtualComponent.validateOrd(ord);
        BObject obj = ord.get((BObject)Sys.getStation(), cx);
        if (obj.isComponent() && obj.asComponent().getPermissions(cx).hasOperatorRead()) {
            try (HistorySpaceConnection conn = historyService.getDatabase().getConnection(cx);){
                if (obj instanceof BNiagaraVirtualComponent) {
                    BNiagaraVirtualComponent virtualComp = (BNiagaraVirtualComponent)obj;
                    List<String> historyIds = virtualComp.getStationAdapter().findDescendantHistories(virtualComp, -1, cx);
                    Stream<String> idStream = historyIds.stream().filter(idStr -> {
                        BHistoryId id = BHistoryId.make((String)idStr);
                        BIHistory history = conn.getHistory(id);
                        return history != null && history.getPermissions(cx).hasOperatorRead();
                    });
                    if (limit > 0.0) {
                        idStream = idStream.limit((long)limit);
                    }
                    List<String> list = idStream.collect(Collectors.toList());
                    return list;
                }
                LinkedHashSet<String> historyIds = new LinkedHashSet<String>();
                BOrd bqlOrd = BOrd.make((String)"bql:select * from history:HistoryConfig stop where parent.enabled");
                BITable results = (BITable)bqlOrd.get(obj, cx);
                try (TableCursor result = results.cursor();){
                    while (result.next()) {
                        BHistoryId id = ((BHistoryConfig)result.get()).getId();
                        BIHistory history = conn.getHistory(id);
                        if (history == null || !history.getPermissions(cx).hasOperatorRead()) continue;
                        historyIds.add(id.encodeToString());
                        if (!(limit > 0.0) || historyIds.size() < (int)limit) continue;
                        break;
                    }
                }
                if (limit <= 0.0 || historyIds.size() < (int)limit) {
                    bqlOrd = BOrd.make((String)"bql:select n$243ahistory from baja:Component where n$243ahistory != null");
                    BITable table = (BITable)bqlOrd.get(obj, cx);
                    Column historyCol = table.getColumns().get(0);
                    try (TableCursor cursor = table.cursor();){
                        while (cursor.next()) {
                            BHistoryId id;
                            String idStr2 = cursor.cell(historyCol).toString();
                            try {
                                id = BHistoryId.make((String)idStr2);
                            }
                            catch (Exception e) {
                                continue;
                            }
                            BIHistory history = conn.getHistory(id);
                            if (history == null || !history.getPermissions(cx).hasOperatorRead()) continue;
                            historyIds.add(id.encodeToString());
                            if (!(limit > 0.0) || historyIds.size() < (int)limit) continue;
                            break;
                        }
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>(historyIds);
                return arrayList;
            }
        }
        throw new IllegalArgumentException("Cannot find descendant histories because the given ORD does not resolve to an authorized component: " + ordStr);
    }

    private static void validateOrd(BOrd ord) {
        OrdQuery[] ordQueries;
        Set invalidOrdSchemes = Collections.emptySet();
        for (OrdQuery ordQuery : ordQueries = ord.parse()) {
            String ordScheme = ordQuery.getScheme();
            if (VALID_ORD_SCHEMES.contains(ordScheme)) continue;
            if (invalidOrdSchemes.isEmpty()) {
                invalidOrdSchemes = new LinkedHashSet();
            }
            invalidOrdSchemes.add(ordScheme);
        }
        if (!invalidOrdSchemes.isEmpty()) {
            String invalidOrdSchemesStr = String.join((CharSequence)", ", invalidOrdSchemes);
            throw new LocalizableRuntimeException("baja", "query.invalidOrdSchemes", new Object[]{invalidOrdSchemesStr});
        }
    }

    private final class WriteRequest
    implements Runnable,
    ICoalesceable {
        private final BNiagaraVirtualComponent vComp;
        private final NiagaraVirtualPropertyHandler handler;
        private final BValue val;
        private final int hashCode;

        private WriteRequest(BNiagaraVirtualComponent vComp, NiagaraVirtualPropertyHandler handler, BValue val) {
            this.vComp = vComp;
            this.handler = handler;
            this.val = val.newCopy(true);
            this.hashCode = vComp.hashCode() ^ handler.getName().hashCode();
        }

        @Override
        public void run() {
            try {
                BNiagaraVirtualComponent.this.getComms().write(BNiagaraVirtualComponent.this.getNiagaraVirtualCompInfo().getSlotOrd(), this.handler.getName(), this.val, BNiagaraVirtualComponent.this.getDisplayName(null) + ": Niagara Virtual Write");
                this.handler.writeOk();
            }
            catch (Exception e) {
                String name = "";
                if (this.handler != null) {
                    name = this.handler.getName();
                    this.handler.writeFail(e.getMessage());
                }
                BNiagaraVirtualComponent.this.getComms().error("Writing to Niagara Virtual Property: " + name, e);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WriteRequest)) {
                return false;
            }
            WriteRequest wr = (WriteRequest)obj;
            return wr.handler.getName().equals(this.handler.getName()) && wr.vComp.equals(this.vComp);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        public Object getCoalesceKey() {
            return this;
        }
    }

    private static final class HandlerArray {
        private final Array<NiagaraVirtualPropertyHandler> array = new Array(NiagaraVirtualPropertyHandler.class);

        private HandlerArray() {
        }

        private synchronized void add(NiagaraVirtualPropertyHandler handler) {
            this.array.add((Object)handler);
        }

        private synchronized NiagaraVirtualPropertyHandler findAndRemove(Property p) {
            NiagaraVirtualPropertyHandler handler = this.find(p);
            if (handler != null) {
                this.array.remove((Object)handler);
            }
            return handler;
        }

        private synchronized NiagaraVirtualPropertyHandler[] toArray() {
            return (NiagaraVirtualPropertyHandler[])this.array.copy().trim();
        }

        private synchronized void clear() {
            this.array.clear();
        }

        private synchronized boolean hasPropertyHandlers() {
            return this.array.size() > 0;
        }

        private synchronized int size() {
            return this.array.size();
        }

        private synchronized NiagaraVirtualPropertyHandler find(Property prop) {
            for (NiagaraVirtualPropertyHandler handler : this.array) {
                if (handler.getProperty() != prop) continue;
                return handler;
            }
            return null;
        }
    }
}

