/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.nv.BSlotInfo;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.nv.cache.BNvaEntry;
import com.tridium.nv.cache.NvaDecoder;
import com.tridium.nv.cache.NvaEncoder;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="persistCache", type="boolean", defaultValue="true"), @NiagaraProperty(name="cacheDirectory", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IDirectory\"")})})
public final class BDefaultNiagaraVirtualCache
extends BNiagaraVirtualCache {
    @Generated
    public static final Property persistCache = BDefaultNiagaraVirtualCache.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property cacheDirectory = BDefaultNiagaraVirtualCache.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IDirectory"));
    @Generated
    public static final Type TYPE = Sys.loadType(BDefaultNiagaraVirtualCache.class);
    private BAbsTime lastUpdate = BAbsTime.NULL;
    private BAbsTime lastLookup = BAbsTime.NULL;
    private final RefMap refMap = new RefMap();
    private static final Logger log = Logger.getLogger("niagaraVirtualCache.default");
    private static final int defaultHardReferenceLimit = 1000;
    private static int hardReferenceLimit = 1000;
    private static boolean useSoftRefs = true;

    @Generated
    public boolean getPersistCache() {
        return this.getBoolean(persistCache);
    }

    @Generated
    public void setPersistCache(boolean v) {
        this.setBoolean(persistCache, v, null);
    }

    @Generated
    public BOrd getCacheDirectory() {
        return (BOrd)this.get(cacheDirectory);
    }

    @Generated
    public void setCacheDirectory(BOrd v) {
        this.set(cacheDirectory, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        this.saveToFiles();
    }

    public void atSteadyState() throws Exception {
        this.getVirtualPolicies().postAsync(new Runnable(){

            @Override
            public void run() {
                BDefaultNiagaraVirtualCache.this.loadFromFiles();
            }
        });
    }

    @Override
    public void update(String stationName, BOrd vOrd, BSlotInfo info) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updating Cache: " + stationName + " " + vOrd);
        }
        this.lastUpdate = BAbsTime.now();
        this.refMap.put(new Key(stationName, vOrd), info);
    }

    @Override
    public BSlotInfo doLookup(String stationName, BOrd vOrd) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking up from Cache: " + stationName + " " + vOrd);
        }
        this.lastLookup = BAbsTime.now();
        return this.refMap.get(new Key(stationName, vOrd));
    }

    @Override
    protected BNiagaraVirtualCache.CachedSlotInfo[] lookup(String stationName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking up from Cache for Station: " + stationName);
        }
        return this.refMap.lookup(stationName);
    }

    @Override
    public void remove(String stationName, BOrd[] vOrds) {
        if (log.isLoggable(Level.FINE)) {
            for (int i = 0; i < vOrds.length; ++i) {
                log.fine("Removing from Cache: " + stationName + " " + vOrds[i]);
            }
        }
        Key[] keys = new Key[vOrds.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = new Key(stationName, vOrds[i]);
        }
        this.refMap.remove(keys);
    }

    @Override
    public void doClear() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Clearing entire Cache");
        }
        this.refMap.clear();
    }

    private void loadFromFiles() {
        if (this.getVirtualPolicies().getStatus().isDisabled() || !this.getVirtualPolicies().isLicensed() || !this.getPersistCache()) {
            return;
        }
        int count = 0;
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Started loading persisted Niagara Virtual Cache...");
            }
            count = AccessController.doPrivileged(() -> {
                int total = 0;
                NvaDecoder decoder = NvaDecoder.make((BObject)this, this.getDefaultCacheDirectory());
                Cursor<BNvaEntry> c = decoder.getReverseCursor();
                while (c.next()) {
                    BNvaEntry entry = (BNvaEntry)((Object)((Object)c.get()));
                    this.update(entry.getStationName(), entry.getVirtualOrd(), entry.getSlotInfo());
                    ++total;
                }
                return total;
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not load Cache from File System", e);
        }
        finally {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Finished loading persisted Niagara Virtual Cache: " + count);
            }
        }
    }

    private void saveToFiles() {
        if (this.getVirtualPolicies().getStatus().isDisabled() || !this.getVirtualPolicies().isLicensed() || !this.getPersistCache()) {
            return;
        }
        try {
            AccessController.doPrivileged(() -> {
                ArrayList<NvaEntryInfo> nvaEntries;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Started saving Niagara Virtual Cache...");
                }
                NvaEncoder encoder = NvaEncoder.make(this.getDefaultCacheDirectory());
                RefMap refMap = this.refMap;
                synchronized (refMap) {
                    this.refMap.processQueue();
                    int capacity = this.refMap.hardMap.size();
                    if (useSoftRefs) {
                        capacity += this.refMap.softMap.size();
                    }
                    nvaEntries = new ArrayList<NvaEntryInfo>(capacity);
                    ArrayList entries = new ArrayList(this.refMap.hardMap.entrySet());
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        Key key = (Key)entries.get(i).getKey();
                        BSlotInfo info = (BSlotInfo)((Object)((Object)entries.get(i).getValue()));
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Adding Hard Entry: " + key.stationName + " -> " + key.vOrd);
                        }
                        nvaEntries.add(new NvaEntryInfo(key, info));
                    }
                    if (useSoftRefs) {
                        for (Map.Entry entry : this.refMap.softMap.entrySet()) {
                            Key key = (Key)entry.getKey();
                            SoftValue val = (SoftValue)entry.getValue();
                            BSlotInfo info = (BSlotInfo)((Object)((Object)val.get()));
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Adding Soft Entry: " + key.stationName + " -> " + key.vOrd);
                            }
                            if (info == null) continue;
                            nvaEntries.add(new NvaEntryInfo(key, info));
                        }
                    }
                }
                for (NvaEntryInfo nvaEntryInfo : nvaEntries) {
                    Key key = nvaEntryInfo.key;
                    encoder.add(BNvaEntry.make(key.stationName, key.vOrd, nvaEntryInfo.info));
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Finished Adding Entries: " + nvaEntries.size());
                }
                encoder.close();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Closing Encoder");
                }
                return null;
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not load Cache from File System", e);
        }
        finally {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Finished saving Niagara Virtual Cache");
            }
        }
    }

    public BOrd getDefaultCacheDirectory() {
        BOrd cacheDir = this.getCacheDirectory();
        if (cacheDir.isNull()) {
            StringBuilder buff = new StringBuilder();
            buff.append("file:^^");
            buff.append(this.getVirtualPolicies().getType().getModule().getModuleName());
            buff.append("_");
            buff.append("nVirtual");
            cacheDir = BOrd.make((String)buff.toString());
        }
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            this.refMap.processQueue();
            out.startProps("Cache");
            out.prop((Object)"Size", (Object)this.getCacheSize());
            out.prop((Object)"Hard Ref Limit", hardReferenceLimit);
            out.prop((Object)"Soft Refs Enabled", useSoftRefs);
            out.prop((Object)"Total Hard Refs", this.refMap.hardMap.size());
            out.prop((Object)"Total Soft Refs", this.refMap.softMap.size());
            out.prop((Object)"Total Collected Soft Refs", (Object)this.refMap.totalCollectedSoftReferences);
            out.prop((Object)"Last Update", (Object)this.lastUpdate);
            out.prop((Object)"Last Lookup", (Object)this.lastLookup);
            out.endProps();
            out.startTable(true);
            out.trTitle((Object)"Hard References", 12);
            out.w((Object)"<tr>");
            out.th((Object)"ORD");
            out.th((Object)"slotName");
            out.th((Object)"slotDisplayName");
            out.th((Object)"slotType");
            out.th((Object)"slotOrd");
            out.th((Object)"isFrozen");
            out.th((Object)"isComponent");
            out.th((Object)"typeSpec");
            out.th((Object)"facets");
            out.th((Object)"slotFlags");
            out.th((Object)"returnTypeSpec");
            out.th((Object)"slotIcon");
            out.w((Object)"</tr>");
            ArrayList entries = new ArrayList(this.refMap.hardMap.entrySet());
            for (int i = entries.size() - 1; i >= 0; --i) {
                out.w((Object)"<tr>");
                BOrd vOrd = ((Key)entries.get((int)i).getKey()).vOrd;
                BSlotInfo info = (BSlotInfo)((Object)entries.get(i).getValue());
                out.td((Object)vOrd);
                out.td((Object)info.getSlotName());
                out.td((Object)info.getSlotDisplayName());
                out.td((Object)info.getSlotType());
                out.td((Object)info.getSlotOrd());
                out.td((Object)BBoolean.make((boolean)info.getIsFrozen()));
                out.td((Object)BBoolean.make((boolean)info.getIsComponent()));
                out.td((Object)info.getTypeSpec());
                out.td((Object)info.getFacets());
                out.td((Object)Flags.encodeToString((int)info.getSlotFlags()));
                out.td((Object)info.getReturnTypeSpec());
                out.td((Object)info.getSlotIcon());
                out.w((Object)"</tr><br />");
            }
            out.endTable();
        }
        super.spy(out);
    }

    public static void setHardReferenceLimit(int limit) {
        hardReferenceLimit = Math.abs(limit);
    }

    public static void setUseSoftRefs(boolean useRefs) {
        useSoftRefs = useRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheSize() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            this.refMap.processQueue();
            return this.refMap.hardMap.size() + this.refMap.softMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalCollectedSoftReferences() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            return this.refMap.totalCollectedSoftReferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BSlotInfo getMostAccessedSlotInfo() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            ArrayList entries = new ArrayList(this.refMap.hardMap.entrySet());
            return (BSlotInfo)((Object)entries.get(entries.size() - 1).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardRef(String stationName, BOrd vOrd) throws Exception {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            return this.refMap.hardMap.get(new Key(stationName, vOrd)) != null;
        }
    }

    static {
        String hardRefStr = AccessController.doPrivileged(() -> System.getProperty("niagara.niagaraVirtuals.cacheHardRefLimit", String.valueOf(1000)));
        try {
            BDefaultNiagaraVirtualCache.setHardReferenceLimit(Integer.parseInt(hardRefStr));
        }
        catch (NumberFormatException e) {
            BDefaultNiagaraVirtualCache.setHardReferenceLimit(1000);
        }
        BDefaultNiagaraVirtualCache.setUseSoftRefs(!AccessController.doPrivileged(() -> System.getProperty("niagara.niagaraVirtuals.useSoftRefs", "true")).equals("false"));
    }

    private static class NvaEntryInfo {
        final Key key;
        final BSlotInfo info;

        NvaEntryInfo(Key key, BSlotInfo info) {
            this.key = key;
            this.info = info;
        }
    }

    private static class SoftValue
    extends SoftReference<BSlotInfo> {
        private final Key key;

        SoftValue(Key key, BSlotInfo info, ReferenceQueue<BSlotInfo> queue) {
            super(info, queue);
            this.key = key;
        }
    }

    private static class Key {
        String stationName = "";
        BOrd vOrd = BOrd.NULL;
        int hashCode = -1;

        Key(String stationName, BOrd vOrd) {
            this.stationName = stationName;
            this.vOrd = vOrd;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return ((Key)obj).hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = new String(this.stationName + this.vOrd.toString()).hashCode();
            }
            return this.hashCode;
        }
    }

    private static class RefMap {
        private final Map<Key, BSlotInfo> hardMap = new LinkedHashMap<Key, BSlotInfo>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, BSlotInfo> eldest) {
                if (this.size() > hardReferenceLimit) {
                    if (useSoftRefs) {
                        SoftValue val = new SoftValue(eldest.getKey(), eldest.getValue(), queue);
                        softMap.put(val.key, val);
                    }
                    return true;
                }
                return false;
            }
        };
        private final Map<Key, SoftValue> softMap = new LinkedHashMap<Key, SoftValue>();
        private final ReferenceQueue<BSlotInfo> queue = new ReferenceQueue();
        long totalCollectedSoftReferences = 0L;

        private RefMap() {
        }

        synchronized BSlotInfo get(Key key) {
            this.processQueue();
            BSlotInfo info = this.hardMap.get(key);
            if (useSoftRefs && info == null) {
                SoftValue val = this.softMap.get(key);
                if (val != null) {
                    info = (BSlotInfo)((Object)val.get());
                }
                if (info != null) {
                    this.softMap.remove(val);
                    this.hardMap.put(key, info);
                }
            }
            return info;
        }

        synchronized void put(Key key, BSlotInfo info) {
            this.processQueue();
            if (useSoftRefs) {
                this.softMap.remove(key);
            }
            this.hardMap.put(key, info);
        }

        synchronized void clear() {
            this.processQueue();
            this.hardMap.clear();
            this.softMap.clear();
        }

        synchronized void remove(Key[] keys) {
            this.processQueue();
            for (int i = 0; i < keys.length; ++i) {
                this.hardMap.remove(keys[i]);
                this.softMap.remove(keys[i]);
            }
        }

        synchronized BNiagaraVirtualCache.CachedSlotInfo[] lookup(String stationName) {
            Array a = new Array(BNiagaraVirtualCache.CachedSlotInfo.class);
            this.processQueue();
            ArrayList<Map.Entry<Key, BSlotInfo>> entries = new ArrayList<Map.Entry<Key, BSlotInfo>>(this.hardMap.entrySet());
            for (int i = entries.size() - 1; i >= 0; --i) {
                Key key = entries.get(i).getKey();
                BSlotInfo info = entries.get(i).getValue();
                if (!key.stationName.equals(stationName)) continue;
                a.add((Object)new BNiagaraVirtualCache.CachedSlotInfo(key.vOrd, info));
            }
            if (useSoftRefs) {
                for (Map.Entry<Key, SoftValue> entry : this.softMap.entrySet()) {
                    Key key = entry.getKey();
                    BSlotInfo info = (BSlotInfo)((Object)entry.getValue().get());
                    if (info == null || !key.stationName.equals(stationName)) continue;
                    a.add((Object)new BNiagaraVirtualCache.CachedSlotInfo(key.vOrd, info));
                }
            }
            return (BNiagaraVirtualCache.CachedSlotInfo[])a.trim();
        }

        private void processQueue() {
            SoftValue val;
            if (!useSoftRefs) {
                return;
            }
            while ((val = (SoftValue)this.queue.poll()) != null) {
                this.softMap.remove(val.key);
                if (++this.totalCollectedSoftReferences != Long.MAX_VALUE) continue;
                this.totalCollectedSoftReferences = 0L;
            }
        }
    }
}

