/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep.internal;

import com.tridium.cloud.client.iotdep.internal.AmqpAuthReceiverLinkHandler;
import com.tridium.cloud.client.iotdep.internal.AmqpAuthSenderLinkHandler;
import com.tridium.cloud.client.iotdep.internal.AmqpClient;
import com.tridium.cloud.client.iotdep.internal.IAmqpSessionHandler;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class AmqpAuthSessionHandler
extends BaseHandler
implements IAmqpSessionHandler {
    private final AmqpClient client;
    private final Session session;
    private AmqpAuthSenderLinkHandler senderHandler;
    private AmqpAuthReceiverLinkHandler receiverHandler;
    private boolean senderOpen;
    private boolean receiverOpen;
    private static final Logger log = Logger.getLogger("cloud.iotmsg.amqp");

    AmqpAuthSessionHandler(Session session, AmqpClient client) {
        this.client = client;
        this.session = session;
        BaseHandler.setHandler(session, (Handler)this);
        session.open();
    }

    @Override
    public void onSessionLocalOpen(Event event) {
        log.finest(event.toString());
        if (event.getSession() != this.session) {
            log.config("onSessionLocalOpen called for a session we are not managing.");
            return;
        }
        Sender sender = this.session.sender("cbs-sender");
        this.senderHandler = new AmqpAuthSenderLinkHandler(sender, this);
        Receiver receiver = this.session.receiver("cbs-receiver");
        this.receiverHandler = new AmqpAuthReceiverLinkHandler(receiver, this);
    }

    @Override
    public void onSessionLocalClose(Event event) {
        log.finest(event.toString());
        this.session.getConnection().close();
        this.close();
    }

    @Override
    public void onSessionRemoteClose(Event event) {
        log.finest(event.toString());
        Session sess = event.getSession();
        if (sess.getLocalState() == EndpointState.ACTIVE) {
            log.config("Amqp CBS session closed remotely unexpectedly");
            this.client.getCallbackHandler().onConnectionLost(this.client, new IOException(sess.getRemoteCondition().toString()));
            this.session.close();
        }
    }

    public boolean isConnected() {
        return this.session != null && this.session.getLocalState() == EndpointState.ACTIVE && this.session.getRemoteState() == EndpointState.ACTIVE;
    }

    @Override
    public void linkOpened(BaseHandler linkHandler) {
        if (linkHandler == this.senderHandler) {
            this.senderOpen = true;
        } else if (linkHandler == this.receiverHandler) {
            this.receiverOpen = true;
        }
        if (this.senderOpen && this.receiverOpen) {
            try {
                this.receiverHandler.addAuthenticationMessageCorrelation(this.senderHandler.sendAuthenticationMessage());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "unable to authenticate,", ex);
            }
        }
    }

    @Override
    public void linkLost(ErrorCondition condition, BaseHandler linkHandler) {
        log.config("Auth link closed unexpectedly, closing auth session");
        this.close();
        this.client.getCallbackHandler().onConnectionLost(this.client, new IOException("auth link closed unexpectedly"));
    }

    @Override
    public void close() {
        if (this.senderHandler != null) {
            this.senderHandler.close();
        }
        if (this.receiverHandler != null) {
            this.receiverHandler.close();
        }
        this.session.close();
    }

    @Override
    public AmqpClient getClient() {
        return this.client;
    }
}

