/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep.internal;

import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketImpl;
import com.tridium.cloud.client.iotdep.internal.AmqpAuthSessionHandler;
import com.tridium.cloud.client.iotdep.internal.AmqpDeviceSessionHandler;
import com.tridium.cloud.client.iotdep.internal.AmqpMessage;
import com.tridium.cloud.client.iotdep.internal.IAmqpCallbacks;
import com.tridium.cloud.client.iotdep.internal.ProxyHandler;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustManagerBuilder;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.security.cert.TrustAnchor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.util.ExecutorUtil;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorOptions;

public class AmqpClient
extends BaseHandler {
    Map<String, String> connectionInfo;
    private Reactor reactor;
    private Connection connection;
    private AmqpAuthSessionHandler authSessionHandler;
    private AmqpDeviceSessionHandler deviceSessionHandler;
    private ExecutorService worker;
    private IAmqpCallbacks callbackHandler;
    private final boolean useWebSockets;
    private final String sslProtocol;
    private CompletableFuture<Boolean> connectFuture;
    private Proxy proxy;
    private static final int AMQP_PORT = 5671;
    private static final int AMQP_WS_PORT = 443;
    private static final int MAX_WS_FRAME_SIZE = 4096;
    private static final Logger log = Logger.getLogger("cloud.iotmsg.amqp");

    public AmqpClient(boolean webSockets, String sslProtocol) {
        this.useWebSockets = webSockets;
        this.sslProtocol = sslProtocol;
        this.add(new Handshaker());
    }

    public CompletableFuture<Boolean> connect(IAmqpCallbacks callbackHandler, Map<String, String> connectionInfo) throws IOException {
        this.callbackHandler = callbackHandler;
        this.connectFuture = new CompletableFuture();
        this.connectionInfo = Collections.unmodifiableMap(connectionInfo);
        ReactorOptions options = new ReactorOptions();
        if (this.useWebSockets) {
            options.setMaxFrameSize(4096);
        }
        this.reactor = Proton.reactor(options, this);
        this.worker = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"amqp.client.worker", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.worker.submit(() -> {
            try {
                AccessController.doPrivileged(() -> {
                    try {
                        this.reactor.setTimeout(10L);
                        this.reactor.start();
                        while (this.reactor.process()) {
                        }
                        this.reactor.stop();
                        this.reactor.process();
                        this.reactor.free();
                    }
                    catch (HandlerException hEx) {
                        this.callbackHandler.onConnectionLost(this, hEx);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException ex) {
                log.log(Level.INFO, "exception running reactor", ex);
            }
        });
        return this.connectFuture;
    }

    public boolean isConnected() {
        return this.authSessionHandler != null && this.authSessionHandler.isConnected() && this.deviceSessionHandler != null && this.deviceSessionHandler.isConnected();
    }

    public void disconnect() {
        this.callbackHandler = null;
        if (this.deviceSessionHandler != null) {
            this.deviceSessionHandler.close();
            this.deviceSessionHandler = null;
        }
        if (this.authSessionHandler != null) {
            this.authSessionHandler.close();
            this.authSessionHandler = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.reactor != null) {
            this.reactor.stop();
            this.reactor.free();
            this.reactor = null;
        }
        if (this.worker != null) {
            this.worker.shutdown();
            this.worker = null;
        }
    }

    public CompletableFuture<Delivery> send(AmqpMessage message) {
        if (!this.isConnected()) {
            CompletableFuture<Delivery> future = new CompletableFuture<Delivery>();
            future.completeExceptionally(new IOException("Client not connected"));
            return future;
        }
        return this.deviceSessionHandler.send(message);
    }

    @Override
    public void onReactorInit(Event event) {
        log.finest(event.toString());
        String hostname = this.connectionInfo.get("hostName");
        int port = 5671;
        if (this.useWebSockets) {
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(URI.create("https://" + hostname));
            if (AmqpClient.isProxyValid(proxies)) {
                this.proxy = proxies.get(0);
                InetSocketAddress address = (InetSocketAddress)this.proxy.address();
                hostname = address.getHostName();
                port = address.getPort();
            } else {
                port = 443;
            }
        }
        event.getReactor().connectionToHost(hostname, port, this);
    }

    @Override
    public void onReactorFinal(Event event) {
        log.finest(event.toString());
        this.reactor = null;
    }

    @Override
    public void onConnectionInit(Event event) {
        log.finest(event.toString());
        this.connection = event.getConnection();
        this.connection.setHostname(this.connectionInfo.get("hostName"));
        this.connection.open();
        this.authSessionHandler = new AmqpAuthSessionHandler(this.connection.session(), this);
        this.deviceSessionHandler = new AmqpDeviceSessionHandler(this.connection.session(), this);
    }

    @Override
    public void onConnectionBound(Event event) {
        log.finest(event.toString());
        Connection connection = event.getConnection();
        Transport transport = connection.getTransport();
        if (this.useWebSockets) {
            WebSocketImpl webSocket = new WebSocketImpl();
            webSocket.configure(this.connectionInfo.get("hostName"), "/$iothub/websocket", "iothub-no-client-cert=true", 0, "AMQPWSB10", null, null);
            ((TransportInternal)transport).addTransportLayer(webSocket);
        }
        Sasl sasl = transport.sasl();
        sasl.setMechanisms("ANONYMOUS");
        SslDomain domain = Proton.sslDomain();
        try {
            SSLContext context = SSLContext.getInstance(this.sslProtocol);
            ISecurityInfoProvider securityInfoProvider = SecurityInitializer.getInstance().getSecurityInfoProvider();
            CoreCryptoManager coreCryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)securityInfoProvider);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (IX509CertificateEntry systemCert : coreCryptoManager.getSystemTrustStore().getCertificateEntries()) {
                trustAnchors.add(new TrustAnchor(systemCert.getCertificate(0).getCertificate(), null));
            }
            for (IX509CertificateEntry userCert : coreCryptoManager.getUserTrustStore().getCertificateEntries()) {
                trustAnchors.add(new TrustAnchor(userCert.getCertificate(0).getCertificate(), null));
            }
            context.init(null, TrustManagerBuilder.getTrustManagers(trustAnchors), new SecureRandom());
            domain.setSslContext(context);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Unable to create AMQP SSL context", ex);
        }
        domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
        domain.init(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
        if (this.proxy != null) {
            ProxyImpl proxyImpl = new ProxyImpl();
            proxyImpl.configure("https://" + event.getConnection().getHostname() + ':' + 443, null, new ProxyHandler(), transport);
            ((TransportInternal)transport).addTransportLayer(proxyImpl);
        }
    }

    @Override
    public void onConnectionLocalClose(Event event) {
        log.finest(event.toString());
        if (this.deviceSessionHandler != null) {
            this.deviceSessionHandler.close();
        }
        if (this.authSessionHandler != null) {
            this.authSessionHandler.close();
        }
        event.getReactor().stop();
    }

    @Override
    public void onConnectionRemoteClose(Event event) {
        log.finest(event.toString());
        Connection conn = event.getConnection();
        if (conn.getLocalState() == EndpointState.ACTIVE) {
            this.connection.close();
        } else {
            event.getReactor().stop();
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.onConnectionLost(this, new IOException("Remote connection closed"));
        }
    }

    @Override
    public void onTransportError(Event event) {
        log.finest(event.toString());
        String errorString = event.getTransport() != null && event.getTransport().getCondition() != null ? event.getTransport().getCondition().toString() : "unknown transport error occurred";
        Connection connection = event.getConnection();
        if (connection != null) {
            connection.close();
        }
        if (this.connectFuture != null && !this.connectFuture.isDone()) {
            this.connectFuture.completeExceptionally(new IOException(errorString));
            this.connectFuture = null;
        }
        this.callbackHandler.onConnectionLost(this, new IOException(errorString));
    }

    IAmqpCallbacks getCallbackHandler() {
        return this.callbackHandler;
    }

    Map<String, String> getConnectionInfo() {
        return this.connectionInfo;
    }

    void authenticated() {
        this.deviceSessionHandler.openLinks();
    }

    void connected() {
        this.connectFuture.complete(true);
        this.connectFuture = null;
    }

    private static boolean isProxyValid(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }
}

