/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioException;
import com.tridium.ndio.NdioProperties;
import com.tridium.ndio.NdioRebootException;
import javax.baja.log.Log;

public class NdioProcessor
implements NdioConstants {
    static final Log log = Log.getLog((String)"ndio");
    private int ioPort;
    private boolean master;
    private int hdwrAddress = -1;
    private String firmwareVersion = "-";
    private int configCode = 0;
    private NdioProperties ndioProps = NdioProperties.DEFAULT;
    private long firstReadTicks = -1L;

    public NdioProcessor() {
        this.ioPort = -1;
        this.master = true;
    }

    public NdioProcessor(int ioPort, boolean master) {
        this.ioPort = ioPort;
        this.master = master;
        try {
            this.initDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHdwrAddress() {
        return this.hdwrAddress;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getConfigCode() {
        return this.configCode;
    }

    public boolean getMultipleProcessors() {
        return this.ndioProps.getMultipleProcessors();
    }

    public int getUiCount() {
        return this.ndioProps.getUiCount();
    }

    public int getBoCount() {
        return this.ndioProps.getBoCount();
    }

    public int getAoCount() {
        return this.ndioProps.getAoCount();
    }

    public boolean getUiBiEnabled() {
        return this.ndioProps.getUiBiEnabled();
    }

    public boolean getUiHsEnabled() {
        return this.ndioProps.getUiHsEnabled();
    }

    public boolean getUiThEnabled() {
        return this.ndioProps.getUiThEnabled();
    }

    public boolean getUiPlEnabled() {
        return this.ndioProps.getUiPlEnabled();
    }

    public boolean getUiVEnabled() {
        return this.ndioProps.getUiVEnabled();
    }

    public boolean getUiMaEnabled() {
        return this.ndioProps.getUiMaEnabled();
    }

    public int getCount(int type) {
        return this.ndioProps.getCount(type);
    }

    public int getAoType(int index) {
        return this.ndioProps.getAoType(index);
    }

    int getAoOverrideMap(int index) {
        return this.ndioProps.getAoOverrideMap(index);
    }

    int getDoOverrideMap(int index) {
        return this.ndioProps.getDoOverrideMap(index);
    }

    public void resetInfo() {
        this.firmwareVersion = "-";
        this.configCode = 0;
        this.hdwrAddress = -1;
        this.ndioProps = NdioProperties.DEFAULT;
    }

    public void initDevice() throws Exception {
        this.resetInfo();
        this.recalcHdwrAddress();
        if (this.hdwrAddress < 0 || this.hdwrAddress > 7) {
            return;
        }
        if (BNdioNetwork.getPlatformService() != null) {
            int intf = BNdioNetwork.getPlatformService().getFirmwareIntfNum(this.hdwrAddress);
            int build = BNdioNetwork.getPlatformService().getFirmwareBuildNum(this.hdwrAddress);
            this.firmwareVersion = intf + "." + build;
            this.configCode = BNdioNetwork.getPlatformService().readConfigCode(this.hdwrAddress);
            this.ndioProps = NdioProperties.make(this.configCode);
        }
    }

    public int readUIType(int index) throws Exception {
        return BNdioNetwork.getPlatformService().readUIType(this.hdwrAddress, index - 1);
    }

    public void writeUIType(int index, int subtype) throws Exception {
        BNdioNetwork.getPlatformService().writeUIType(this.hdwrAddress, index - 1, subtype);
    }

    public int readValue(int type, int index) throws Exception {
        int value = BNdioNetwork.getPlatformService().readValue(this.hdwrAddress, type, index - 1);
        return value;
    }

    public void writeValue(int type, int index, int value) throws Exception {
        BNdioNetwork.getPlatformService().writeValue(this.hdwrAddress, type, index - 1, value);
    }

    public long readUICount(int index) throws Exception {
        return BNdioNetwork.getPlatformService().readUICount(this.hdwrAddress, index - 1);
    }

    public long readUICountDelta(int index) throws Exception {
        return BNdioNetwork.getPlatformService().readUICountDelta(this.hdwrAddress, index - 1);
    }

    public void recalcHdwrAddress() {
        int addr = -1;
        if (this.ioPort >= 0) {
            addr = IO_PORT_TO_PROC_0[this.ioPort];
            if (!this.master) {
                ++addr;
            }
        }
        this.hdwrAddress = addr;
    }

    public void ping() throws Exception {
        int ioType = BNdioNetwork.getPlatformService().readIoType(this.hdwrAddress);
        int ioConfigState = BNdioNetwork.getPlatformService().readIoConfigState(this.hdwrAddress);
        if (ioType == 0 || ioConfigState == 0 || ioConfigState == 1) {
            throw new NdioException("processor @ " + this.hdwrAddress + " was not found");
        }
        if (!BNdioNetwork.getPlatformService().isProcessorOk(this.hdwrAddress)) {
            log.error("processor " + this.hdwrAddress + " is not 'ok'");
            throw new NdioRebootException("processor " + this.hdwrAddress + " is not 'ok'");
        }
        if (BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress) != 0) {
            log.error("processor " + this.hdwrAddress + " failed with error flags " + BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress));
            throw new NdioException("processor " + this.hdwrAddress + " failed with error flags " + BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress));
        }
    }
}

