/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.learn;

import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProperties;
import com.tridium.ndio.learn.BNdioBoardEntry;
import com.tridium.platNdio.BNdioPlatformService;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNdioBoardDiscoveryJob
extends BSimpleJob
implements NdioConstants {
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioBoardDiscoveryJob.class);
    BNdioNetwork network;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNdioBoardDiscoveryJob() {
    }

    public BNdioBoardDiscoveryJob(BNdioNetwork network) {
        this.network = network;
    }

    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru ndioNetwork.submitDiscoveryJob()");
        }
        this.log().start("Board discovery");
        this.removeAll();
        BNdioPlatformService platSvc = BNdioNetwork.getPlatformService();
        if (platSvc == null) {
            this.log().failed("Unable to find NdioPlatformService.");
            return;
        }
        this.progress(0);
        for (int i = 0; i < 8; i += 2) {
            try {
                int ioType = platSvc.readIoType(i);
                int ioConfigState = platSvc.readIoConfigState(i);
                if (ioType != 0 && ioConfigState != 0 && ioConfigState != 1) {
                    BNdioBoardEntry board;
                    int code = platSvc.readConfigCode(i);
                    NdioProperties props = NdioProperties.make(code);
                    if (props.getMultipleProcessors()) {
                        ioType = platSvc.readIoType(i + 1);
                        ioConfigState = platSvc.readIoConfigState(i + 1);
                        if (ioType != 0 && ioConfigState != 0 && ioConfigState != 1) {
                            board = new BNdioBoardEntry(PROC_TO_IO_PORT[i]);
                            this.log().success("Found ndio board @ io port " + (i + 1));
                            this.add("s" + i, (BValue)board, 1);
                        }
                    } else {
                        board = new BNdioBoardEntry(PROC_TO_IO_PORT[i]);
                        this.log().success("Found ndio board @ io port " + (i + 1));
                        this.add("s" + i, (BValue)board, 1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.progress((int)((float)(i + 1) / 8.0f * 100.0f));
        }
        this.progress(100);
        this.log().success("Discovery done");
    }
}

