/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioOutputProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="pointType", type="BNdioPointTypeEnum", defaultValue="BNdioPointTypeEnum.booleanOutput", flags=1, override=true)
public class BNdioBooleanOutputProxyExt
extends BNdioOutputProxyExt {
    @Generated
    public static final Property pointType = BNdioBooleanOutputProxyExt.newProperty((int)1, (BValue)BNdioPointTypeEnum.booleanOutput, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioBooleanOutputProxyExt.class);
    private boolean pendingValue = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BBooleanPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    @Override
    public void read() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            BStatusBoolean value = this.readBooleanValue();
            this.readOk((BStatusValue)value);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    @Override
    public boolean write(Context cx) {
        if (!Sys.atSteadyState()) {
            this.pendingValue = true;
        }
        if (!this.pointSynchronized()) {
            return false;
        }
        if (this.getWriteValue().getStatus().isNull()) {
            return false;
        }
        boolean value = ((BStatusBoolean)this.getWriteValue()).getBoolean();
        try {
            this.writeBooleanValue(value);
            this.writeOk(this.getWriteValue());
            this.readOk((BStatusValue)new BStatusBoolean(value));
            return true;
        }
        catch (Exception e) {
            this.writeFail(e.getMessage());
            return false;
        }
    }

    public void atSteadyState() throws Exception {
        if (this.pendingValue) {
            this.write(null);
        }
    }

    public boolean isUniversalInput() {
        return false;
    }

    public boolean isAnalogOutput() {
        return false;
    }

    public boolean isBooleanOutput() {
        return true;
    }

    @Override
    public BNdioIoTypeEnum getIoType() {
        return BNdioIoTypeEnum.booleanOutput;
    }

    protected BStatusBoolean readBooleanValue() throws Exception {
        int value = this.getBoard().readValue(3, this.getAddress());
        this.setRaw(value);
        boolean bvalue = value != 0;
        boolean orval = this.getBoard().readOverrideValue(3, this.getAddress());
        BStatusBoolean svalue = new BStatusBoolean(bvalue);
        this.getHardwareOverride().evaluate((BStatusValue)svalue, orval);
        return svalue;
    }

    protected void writeBooleanValue(boolean value) throws Exception {
        boolean bvalue = value;
        this.getBoard().writeValue(3, this.getAddress(), bvalue ? 1 : 0);
    }
}

