/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.point.BNdioProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BNdioUniversalInputProxyExt
extends BNdioProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioUniversalInputProxyExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        try {
            this.getBoard().writeUIType(this.getAddress(), this.getUiType());
        }
        catch (Exception e) {
            log.trace("Unable to initialize ui type", (Throwable)e);
        }
    }

    @Override
    public BNdioIoTypeEnum getIoType() {
        return BNdioIoTypeEnum.universalInput;
    }

    private int getUiType() {
        switch (this.getPointType().getOrdinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
        }
        log.error("BNdioProxyExt: getIOType returned invalid ui type");
        return -1;
    }

    @Override
    protected boolean pointSynchronized() {
        if (!this.getNdioNetwork().isKeepAliveStarted()) {
            return false;
        }
        if (this.getBoard().isDown()) {
            return false;
        }
        if (this.getBoard().isFault()) {
            return false;
        }
        if (this.isFatalFault()) {
            return false;
        }
        if (this.isConfigFault()) {
            return false;
        }
        if (this.getSynced()) {
            return true;
        }
        try {
            log.trace("checkSynchronization: checking synchronization for " + this.getPointType() + " @ " + this.getAddress());
            BNdioBoard board = this.getBoard();
            int uiNewType = this.getUiType();
            int uiOldType = this.getBoard().readUIType(this.getAddress());
            if (uiOldType != uiNewType) {
                this.getBoard().writeUIType(this.getAddress(), uiNewType);
                uiOldType = this.getBoard().readUIType(this.getAddress());
                if (uiOldType != uiNewType) {
                    this.readFail("synchronization failed trying to update " + this.getPointType() + " @ " + this.getAddress());
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.readFail("unable to synchronize ui type: " + e.getMessage());
            return false;
        }
        this.setSynced(true);
        return true;
    }
}

