/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.type;

import com.tridium.ndio.type.BAbstractRateType;
import com.tridium.ndio.type.BRecalcRateAction;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BTriggerRateType
extends BAbstractRateType {
    @Generated
    public static final Type TYPE = Sys.loadType(BTriggerRateType.class);
    private long lastCount = 0L;
    private long lastTicks = 0L;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void initType() {
        try {
            BProxyExt ext = (BProxyExt)this.getParent();
            ext.getParentPoint().add("recalculateRate", (BValue)new BRecalcRateAction());
        }
        catch (Exception e) {
            log.error("Unable to add RecalcRateAction", (Throwable)e);
        }
    }

    @Override
    public void cleanupType() {
        try {
            BProxyExt ext = (BProxyExt)this.getParent();
            ext.getParentPoint().remove("recalculateRate");
        }
        catch (Exception e) {
            log.error("Unable to remove RecalcRateAction", (Throwable)e);
        }
    }

    @Override
    public synchronized void resetRate() {
        this.lastCount = 0L;
        this.lastTicks = 0L;
        if (this.getCounterProxy() != null) {
            this.getCounterProxy().setStale(true, null);
        }
    }

    @Override
    public synchronized BStatusNumeric calculateRate(long count) {
        long ticks = Clock.ticks();
        if (this.lastTicks == 0L) {
            this.lastTicks = ticks;
            this.lastCount = count;
            return null;
        }
        long tickDelta = (ticks - this.lastTicks) / 1000L;
        float rate = (float)(count - this.lastCount) / (float)tickDelta;
        this.lastTicks = ticks;
        this.lastCount = count;
        BStatusNumeric srate = new BStatusNumeric((double)(rate *= this.getScale()));
        this.getCounterProxy().setRateCalcTime(BAbsTime.now());
        return srate;
    }
}

