/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.ui.BTemplateConfigEditor;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.BTemplateView;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.template.ui.tag.TagSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BTemplateRelationEditor
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateRelationEditor.class);
    private static Lexicon lex = Lexicon.make((String)"template");
    private static BModule module = Sys.getModuleForClass(BTemplateRelationEditor.class);
    private static BImage inIcon = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage outIcon = BImage.make((String)"module://icons/x16/arrowRight.png");
    BTemplateView view;
    private BComponent templateConfig;
    private BTable relationTable;
    private BTable selectTable;
    RelationInfo[] list;
    private BWidget owner;
    private Add add;
    private Reverse reverse;
    private Remove remove;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTemplateRelationEditor() {
        throw new IllegalStateException();
    }

    public BTemplateRelationEditor(BTemplateView view, BTemplateConfig config) {
        this.owner = view.getShell();
        this.view = view;
        this.templateConfig = config;
        RelateInfoModel model = new RelateInfoModel();
        this.relationTable = new BTable((TableModel)model);
        this.relationTable.setController((TableController)new RelateInfoController());
        this.relationTable.setSelection((TableSelection)new RelateInfoSelection());
        this.relationTable.setHeaderRenderer((TableHeaderRenderer)new RelateInfoHeaderRenderer());
        this.relationTable.setCellRenderer((TableCellRenderer)new RelateInfoRenderer());
        Model selectModel = new Model();
        this.selectTable = new BTable((TableModel)selectModel);
        this.selectTable.setMultipleSelection(false);
        this.selectTable.setController((TableController)new Controller());
        this.selectTable.setSelection((TableSelection)new Selection());
        this.initRelationTable();
        int i = 0;
        for (RelationInfo relationInfo : this.getRelationInfos()) {
            selectModel.add(i++, relationInfo.getRelationId().getQName());
        }
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(15.0);
        split.setWidget1(this.buildLeftPane());
        split.setWidget2(this.buildRightPane());
        this.setCenter((BWidget)split);
    }

    private BWidget buildLeftPane() {
        this.add = new Add((BWidget)this);
        this.add.setEnabled(true);
        BButton a = new BButton((Command)this.add);
        a.setButtonStyle(BButtonStyle.toolBar);
        BGridPane top = new BGridPane(1);
        top.setHalign(BHalign.left);
        top.add(null, (BValue)a);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.selectTable, BBorder.none, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    private BWidget buildRightPane() {
        this.reverse = new Reverse((BWidget)this);
        this.remove = new Remove((BWidget)this);
        this.reverse.setEnabled(false);
        this.remove.setEnabled(false);
        BButton a = new BButton((Command)this.reverse);
        BButton c = new BButton((Command)this.remove);
        a.setButtonStyle(BButtonStyle.toolBar);
        c.setButtonStyle(BButtonStyle.toolBar);
        BGridPane topLeft = new BGridPane(3);
        topLeft.add(null, (BValue)a);
        topLeft.add(null, (BValue)c);
        BGridPane topRight = new BGridPane(2);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)topLeft);
        top.setRight((BWidget)topRight);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.relationTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    public boolean hasValidHints() {
        RelateInfoModel model = (RelateInfoModel)this.relationTable.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BRelationInfo relationInfo = model.get(i);
            String predicateStatus = TagSupport.isNeqlPredicateValid(relationInfo.getRelateHints(), "RelateHints");
            if (predicateStatus.equals("")) continue;
            return false;
        }
        return true;
    }

    public void save() {
        Property[] properties;
        this.templateConfig.lease(Integer.MAX_VALUE);
        Context tx = Transaction.start((BComponent)this.templateConfig, null);
        for (Property property : properties = this.templateConfig.getPropertiesArray()) {
            if (!(this.templateConfig.get(property) instanceof BRelationInfo)) continue;
            this.templateConfig.remove(property, tx);
        }
        RelateInfoModel model = (RelateInfoModel)this.relationTable.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BRelationInfo relationInfo = model.get(i);
            this.templateConfig.add("relate?", (BValue)relationInfo, 5, tx);
        }
        try {
            Transaction.end((BComponent)this.templateConfig, (Context)tx);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getShell(), (String)"Error", (Object)"createTemplateConfig failed.", (Throwable)e);
        }
    }

    private void initRelationTable() {
        RelateInfoModel model = (RelateInfoModel)this.relationTable.getModel();
        for (BRelationInfo relationInfo : (BRelationInfo[])this.templateConfig.getChildren(BRelationInfo.class)) {
            model.add((BRelationInfo)relationInfo.newCopy());
        }
    }

    private RelationInfo[] getRelationInfos() {
        RelationInfo relInfo;
        Iterator relInfos;
        Array relList;
        if (this.list != null) {
            return this.list;
        }
        Collection dictionaries = null;
        TagDictionaryService tdService = null;
        try {
            tdService = this.templateConfig.getTagDictionaryService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tdService != null) {
            dictionaries = tdService.getTagDictionaries();
            if (dictionaries.size() != 0) {
                relList = new Array(RelationInfo.class);
                for (TagDictionary tagDictionary : tdService.getTagDictionaries()) {
                    relInfos = tagDictionary.getRelations();
                    while (relInfos.hasNext()) {
                        relInfo = (RelationInfo)relInfos.next();
                        relList.add((Object)relInfo);
                    }
                }
            }
        } else {
            tdService = TmplUtil.makeTagDictionaryService();
            if (tdService != null) {
                dictionaries = tdService.getTagDictionaries();
            }
        }
        if (dictionaries != null && dictionaries.size() != 0) {
            relList = new Array(RelationInfo.class);
            for (TagDictionary tagDictionary : dictionaries) {
                relInfos = tagDictionary.getRelations();
                while (relInfos.hasNext()) {
                    relInfo = (RelationInfo)relInfos.next();
                    relList.add((Object)relInfo);
                }
            }
        } else {
            throw new RuntimeException(lex.getText("relateCommand.noTagService.error.message"));
        }
        this.list = (RelationInfo[])relList.trim();
        return this.list;
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            RelateInfoModel relationTableModel = (RelateInfoModel)BTemplateRelationEditor.this.relationTable.getModel();
            Model selectModel = (Model)BTemplateRelationEditor.this.selectTable.getModel();
            int i = this.getRow();
            if (i < 0) {
                BTemplateRelationEditor.this.add.setEnabled(true);
            } else if (i >= 0) {
                String relationId = selectModel.getValueAt(i, 0);
                BTemplateRelationEditor.this.add.setEnabled(!relationTableModel.contains(relationId, true) || !relationTableModel.contains(relationId, false));
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            if (BTemplateRelationEditor.this.add.isEnabled()) {
                BTemplateRelationEditor.this.add.invoke();
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (column == 0 && BTemplateRelationEditor.this.add.isEnabled()) {
                BTemplateRelationEditor.this.add.invoke();
            }
        }
    }

    class Model
    extends TableModel {
        HashMap<Integer, String> choices = new HashMap();

        Model() {
        }

        public int getRowCount() {
            return this.choices.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "RelationId";
        }

        public String getValueAt(int row, int col) {
            return this.choices.get(row);
        }

        public void add(int row, String relationId) {
            if (!this.choices.containsValue(relationId)) {
                this.choices.put(row, relationId);
            }
        }

        public int getRowFor(String relationId) {
            if (!this.choices.containsValue(relationId)) {
                return -1;
            }
            int row = 0;
            for (String id : this.choices.values()) {
                if (id.equals(relationId)) {
                    return row;
                }
                ++row;
            }
            return -1;
        }
    }

    class RelateInfoRenderer
    extends TableCellRenderer {
        RelateInfoRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 5) {
                return BBrush.makeSolid((BColor)BColor.red);
            }
            return super.getForeground(cell);
        }
    }

    class RelateInfoHeaderRenderer
    extends TableHeaderRenderer {
        RelateInfoHeaderRenderer() {
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            double width = super.getPreferredHeaderWidth(header);
            if (header.column == 1 && width < BTemplateConfigEditor.COL0_MIN_WIDTH) {
                return BTemplateConfigEditor.COL0_MIN_WIDTH;
            }
            return width;
        }
    }

    class RelateInfoSelection
    extends TableSelection {
        RelateInfoSelection() {
        }

        public void updateTable() {
            super.updateTable();
            RelateInfoModel model = (RelateInfoModel)this.getTable().getModel();
            int[] rows = this.getRows();
            BTemplateRelationEditor.this.remove.setEnabled(rows.length > 0);
            boolean revEnable = true;
            for (int i : rows) {
                BRelationInfo relationInfo = model.get(i);
                if (!model.contains(relationInfo.getRelationId(), !relationInfo.getInbound())) continue;
                revEnable = false;
                break;
            }
            BTemplateRelationEditor.this.reverse.setEnabled(revEnable);
        }
    }

    class RelateInfoController
    extends TableController {
        RelateInfoController() {
        }

        protected void checkSelection(BMouseEvent event, int row) {
            super.checkSelection(event, row);
            int selRow = BTemplateRelationEditor.this.relationTable.getSelection().getRow();
            if (selRow >= 0) {
                RelateInfoModel model = (RelateInfoModel)BTemplateRelationEditor.this.relationTable.getModel();
                String relationId = model.get(selRow).getRelationId();
                TableSelection idSelection = BTemplateRelationEditor.this.selectTable.getSelection();
                Model idModel = (Model)BTemplateRelationEditor.this.selectTable.getModel();
                int idRow = idModel.getRowFor(relationId);
                idSelection.deselectAll();
                idSelection.select(idRow);
            }
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 127 && BTemplateRelationEditor.this.remove.isEnabled()) {
                BTemplateRelationEditor.this.remove.invoke();
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BValue newValue;
            BString valueAt;
            BRelationInfo value;
            if (column == 1 && BTemplateRelationEditor.this.reverse.isEnabled()) {
                BTemplateRelationEditor.this.reverse.invoke();
            }
            if (column == 2) {
                value = (BRelationInfo)BTemplateRelationEditor.this.relationTable.getModel().getSubject(row);
                valueAt = BString.make((String)value.getRelateHints());
                newValue = this.editCellValue(valueAt, lex.getText("templateRelationEditor.relateHints"));
                if (newValue == null) {
                    return;
                }
                value.setRelateHints(newValue.toString());
                BTemplateRelationEditor.this.view.templateModified();
            }
            if (column == 3) {
                value = (BRelationInfo)BTemplateRelationEditor.this.relationTable.getModel().getSubject(row);
                valueAt = BString.make((String)value.getUserTip());
                newValue = this.editCellValue(valueAt, lex.getText("templateRelationEditor.userTip"));
                if (newValue == null) {
                    return;
                }
                value.setUserTip(newValue.toString());
                BTemplateRelationEditor.this.view.templateModified();
            }
            if (column == 4) {
                value = (BRelationInfo)BTemplateRelationEditor.this.relationTable.getModel().getSubject(row);
                valueAt = BString.make((String)value.getSlotPathScope());
                newValue = this.editCellValue(valueAt, lex.getText("templateRelationEditor.slotPathScope"));
                if (newValue == null) {
                    return;
                }
                value.setSlotPathScope(newValue.toString());
                BTemplateRelationEditor.this.view.templateModified();
            }
            BTemplateRelationEditor.this.relationTable.repaint();
        }

        private BValue editCellValue(BString value, String prompt) {
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)value);
            editor.loadValue((BObject)value);
            BGridPane grid = new BGridPane(1);
            grid.add(null, (BValue)new BLabel(prompt));
            grid.add(null, (BValue)editor);
            BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
            if (1 != BDialog.open((BWidget)BTemplateRelationEditor.this.view, (String)lex.getText("controlAppConfigEditor.setValue.label"), (Object)pane, (int)3)) {
                return null;
            }
            BValue newValue = null;
            try {
                newValue = editor.saveValue().asValue();
            }
            catch (Exception e) {
                BTemplateManager.log.log(Level.WARNING, lex.getText("templateRelationEditor.saveError"), e);
            }
            return newValue;
        }
    }

    public class RelateInfoModel
    extends TableModel {
        ArrayList<BRelationInfo> kids = new ArrayList();

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("templateRelationEditor.relationId");
                }
                case 1: {
                    return lex.getText("templateRelationEditor.dir");
                }
                case 2: {
                    return lex.getText("templateRelationEditor.relateHints");
                }
                case 3: {
                    return lex.getText("templateRelationEditor.userTip");
                }
                case 4: {
                    return lex.getText("templateRelationEditor.slotPathScope");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BRelationInfo relationInfo = this.kids.get(row);
            switch (col) {
                case 0: {
                    return relationInfo.getRelationId();
                }
                case 1: {
                    return relationInfo.getInbound() ? lex.getText("templateRelationEditor.in") : lex.getText("templateRelationEditor.out");
                }
                case 2: {
                    return relationInfo.getRelateHints();
                }
                case 3: {
                    return relationInfo.getUserTip();
                }
                case 4: {
                    return relationInfo.getSlotPathScope();
                }
                case 5: {
                    return TagSupport.isNeqlPredicateValid(relationInfo.getRelateHints(), "RelateHints");
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public BImage getRowIcon(int row) {
            BRelationInfo relationInfo = this.kids.get(row);
            return relationInfo.getInbound() ? inIcon : outIcon;
        }

        public void add(BRelationInfo relationInfo) {
            this.kids.add(relationInfo);
        }

        public void add(String relationId, boolean inbound, String relateHints, String userTip, String slotPathScope) {
            BRelationInfo relationInfo = BRelationInfo.make((boolean)inbound, (String)relationId, (String)relateHints, (String)userTip, (String)slotPathScope);
            this.kids.add(relationInfo);
        }

        public void remove(int row) {
            this.kids.remove(row);
        }

        public BRelationInfo get(int row) {
            if (row > this.kids.size()) {
                return null;
            }
            return this.kids.get(row);
        }

        public boolean contains(String relationId, boolean inbound) {
            for (BRelationInfo kid : this.kids) {
                if (!kid.getRelationId().equals(relationId) || kid.getInbound() != inbound) continue;
                return true;
            }
            return false;
        }
    }

    public class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.remove");
        }

        public CommandArtifact doInvoke() {
            RelateInfoModel model = (RelateInfoModel)BTemplateRelationEditor.this.relationTable.getModel();
            int[] rows = model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                model.remove(rows[i] - i);
            }
            BTemplateRelationEditor.this.relationTable.getSelection().deselectAll();
            BTemplateRelationEditor.this.relationTable.relayout();
            BTemplateRelationEditor.this.view.templateModified();
            return null;
        }
    }

    public class Reverse
    extends Command {
        public Reverse(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.reverse");
        }

        public CommandArtifact doInvoke() {
            int[] rows;
            RelateInfoModel model = (RelateInfoModel)BTemplateRelationEditor.this.relationTable.getModel();
            for (int row : rows = BTemplateRelationEditor.this.relationTable.getSelection().getRows()) {
                BRelationInfo relationInfo;
                relationInfo.setInbound(!(relationInfo = (BRelationInfo)model.getSubject(row)).getInbound());
            }
            BTemplateRelationEditor.this.relationTable.repaint();
            BTemplateRelationEditor.this.view.templateModified();
            return null;
        }
    }

    public class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.add");
        }

        public CommandArtifact doInvoke() {
            RelateInfoModel model = (RelateInfoModel)BTemplateRelationEditor.this.relationTable.getModel();
            TableSelection tableSelection = BTemplateRelationEditor.this.selectTable.getSelection();
            TableModel selectModel = BTemplateRelationEditor.this.selectTable.getModel();
            int row = tableSelection.getRow();
            if (row < 0) {
                boolean noRelateId = true;
                while (noRelateId) {
                    String relateId = BDialog.prompt((BWidget)BTemplateRelationEditor.this.owner, (String)lex.getText("templateRelationEditor.addHoc.enterRelationId"), (String)"", (int)32);
                    if (relateId == null || relateId.equals("")) {
                        noRelateId = false;
                        continue;
                    }
                    String[] split = (relateId = relateId.trim()).split(":", 0);
                    if (split.length != 2) {
                        BDialog.error((BWidget)BTemplateRelationEditor.this.owner, (Object)lex.getText("templateRelationEditor.addHoc.invalidId"));
                        continue;
                    }
                    if (!model.contains(relateId, true)) {
                        model.add(relateId, true, "", "", "");
                        noRelateId = false;
                        BTemplateRelationEditor.this.view.templateModified();
                        continue;
                    }
                    if (!model.contains(relateId, false)) {
                        model.add(relateId, false, "", "", "");
                        noRelateId = false;
                        BTemplateRelationEditor.this.view.templateModified();
                        continue;
                    }
                    BDialog.error((BWidget)BTemplateRelationEditor.this.owner, (Object)lex.getText("templateRelationEditor.addHoc.alreadyDefined"));
                }
            } else if (row >= 0) {
                String relationId = (String)selectModel.getValueAt(row, 0);
                if (!model.contains(relationId, true)) {
                    model.add(relationId, true, "", "", "");
                } else if (!model.contains(relationId, false)) {
                    model.add(relationId, false, "", "", "");
                }
                tableSelection.updateTable();
                BTemplateRelationEditor.this.relationTable.getSelection().updateTable();
                BTemplateRelationEditor.this.view.templateModified();
            }
            return null;
        }
    }
}

