/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.sys.transfer.DeployToComp;
import com.tridium.template.TemplateConst;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDeployable;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;

class UpdateUtil
implements TemplateConst {
    public static final Logger log = Logger.getLogger("ntpl");

    UpdateUtil() {
    }

    static boolean updateNtplFile(BWbDeployableNtplFile ntplFile, BComponent target) {
        try {
            BIDeployable.Step[] transferSteps;
            for (BIDeployable.Step transferStep : transferSteps = ntplFile.makeNtplTransferStep(target)) {
                if (transferStep == null) continue;
                BObject tgt = UpdateUtil.getTarget(transferStep.destination, (BObject)target);
                transferStep.mark.copyTo(tgt, new BComponent(), DeployToComp.NoPostLink);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error updating template file " + ntplFile.getFileName(), e);
            return false;
        }
    }

    private static BObject getTarget(BOrd ord, BObject target) throws Exception {
        BObject obj;
        try {
            obj = ord.resolve(target).get();
        }
        catch (UnresolvedException e) {
            OrdQuery[] oqs;
            for (OrdQuery oq : oqs = ord.parse()) {
                if (!(oq instanceof FilePath)) continue;
                FilePath fp = (FilePath)oq;
                BDirectory rootDir = (BDirectory)BOrd.make((String)"file:^").resolve(target).get();
                rootDir.getFileSpace().makeDir(fp);
            }
            obj = ord.resolve(target).get();
        }
        return obj;
    }
}

