/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.file;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BVersion;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.BTemplateValues;
import com.tridium.template.api.TemplateType;
import com.tridium.template.file.BMemoryFileSpace;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.util.CompUtil;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDeployable;
import javax.baja.file.BIFile;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.file.zip.ZipPath;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.Path;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.BPxTemplateInfo;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

@NiagaraType(ext={@FileExt(name="ntpl"), @FileExt(name="napl")})
public class BWbDeployableNtplFile
extends BNtplFile
implements BIDeployable {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbDeployableNtplFile.class);
    private Object owner = null;
    private boolean isModule = false;
    private FilePath stationDir = null;
    private String missingModules = null;
    private String missingPxModules = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbDeployableNtplFile() {
    }

    public BWbDeployableNtplFile(BMemoryFileStore fs, TemplateManifest manifest, BBogFile bog, PxFileRef[] pxRefs, BImageFile[] imageRefs) {
        super(fs, manifest, bog, pxRefs, imageRefs, null);
    }

    public BWbDeployableNtplFile(BMemoryFileStore fs, TemplateManifest manifest, BBogFile bog, PxFileRef[] pxRefs, BImageFile[] imageRefs, BDataFile[] stationFiles) {
        super(fs, manifest, bog, pxRefs, imageRefs, stationFiles);
    }

    public BWbDeployableNtplFile(BNtplFile f, BMemoryFileStore fs) {
        super(fs, f.getTemplateManifest(), f.getBog(), f.getPxFiles(), f.getPxImageFiles(), f.getStationFiles());
    }

    public static BWbDeployableNtplFile make(BNtplFile f) {
        if (f instanceof BWbDeployableNtplFile) {
            return (BWbDeployableNtplFile)f;
        }
        BMemoryFileStore fs = BMemoryFileSpace.INSTANCE.makeMemoryStore(f.getFileName());
        BWbDeployableNtplFile dNtplFile = new BWbDeployableNtplFile(f, fs);
        fs.setFile((BIFile)dNtplFile);
        return dNtplFile;
    }

    public String getDeployName() {
        return SlotPath.escape((String)this.getFileBase(this.getFileName()));
    }

    public boolean isDeployable(BComponent target) {
        OrdTarget templateTarget;
        boolean isStationDeploy;
        BComponent root = this.getBaseComponent();
        if (root != null && (isStationDeploy = root.getType().is(BStation.TYPE))) {
            this.notifyError(lex.getText("deploy.noStationDeploy"));
            return false;
        }
        BISession session = target.getSession();
        if (session == null) {
            return false;
        }
        BOrd templateServiceOrd = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"service:template:TemplateService");
        try {
            templateTarget = templateServiceOrd.resolve();
        }
        catch (UnresolvedException e) {
            boolean isOffLine = target.getSpace().getType().is(BBogSpace.TYPE);
            if (isOffLine) {
                return true;
            }
            this.notifyError(lex.getText("deploy.templateServiceNotFound.title"), lex.getText("deploy.templateServiceNotFound.msg"), (Exception)((Object)e));
            return false;
        }
        BPermissions permissions = templateTarget.getPermissionsForTarget();
        if (permissions.hasOperatorRead() && permissions.hasOperatorInvoke()) {
            BAbstractService templateService = (BAbstractService)templateTarget.get();
            templateService.lease();
            if (!templateService.isOperational()) {
                if (templateService.isFault()) {
                    this.notifyError(templateService.getFaultCause());
                } else if (templateService.isDisabled()) {
                    this.notifyError(lex.getText("deploy.disabled"));
                } else {
                    this.notifyError(lex.getText("deploy.templateServiceNotFound.title"), lex.getText("deploy.templateServiceNotFound.msg"));
                }
                return false;
            }
            return true;
        }
        this.notifyError(lex.getText("deploy.permissionsError"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIDeployable.Step[] getSteps(Object owner, BComponent target, String name) throws Exception {
        boolean isRemotePre4_3;
        this.owner = owner;
        Version remoteVersion = (Version)target.fw(404, (Object)"template", null, null, null);
        boolean bl = isRemotePre4_3 = remoteVersion.major() == 4 && remoteVersion.minor() < 3;
        if (isRemotePre4_3) {
            TemplateManifest manifest = this.getTemplateManifest();
            BTemplateConfig templateConfig = this.getTemplateConfig();
            BUuid templateUid = BUuid.DEFAULT;
            if (templateConfig != null) {
                templateUid = templateConfig.getUID();
            }
            if (!templateUid.equals((Object)BUuid.DEFAULT)) {
                this.notifyError(lex.get("deploy.4_2_station"));
                return null;
            }
        }
        ArrayList<BIDeployable.Step> al = new ArrayList<BIDeployable.Step>();
        try {
            BSpace space = this.getSpace();
            this.isModule = space instanceof BZipSpace;
            BComponent root = this.getBaseComponent();
            TemplateManifest manifest = this.getTemplateManifest();
            if (root != null) {
                boolean hasMissing;
                BTemplateConfig tc = this.getTemplateConfig();
                tc.checkForValidTemplate();
                Mark mark = new Mark((BObject)root, name);
                boolean bl2 = hasMissing = !TransferUtil.checkForMissingModules((Object)owner, (Mark)mark, (BObject)target, (boolean)false);
                if (hasMissing) {
                    log.finer("BWbDeployableNtplFile.getSteps has missing Modules");
                    BIDeployable.Step[] stepArray = null;
                    return stepArray;
                }
                al.add(new BIDeployable.Step(mark, target.getAbsoluteOrd()));
            }
            BSpace targetSpace = target.getSpace();
            boolean isTargetTemplate = false;
            boolean isOffLine = targetSpace.getType().is(BBogSpace.TYPE);
            BOrd dplDirOrd = null;
            if (isOffLine) {
                BBogFile targetBogFile = ((BBogSpace)targetSpace).getBogFile();
                FilePath filePath = targetBogFile.getFilePath();
                isTargetTemplate = filePath instanceof ZipPath;
                this.stationDir = filePath.getParent();
            } else {
                this.stationDir = null;
            }
            if (!isTargetTemplate) {
                PxFileRef[] pxFileRefs;
                if (owner != null) {
                    Collections.addAll(al, this.makeNtplTransferStep(target));
                }
                if ((pxFileRefs = this.getPxFiles()) != null) {
                    BImageFile[] imageFiles;
                    FilePath pxDeployDir = this.pxDeployDir();
                    dplDirOrd = this.verifyDir(pxDeployDir, target);
                    BPxView[] pxViews = null;
                    if (root != null) {
                        pxViews = (BPxView[])CompUtil.getDescendants((BComponent)root, BPxView.class);
                    }
                    ArrayList<BPxFile> pxl = new ArrayList<BPxFile>();
                    ArrayList<String> nml = new ArrayList<String>();
                    for (PxFileRef pxFileRef : pxFileRefs) {
                        PxDecoder decoder;
                        BWidget wroot;
                        BPxInclude[] pxIncludes;
                        BPxFile pxf = pxFileRef.getPxFile();
                        String pxNam = pxFileRef.getPxName();
                        TemplateManifest.Resource res = manifest.getResource(pxNam, "px");
                        if (res != null && pxViews != null) {
                            for (int n = 0; n < pxViews.length; ++n) {
                                BPxView pv = pxViews[n];
                                if (pv == null || !pv.getPxFile().toString(null).equals(res.sourceOrd)) continue;
                                pv.setPxFile(BOrd.make((OrdQuery)this.pxDeployPath(pxNam)));
                                pxViews[n] = null;
                            }
                        }
                        if ((pxIncludes = (BPxInclude[])CompUtil.getDescendants((BComponent)(wroot = (decoder = new PxDecoder((BIFile)pxf)).decodeDocument()), BPxInclude.class)) != null) {
                            for (BPxInclude pv : pxIncludes) {
                                String pxNam1 = pv.getOrd().toString(null);
                                pxNam1 = pxNam1.substring(pxNam1.lastIndexOf(47) + 1);
                                res = manifest.getResource(pxNam, "px");
                                if (res == null) {
                                    log.log(Level.WARNING, lex.getText("deploy.templatePxResourceResolved"), pxNam);
                                    continue;
                                }
                                BOrd ord = BOrd.make((OrdQuery)this.pxDeployPath(pxNam1));
                                pv.setOrd(ord);
                            }
                        }
                        BPxTemplateInfo tmplInfo = new BPxTemplateInfo(this.getDeployName(), manifest.vendor, manifest.version);
                        CompUtil.setOrAdd((BComponent)wroot, (String)"templateInfo", (BValue)tmplInfo, null);
                        PxEncoder pxEncoder = new PxEncoder(pxf.getOutputStream());
                        PxProperty[] propA = decoder.getPxProperties();
                        PxLayer[] layA = decoder.getPxLayers();
                        boolean hasProperties = propA.length > 0;
                        pxEncoder.setPreserveIdentities(hasProperties);
                        pxEncoder.encodeDocument(wroot, decoder.getPxProperties(), decoder.getPxLayers(), (BAbstractPxView)null);
                        String newNam = this.getPxName(target, pxNam);
                        if (newNam == null) continue;
                        pxl.add(pxf);
                        nml.add(newNam);
                    }
                    if (pxl.size() > 0) {
                        BPxFile[] pxa = pxl.toArray(new BPxFile[0]);
                        String[] nma = nml.toArray(new String[0]);
                        al.add(new BIDeployable.Step(new Mark((BObject[])pxa, nma), dplDirOrd));
                    }
                    if ((imageFiles = this.getPxImageFiles()) != null) {
                        for (BImageFile imageFile : imageFiles) {
                            TemplateManifest.Resource res;
                            if (imageFile == null || (res = manifest.getResource(imageFile.getFileName(), "image")) == null) continue;
                            BOrd targetOrd = BOrd.make((OrdQuery)this.imageDeployDir(res.sourceOrd));
                            try {
                                targetOrd.resolve((BObject)target);
                                log.fine("Using existing image: " + res.sourceOrd);
                            }
                            catch (Exception decoder) {
                                BOrd imageDeployDir = targetOrd.getParent();
                                String imageDeployName = this.getFileNameFromOrd(targetOrd);
                                al.add(new BIDeployable.Step((BObject)imageFile, imageDeployName, imageDeployDir));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.notifyError(e.getLocalizedMessage());
        }
        finally {
            if (!this.isModule && this.isOpen()) {
                this.close();
            }
        }
        BIDeployable.Step[] steps = al.toArray(new BIDeployable.Step[0]);
        log.finer("BWbDeployableNtplFile.getSteps steps length = " + steps.length);
        return steps;
    }

    private String getFileNameFromOrd(BOrd ord) {
        OrdQuery[] q = ord.parse();
        int lastIndex = q.length - 1;
        if (lastIndex >= q.length || lastIndex < 0) {
            return null;
        }
        OrdQuery lastQuery = q[lastIndex];
        if (lastQuery instanceof ViewQuery) {
            if (--lastIndex >= q.length || lastIndex < 0) {
                return null;
            }
            lastQuery = q[lastIndex];
        }
        if (!(lastQuery instanceof Path)) {
            return null;
        }
        Path path = (Path)lastQuery;
        String[] names = path.getNames();
        if (names.length == 0) {
            return null;
        }
        return names[names.length - 1];
    }

    private void notifyInfo(String message) {
        if (this.owner instanceof BWidget) {
            BDialog.info((BWidget)((BWidget)this.owner), (Object)message);
        } else {
            log.log(Level.INFO, message);
        }
    }

    private void notifyError(String message) {
        if (this.owner instanceof BWidget) {
            BDialog.error((BWidget)((BWidget)this.owner), (Object)message);
        } else {
            log.log(Level.WARNING, message);
        }
    }

    private void notifyError(String title, String message) {
        if (this.owner instanceof BWidget) {
            BDialog.error((BWidget)((BWidget)this.owner), (String)title, (Object)message);
        } else {
            log.log(Level.WARNING, message);
        }
    }

    private void notifyError(String title, String message, Exception e) {
        if (this.owner instanceof BWidget) {
            BDialog.error((BWidget)((BWidget)this.owner), (String)title, (Object)message, (Throwable)e);
        } else {
            log.log(Level.WARNING, message, e);
        }
    }

    public void postDeploy(TransferResult[] tres, TransferStrategy strategy, Context cx) {
        BComponent target = null;
        List<String> insertNames = Collections.emptyList();
        if (tres != null && tres.length > 0 && tres[0] != null) {
            DeployToComp.DeployTransferResult result = (DeployToComp.DeployTransferResult)tres[0];
            target = result.target;
            insertNames = Arrays.asList(result.getInsertNames());
        }
        BWbDeployableNtplFile.doPostDeploy(this, (BWidget)this.owner, target, insertNames, statusMessage -> {
            if (strategy != null) {
                strategy.updateStatus(statusMessage);
            }
        }, cx);
    }

    public static void doPostDeploy(BWbDeployableNtplFile file, BWidget owner, BComponent target, List<String> insertNames, Consumer<String> statusListener, Context cx) {
        TemplateManifest manifest;
        try {
            manifest = file.getTemplateManifest();
        }
        catch (Exception ex) {
            manifest = null;
        }
        if (!insertNames.isEmpty()) {
            Version remoteVersion = (Version)target.fw(404, (Object)"template", null, null, null);
            if (insertNames.size() > 1 && target.getType().is(BStation.TYPE)) {
                target.lease(Integer.MAX_VALUE);
                BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)target);
                templateConfig.setVersionDate(file.getLastModified());
                templateConfig.propagateConfiguration();
            } else {
                BComponent[] deployedRoots = new BComponent[insertNames.size()];
                for (int i = 0; i < insertNames.size(); ++i) {
                    Object deployedRootsValue = insertNames.size() == 1 && insertNames.get(0).contains(";") ? target : target.get(insertNames.get(i));
                    deployedRoots[i] = deployedRootsValue.asComponent();
                    statusListener.accept("initializing " + deployedRoots[i].getSlotPath());
                    if (deployedRootsValue != target) {
                        target.setDisplayName(deployedRoots[i].getPropertyInParent(), BFormat.DEFAULT, null);
                    }
                    CompUtil.setOrAdd((BComponent)deployedRoots[i], (String)ROOT_TAG_NAME, (BValue)BMarker.MARKER, (int)16389, null, null);
                    CompUtil.setOrAdd((BComponent)deployedRoots[i], (String)NTPL_FILE_TAG_NAME, (BValue)BString.make((String)file.getFileName()), (int)16389, null, null);
                    if (manifest != null) {
                        CompUtil.setOrAdd((BComponent)deployedRoots[i], (String)VENDOR_TAG_NAME, (BValue)BString.make((String)manifest.vendor), (int)16389, null, null);
                        CompUtil.setOrAdd((BComponent)deployedRoots[i], (String)VERSION_TAG_NAME, (BValue)BString.make((String)manifest.version), (int)16389, null, null);
                        CompUtil.setOrAdd((BComponent)deployedRoots[i], (String)INFO_TAG_NAME, (BValue)BString.make((String)manifest.description), (int)16389, null, null);
                    }
                    deployedRoots[i].lease(Integer.MAX_VALUE);
                    BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedRoots[i]);
                    if (!templateConfig.isRunning()) {
                        templateConfig.propagateConfiguration();
                    }
                    if (remoteVersion.major() == 4 && remoteVersion.minor() == 3) {
                        if (templateConfig.getVersion().getVendor().isEmpty() && manifest != null) {
                            templateConfig.setVersion(new BVersion(manifest.vendor, manifest.version));
                        }
                        templateConfig.setVersionDate(file.getLastModified());
                    }
                    deployedRoots[i].loadSlots();
                    templateConfig.lease();
                }
                BTemplateManager.processPostDeploy(owner, deployedRoots, statusListener, cx);
            }
            statusListener.accept("postDeployComplete");
        }
        file.closeIfOpen();
    }

    public void closeIfOpen() {
        if (this.isOpen()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BIDeployable.Step[] makeNtplTransferStep(BComponent target) throws Exception {
        Map<String, BVersion> missingElements;
        List<Map<String, BVersion>> missingDependencies = this.checkRemoteModuleDependencies(target);
        Map<String, BVersion> map = missingElements = missingDependencies == null || missingDependencies.size() < 1 ? null : missingDependencies.get(0);
        if (missingElements != null && missingElements.keySet().size() > 0) {
            this.logMissingModules(missingElements, "transfer.missingModuleInfo", Level.WARNING);
            return new BIDeployable.Step[0];
        }
        Map<String, BVersion> map2 = missingElements = missingDependencies == null || missingDependencies.size() < 2 ? null : missingDependencies.get(1);
        if (missingElements != null && missingElements.keySet().size() > 0) {
            this.logMissingModules(missingElements, "transfer.missingModuleInfo", Level.FINE);
        }
        Map<String, BVersion> map3 = missingElements = missingDependencies == null || missingDependencies.size() < 3 ? null : missingDependencies.get(2);
        if (missingElements != null && missingElements.keySet().size() > 0) {
            this.logMissingModules(missingElements, "transfer.missingPxInfo", Level.FINE);
        }
        ArrayList<BNtplFile.FileTransferSpec> fileTransferSpecs = new ArrayList<BNtplFile.FileTransferSpec>();
        this.listFilesToBeTransferred(target, fileTransferSpecs);
        BIDeployable.Step[] steps = new BIDeployable.Step[fileTransferSpecs.size()];
        for (int i = 0; i < fileTransferSpecs.size(); ++i) {
            BIDeployable.Step step;
            BNtplFile.FileTransferSpec fileTransferSpec = (BNtplFile.FileTransferSpec)fileTransferSpecs.get(i);
            Mark mark = new Mark((BObject)fileTransferSpec.getFileToTransfer(), fileTransferSpec.getNewFileName());
            steps[i] = step = new BIDeployable.Step(mark, BOrd.make((OrdQuery)fileTransferSpec.getTargetPath()));
        }
        log.finer("BWbDeployableNtplFile.makeNtplTransferStep steps length = " + steps.length);
        return steps;
    }

    public FilePath listFilesToBeTransferred(BComponent target, List<BNtplFile.FileTransferSpec> fileTransferSpecs) throws Exception {
        assert (target != null);
        assert (fileTransferSpecs != null);
        TemplateManifest manifest = this.getTemplateManifest();
        BTemplateConfig config = this.getTemplateConfig();
        TemplateType templateType = NtplUtil.getTemplateType((BComponent)this.getBaseComponent(), (BTemplateConfig)config);
        String templateName = config.getTemplateName();
        String thisFileName = templateName == null || templateName.isEmpty() ? this.getFileName() : NtplUtil.buildTemplateFileName((String)templateName, (TemplateType)templateType);
        FilePath targetDirectory = this.deployDir();
        boolean exist = this.alreadyExist(target, thisFileName);
        log.finer("BWbDeployableNtplFile.makeNtplTransferStep exist = " + exist);
        if (!exist) {
            this.verifyDir(targetDirectory, target);
            fileTransferSpecs.add(new BNtplFile.FileTransferSpec((BDataFile)this, this.getFileBase(thisFileName) + '.' + this.getFileExtension(thisFileName), targetDirectory));
        }
        HashSet<String> addedSet = new HashSet<String>();
        for (Object subtemplate : manifest.subtemplates) {
            if (!(subtemplate instanceof TemplateManifest.Subtemplate)) continue;
            TemplateManifest.Subtemplate subTmpl = (TemplateManifest.Subtemplate)subtemplate;
            String ntplFileOrd = subTmpl.ntplFileOrd;
            if (addedSet.contains(ntplFileOrd)) continue;
            BNtplFile stFile = null;
            try {
                stFile = (BNtplFile)BOrd.make((String)ntplFileOrd).resolve().get();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error resolving file ORD:" + e.getLocalizedMessage(), e);
            }
            if (stFile == null) continue;
            exist = this.alreadyExist(target, stFile.getFileName());
            if (!exist) {
                FilePath directory = stFile.deployDir();
                this.verifyDir(directory, target);
                fileTransferSpecs.add(new BNtplFile.FileTransferSpec((BDataFile)stFile, this.getFileBase(stFile.getFileName()) + '.' + this.getFileExtension(stFile.getFileName()), directory));
                addedSet.add(ntplFileOrd);
            }
            stFile.close();
        }
        if (!this.isModule && this.isOpen()) {
            this.close();
        }
        return targetDirectory.merge(thisFileName);
    }

    private void logMissingModules(Map<String, BVersion> missingElements, String lexKey, Level logLevel) {
        StringBuilder modules = new StringBuilder().append("\n");
        modules.append(" Template: ").append(this.getTemplateManifest().title).append("\n");
        for (String key : missingElements.keySet()) {
            modules.append(" Module: ").append(key);
            BVersion version = missingElements.get(key);
            if (version != BVersion.ZERO) {
                modules.append("    Version: ").append(version.toString());
            }
            modules.append("\n");
        }
        if (logLevel.equals(Level.WARNING) || logLevel.equals(Level.SEVERE)) {
            this.notifyError(lex.getText(lexKey, new Object[]{modules.toString()}));
        } else if (logLevel.equals(Level.INFO)) {
            this.notifyInfo(lex.getText(lexKey, new Object[]{modules.toString()}));
        } else {
            log.log(logLevel, lex.getText(lexKey, new Object[]{modules.toString()}));
        }
    }

    private FilePath imageDeployDir(String imageOrd) {
        if (this.stationDir != null) {
            String[] split = imageOrd.split("\\^");
            if (split.length > 1) {
                return this.stationDir.merge("shared/" + split[1]);
            }
            return new FilePath(imageOrd);
        }
        String[] split = imageOrd.split("file:");
        if (split.length > 1) {
            return new FilePath(split[1]);
        }
        return new FilePath(imageOrd);
    }

    private BOrd verifyDir(FilePath dPath, BComponent target) throws Exception {
        BOrd dirOrd = BOrd.make((OrdQuery)dPath);
        try {
            dirOrd.resolve((BObject)target);
        }
        catch (UnresolvedException e) {
            try {
                if (this.stationDir == null) {
                    BDirectory rootDir = (BDirectory)BOrd.make((String)"file:^").resolve((BObject)target).get();
                    rootDir.getFileSpace().makeDir(dPath);
                } else {
                    BDirectory rootDir = (BDirectory)BOrd.make((OrdQuery)this.stationDir).resolve().get();
                    rootDir.getFileSpace().makeDir(dPath);
                }
            }
            catch (Exception e1) {
                log.log(Level.WARNING, "Error resolving path:" + dPath.toString(), e1);
                throw e1;
            }
        }
        return dirOrd;
    }

    public List<Map<String, BVersion>> checkRemoteModuleDependencies(BComponent target) {
        try {
            BISession session = target.getSession();
            BOrd templateServiceOrd = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"service:template:TemplateService");
            BTemplateService templateService = null;
            try {
                OrdTarget templateTarget = templateServiceOrd.resolve();
                templateService = (BTemplateService)templateTarget.get();
            }
            catch (Exception templateTarget) {
                // empty catch block
            }
            if (templateService != null) {
                templateService.lease();
                BVector resultVector = templateService.getRemoteModules();
                Property[] propertiesArray = resultVector.getPropertiesArray();
                HashMap<String, BVersion> nreModules = new HashMap<String, BVersion>();
                if (propertiesArray.length > 0) {
                    for (Property property : propertiesArray) {
                        BValue bValue = resultVector.get(property);
                        if (!(bValue instanceof BTemplateValues)) continue;
                        BTemplateValues value = (BTemplateValues)bValue;
                        nreModules.put(value.getModulePartName(), value.getModuleVersion());
                    }
                    List<Map<String, BVersion>> missingModules = TmplUtil.checkModuleDependencies(this, nreModules, true, true);
                    return missingModules;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error checking module dependencies:" + e.getLocalizedMessage(), e);
        }
        return null;
    }

    private boolean alreadyExist(BComponent target, String templateName) {
        try {
            FilePath ntplFilePath = this.deployDir().merge(templateName);
            OrdTarget f = BOrd.make((OrdQuery)ntplFilePath).resolve((BObject)target);
            if (target.getType().is(BFoxClientConnection.TYPE)) {
                BFoxSession session = ((BFoxClientConnection)target).getFoxSession();
                f = BOrd.make((BOrd)session.getAbsoluteOrd(), (OrdQuery)ntplFilePath).resolve();
            }
            if (f != null) {
                BNtplFile file = (BNtplFile)f.get();
                if (file.getCrc() != this.getCrc()) {
                    file.close();
                    file.delete();
                    return false;
                }
                return true;
            }
        }
        catch (UnresolvedException ntplFilePath) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error checking if template " + templateName + " exists", e);
        }
        return false;
    }

    private String getFileExtension(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    private String getFileBase(String fileName) {
        String version = '-' + this.getTemplateManifest().version;
        int findVersion = fileName.lastIndexOf(version);
        if (findVersion != -1 && findVersion != 0) {
            return fileName.substring(0, findVersion);
        }
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    private String getPxName(BComponent target, String nam) {
        try {
            FilePath pxFilePath = this.pxDeployPath(nam);
            OrdTarget f = BOrd.make((OrdQuery)pxFilePath).resolve((BObject)target);
            if (f != null) {
                BPxFile file = (BPxFile)f.get();
                file.delete();
            }
        }
        catch (UnresolvedException pxFilePath) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error resolving PX file name " + nam, e);
        }
        return nam;
    }

    private FilePath pxDeployPath(String nam) {
        return this.pxDeployDir().merge(nam);
    }

    private FilePath pxDeployDir() {
        if (this.stationDir != null) {
            return this.stationDir.merge("shared/px/deploy/" + this.getFileName().substring(0, this.getFileName().indexOf(".")).toLowerCase());
        }
        return new FilePath("^px/deploy/" + this.getFileName().substring(0, this.getFileName().indexOf(".")).toLowerCase());
    }

    public FilePath deployDir() {
        boolean isApplication = this.getTemplateManifest().isApplication;
        String basePath = isApplication ? "^applicationTemplate/" : "^template/";
        String sharedPath = isApplication ? "shared/applicationTemplate/" : "shared/template/";
        return this.deployDir(basePath, sharedPath, this.getTemplateManifest().vendor);
    }

    private FilePath deployDir(String basePath, String sharedPath, String vendor) {
        if (this.stationDir != null) {
            return this.stationDir.merge(sharedPath + vendor);
        }
        return new FilePath(basePath + vendor);
    }
}

