/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.sidebar;

import com.tridium.sys.module.BModuleFile;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.template.TemplateConst;
import com.tridium.template.api.TemplateType;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.ExportConfigsCommand;
import com.tridium.template.ui.sidebar.BTemplateSideBarNavTree;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.shell.WbMain;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.NavEvent;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.util.BNotifyPane;

@NiagaraType
@NiagaraAction(name="updateTree")
public class BTemplateSideBar
extends BWbSideBar {
    @Generated
    public static final Action updateTree = BTemplateSideBar.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateSideBar.class);
    private static final BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    private static final BIcon jarIcon = BIcon.make((String)"module://icons/x16/modules.png");
    static final Lexicon lex = Lexicon.make((String)"template");
    public static final Logger log = Logger.getLogger("ntpl");
    private static final String SLOT_NAME_SEPARATOR = ".";
    private BListDropDown selTree = new BListDropDown();
    private final BNavTree tree;
    BEdgePane content;
    BTreePane treePane;
    BButton bModule;
    BOrd moduleOrd = BOrd.NULL;
    TmplSideBarModel modModel = null;
    private boolean init = false;
    private boolean inError = false;

    @Generated
    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTemplateSideBar() {
        this.selTree = new BListDropDown();
        this.selTree.getList().setModel((ListModel)new NavListModel());
        this.linkTo(null, (BComponent)this.selTree, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        this.tree = new BTemplateSideBarNavTree();
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new TplNavController());
        this.bModule = new BButton((Command)new MakeModule((BWidget)this), false, true);
        this.bModule.setButtonStyle(BButtonStyle.toolBar);
        this.bModule.setFocusTraversable(false);
        BGridPane grid = new BGridPane(3);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowAlign(BValign.fill);
        grid.add(null, (BValue)this.bModule);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)grid);
        top.setCenter((BWidget)new BBorderPane((BWidget)this.selTree, 0.0, 0.0, 0.0, 5.0));
        BBorderPane topPane = new BBorderPane((BWidget)top, 5.0, 5.0, 5.0, 5.0);
        StyleUtils.addStyleClass((IStylable)topPane, (String)"sidebar-header");
        this.content = new BEdgePane();
        this.content.setTop((BWidget)topPane);
        this.treePane = new BTreePane((BTree)this.tree);
        this.tree.setStyleId("template-sidebar");
        StyleUtils.addStyleClass((IStylable)this.tree, (String)"sidebar-body");
        StyleUtils.addStyleClass((IStylable)this.treePane, (String)"sidebar-scroll-pane");
        this.content.setCenter((BWidget)this.treePane);
        this.setContent((BWidget)this.content);
    }

    public void started() throws Exception {
        super.started();
        if (!this.init) {
            this.loadSelTree();
            this.doUpdateTree();
            this.init = true;
        }
    }

    private void loadSelTree() throws Exception {
        this.selTree.getList().removeAllItems();
        BDirectory modDir = BFileSystem.INSTANCE.makeDir(TemplateConst.TEMPLATE_MODULE_DIR);
        this.moduleOrd = modDir.getAbsoluteOrd();
        BBookmark moduleBookmark = new BBookmark(lex.getText("templateSideBar.moduleMenu"), modDir.getNavOrd(), jarIcon);
        this.selTree.getList().addItem((Object)new NavWrapper(moduleBookmark, true));
        BBookmark templateBookmark = new BBookmark(lex.getText("templateSideBar.templateMenu"), NtplUtil.getTemplateDirectoryOrd(), NtplUtil.getTemplateDirectory().getNavIcon());
        this.selTree.getList().addItem((Object)new NavWrapper(templateBookmark, false));
        this.selTree.getList().setSelectedIndex(1);
    }

    private void displayError(String name, Exception e) {
        this.inError = true;
        BGridPane a = new BGridPane(1);
        a.setRowGap(1.0);
        a.add(null, (BValue)new BLabel(lex.getText("templateSideBar.couldNotFind"), Theme.widget().getBoldText()));
        a.add(null, (BValue)new BLabel(name));
        BGridPane b = new BGridPane(2);
        b.add(null, (BValue)new BLabel(errorIcon, ""));
        b.add(null, (BValue)a);
        BGridPane c = new BGridPane(1);
        c.setRowGap(5.0);
        c.setColumnAlign(BHalign.center);
        c.add(null, (BValue)b);
        c.add(null, (BValue)new BButton((Command)new Details((BWidget)this, name, e)));
        this.content.setCenter((BWidget)c);
    }

    public void doUpdateTree() {
        this.inError = false;
        NavWrapper w = (NavWrapper)this.selTree.getSelectedItem();
        try {
            BOrd ord = w.bookmark.getBookmarkOrd();
            BObject obj = ord.resolve().get();
            w.bookmark.setIcon(obj.getIcon());
            TmplSideBarModel model = new TmplSideBarModel((BINavNode)obj);
            if (w.isModule) {
                this.modModel = model;
            }
            this.tree.setModel((TreeModel)model);
            this.tree.relayout();
            if (!(this.content.getCenter() instanceof BTreePane)) {
                this.content.setCenter((BWidget)this.treePane);
            }
            this.bModule.setEnabled(!w.isModule);
        }
        catch (Exception e) {
            this.displayError(w.bookmark.getText(), e);
        }
    }

    public void doTreeSelectionModified() {
        this.repaint();
    }

    public void activeViewChanged() {
        if (!this.inError) {
            return;
        }
        this.doUpdateTree();
    }

    private void remove(BComponent c, String name) {
        if (c == null) {
            return;
        }
        Property p = c.getProperty(name);
        if (p != null) {
            c.remove(p);
        }
    }

    public static Collection<BWbDeployableNtplFile> collectTemplates(BObject[] selectedObjects) {
        TreeSet<BWbDeployableNtplFile> templates = new TreeSet<BWbDeployableNtplFile>();
        for (BObject selectedObject : selectedObjects) {
            if (!(selectedObject instanceof BIFile)) continue;
            BTemplateSideBar.collectTemplates((BIFile)selectedObject, templates);
        }
        return templates;
    }

    private static void collectTemplates(BIFile selectedFile, Collection<BWbDeployableNtplFile> templates) {
        if (selectedFile instanceof BWbDeployableNtplFile) {
            templates.add((BWbDeployableNtplFile)selectedFile);
        } else if (selectedFile instanceof BDirectory) {
            for (BIFile childFile : ((BDirectory)selectedFile).listFiles()) {
                BTemplateSideBar.collectTemplates(childFile, templates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOrd makeTemplateModule(Collection<BWbDeployableNtplFile> templates, String name, String description, String vendor, String version, String fileName) throws IOException {
        FilePath path = TemplateConst.TEMPLATE_MODULE_DIR;
        BDirectory modDir = BFileSystem.INSTANCE.makeDir(path);
        BIFile biFile = modDir.getFileSpace().makeFile(path.merge(fileName));
        BOrd result = biFile.getOrdInSession();
        try (ZipOutputStream zout = new ZipOutputStream(biFile.getOutputStream());){
            ZipEntry zmod = new ZipEntry("META-INF/module.xml");
            zout.putNextEntry(zmod);
            BTemplateSideBar.writeModuleXml(zout, name, description, vendor, version);
            zout.closeEntry();
            for (BWbDeployableNtplFile template : templates) {
                FilePath relativePath = NtplUtil.getTemplateRelativePath((FilePath)template.getFilePath(), (TemplateType)TemplateType.COMPONENT);
                ZipEntry zntp = new ZipEntry(relativePath.isAbsolute() ? relativePath.getName() : relativePath.getBody());
                zout.putNextEntry(zntp);
                try (InputStream templateStream = template.getInputStream();){
                    BajaFileUtil.pipe((InputStream)templateStream, (OutputStream)zout);
                }
                zout.closeEntry();
            }
        }
        finally {
            ((BModuleFile)biFile).close();
            TemplateManager.INSTANCE.modsChanged();
        }
        return result;
    }

    private Hashtable<String, ArrayList<String>> makeSubtemplateMap(BObject[] files) throws Exception {
        Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
        FilePath path = TemplateConst.TEMPLATE_DIR;
        BDirectory tnplDir = BFileSystem.INSTANCE.makeDir(path);
        BIFile[] ntplFiles = tnplDir.listFiles();
        for (BObject file : files) {
            if (!(file instanceof BWbDeployableNtplFile)) continue;
            BWbDeployableNtplFile ntplFile = (BWbDeployableNtplFile)file;
            TemplateManifest manifest = ntplFile.getTemplateManifest();
            String templateName = manifest.vendor + '/' + ntplFile.getFileName();
            ArrayList<String> subtemplateList = new ArrayList<String>();
            for (BIFile otherFile : ntplFiles) {
                if (file == otherFile || !(otherFile instanceof BWbDeployableNtplFile)) continue;
                BWbDeployableNtplFile otherNtplFile = (BWbDeployableNtplFile)otherFile;
                TemplateManifest stm = otherNtplFile.getTemplateManifest();
                for (TemplateManifest.Subtemplate st : stm.subtemplates) {
                    String ordInHost;
                    String stFileOrd;
                    if (st == null || !(stFileOrd = st.ntplFileOrd).contains(ntplFile.getNavName()) || subtemplateList.contains(ordInHost = otherNtplFile.getOrdInHost().toString(null))) continue;
                    subtemplateList.add(ordInHost);
                }
            }
            hashtable.put(templateName, subtemplateList);
        }
        return hashtable;
    }

    private void notifySuccess(String fileName) {
        BNotifyPane pane = new BNotifyPane();
        BGridPane notifyGrid = new BGridPane(1);
        BLabel title = new BLabel(lex.getText("templateSideBar.makeModule"));
        StyleUtils.addStyleClass((IStylable)title, (String)"strong");
        notifyGrid.add(null, (BValue)title);
        BLabel status = new BLabel(BImage.make((String)"module://icons/x16/job/success.png"), "success");
        notifyGrid.add(null, (BValue)status);
        String detailText = lex.getText("templateSideBar.notify.success", new Object[]{fileName});
        BLabel msg = new BLabel(BImage.make((BIcon)BIcon.make((String)lex.getText("templateSideBar.notify.icon"))), detailText);
        notifyGrid.add(null, (BValue)msg);
        pane.setCenter((BWidget)notifyGrid);
        pane.open();
    }

    private boolean isValidModuleName(String name) {
        String err;
        if (name.isEmpty()) {
            err = lex.getText("templateSideBar.makeModule.noName");
        } else if (!SlotPath.isValidName((String)name)) {
            err = lex.getText("templateSideBar.makeModule.invalidName", new Object[]{name});
        } else {
            return true;
        }
        BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("templateName.invalidNameTitle"), (Object)err);
        return false;
    }

    private static void writeModuleXml(ZipOutputStream zout, String moduleName, String description, String vendor, String vendorVersion) throws IOException {
        String buf = "<module\n  name = \"" + moduleName + "\"\n  bajaVersion = \"0\"\n  description = \"" + description + "\"\n  vendor = \"" + vendor + "\"\n  vendorVersion = \"" + vendorVersion + "\"\n  templateJar=\"true\"\n>\n\n<dependencies>\n</dependencies>\n\n<dirs/>\n\n<types/>\n\n</module>\n";
        PrintWriter pw = new PrintWriter(zout);
        pw.write(buf);
        pw.flush();
        zout.flush();
    }

    private static boolean navNodeContainsTemplate(BINavNode navNode) {
        return BTemplateSideBar.navNodesContainTemplate(navNode.getNavChildren());
    }

    private static boolean navNodesContainTemplate(BINavNode[] navNodes) {
        for (BINavNode navChild : navNodes) {
            if (navChild instanceof BDirectory && BTemplateSideBar.navNodeContainsTemplate(navChild)) {
                return true;
            }
            if (!navChild.getNavName().endsWith(".ntpl")) continue;
            return true;
        }
        return false;
    }

    static class Details
    extends Command {
        private final Exception e;

        public Details(BWidget owner, String name, Exception e) {
            super(owner, lex.getText("NavSideBar.details"));
            this.e = e;
        }

        public CommandArtifact doInvoke() {
            BTextEditor msg = new BTextEditor(ThrowableUtil.dumpToString((Throwable)this.e), false);
            BTextEditorPane pane = new BTextEditorPane(msg, 25, 80);
            BDialog.open((BWidget)this.getOwner(), (String)lex.getText("NavSideBar.details"), (Object)pane, (int)1);
            return null;
        }
    }

    static class TmplNavTreeNode
    extends NavTreeNode {
        public TmplNavTreeNode(NavTreeModel model, NavTreeNode parent, BINavNode navNode) {
            super(model, parent, navNode);
        }

        public String getText() {
            BINavNode navNode = this.getNavNode();
            if (navNode instanceof BModuleFile) {
                String nn = navNode.getNavName();
                return nn.substring(0, nn.indexOf(BTemplateSideBar.SLOT_NAME_SEPARATOR));
            }
            if (navNode instanceof BDirectory) {
                return navNode.getNavName();
            }
            if (navNode instanceof BWbDeployableNtplFile) {
                BWbDeployableNtplFile file = (BWbDeployableNtplFile)this.getNavNode();
                String title = file.getTemplateManifest().title;
                String version = file.getTemplateManifest().version;
                if (title == null || title.length() == 0) {
                    String t = super.getText();
                    return this.getFileBase(t);
                }
                return title + '-' + version;
            }
            return "";
        }

        private String getFileBase(String fileName) {
            if (fileName.lastIndexOf(BTemplateSideBar.SLOT_NAME_SEPARATOR) != -1 && fileName.lastIndexOf(BTemplateSideBar.SLOT_NAME_SEPARATOR) != 0) {
                return fileName.substring(0, fileName.lastIndexOf(BTemplateSideBar.SLOT_NAME_SEPARATOR));
            }
            return fileName;
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeNode getChild(int index) {
            return this.getChildren()[index];
        }

        public NavTreeNode[] getChildren() {
            if (this.children == null) {
                BWidgetShell shell = this.getShell();
                if (shell != null) {
                    shell.enterBusy();
                }
                try {
                    this.children = this.buildChildren();
                }
                catch (Throwable e) {
                    this.children = new NavTreeNode[0];
                    log.log(Level.WARNING, "Cannot expand tree:" + e.getLocalizedMessage(), e);
                    BDialog.error((BWidget)this.getTree(), (String)BDialog.TITLE_ERROR, (Object)lex.getText("templateSideBar.cannotExpandTree"), (Throwable)e);
                }
                finally {
                    if (shell != null) {
                        shell.exitBusy();
                    }
                }
            }
            return this.children;
        }
    }

    public class TmplSideBarModel
    extends DefaultNavTreeModel {
        private final TmplNavTreeNode root;

        public TmplSideBarModel(BINavNode node) {
            super(node);
            this.root = new TmplNavTreeNode((NavTreeModel)this, null, node);
        }

        protected void added(NavEvent event) {
            super.added(event);
        }

        protected void replaced(NavEvent event) {
            if (event.getFacets().getb("close", false)) {
                return;
            }
            super.replaced(event);
        }

        protected void removed(NavEvent event) {
            NavWrapper w = (NavWrapper)BTemplateSideBar.this.selTree.getSelectedItem();
            BOrd activeOrd = w.bookmark.getBookmarkOrd();
            if (WbMain.isRemoved((NavEvent)event, (BOrd)activeOrd)) {
                BTemplateSideBar.this.displayError(w.bookmark.getText(), new Exception("Parent node removed"));
            } else {
                TreeNode[] tnodA;
                for (TreeNode tnod : tnodA = BTemplateSideBar.this.tree.getSelection().getNodes()) {
                    if (!((TmplNavTreeNode)tnod).getNavNode().getNavName().equals(event.getOldChildName())) continue;
                    BTemplateSideBar.this.tree.getSelection().deselect(tnod);
                }
                super.removed(event);
            }
        }

        public int getRootCount() {
            return this.root.getChildCount();
        }

        public TreeNode getRoot(int index) {
            return this.root.getChild(index);
        }

        public NavTreeNode makeNavTreeNode(NavTreeNode parent, BINavNode navNode) {
            if (navNode instanceof BIFile && navNode.getNavName().endsWith(".lock")) {
                return null;
            }
            if (navNode.getNavName().endsWith(".ntpl")) {
                return new TmplNavTreeNode((NavTreeModel)this, parent, navNode);
            }
            try {
                if (navNode instanceof BModuleFile) {
                    BINavNode[] navKids = navNode.getNavChildren();
                    ((BModuleFile)navNode).close();
                    if (BTemplateSideBar.navNodesContainTemplate(navKids)) {
                        return new TmplNavTreeNode((NavTreeModel)this, parent, navNode);
                    }
                } else if (navNode instanceof BDirectory && BTemplateSideBar.navNodeContainsTemplate(navNode)) {
                    return new TmplNavTreeNode((NavTreeModel)this, parent, navNode);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    class FindUsages
    extends Command {
        public FindUsages(BWidget owner) {
            super(owner, lex, "commands.showUsedBy");
        }

        public CommandArtifact doInvoke() {
            try {
                BObject[] sel = BTemplateSideBar.this.tree.getSelectedObjects();
                if (sel.length == 0) {
                    return null;
                }
                Hashtable subtemplateMap = BTemplateSideBar.this.makeSubtemplateMap(sel);
                Enumeration stEnum = subtemplateMap.keys();
                StringBuilder sb = new StringBuilder();
                while (stEnum.hasMoreElements()) {
                    String stName = (String)stEnum.nextElement();
                    if (subtemplateMap.size() <= 0 || ((ArrayList)subtemplateMap.get(stName)).size() <= 0) continue;
                    String[] split = stName.split("[.]");
                    sb.append(lex.getText("templateSidebar.usedBy", new Object[]{split[0]}));
                    sb.append("\n");
                    for (String usedInTmpl : (ArrayList)subtemplateMap.get(stName)) {
                        try {
                            BObject bObject = BOrd.make((String)usedInTmpl).get();
                            if (bObject instanceof BWbDeployableNtplFile) {
                                String[] split1 = ((BWbDeployableNtplFile)bObject).getFileName().split("[.]");
                                usedInTmpl = split1[0];
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        sb.append("             ").append(usedInTmpl).append("\n");
                    }
                }
                if (sb.toString().isEmpty()) {
                    sb.append(lex.getText("templateSideBar.notSubtemplate"));
                }
                BDialog.message((BWidget)this.getOwner(), (String)lex.getText("templateSidebar.usage"), (Object)sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class MakeModule
    extends Command {
        public MakeModule(BWidget owner) {
            super(owner, lex, "commands.makeModule");
        }

        public CommandArtifact doInvoke() {
            try {
                boolean fileExists;
                Collection<BWbDeployableNtplFile> selectedTemplates = BTemplateSideBar.collectTemplates(BTemplateSideBar.this.tree.getSelectedObjects());
                if (selectedTemplates.isEmpty()) {
                    BDialog.info((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.makeModule"), (Object)BString.make((String)lex.getText("templateSideBar.makeModule.noFilesSelected")));
                    return null;
                }
                BComponent cmp = new BComponent();
                cmp.add("moduleName", (BValue)BString.make((String)"myModule"));
                cmp.add("description", (BValue)BString.make((String)""));
                cmp.add("vendor", (BValue)BString.make((String)""));
                cmp.add("vendorVersion", (BValue)BString.make((String)"1.0"));
                BObject result = BWbFieldEditor.dialog((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.moduleInfo.title"), (BObject)cmp);
                if (result == null) {
                    return null;
                }
                cmp = result.asComponent();
                String moduleName = ((BString)cmp.get("moduleName")).getString();
                String description = ((BString)cmp.get("description")).getString();
                String vendor = ((BString)cmp.get("vendor")).getString();
                String vendorVersion = ((BString)cmp.get("vendorVersion")).getString();
                if (!BTemplateSideBar.this.isValidModuleName(moduleName)) {
                    return null;
                }
                String fileName = moduleName + ".jar";
                FilePath path = TemplateConst.TEMPLATE_MODULE_DIR;
                BDirectory modDir = BFileSystem.INSTANCE.makeDir(path);
                boolean bl = fileExists = modDir.getNavChild(fileName) != null;
                if (fileExists) {
                    Optional fileManagerOptional = DefaultModulesFileManager.get();
                    if (!fileManagerOptional.isPresent()) {
                        BDialog.error((BWidget)BTemplateSideBar.this.getWbShell(), (String)lex.getText("templateSideBar.makeModule.noFileManager.title"), (Object)lex.getText("templateSideBar.makeModule.noFileManager.message"));
                        return null;
                    }
                    DefaultModulesFileManager fm = (DefaultModulesFileManager)fileManagerOptional.get();
                    if (fm.findDependency(moduleName) != null) {
                        BDialog.error((BWidget)BTemplateSideBar.this.getWbShell(), (String)lex.getText("templateName.invalidNameTitle"), (Object)lex.getText("templateSideBar.makeModule.moduleFile"));
                        return null;
                    }
                    int rc = BDialog.confirm((BWidget)BTemplateSideBar.this.getWbShell(), (String)lex.getText("templateSideBar.makeModule.duplicate.title"), (Object)lex.getText("templateSideBar.makeModule.duplicate"));
                    if (rc != 4) {
                        return null;
                    }
                }
                BTemplateSideBar.makeTemplateModule(selectedTemplates, moduleName, description, vendor, vendorVersion, fileName);
                if (BTemplateSideBar.this.modModel != null) {
                    NavEvent event;
                    if (fileExists) {
                        event = NavEvent.makeReplaced((BOrd)BTemplateSideBar.this.moduleOrd, (String)fileName, null);
                        BTemplateSideBar.this.modModel.replaced(event);
                    } else {
                        event = NavEvent.makeAdded((BOrd)BTemplateSideBar.this.moduleOrd, (String)fileName, null);
                        BTemplateSideBar.this.modModel.added(event);
                    }
                }
                BTemplateSideBar.this.notifySuccess(fileName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error creating module:" + e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    class TplNavController
    extends NavTreeController {
        TplNavController() {
        }

        protected BMenu makePopup(NavTreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            TreeNode[] nodes = subject.getNodes();
            boolean modfiles = false;
            boolean tplFiles = false;
            boolean tplInMod = false;
            for (TreeNode node : nodes) {
                NavTreeNode navNode = (NavTreeNode)node;
                if (navNode.getNavNode() instanceof BModuleFile) {
                    modfiles = true;
                    continue;
                }
                if (navNode.getNavNode() instanceof BWbDeployableNtplFile) {
                    tplFiles = true;
                    if (!(((NavTreeNode)navNode.getParent()).getNavNode() instanceof BModuleFile)) continue;
                    tplInMod = true;
                    continue;
                }
                return null;
            }
            if (modfiles && tplFiles) {
                return null;
            }
            BTemplateSideBar.this.remove((BComponent)menu, "cut");
            BTemplateSideBar.this.remove((BComponent)menu, "paste");
            BTemplateSideBar.this.remove((BComponent)menu, "duplicate");
            BTemplateSideBar.this.remove((BComponent)menu, "rename");
            BTemplateSideBar.this.remove((BComponent)menu, "exportConfigs");
            if (modfiles || nodes.length > 1) {
                BTemplateSideBar.this.remove((BComponent)menu, "copy");
            }
            if (tplInMod) {
                BTemplateSideBar.this.remove((BComponent)menu, "delete");
                menu.addItem("exportConfigs", (Command)new ExportConfigsCommand((BWidget)BTemplateSideBar.this.tree));
            }
            if (tplFiles && !tplInMod) {
                menu.addSeparator();
                menu.addItem("makeTemplateModule", (Command)new MakeModule((BWidget)BTemplateSideBar.this.tree));
                menu.addItem("findUsages", (Command)new FindUsages((BWidget)BTemplateSideBar.this.tree));
                menu.addItem("exportConfigs", (Command)new ExportConfigsCommand((BWidget)BTemplateSideBar.this.tree));
            }
            return menu;
        }
    }

    static class NavWrapper {
        public BBookmark bookmark;
        public boolean isModule;

        public NavWrapper(BBookmark bookmark, boolean isModule) {
            this.bookmark = bookmark;
            this.isModule = isModule;
        }

        public String toString() {
            return this.bookmark.getText();
        }
    }

    static class NavListModel
    extends DefaultListModel {
        NavListModel() {
        }

        public BImage getItemIcon(int index) {
            NavWrapper w = (NavWrapper)this.getItem(index);
            return BImage.make((BIcon)w.bookmark.getIcon());
        }
    }
}

