/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BajaRuntimeException;

public class PathSupport {
    public static void doPath(PdfGraphics g, IPathGeom p) {
        try {
            PdfStream stream = g.target.getContentStream();
            Point controlPoint = new Point();
            Point lastPoint = new Point();
            Point lastControlPoint = null;
            block14: for (int i = 0; i < p.size(); ++i) {
                IPathGeom.Segment seg = p.segment(i);
                switch (seg.getCommand()) {
                    case 'M': 
                    case 'm': {
                        IPathGeom.MoveTo m = (IPathGeom.MoveTo)seg;
                        double x = g.transX(m.getX());
                        double y = g.transY(m.getY());
                        stream.println(x + " " + y + " m");
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'L': 
                    case 'l': {
                        IPathGeom.LineTo l = (IPathGeom.LineTo)seg;
                        double x = g.transX(l.getX());
                        double y = g.transY(l.getY());
                        stream.println(x + " " + y + " l");
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'H': 
                    case 'h': {
                        continue block14;
                    }
                    case 'V': 
                    case 'v': {
                        continue block14;
                    }
                    case 'Q': 
                    case 'q': {
                        lastControlPoint = PathSupport.quadTo(g, (IPathGeom.QuadTo)seg, controlPoint, lastPoint);
                        continue block14;
                    }
                    case 'T': 
                    case 't': {
                        lastControlPoint = PathSupport.smoothQuadTo(g, (IPathGeom.SmoothQuadTo)seg, controlPoint, lastPoint, lastControlPoint);
                        continue block14;
                    }
                    case 'C': 
                    case 'c': {
                        lastControlPoint = PathSupport.curveTo(g, (IPathGeom.CurveTo)seg, controlPoint, lastPoint);
                        continue block14;
                    }
                    case 'S': 
                    case 's': {
                        lastControlPoint = PathSupport.smoothCurveTo(g, (IPathGeom.SmoothCurveTo)seg, controlPoint, lastPoint, lastControlPoint);
                        continue block14;
                    }
                    case 'A': 
                    case 'a': {
                        PathSupport.arcTo(g, (IPathGeom.ArcTo)seg, lastPoint);
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'Z': 
                    case 'z': {
                        lastControlPoint = null;
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException(seg.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected static Point quadTo(PdfGraphics g, IPathGeom.QuadTo s, Point controlPoint, Point lastPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = g.transX(s.getX1());
        double y1 = g.transY(s.getY1());
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x1 += lastPoint.x;
            y1 -= lastPoint.y;
        }
        PdfStream stream = g.target.getContentStream();
        stream.println(x1 + " " + y1 + " " + x + " " + y + " v");
        lastPoint.set(x, y);
        controlPoint.set(x1, y1);
        return controlPoint;
    }

    protected static Point smoothQuadTo(PdfGraphics g, IPathGeom.SmoothQuadTo s, Point controlPoint, Point lastPoint, Point lastControlPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        if (lastControlPoint != null) {
            x1 += lastPoint.x - lastControlPoint.x;
            y1 -= lastPoint.y - lastControlPoint.y;
        }
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
        }
        PdfStream stream = g.target.getContentStream();
        stream.println(x1 + " " + y1 + " " + x + " " + y + " v");
        lastPoint.set(x, y);
        controlPoint.set(x1, y1);
        return controlPoint;
    }

    protected static Point curveTo(PdfGraphics g, IPathGeom.CurveTo s, Point controlPoint, Point lastPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = g.transX(s.getX1());
        double y1 = g.transY(s.getY1());
        double x2 = g.transX(s.getX2());
        double y2 = g.transY(s.getY2());
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x1 += lastPoint.x;
            y1 -= lastPoint.y;
            x2 += lastPoint.x;
            y2 -= lastPoint.y;
        }
        PdfStream stream = g.target.getContentStream();
        stream.println(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x + " " + y + " c");
        lastPoint.set(x, y);
        controlPoint.set(x2, y2);
        return controlPoint;
    }

    protected static Point smoothCurveTo(PdfGraphics g, IPathGeom.SmoothCurveTo s, Point controlPoint, Point lastPoint, Point lastControlPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        double x2 = g.transX(s.getX2());
        double y2 = g.transY(s.getY2());
        if (lastControlPoint != null) {
            x1 += lastPoint.x - lastControlPoint.x;
            y1 -= lastPoint.y - lastControlPoint.y;
        }
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x2 += lastPoint.x;
            y2 -= lastPoint.y;
        }
        PdfStream stream = g.target.getContentStream();
        stream.println(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x + " " + y + " c");
        lastPoint.set(x, y);
        controlPoint.set(x2, y2);
        return controlPoint;
    }

    protected static void arcTo(PdfGraphics g, IPathGeom.ArcTo s, Point lastPoint) {
        System.out.println("PathSupport.arcTo converting arc to PDF: " + s.toString());
        double rx = s.getRadiusX();
        double ry = s.getRadiusY();
        double x0 = lastPoint.x;
        double y0 = lastPoint.y;
        double x1 = g.transX(s.getX());
        double y1 = g.transY(s.getY());
        System.out.println("Starting point: " + x0 + " , " + y0);
        if (s.isRelative()) {
            x1 += x0;
            y1 += y0;
        }
        double a = rx;
        double b = ry;
        double c = Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
        double angle = Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
        if (s.getLargeArcFlag() && s.getSweepFlag() && angle == 0.0) {
            angle = 360.0;
        }
        PdfStream stream = g.target.getContentStream();
        lastPoint.set(x1, y1);
    }
}

