/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.PdfFontEncodingInfo;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.baja.gx.BFont;
import javax.baja.gx.RectGeom;

public class PdfFont
extends PdfObject {
    public static final int FLAG_FIXED_PITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALL_CAP = 65536;
    public static final int FLAG_SMALL_CAP = 131072;
    public static final int FLAG_FORCE_BOLD = 262144;
    private int scale;
    private String subType = "TrueType";
    private String baseFont;
    private int firstChar;
    private int lastChar;
    private double[] widths;
    private String encoding;
    private int ascent = 0;
    private int capHeight = 0;
    private int descent = 0;
    private int flags = 0;
    private RectGeom fontBox = new RectGeom();
    private int italicAngle = 0;
    private int stemV = 0;
    private int stemH = 0;
    private double avgWidth = 0.0;
    private int leading = 0;
    private int maxWidth = 0;
    private int missingWidth = 0;
    private int xHeight = 0;

    public PdfFont(BFont font, PdfDocument parent, int objectId, int generationNum, String encoding) {
        this((MicroFontPeer)PdfGraphics.env.makeFontPeer(font), parent, objectId, generationNum, encoding);
    }

    public PdfFont(MicroFontPeer peer, PdfDocument parent, int objectId, int generationNum, String encoding) {
        super(parent, objectId, generationNum);
        double scale = 13.4;
        this.baseFont = peer.getPostScriptName();
        this.firstChar = 0;
        this.lastChar = 255;
        this.ascent = (int)((double)peer.getPdfAscent() * scale);
        this.capHeight = (int)((double)peer.getPdfAscent() * scale);
        this.descent = (int)(-((double)peer.getPdfDescent() * scale));
        this.flags = 4;
        this.leading = (int)((double)peer.getPdfLeading() * scale);
        this.stemV = (int)(peer.getSize() * scale);
        this.italicAngle = 0;
        byte[] w = peer.getPdfWidths();
        this.widths = new double[w.length];
        this.avgWidth = 0.0;
        this.maxWidth = 0;
        for (int i = 0; i <= this.lastChar; ++i) {
            this.widths[i] = (int)((double)w[i] * scale);
            this.avgWidth += this.widths[i];
            this.maxWidth = (int)Math.max((double)this.maxWidth, this.widths[i]);
        }
        this.fontBox.set(0.0, (double)this.descent, (double)this.maxWidth, (double)(this.ascent + this.descent));
        this.encoding = encoding;
        if (encoding.equalsIgnoreCase(PdfFontEncodingInfo.EASTERN_EURO_ENCODING) || encoding.equalsIgnoreCase(PdfFontEncodingInfo.CYRILLIC_ENCODING)) {
            Map<Integer, List<String>> encodingDiffs = PdfFontEncodingInfo.getEncodingData(encoding);
            this.avgWidth = 0.0;
            for (int i = 0; i <= this.lastChar; ++i) {
                List<String> glyphIndexInfo;
                String unicode;
                int codePoint;
                int key = i;
                if (encodingDiffs.containsKey(key) && (codePoint = Character.codePointAt(unicode = (glyphIndexInfo = encodingDiffs.get(key)).get(0), 0)) < w.length) {
                    this.widths[i] = (int)((double)w[codePoint] * scale);
                    this.maxWidth = (int)Math.max((double)this.maxWidth, this.widths[i]);
                }
                this.avgWidth += this.widths[i];
            }
        }
        this.avgWidth /= (double)this.lastChar;
    }

    @Override
    public void toPdf() throws IOException {
        PdfDocument doc = this.getParent();
        doc.markOffset(this.getObjectId());
        doc.writeln(this.getObjectId() + " " + this.getGenerationNum() + " obj");
        doc.write("<< /Type /Font /Subtype /" + this.subType);
        doc.write(" /BaseFont /" + this.baseFont);
        doc.write(" /FirstChar " + this.firstChar + " /LastChar " + this.lastChar);
        if (PdfFontEncodingInfo.isEncodingOverride(this.encoding)) {
            Map<Integer, List<String>> encodingDiffs = PdfFontEncodingInfo.getEncodingData(this.encoding);
            if (encodingDiffs.isEmpty()) {
                this.writeDefaultFontDescriptor(doc);
            } else {
                int i;
                StringBuilder glyphNames = new StringBuilder();
                for (i = 0; i < 256; ++i) {
                    int key = i;
                    if (!encodingDiffs.containsKey(key)) continue;
                    List<String> glyphIndexInfo = encodingDiffs.get(key);
                    if (glyphNames.length() != 0) {
                        glyphNames.append(' ');
                    }
                    glyphNames.append(key + "/" + glyphIndexInfo.get(2));
                }
                doc.write(" /FontDescriptor " + (this.getObjectId() + 2) + " 0 R");
                doc.write(" /Encoding <</Type/Encoding/Differences[");
                doc.write(glyphNames.toString());
                doc.writeln("]>> /Widths " + (this.getObjectId() + 1) + " 0 R>>");
                doc.writeln("endobj");
                doc.markOffset(this.getObjectId() + 1);
                doc.writeln(this.getObjectId() + 1 + " " + this.getGenerationNum() + " obj");
                doc.write("[ ");
                for (i = 0; i <= this.lastChar; ++i) {
                    if (i > 0 && i % 16 == 0) {
                        doc.writeln((int)this.widths[i] + " ");
                        continue;
                    }
                    doc.write((int)this.widths[i] + " ");
                }
                doc.writeln("]");
                doc.writeln("endobj");
            }
        } else {
            this.writeDefaultFontDescriptor(doc);
        }
        if (this.encoding.equalsIgnoreCase(PdfFontEncodingInfo.EASTERN_EURO_ENCODING) || this.encoding.equalsIgnoreCase(PdfFontEncodingInfo.CYRILLIC_ENCODING)) {
            this.flags = this.baseFont.contains("Bold") || this.baseFont.contains("bold") ? 262176 : 32;
        }
        doc.markOffset(this.getObjectId() + 2);
        doc.writeln(this.getObjectId() + 2 + " " + this.getGenerationNum() + " obj");
        doc.write("<< /Type /FontDescriptor /FontName /" + this.baseFont);
        doc.write(" /Flags " + this.flags);
        doc.write(" /FontBBox [" + this.fontBox.x + " " + this.fontBox.y);
        doc.write(" " + this.fontBox.width + " " + this.fontBox.height + "]");
        doc.write(" /StemV " + this.stemV);
        doc.write(" /CapHeight " + this.capHeight);
        doc.write(" /Ascent " + this.ascent);
        doc.write(" /Descent " + this.descent);
        doc.write(" /Leading " + this.leading);
        doc.write(" /MaxWidth " + this.maxWidth);
        doc.write(" /AvgWidth " + (int)this.avgWidth);
        doc.write(" /ItalicAngle " + this.italicAngle);
        doc.writeln(" >>");
        doc.writeln("endobj");
    }

    private void writeDefaultFontDescriptor(PdfDocument doc) {
        doc.write(" /FontDescriptor " + (this.getObjectId() + 2) + " 0 R");
        doc.write(" /Encoding /WinAnsiEncoding");
        doc.writeln(" /Widths " + (this.getObjectId() + 1) + " 0 R>>");
        doc.writeln("endobj");
        doc.markOffset(this.getObjectId() + 1);
        doc.writeln(this.getObjectId() + 1 + " " + this.getGenerationNum() + " obj");
        doc.write("[ ");
        for (int i = 0; i <= this.lastChar; ++i) {
            if (i > 0 && i % 16 == 0) {
                doc.writeln((int)this.widths[i] + " ");
                continue;
            }
            doc.write((int)this.widths[i] + " ");
        }
        doc.writeln("]");
        doc.writeln("endobj");
    }
}

