/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.PdfCidFontInfo;
import com.tridium.pdf.PdfException;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfObject;
import java.io.IOException;

public class PdfFontReference
extends PdfObject {
    private String encoding = "";
    private String ordering = "";
    private PdfCidFontInfo cidFontInfo;

    public PdfFontReference(PdfDocument parent, int objectId, int generationNum, PdfCidFontInfo.CJK type, String fontDescription) {
        super(parent, objectId, generationNum);
        this.encoding = PdfCidFontInfo.getEncodingForType(type);
        this.ordering = PdfCidFontInfo.getOrderingForType(type);
        this.cidFontInfo = new PdfCidFontInfo(fontDescription);
    }

    @Override
    public void toPdf() throws IOException, PdfException {
        if (this.cidFontInfo == null) {
            throw new PdfException("Pdf font reference information is invalid");
        }
        String fontBox = "[0 0 0 0]";
        PdfDocument doc = this.getParent();
        int objectNumber = this.getObjectId();
        doc.markOffset(objectNumber);
        doc.writeln(Integer.toString(objectNumber) + " 0 obj");
        doc.writeln("<< /Type /Font /Subtype /Type0 /BaseFont /" + this.cidFontInfo.getFontName() + this.encoding + " /Encoding /" + this.encoding + " /DescendantFonts [" + Integer.toString(objectNumber + 1) + " 0 R] >>");
        doc.writeln("endobj");
        doc.markOffset(objectNumber + 1);
        doc.writeln(Integer.toString(objectNumber + 1) + " 0 obj");
        doc.writeln("<< /Type /Font /Subtype /CIDFontType0 /BaseFont /" + this.cidFontInfo.getFontName() + " /FontDescriptor " + Integer.toString(objectNumber + 2) + " 0 R /CIDSystemInfo << /Registry (Adobe) /Ordering (" + this.ordering + ") /Supplement 4 >> /DW 1000>>");
        doc.writeln("endobj");
        doc.markOffset(objectNumber + 2);
        doc.writeln(Integer.toString(objectNumber + 2) + " 0 obj");
        doc.writeln("<< /Type /FontDescriptor /FontName /" + this.cidFontInfo.getFontName() + " /StemV 93 /Descent -120 /Ascent 880 /CapHeight 880 /ItalicAngle 0 /Style<</Panose(" + PdfCidFontInfo.getPanoseForType(this.cidFontInfo.getType()) + ")>> /Flags " + PdfCidFontInfo.getFlagsForType(this.cidFontInfo.getType()) + " /FontBBox " + PdfCidFontInfo.getFontBoxForType(this.cidFontInfo.getType()) + ">>");
        doc.writeln("endobj");
    }
}

