/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroEnv;
import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.PdfCidFontInfo;
import com.tridium.pdf.gx.PathSupport;
import com.tridium.pdf.gx.PdfImageStream;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

public class PdfGraphics
implements Graphics {
    public static final Logger log = Logger.getLogger("pdf");
    static MicroEnv env;
    private BFont font;
    private String pdfFontDescription = null;
    private BBrush brush = BBrush.DEFAULT;
    private BPen pen = BPen.DEFAULT;
    public BTransform tx = null;
    protected PdfPage target;
    private int imageNum = 1;
    private RectGeom clip = null;
    private int clipStackSize = 0;

    protected PdfGraphics() {
        if (env == null) {
            env = new MicroEnv();
        }
        this.font = BFont.make((String)Lexicon.make((String)"pdf").getText("pdf.font"));
    }

    public void setPage(PdfPage page) {
        this.target = page;
        this.setPen(BPen.make((String)"1 capSquare joinMiter"));
        Size size = this.target.getParent().getPageSize();
        this.clip = new RectGeom(0.0, 0.0, size.width, size.height);
    }

    public void useAntiAliasing(boolean b) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush brush) {
        this.brush = brush;
        try {
            BColor color = BColor.white;
            BBrush.Paint paint = brush.getPaint();
            if (paint instanceof BBrush.Solid) {
                color = ((BBrush.Solid)paint).getColor();
            } else if (paint instanceof BBrush.Gradient) {
                BBrush.Stop stop = ((BBrush.Gradient)brush.getPaint()).getStops()[0];
                color = stop.getColor();
            }
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            PdfStream stream = this.target.getContentStream();
            stream.println(r + " " + g + " " + b + " rg");
            stream.println(r + " " + g + " " + b + " RG");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setBrush(BColor c) {
        this.setBrush(c.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen pen) {
        this.pen = pen;
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println(pen.getWidth() + " w");
            switch (pen.getCap()) {
                case 101: {
                    stream.println("0 J");
                    break;
                }
                case 103: {
                    stream.println("1 J");
                    break;
                }
                case 102: {
                    stream.println("2 J");
                }
            }
            switch (pen.getJoin()) {
                case 201: {
                    stream.println("0 j");
                    break;
                }
                case 202: {
                    stream.println("1 j");
                    break;
                }
                case 203: {
                    stream.println("2 j");
                }
            }
            double[] dash = pen.getDash();
            stream.print("[");
            for (int i = 0; i < dash.length; ++i) {
                stream.print(dash[i] + " ");
            }
            stream.println("] 0 d");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont font) {
        this.font = font;
    }

    public BTransform getTransform() {
        return null;
    }

    public void transform(BTransform transform) {
        try {
            PdfStream stream = this.target.getContentStream();
            BTransform.Transform[] t = transform.getTransforms();
            block9: for (int i = 0; i < t.length; ++i) {
                double rad = 0.0;
                double sin = 0.0;
                double cos = 0.0;
                double tan = 0.0;
                switch (t[i].getTransformCase()) {
                    case 1: {
                        BTransform.Translate trans = (BTransform.Translate)t[i];
                        stream.println("1 0 0 1 " + trans.getX() + " " + -trans.getY() + " cm");
                        this.clip.set(this.clip.x() - trans.getX(), this.clip.y() - trans.getY(), this.clip.width(), this.clip.height());
                        continue block9;
                    }
                    case 2: {
                        BTransform.Scale scale = (BTransform.Scale)t[i];
                        stream.println(scale.getX() + " 0 0 " + scale.getY() + " 0 0 cm");
                        this.clip.set(this.clip.x(), this.clip.y(), this.clip.width() / scale.getX(), this.clip.height() / scale.getY());
                        if (scale.getY() == 1.0) continue block9;
                        this.tx = transform.getInverse();
                        continue block9;
                    }
                    case 3: {
                        BTransform.Rotate rotate = (BTransform.Rotate)t[i];
                        rad = -rotate.getAngle() / 180.0 * Math.PI;
                        sin = this.round(Math.sin(rad));
                        cos = this.round(Math.cos(rad));
                        stream.println(cos + " " + sin + " " + -sin + " " + cos + " 0 0 cm");
                        continue block9;
                    }
                    case 4: {
                        BTransform.SkewX skewX = (BTransform.SkewX)t[i];
                        rad = -skewX.getAngle() / 180.0 * Math.PI;
                        tan = this.round(Math.tan(rad));
                        stream.println("1 0 " + tan + " 1 0 0 cm");
                        continue block9;
                    }
                    case 5: {
                        BTransform.SkewY skewY = (BTransform.SkewY)t[i];
                        rad = -skewY.getAngle() / 180.0 * Math.PI;
                        tan = this.round(Math.tan(rad));
                        stream.println("1 " + tan + " 0 1 0 0 cm");
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void translate(double x, double y) {
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println("1 0 0 1 " + x + " " + -y + " cm");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public IGeom getClip() {
        return this.getClipBounds();
    }

    public IRectGeom getClipBounds() {
        return this.clip;
    }

    public void clip(IGeom geom) {
        IRectGeom r = geom.bounds();
        this.clip(r.x(), r.y(), r.width(), r.height());
    }

    public void clip(double x, double y, double width, double height) {
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println(this.transX(x) + " " + (this.transY(y) - height) + " " + width + " " + height + " re");
            stream.println("W n");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void stroke(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                ILineGeom l = (ILineGeom)geom;
                this.strokeLine(l.x1(), l.y1(), l.x2(), l.y2());
                break;
            }
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.strokeRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.strokeEllipse((IEllipseGeom)geom);
                break;
            }
            case 4: {
                this.strokePolygon((IPolygonGeom)geom);
                break;
            }
            case 5: {
                this.strokePath((IPathGeom)geom);
            }
        }
    }

    public void fill(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.fillRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.fillEllipse((IEllipseGeom)geom);
                break;
            }
            case 4: {
                this.fillPolygon((IPolygonGeom)geom);
                break;
            }
            case 5: {
                this.fillPath((IPathGeom)geom);
            }
        }
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        if (Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(x2) || Double.isNaN(y2)) {
            return;
        }
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println(this.transX(x1) + " " + this.transY(y1) + " m");
            stream.println(this.transX(x2) + " " + this.transY(y2) + " l");
            stream.println("S");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void fillRect(double x, double y, double w, double h) {
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println(this.transX(x) + " " + (this.transY(y) - h) + " " + w + " " + h + " re");
            stream.println("B");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void strokeRect(double x, double y, double w, double h) {
        try {
            PdfStream stream = this.target.getContentStream();
            stream.println(this.transX(x) + " " + (this.transY(y) - h) + " " + w + " " + h + " re");
            stream.println("S");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void drawString(String str, double x, double y) {
        try {
            String fontName = "";
            String encoding = Lexicon.make((String)"pdf").getText("pdf.encoding");
            PdfCidFontInfo.CJK cjkFont = this.cjkFontType(str);
            if (cjkFont != PdfCidFontInfo.CJK.UNKNOWN) {
                fontName = PdfCidFontInfo.getFontNameForType(cjkFont);
                encoding = PdfCidFontInfo.getFontEncodingForType(cjkFont);
                this.target.addFont(fontName, this.target.getParent().getReferenceFontId(fontName, cjkFont));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Added CJK font " + fontName + " with encoding " + encoding + " with ID = " + this.target.getParent().getReferenceFontId(fontName, cjkFont));
                }
            } else {
                MicroFontPeer peer = (MicroFontPeer)env.makeFontPeer(this.font);
                fontName = peer.getPostScriptName();
                this.target.addFont(fontName, this.target.getParent().getFontId(peer));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Added micro font " + fontName + " with encoding " + encoding + " with ID = " + this.target.getParent().getFontId(peer));
                }
            }
            byte[] bytes = str.getBytes(encoding);
            PdfByteBuffer escapedBuffer = new PdfByteBuffer(bytes.length * 4);
            block5: for (int k = 0; k < bytes.length; ++k) {
                byte c = bytes[k];
                switch (c) {
                    case 40: 
                    case 41: 
                    case 92: {
                        escapedBuffer.append_i(92).append_i(c);
                        continue block5;
                    }
                    default: {
                        escapedBuffer.append_i(c);
                    }
                }
            }
            byte[] escapedBytes = escapedBuffer.toByteArray();
            PdfStream stream = this.target.getContentStream();
            stream.print("BT /" + fontName + " " + this.font.getSize() + " Tf " + this.transX(x) + " " + this.transY(y) + " Td (");
            stream.print(escapedBytes);
            stream.println(") Tj ET");
            if (this.font.isUnderline()) {
                this.drawUnderline(str, x, y);
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void drawString(char[] data, int offset, int length, double x, double y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public double getWidth(BImage image) {
        System.out.println("getWidth(image)");
        return 0.0;
    }

    public double getHeight(BImage image) {
        System.out.println("getHeight(image)");
        return 0.0;
    }

    public void drawImage(BImage img, double x, double y) {
        if (img == null) {
            return;
        }
        int w = (int)img.getWidth();
        int h = (int)img.getHeight();
        int[] pixels = img.getPixels();
        this.drawImage(pixels, w, h, x, y);
    }

    public void drawImage(int[] pixels, int w, int h, double x, double y) {
        if (pixels == null || pixels.length == 0) {
            return;
        }
        try {
            PdfStream stream = this.target.getContentStream();
            PdfImageStream imgStream = this.target.getParent().createImageStream();
            String name = "Im" + this.imageNum++;
            this.target.addXObject(name, imgStream);
            imgStream.writePixels(pixels, w, h);
            stream.println("q");
            stream.println("1 0 0 1 " + this.transX(x) + " " + (this.transY(y) - (double)h) + " cm");
            stream.println(w + " 0 0 " + h + " 0 0 cm");
            stream.println("/" + name + " Do");
            stream.println("Q");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void push() {
        try {
            this.target.getContentStream().println("q");
            ++this.clipStackSize;
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void pop() {
        try {
            if (this.clipStackSize == 0) {
                return;
            }
            this.target.getContentStream().println("Q");
            --this.clipStackSize;
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void dispose() {
    }

    public Object support() {
        return null;
    }

    private PdfCidFontInfo.CJK cjkFontType(String s) {
        PdfCidFontInfo.CJK type;
        if (this.pdfFontDescription == null) {
            this.pdfFontDescription = Lexicon.make((String)"pdf").getText("pdf.font");
        }
        if ((type = PdfCidFontInfo.cjkFontType(this.pdfFontDescription)) != PdfCidFontInfo.CJK.UNKNOWN) {
            char[] text = s.toCharArray();
            for (int i = 0; i < text.length; ++i) {
                if (text[i] <= '\u0100') continue;
                return type;
            }
        }
        return PdfCidFontInfo.CJK.UNKNOWN;
    }

    protected void strokeEllipse(IEllipseGeom e) {
        try {
            this.doEllipse(e);
            PdfStream stream = this.target.getContentStream();
            stream.println("h S");
        }
        catch (IOException ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    protected void fillEllipse(IEllipseGeom e) {
        try {
            this.doEllipse(e);
            PdfStream stream = this.target.getContentStream();
            stream.println("h f");
        }
        catch (IOException ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    protected void doEllipse(IEllipseGeom e) {
        try {
            double x1 = this.transX(e.x());
            double x2 = this.transX(e.x() + e.width());
            double y = this.transY(e.y() + e.height() / 2.0);
            double cx1 = x1 + e.width() / 4.0;
            double cx2 = x2 - e.width() / 4.0;
            double ay = this.transY(e.y());
            double by = this.transY(e.y() + e.height());
            PdfStream stream = this.target.getContentStream();
            this.strokeRect(e.x(), e.y(), e.width(), e.height());
            stream.println(x1 + " " + y + " m");
            stream.println(cx1 + " " + ay + " " + cx2 + " " + ay + " " + x2 + " " + y + " c");
            stream.println(cx2 + " " + by + " " + cx1 + " " + by + " " + x1 + " " + y + " c");
        }
        catch (IOException ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    protected void strokePolygon(IPolygonGeom p) {
        try {
            this.doPolygon(p);
            PdfStream stream = this.target.getContentStream();
            stream.println("h S");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void fillPolygon(IPolygonGeom p) {
        try {
            this.doPolygon(p);
            PdfStream stream = this.target.getContentStream();
            stream.println("h f");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void doPolygon(IPolygonGeom p) {
        try {
            PdfStream stream = this.target.getContentStream();
            for (int i = 0; i < p.size(); ++i) {
                double x = this.transX(p.x(i));
                double y = this.transY(p.y(i));
                if (i == 0) {
                    stream.println(x + " " + y + " m");
                    continue;
                }
                stream.println(x + " " + y + " l");
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void strokePath(IPathGeom p) {
        try {
            PdfStream stream = this.target.getContentStream();
            PathSupport.doPath(this, p);
            stream.println("h S");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void fillPath(IPathGeom p) {
        try {
            PdfStream stream = this.target.getContentStream();
            PathSupport.doPath(this, p);
            stream.println("h f");
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public double transX(double x) {
        return this.round(x);
    }

    public double transY(double y) {
        if (this.tx == null) {
            return this.round(this.target.getParent().getPageSize().height - y);
        }
        double ty = this.target.getParent().getPageSize().height;
        return this.round(this.tx.transform((IPoint)new Point((double)0.0, (double)ty), null).y - y);
    }

    protected void drawUnderline(String str, double x, double y) {
        double tw = this.font.width(str);
        this.strokeLine(x, y + 2.0, x + tw, y + 2.0);
    }

    protected double round(double d) {
        return d < 1.0E-5 ? 0.0 : d;
    }

    class PdfByteBuffer {
        protected int count;
        protected byte[] buf;

        public PdfByteBuffer() {
            this(128);
        }

        public PdfByteBuffer(int size) {
            if (size < 1) {
                size = 128;
            }
            this.buf = new byte[size];
        }

        public PdfByteBuffer append_i(int b) {
            int newcount = this.count + 1;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count] = (byte)b;
            this.count = newcount;
            return this;
        }

        public byte[] toByteArray() {
            byte[] newbuf = new byte[this.count];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            return newbuf;
        }
    }

    class BitStream {
        byte[] bits = new byte[1];
        int c = 7;

        BitStream() {
        }

        public void write(int bit) {
            if (this.c == -1) {
                byte[] temp = new byte[this.bits.length + 1];
                System.arraycopy(this.bits, 0, temp, 0, this.bits.length);
                this.bits = temp;
                this.c = 7;
            }
            this.bits[this.bits.length - 1] = (byte)(this.bits[this.bits.length - 1] | (byte)(0xFF & bit) << this.c--);
        }

        public void next() {
            this.c = -1;
        }
    }
}

